/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.lucene.search.vectorhighlight.SimpleBoundaryScanner;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;

public class HighlighterParseElement
implements SearchParseElement {
    private static final String[] DEFAULT_PRE_TAGS = new String[]{"<em>"};
    private static final String[] DEFAULT_POST_TAGS = new String[]{"</em>"};
    private static final String[] STYLED_PRE_TAG = new String[]{"<em class=\"hlt1\">", "<em class=\"hlt2\">", "<em class=\"hlt3\">", "<em class=\"hlt4\">", "<em class=\"hlt5\">", "<em class=\"hlt6\">", "<em class=\"hlt7\">", "<em class=\"hlt8\">", "<em class=\"hlt9\">", "<em class=\"hlt10\">"};
    private static final String[] STYLED_POST_TAGS = new String[]{"</em>"};

    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token;
        String topLevelFieldName = null;
        ArrayList<Tuple<String, SearchContextHighlight.FieldOptions.Builder>> fieldsOptions = Lists.newArrayList();
        SearchContextHighlight.FieldOptions.Builder globalOptionsBuilder = new SearchContextHighlight.FieldOptions.Builder().preTags(DEFAULT_PRE_TAGS).postTags(DEFAULT_POST_TAGS).scoreOrdered(false).highlightFilter(false).requireFieldMatch(false).forceSource(false).fragmentCharSize(100).numberOfFragments(5).encoder("default").boundaryMaxScan(20).boundaryChars(SimpleBoundaryScanner.DEFAULT_BOUNDARY_CHARS).noMatchSize(0).phraseLimit(256);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                topLevelFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("pre_tags".equals(topLevelFieldName) || "preTags".equals(topLevelFieldName)) {
                    ArrayList<String> preTagsList = Lists.newArrayList();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        preTagsList.add(parser.text());
                    }
                    globalOptionsBuilder.preTags(preTagsList.toArray(new String[preTagsList.size()]));
                    continue;
                }
                if (!"post_tags".equals(topLevelFieldName) && !"postTags".equals(topLevelFieldName)) continue;
                ArrayList<String> postTagsList = Lists.newArrayList();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    postTagsList.add(parser.text());
                }
                globalOptionsBuilder.postTags(postTagsList.toArray(new String[postTagsList.size()]));
                continue;
            }
            if (token.isValue()) {
                if ("order".equals(topLevelFieldName)) {
                    globalOptionsBuilder.scoreOrdered("score".equals(parser.text()));
                    continue;
                }
                if ("tags_schema".equals(topLevelFieldName) || "tagsSchema".equals(topLevelFieldName)) {
                    String schema = parser.text();
                    if (!"styled".equals(schema)) continue;
                    globalOptionsBuilder.preTags(STYLED_PRE_TAG);
                    globalOptionsBuilder.postTags(STYLED_POST_TAGS);
                    continue;
                }
                if ("highlight_filter".equals(topLevelFieldName) || "highlightFilter".equals(topLevelFieldName)) {
                    globalOptionsBuilder.highlightFilter(parser.booleanValue());
                    continue;
                }
                if ("fragment_size".equals(topLevelFieldName) || "fragmentSize".equals(topLevelFieldName)) {
                    globalOptionsBuilder.fragmentCharSize(parser.intValue());
                    continue;
                }
                if ("number_of_fragments".equals(topLevelFieldName) || "numberOfFragments".equals(topLevelFieldName)) {
                    globalOptionsBuilder.numberOfFragments(parser.intValue());
                    continue;
                }
                if ("encoder".equals(topLevelFieldName)) {
                    globalOptionsBuilder.encoder(parser.text());
                    continue;
                }
                if ("require_field_match".equals(topLevelFieldName) || "requireFieldMatch".equals(topLevelFieldName)) {
                    globalOptionsBuilder.requireFieldMatch(parser.booleanValue());
                    continue;
                }
                if ("boundary_max_scan".equals(topLevelFieldName) || "boundaryMaxScan".equals(topLevelFieldName)) {
                    globalOptionsBuilder.boundaryMaxScan(parser.intValue());
                    continue;
                }
                if ("boundary_chars".equals(topLevelFieldName) || "boundaryChars".equals(topLevelFieldName)) {
                    char[] charsArr = parser.text().toCharArray();
                    Character[] globalBoundaryChars = new Character[charsArr.length];
                    for (int i = 0; i < charsArr.length; ++i) {
                        globalBoundaryChars[i] = Character.valueOf(charsArr[i]);
                    }
                    globalOptionsBuilder.boundaryChars(globalBoundaryChars);
                    continue;
                }
                if ("type".equals(topLevelFieldName)) {
                    globalOptionsBuilder.highlighterType(parser.text());
                    continue;
                }
                if ("fragmenter".equals(topLevelFieldName)) {
                    globalOptionsBuilder.fragmenter(parser.text());
                    continue;
                }
                if ("no_match_size".equals(topLevelFieldName) || "noMatchSize".equals(topLevelFieldName)) {
                    globalOptionsBuilder.noMatchSize(parser.intValue());
                    continue;
                }
                if ("force_source".equals(topLevelFieldName) || "forceSource".equals(topLevelFieldName)) {
                    globalOptionsBuilder.forceSource(parser.booleanValue());
                    continue;
                }
                if (!"phrase_limit".equals(topLevelFieldName) && !"phraseLimit".equals(topLevelFieldName)) continue;
                globalOptionsBuilder.phraseLimit(parser.intValue());
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT && "options".equals(topLevelFieldName)) {
                globalOptionsBuilder.options(parser.map());
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if ("fields".equals(topLevelFieldName)) {
                String highlightFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        highlightFieldName = parser.currentName();
                        continue;
                    }
                    if (token != XContentParser.Token.START_OBJECT) continue;
                    SearchContextHighlight.FieldOptions.Builder fieldOptionsBuilder = new SearchContextHighlight.FieldOptions.Builder();
                    String fieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.START_ARRAY) {
                            if ("pre_tags".equals(fieldName) || "preTags".equals(fieldName)) {
                                ArrayList<String> arrayList = Lists.newArrayList();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    arrayList.add(parser.text());
                                }
                                fieldOptionsBuilder.preTags(arrayList.toArray(new String[arrayList.size()]));
                                continue;
                            }
                            if ("post_tags".equals(fieldName) || "postTags".equals(fieldName)) {
                                ArrayList<String> arrayList = Lists.newArrayList();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    arrayList.add(parser.text());
                                }
                                fieldOptionsBuilder.postTags(arrayList.toArray(new String[arrayList.size()]));
                                continue;
                            }
                            if (!"matched_fields".equals(fieldName) && !"matchedFields".equals(fieldName)) continue;
                            HashSet<String> hashSet = Sets.newHashSet();
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                hashSet.add(parser.text());
                            }
                            fieldOptionsBuilder.matchedFields(hashSet);
                            continue;
                        }
                        if (token.isValue()) {
                            if ("fragment_size".equals(fieldName) || "fragmentSize".equals(fieldName)) {
                                fieldOptionsBuilder.fragmentCharSize(parser.intValue());
                                continue;
                            }
                            if ("number_of_fragments".equals(fieldName) || "numberOfFragments".equals(fieldName)) {
                                fieldOptionsBuilder.numberOfFragments(parser.intValue());
                                continue;
                            }
                            if ("fragment_offset".equals(fieldName) || "fragmentOffset".equals(fieldName)) {
                                fieldOptionsBuilder.fragmentOffset(parser.intValue());
                                continue;
                            }
                            if ("highlight_filter".equals(fieldName) || "highlightFilter".equals(fieldName)) {
                                fieldOptionsBuilder.highlightFilter(parser.booleanValue());
                                continue;
                            }
                            if ("order".equals(fieldName)) {
                                fieldOptionsBuilder.scoreOrdered("score".equals(parser.text()));
                                continue;
                            }
                            if ("require_field_match".equals(fieldName) || "requireFieldMatch".equals(fieldName)) {
                                fieldOptionsBuilder.requireFieldMatch(parser.booleanValue());
                                continue;
                            }
                            if ("boundary_max_scan".equals(topLevelFieldName) || "boundaryMaxScan".equals(topLevelFieldName)) {
                                fieldOptionsBuilder.boundaryMaxScan(parser.intValue());
                                continue;
                            }
                            if ("boundary_chars".equals(topLevelFieldName) || "boundaryChars".equals(topLevelFieldName)) {
                                char[] cArray = parser.text().toCharArray();
                                Character[] boundaryChars = new Character[cArray.length];
                                for (int i = 0; i < cArray.length; ++i) {
                                    boundaryChars[i] = Character.valueOf(cArray[i]);
                                }
                                fieldOptionsBuilder.boundaryChars(boundaryChars);
                                continue;
                            }
                            if ("type".equals(fieldName)) {
                                fieldOptionsBuilder.highlighterType(parser.text());
                                continue;
                            }
                            if ("fragmenter".equals(fieldName)) {
                                fieldOptionsBuilder.fragmenter(parser.text());
                                continue;
                            }
                            if ("no_match_size".equals(fieldName) || "noMatchSize".equals(fieldName)) {
                                fieldOptionsBuilder.noMatchSize(parser.intValue());
                                continue;
                            }
                            if ("force_source".equals(fieldName) || "forceSource".equals(fieldName)) {
                                fieldOptionsBuilder.forceSource(parser.booleanValue());
                                continue;
                            }
                            if (!"phrase_limit".equals(fieldName) && !"phraseLimit".equals(fieldName)) continue;
                            fieldOptionsBuilder.phraseLimit(parser.intValue());
                            continue;
                        }
                        if (token != XContentParser.Token.START_OBJECT) continue;
                        if ("highlight_query".equals(fieldName) || "highlightQuery".equals(fieldName)) {
                            fieldOptionsBuilder.highlightQuery(context.queryParserService().parse(parser).query());
                            continue;
                        }
                        if (!"options".equals(fieldName)) continue;
                        fieldOptionsBuilder.options(parser.map());
                    }
                    fieldsOptions.add(Tuple.tuple(highlightFieldName, fieldOptionsBuilder));
                }
                continue;
            }
            if (!"highlight_query".equals(topLevelFieldName) && !"highlightQuery".equals(topLevelFieldName)) continue;
            globalOptionsBuilder.highlightQuery(context.queryParserService().parse(parser).query());
        }
        SearchContextHighlight.FieldOptions globalOptions = globalOptionsBuilder.build();
        if (globalOptions.preTags() != null && globalOptions.postTags() == null) {
            throw new SearchParseException(context, "Highlighter global preTags are set, but global postTags are not set");
        }
        ArrayList<SearchContextHighlight.Field> fields = Lists.newArrayList();
        for (Tuple tuple : fieldsOptions) {
            fields.add(new SearchContextHighlight.Field((String)tuple.v1(), ((SearchContextHighlight.FieldOptions.Builder)tuple.v2()).merge(globalOptions).build()));
        }
        context.highlight(new SearchContextHighlight(fields));
    }
}

