/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support.numeric;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.search.internal.SearchContext;

public interface ValueParser {
    public static final ValueParser IPv4 = new IPv4();

    public long parseLong(String var1, SearchContext var2);

    public double parseDouble(String var1, SearchContext var2);

    public static class IPv4
    implements ValueParser {
        private IPv4() {
        }

        @Override
        public long parseLong(String value, SearchContext searchContext) {
            return IpFieldMapper.ipToLong(value);
        }

        @Override
        public double parseDouble(String value, SearchContext searchContext) {
            return this.parseLong(value, searchContext);
        }
    }

    public static class DateMath
    implements ValueParser {
        public static final DateMath DEFAULT = new DateMath(new DateMathParser(DateFieldMapper.Defaults.DATE_TIME_FORMATTER, DateFieldMapper.Defaults.TIME_UNIT));
        private DateMathParser parser;

        public DateMath(String format, TimeUnit timeUnit) {
            this(new DateMathParser(Joda.forPattern(format), timeUnit));
        }

        public DateMath(DateMathParser parser) {
            this.parser = parser;
        }

        @Override
        public long parseLong(String value, SearchContext searchContext) {
            return this.parser.parse(value, searchContext.nowInMillis());
        }

        @Override
        public double parseDouble(String value, SearchContext searchContext) {
            return this.parseLong(value, searchContext);
        }
    }

    public static class DateTime
    implements ValueParser {
        private FormatDateTimeFormatter formatter;

        public DateTime(String format) {
            this(Joda.forPattern(format));
        }

        public DateTime(FormatDateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public long parseLong(String value, SearchContext searchContext) {
            return this.formatter.parser().parseMillis(value);
        }

        @Override
        public double parseDouble(String value, SearchContext searchContext) {
            return this.parseLong(value, searchContext);
        }
    }
}

