/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.template.get;

import java.util.HashMap;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestGetIndexTemplateAction
extends BaseRestHandler {
    @Inject
    public RestGetIndexTemplateAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_template", this);
        controller.registerHandler(RestRequest.Method.GET, "/_template/{name}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String[] names = Strings.splitStringByCommaToArray(request.param("name"));
        GetIndexTemplatesRequest getIndexTemplatesRequest = new GetIndexTemplatesRequest(names);
        getIndexTemplatesRequest.local(request.paramAsBoolean("local", getIndexTemplatesRequest.local()));
        getIndexTemplatesRequest.listenerThreaded(false);
        final boolean implicitAll = getIndexTemplatesRequest.names().length == 0;
        this.client.admin().indices().getTemplates(getIndexTemplatesRequest, new ActionListener<GetIndexTemplatesResponse>(){

            @Override
            public void onResponse(GetIndexTemplatesResponse getIndexTemplatesResponse) {
                try {
                    boolean templateExists = getIndexTemplatesResponse.getIndexTemplates().size() > 0;
                    HashMap<String, String> paramsMap = Maps.newHashMap();
                    paramsMap.put("reduce_mappings", "true");
                    ToXContent.DelegatingMapParams params = new ToXContent.DelegatingMapParams(paramsMap, request);
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    for (IndexTemplateMetaData indexTemplateMetaData : getIndexTemplatesResponse.getIndexTemplates()) {
                        IndexTemplateMetaData.Builder.toXContent(indexTemplateMetaData, builder, params);
                    }
                    builder.endObject();
                    RestStatus restStatus = templateExists || implicitAll ? RestStatus.OK : RestStatus.NOT_FOUND;
                    channel.sendResponse(new XContentRestResponse(request, restStatus, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (Exception e1) {
                    RestGetIndexTemplateAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

