/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.distributor;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.jsr166y.ThreadLocalRandom;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.distributor.AbstractDistributor;

public class RandomWeightedDistributor
extends AbstractDistributor {
    @Inject
    public RandomWeightedDistributor(DirectoryService directoryService) throws IOException {
        super(directoryService);
    }

    @Override
    public Directory doAny() {
        long[] usableSpace = new long[this.delegates.length];
        long size = 0L;
        for (int i = 0; i < this.delegates.length; ++i) {
            usableSpace[i] = size += this.getUsableSpace(this.delegates[i]);
        }
        if (size != 0L) {
            long random = ThreadLocalRandom.current().nextLong(size);
            for (int i = 0; i < this.delegates.length; ++i) {
                if (usableSpace[i] <= random) continue;
                return this.delegates[i];
            }
        }
        return this.delegates[ThreadLocalRandom.current().nextInt(this.delegates.length)];
    }

    @Override
    public String name() {
        return "random";
    }
}

