/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.memory.DirectPostingsFormat;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.codec.postingsformat.AbstractPostingsFormatProvider;

public class DirectPostingsFormatProvider
extends AbstractPostingsFormatProvider {
    private final int minSkipCount;
    private final int lowFreqCutoff;
    private final DirectPostingsFormat postingsFormat;

    @Inject
    public DirectPostingsFormatProvider(@Assisted String name, @Assisted Settings postingsFormatSettings) {
        super(name);
        this.minSkipCount = postingsFormatSettings.getAsInt("min_skip_count", (Integer)8);
        this.lowFreqCutoff = postingsFormatSettings.getAsInt("low_freq_cutoff", (Integer)32);
        this.postingsFormat = new DirectPostingsFormat(this.minSkipCount, this.lowFreqCutoff);
    }

    public int minSkipCount() {
        return this.minSkipCount;
    }

    public int lowFreqCutoff() {
        return this.lowFreqCutoff;
    }

    @Override
    public PostingsFormat get() {
        return this.postingsFormat;
    }
}

