/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.common.hppc.IntObjectOpenHashMap;
import org.elasticsearch.common.io.stream.AdapterStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.text.Text;

public class HandlesStreamInput
extends AdapterStreamInput {
    private final IntObjectOpenHashMap<String> handles = new IntObjectOpenHashMap();
    private final IntObjectOpenHashMap<Text> handlesText = new IntObjectOpenHashMap();

    HandlesStreamInput() {
    }

    public HandlesStreamInput(StreamInput in) {
        super(in);
    }

    @Override
    public String readSharedString() throws IOException {
        byte b = this.in.readByte();
        if (b == 0) {
            int handle = this.in.readVInt();
            String s = this.in.readString();
            this.handles.put(handle, s);
            return s;
        }
        if (b == 1) {
            return this.handles.get(this.in.readVInt());
        }
        throw new IOException("Expected handle header, got [" + b + "]");
    }

    @Override
    public String readString() throws IOException {
        return this.in.readString();
    }

    @Override
    public Text readSharedText() throws IOException {
        byte b = this.in.readByte();
        if (b == 0) {
            int handle = this.in.readVInt();
            Text s = this.in.readText();
            this.handlesText.put(handle, s);
            return s;
        }
        if (b == 1) {
            return this.handlesText.get(this.in.readVInt());
        }
        if (b == 2) {
            return this.in.readText();
        }
        throw new IOException("Expected handle header, got [" + b + "]");
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.cleanHandles();
    }

    @Override
    public void reset(StreamInput in) {
        super.reset(in);
        this.cleanHandles();
    }

    public void cleanHandles() {
        this.handles.clear();
        this.handlesText.clear();
    }
}

