/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.pool.sizeof;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JvmInformation {
    HOTSPOT_32_BIT{

        @Override
        public String getJvmDescription() {
            return "32-Bit HotSpot JVM";
        }

        @Override
        public int getPointerSize() {
            return 4;
        }

        @Override
        public int getJavaPointerSize() {
            return 4;
        }
    }
    ,
    HOTSPOT_32_BIT_WITH_CONCURRENT_MARK_AND_SWEEP{

        @Override
        public int getMinimumObjectSize() {
            return 16;
        }

        @Override
        public String getJvmDescription() {
            return "32-Bit HotSpot JVM with Concurrent Mark-and-Sweep GC";
        }

        @Override
        public int getPointerSize() {
            return 4;
        }

        @Override
        public int getJavaPointerSize() {
            return 4;
        }
    }
    ,
    HOTSPOT_64_BIT{

        @Override
        public int getPointerSize() {
            return 8;
        }

        @Override
        public int getJavaPointerSize() {
            return 8;
        }

        @Override
        public String getJvmDescription() {
            return "64-Bit HotSpot JVM";
        }
    }
    ,
    HOTSPOT_64_BIT_WITH_CONCURRENT_MARK_AND_SWEEP{

        @Override
        public int getPointerSize() {
            return 8;
        }

        @Override
        public int getJavaPointerSize() {
            return 8;
        }

        @Override
        public int getMinimumObjectSize() {
            return 24;
        }

        @Override
        public String getJvmDescription() {
            return "64-Bit HotSpot JVM with Concurrent Mark-and-Sweep GC";
        }
    }
    ,
    HOTSPOT_64_BIT_WITH_COMPRESSED_OOPS{

        @Override
        public int getPointerSize() {
            return 8;
        }

        @Override
        public int getJavaPointerSize() {
            return 4;
        }

        @Override
        public String getJvmDescription() {
            return "64-Bit HotSpot JVM with Compressed OOPs";
        }
    }
    ,
    HOTSPOT_64_BIT_WITH_COMPRESSED_OOPS_AND_CONCURRENT_MARK_AND_SWEEP{

        @Override
        public int getPointerSize() {
            return 8;
        }

        @Override
        public int getJavaPointerSize() {
            return 4;
        }

        @Override
        public int getMinimumObjectSize() {
            return 24;
        }

        @Override
        public String getJvmDescription() {
            return "64-Bit HotSpot JVM with Compressed OOPs and Concurrent Mark-and-Sweep GC";
        }
    }
    ,
    JROCKIT_32_BIT{

        @Override
        public int getAgentSizeOfAdjustment() {
            return 8;
        }

        @Override
        public int getFieldOffsetAdjustment() {
            return 8;
        }

        @Override
        public int getObjectHeaderSize() {
            return 16;
        }

        @Override
        public String getJvmDescription() {
            return "32-Bit JRockit JVM";
        }

        @Override
        public boolean supportsReflectionSizeOf() {
            return false;
        }

        @Override
        public int getPointerSize() {
            return 4;
        }

        @Override
        public int getJavaPointerSize() {
            return 4;
        }
    }
    ,
    JROCKIT_64_BIT{

        @Override
        public int getAgentSizeOfAdjustment() {
            return 8;
        }

        @Override
        public int getFieldOffsetAdjustment() {
            return 8;
        }

        @Override
        public int getObjectHeaderSize() {
            return 16;
        }

        @Override
        public String getJvmDescription() {
            return "64-Bit JRockit JVM (with no reference compression)";
        }

        @Override
        public boolean supportsReflectionSizeOf() {
            return false;
        }

        @Override
        public int getPointerSize() {
            return 4;
        }

        @Override
        public int getJavaPointerSize() {
            return 4;
        }
    }
    ,
    JROCKIT_64_BIT_WITH_4GB_COMPRESSED_REFS{

        @Override
        public int getAgentSizeOfAdjustment() {
            return 8;
        }

        @Override
        public int getFieldOffsetAdjustment() {
            return 8;
        }

        @Override
        public int getObjectHeaderSize() {
            return 16;
        }

        @Override
        public String getJvmDescription() {
            return "64-Bit JRockit JVM with 4GB Compressed References";
        }

        @Override
        public boolean supportsReflectionSizeOf() {
            return false;
        }

        @Override
        public int getPointerSize() {
            return 4;
        }

        @Override
        public int getJavaPointerSize() {
            return 4;
        }
    }
    ,
    JROCKIT_64_BIT_WITH_32GB_COMPRESSED_REFS{

        @Override
        public int getAgentSizeOfAdjustment() {
            return 8;
        }

        @Override
        public int getFieldOffsetAdjustment() {
            return 8;
        }

        @Override
        public int getObjectHeaderSize() {
            return 16;
        }

        @Override
        public String getJvmDescription() {
            return "64-Bit JRockit JVM with 32GB Compressed References";
        }

        @Override
        public boolean supportsReflectionSizeOf() {
            return false;
        }

        @Override
        public int getPointerSize() {
            return 4;
        }

        @Override
        public int getJavaPointerSize() {
            return 4;
        }
    }
    ,
    JROCKIT_64_BIT_WITH_64GB_COMPRESSED_REFS{

        @Override
        public int getObjectAlignment() {
            return 16;
        }

        @Override
        public int getAgentSizeOfAdjustment() {
            return 16;
        }

        @Override
        public int getFieldOffsetAdjustment() {
            return 16;
        }

        @Override
        public int getObjectHeaderSize() {
            return 24;
        }

        @Override
        public String getJvmDescription() {
            return "64-Bit JRockit JVM with 64GB Compressed References";
        }

        @Override
        public boolean supportsReflectionSizeOf() {
            return false;
        }

        @Override
        public int getPointerSize() {
            return 4;
        }

        @Override
        public int getJavaPointerSize() {
            return 4;
        }
    }
    ,
    IBM_64_BIT_WITH_COMPRESSED_REFS{

        @Override
        public int getPointerSize() {
            return 4;
        }

        @Override
        public int getJavaPointerSize() {
            return 4;
        }

        @Override
        public int getObjectHeaderSize() {
            return 16;
        }

        @Override
        public boolean supportsReflectionSizeOf() {
            return false;
        }

        @Override
        public String getJvmDescription() {
            return "IBM 64-Bit JVM with Compressed References";
        }
    }
    ,
    IBM_64_BIT{

        @Override
        public int getPointerSize() {
            return 8;
        }

        @Override
        public int getJavaPointerSize() {
            return 8;
        }

        @Override
        public int getObjectHeaderSize() {
            return 24;
        }

        @Override
        public boolean supportsReflectionSizeOf() {
            return false;
        }

        @Override
        public String getJvmDescription() {
            return "IBM 64-Bit JVM (with no reference compression)";
        }
    }
    ,
    IBM_32_BIT{

        @Override
        public String getJvmDescription() {
            return "IBM 32-Bit JVM";
        }

        @Override
        public int getPointerSize() {
            return 4;
        }

        @Override
        public int getJavaPointerSize() {
            return 4;
        }

        @Override
        public int getObjectHeaderSize() {
            return 16;
        }

        @Override
        public boolean supportsReflectionSizeOf() {
            return false;
        }
    }
    ,
    UNKNOWN_32_BIT{

        @Override
        public String getJvmDescription() {
            return "Unrecognized 32-Bit JVM";
        }

        @Override
        public int getPointerSize() {
            return 4;
        }

        @Override
        public int getJavaPointerSize() {
            return 4;
        }
    }
    ,
    UNKNOWN_64_BIT{

        @Override
        public int getPointerSize() {
            return 8;
        }

        @Override
        public int getJavaPointerSize() {
            return 8;
        }

        @Override
        public String getJvmDescription() {
            return "Unrecognized 64-Bit JVM";
        }
    };

    public static final JvmInformation CURRENT_JVM_INFORMATION;
    private static final Logger LOGGER;
    private static final long THREE_GB = 0xC0000000L;
    private static final long TWENTY_FIVE_GB = 0x640000000L;
    private static final long FIFTY_SEVEN_GB = 0xE40000000L;

    public abstract int getPointerSize();

    public abstract int getJavaPointerSize();

    public int getMinimumObjectSize() {
        return this.getObjectAlignment();
    }

    public int getObjectAlignment() {
        return 8;
    }

    public int getObjectHeaderSize() {
        return this.getPointerSize() + this.getJavaPointerSize();
    }

    public int getFieldOffsetAdjustment() {
        return 0;
    }

    public int getAgentSizeOfAdjustment() {
        return 0;
    }

    public boolean supportsAgentSizeOf() {
        return true;
    }

    public boolean supportsUnsafeSizeOf() {
        return true;
    }

    public boolean supportsReflectionSizeOf() {
        return true;
    }

    public abstract String getJvmDescription();

    private static JvmInformation getJvmInformation() {
        JvmInformation jif = null;
        jif = JvmInformation.detectHotSpot();
        if (jif == null) {
            jif = JvmInformation.detectJRockit();
        }
        if (jif == null) {
            jif = JvmInformation.detectIBM();
        }
        if (jif == null && JvmInformation.is64Bit()) {
            jif = UNKNOWN_64_BIT;
        } else if (jif == null) {
            jif = UNKNOWN_32_BIT;
        }
        return jif;
    }

    private static JvmInformation detectHotSpot() {
        JvmInformation jif = null;
        if (JvmInformation.isHotspot()) {
            jif = JvmInformation.is64Bit() ? (JvmInformation.isHotspotCompressedOops() && JvmInformation.isHotspotConcurrentMarkSweepGC() ? HOTSPOT_64_BIT_WITH_COMPRESSED_OOPS_AND_CONCURRENT_MARK_AND_SWEEP : (JvmInformation.isHotspotCompressedOops() ? HOTSPOT_64_BIT_WITH_COMPRESSED_OOPS : (JvmInformation.isHotspotConcurrentMarkSweepGC() ? HOTSPOT_64_BIT_WITH_CONCURRENT_MARK_AND_SWEEP : HOTSPOT_64_BIT))) : HOTSPOT_32_BIT;
        }
        return jif;
    }

    private static JvmInformation detectJRockit() {
        JvmInformation jif = null;
        if (JvmInformation.isJRockit()) {
            jif = JvmInformation.is64Bit() ? (JvmInformation.isJRockit4GBCompression() ? JROCKIT_64_BIT_WITH_4GB_COMPRESSED_REFS : (JvmInformation.isJRockit32GBCompression() ? JROCKIT_64_BIT_WITH_32GB_COMPRESSED_REFS : (JvmInformation.isJRockit64GBCompression() ? JROCKIT_64_BIT_WITH_64GB_COMPRESSED_REFS : JROCKIT_64_BIT))) : JROCKIT_32_BIT;
        }
        return jif;
    }

    private static JvmInformation detectIBM() {
        JvmInformation jif = null;
        if (JvmInformation.isIBM()) {
            jif = JvmInformation.is64Bit() ? (JvmInformation.isIBMCompressedRefs() ? IBM_64_BIT_WITH_COMPRESSED_REFS : IBM_64_BIT) : IBM_32_BIT;
        }
        return jif;
    }

    private static boolean isJRockit32GBCompression() {
        if (JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:enable=false")) {
            return false;
        }
        if (JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:size=64GB") || JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:size=4GB")) {
            return false;
        }
        if (JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:size=32GB")) {
            return true;
        }
        return Runtime.getRuntime().maxMemory() > 0xC0000000L && Runtime.getRuntime().maxMemory() <= 0x640000000L && JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:enable=true");
    }

    private static boolean isJRockit64GBCompression() {
        if (JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:enable=false")) {
            return false;
        }
        if (JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:size=4GB") || JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:size=32GB")) {
            return false;
        }
        if (JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:size=64GB")) {
            return true;
        }
        return Runtime.getRuntime().maxMemory() > 0x640000000L && Runtime.getRuntime().maxMemory() <= 0xE40000000L && JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:enable=true");
    }

    private static boolean isJRockit4GBCompression() {
        if (JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:enable=false")) {
            return false;
        }
        if (JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:size=64GB") || JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:size=32GB")) {
            return false;
        }
        if (JvmInformation.getJRockitVmArgs().contains("-XXcompressedRefs:size=4GB")) {
            return true;
        }
        return Runtime.getRuntime().maxMemory() <= 0xC0000000L;
    }

    public static boolean isJRockit() {
        return System.getProperty("jrockit.version") != null || System.getProperty("java.vm.name", "").toLowerCase().indexOf("jrockit") >= 0;
    }

    public static boolean isOSX() {
        String vendor = System.getProperty("java.vm.vendor");
        return vendor != null && vendor.startsWith("Apple");
    }

    public static boolean isHotspot() {
        return System.getProperty("java.vm.name", "").toLowerCase().contains("hotspot");
    }

    public static boolean isIBM() {
        return System.getProperty("java.vm.name", "").contains("IBM") && System.getProperty("java.vm.vendor").contains("IBM");
    }

    private static boolean isIBMCompressedRefs() {
        return System.getProperty("com.ibm.oti.vm.bootstrap.library.path", "").contains("compressedrefs");
    }

    private static boolean isHotspotCompressedOops() {
        String value = JvmInformation.getHotSpotVmOptionValue("UseCompressedOops");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    private static String getHotSpotVmOptionValue(String name) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName beanName = ObjectName.getInstance("com.sun.management:type=HotSpotDiagnostic");
            Object vmOption = server.invoke(beanName, "getVMOption", new Object[]{name}, new String[]{"java.lang.String"});
            return (String)((CompositeData)vmOption).get("value");
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String getPlatformMBeanAttribute(String beanName, String attrName) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = ObjectName.getInstance(beanName);
            String attr = server.getAttribute(name, attrName).toString();
            if (attr != null) {
                return attr.toString();
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String getJRockitVmArgs() {
        return JvmInformation.getPlatformMBeanAttribute("oracle.jrockit.management:type=PerfCounters", "java.rt.vmArgs");
    }

    private static boolean isHotspotConcurrentMarkSweepGC() {
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!"ConcurrentMarkSweep".equals(bean.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean is64Bit() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return systemProp.equals("64");
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return systemProp.equals("64");
        }
        systemProp = System.getProperty("java.vm.version");
        if (systemProp != null) {
            return systemProp.contains("_64");
        }
        return false;
    }

    static {
        LOGGER = LoggerFactory.getLogger(JvmInformation.class);
        CURRENT_JVM_INFORMATION = JvmInformation.getJvmInformation();
        LOGGER.info("Detected JVM data model settings of: " + CURRENT_JVM_INFORMATION.getJvmDescription());
    }
}

