/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.measure.IncommensurableException;
import javax.measure.UnitConverter;
import javax.measure.format.ParserException;
import org.apache.sis.internal.jdk8.DateTimeException;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.DiscreteSampling;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.impl.Dimension;
import org.apache.sis.internal.netcdf.impl.FeaturesInfo;
import org.apache.sis.internal.netcdf.impl.GridGeometryInfo;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.logging.WarningListeners;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.InvalidParameterCardinalityException;

public final class ChannelDecoder
extends Decoder {
    public static final int MAGIC_NUMBER = 1128547840;
    public static final int MAX_VERSION = 2;
    private static final Charset NAME_ENCODING = StandardCharsets.UTF_8;
    static final Locale NAME_LOCALE = Locale.US;
    private static final Pattern TIME_UNIT_PATTERN = Pattern.compile("\\s+since\\s+", 2);
    private static final int STREAMING = -1;
    private static final int DIMENSION = 10;
    private static final int VARIABLE = 11;
    private static final int ATTRIBUTE = 12;
    private final ChannelDataInput input;
    private final boolean is64bits;
    private final int numrecs;
    private final Charset encoding;
    final VariableInfo[] variables;
    private final Map<String, VariableInfo> variableMap;
    private final Map<String, Object> attributeMap;
    private Map<String, Dimension> dimensionMap;
    private transient GridGeometry[] gridGeometries;

    public ChannelDecoder(ChannelDataInput channelDataInput, Charset charset, GeometryLibrary geometryLibrary, WarningListeners<DataStore> warningListeners) throws IOException, DataStoreException {
        super(geometryLibrary, warningListeners);
        this.input = channelDataInput;
        this.encoding = charset != null ? charset : StandardCharsets.UTF_8;
        int n = channelDataInput.readInt();
        if ((n & 0xFFFFFF00) != 1128547840) {
            throw new DataStoreContentException(this.errors().getString((short)139, (Object)"netCDF", (Object)this.getFilename()));
        }
        switch (n &= 0xFF) {
            case 1: {
                this.is64bits = false;
                break;
            }
            case 2: {
                this.is64bits = true;
                break;
            }
            default: {
                throw new DataStoreContentException(this.errors().getString((short)159, (Object)"netCDF", (Object)n));
            }
        }
        this.numrecs = channelDataInput.readInt();
        Dimension[] dimensionArray = null;
        VariableInfo[] variableInfoArray = null;
        Map<String, Object> map = null;
        for (int i = 0; i < 3; ++i) {
            long l = channelDataInput.readLong();
            if (l == 0L) continue;
            int n2 = (int)(l >>> 32);
            int n3 = (int)l;
            this.ensureNonNegative(n3, n2);
            try {
                switch (n2) {
                    case 10: {
                        dimensionArray = this.readDimensions(n3);
                        break;
                    }
                    case 11: {
                        variableInfoArray = this.readVariables(n3, dimensionArray);
                        break;
                    }
                    case 12: {
                        map = this.readAttributes(n3);
                        break;
                    }
                    default: {
                        throw this.malformedHeader();
                    }
                }
                continue;
            }
            catch (InvalidParameterCardinalityException invalidParameterCardinalityException) {
                throw new DataStoreContentException(invalidParameterCardinalityException.getLocalizedMessage(), invalidParameterCardinalityException);
            }
        }
        this.attributeMap = map;
        this.variables = variableInfoArray;
        this.variableMap = NamedElement.toCaseInsensitiveNameMap(variableInfoArray, (Locale)NAME_LOCALE);
    }

    private static String tagName(int n) {
        short s;
        switch (n) {
            case 10: {
                s = 34;
                break;
            }
            case 11: {
                s = 113;
                break;
            }
            case 12: {
                s = 7;
                break;
            }
            default: {
                return Integer.toHexString(n);
            }
        }
        return Vocabulary.format((short)s);
    }

    final Errors errors() {
        return Errors.getResources((Locale)this.listeners.getLocale());
    }

    final Resources resources() {
        return Resources.forLocale(this.listeners.getLocale());
    }

    private DataStoreException malformedHeader() {
        return new DataStoreContentException(this.listeners.getLocale(), "netCDF", this.getFilename(), null);
    }

    private void ensureNonNegative(int n, int n2) throws DataStoreException {
        if (n < 0) {
            throw new DataStoreContentException(this.errors().getString((short)93, (Object)(this.getFilename() + ':' + ChannelDecoder.tagName(n2))));
        }
    }

    private void align(int n) throws IOException {
        if ((n &= 3) != 0) {
            n = 4 - n;
            this.input.ensureBufferContains(n);
            this.input.buffer.position(this.input.buffer.position() + n);
        }
    }

    private long readOffset() throws IOException {
        return this.is64bits ? this.input.readLong() : this.input.readUnsignedInt();
    }

    private String readName() throws IOException, DataStoreException {
        int n = this.input.readInt();
        if (n < 0) {
            throw this.malformedHeader();
        }
        String string = this.input.readString(n, NAME_ENCODING);
        this.align(n);
        return string;
    }

    private Object readValues(DataType dataType, int n) throws IOException, DataStoreException {
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            throw this.malformedHeader();
        }
        if (n == 1) {
            switch (dataType) {
                case BYTE: {
                    byte by = this.input.readByte();
                    this.align(1);
                    return by;
                }
                case UBYTE: {
                    short s = (short)this.input.readUnsignedByte();
                    this.align(1);
                    return s;
                }
                case SHORT: {
                    short s = this.input.readShort();
                    this.align(2);
                    return s;
                }
                case USHORT: {
                    int n2 = this.input.readUnsignedShort();
                    this.align(2);
                    return n2;
                }
                case INT: {
                    return this.input.readInt();
                }
                case INT64: {
                    return this.input.readLong();
                }
                case UINT: {
                    return this.input.readUnsignedInt();
                }
                case FLOAT: {
                    return Float.valueOf(this.input.readFloat());
                }
                case DOUBLE: {
                    return this.input.readDouble();
                }
            }
        }
        switch (dataType) {
            case CHAR: {
                String string = this.input.readString(n, this.encoding);
                this.align(n);
                return string.isEmpty() ? null : string;
            }
            case BYTE: 
            case UBYTE: {
                byte[] byArray = new byte[n];
                this.input.readFully(byArray);
                this.align(n);
                return byArray;
            }
            case SHORT: 
            case USHORT: {
                short[] sArray = new short[n];
                this.input.readFully(sArray, 0, n);
                this.align(n << 1);
                return sArray;
            }
            case INT: 
            case UINT: {
                int[] nArray = new int[n];
                this.input.readFully(nArray, 0, n);
                return nArray;
            }
            case INT64: 
            case UINT64: {
                long[] lArray = new long[n];
                this.input.readFully(lArray, 0, n);
                return lArray;
            }
            case FLOAT: {
                float[] fArray = new float[n];
                this.input.readFully(fArray, 0, n);
                return fArray;
            }
            case DOUBLE: {
                double[] dArray = new double[n];
                this.input.readFully(dArray, 0, n);
                return dArray;
            }
        }
        throw this.malformedHeader();
    }

    private Dimension[] readDimensions(int n) throws IOException, DataStoreException {
        NamedElement[] namedElementArray = new Dimension[n];
        for (int i = 0; i < n; ++i) {
            String string = this.readName();
            int n2 = this.input.readInt();
            if (n2 == 0 && (n2 = this.numrecs) == -1) {
                throw new DataStoreContentException(this.errors().getString((short)89, (Object)"numrecs"));
            }
            namedElementArray[i] = new Dimension(string, n2);
        }
        this.dimensionMap = Dimension.toCaseInsensitiveNameMap((NamedElement[])namedElementArray, (Locale)NAME_LOCALE);
        return namedElementArray;
    }

    private Map<String, Object> readAttributes(int n) throws IOException, DataStoreException {
        ArrayList<AbstractMap.SimpleEntry<String, Object>> arrayList = new ArrayList<AbstractMap.SimpleEntry<String, Object>>(n);
        while (--n >= 0) {
            String string = this.readName();
            Object object = this.readValues(DataType.valueOf(this.input.readInt()), this.input.readInt());
            if (object == null) continue;
            arrayList.add(new AbstractMap.SimpleEntry<String, Object>(string, object));
        }
        return CollectionsExt.toCaseInsensitiveNameMap(arrayList, (Locale)NAME_LOCALE);
    }

    private VariableInfo[] readVariables(int n, Dimension[] dimensionArray) throws IOException, DataStoreException {
        if (dimensionArray == null) {
            throw this.malformedHeader();
        }
        VariableInfo[] variableInfoArray = new VariableInfo[n];
        for (int i = 0; i < n; ++i) {
            String string = this.readName();
            int n2 = this.input.readInt();
            Dimension[] dimensionArray2 = new Dimension[n2];
            try {
                for (int j = 0; j < n2; ++j) {
                    dimensionArray2[j] = dimensionArray[this.input.readInt()];
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw this.malformedHeader().initCause(indexOutOfBoundsException);
            }
            Map<String, Object> map = Collections.emptyMap();
            long l = this.input.readLong();
            if (l != 0L) {
                int n3 = (int)(l >>> 32);
                int n4 = (int)l;
                this.ensureNonNegative(n4, n3);
                switch (n3) {
                    case 12: {
                        map = this.readAttributes(n4);
                        break;
                    }
                    default: {
                        throw this.malformedHeader();
                    }
                }
            }
            variableInfoArray[i] = new VariableInfo(this.input, string, dimensionArray2, map, DataType.valueOf(this.input.readInt()), this.input.readInt(), this.readOffset());
        }
        return variableInfoArray;
    }

    @Override
    public final String getFilename() {
        return this.input.filename;
    }

    @Override
    public void setSearchPath(String ... stringArray) {
    }

    @Override
    public String[] getSearchPath() {
        return new String[1];
    }

    final Dimension findDimension(String string) {
        String string2;
        Dimension dimension = this.dimensionMap.get(string);
        if (dimension == null && (string2 = string.toLowerCase(NAME_LOCALE)) != string) {
            dimension = this.dimensionMap.get(string2);
        }
        return dimension;
    }

    final VariableInfo findVariable(String string) {
        String string2;
        VariableInfo variableInfo = this.variableMap.get(string);
        if (variableInfo == null && string != null && (string2 = string.toLowerCase(NAME_LOCALE)) != string) {
            variableInfo = this.variableMap.get(string2);
        }
        return variableInfo;
    }

    private Object findAttribute(String string) {
        String string2;
        Object object = this.attributeMap.get(string);
        if (object == null && string != null && (string2 = string.toLowerCase(NAME_LOCALE)) != string) {
            object = this.attributeMap.get(string2);
        }
        return object;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributeMap.keySet());
    }

    @Override
    public String stringValue(String string) {
        Object object = this.findAttribute(string);
        return object != null ? object.toString() : null;
    }

    @Override
    public Number numericValue(String string) {
        Object object = this.findAttribute(string);
        if (object instanceof String) {
            return this.parseNumber((String)object);
        }
        Number[] numberArray = VariableInfo.numberValues(object);
        return numberArray.length != 0 ? (Number)numberArray[0] : (Number)null;
    }

    @Override
    public Date dateValue(String string) {
        Object object = this.findAttribute(string);
        if (object instanceof CharSequence) {
            try {
                return JDK8.parseDateTime((String)StandardDateFormat.dateToISO((CharSequence)((CharSequence)object), (int)0, (boolean)false));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.listeners.warning(null, (Exception)illegalArgumentException);
            }
        }
        return null;
    }

    @Override
    public Date[] numberToDate(String string, Number ... numberArray) {
        Date[] dateArray = new Date[numberArray.length];
        String[] stringArray = TIME_UNIT_PATTERN.split(string);
        if (stringArray.length == 2) {
            try {
                UnitConverter unitConverter = Units.valueOf((String)stringArray[0]).getConverterToAny(Units.MILLISECOND);
                long l = JDK8.parseDateTime((String)StandardDateFormat.dateToISO((CharSequence)stringArray[1], (int)0, (boolean)false)).getTime();
                for (int i = 0; i < numberArray.length; ++i) {
                    Number number = numberArray[i];
                    if (number == null) continue;
                    dateArray[i] = new Date(l + Math.round(unitConverter.convert(number.doubleValue())));
                }
            }
            catch (ArithmeticException | IncommensurableException | ParserException | DateTimeException throwable) {
                this.listeners.warning(null, (Exception)throwable);
            }
        }
        return dateArray;
    }

    @Override
    public Variable[] getVariables() {
        return this.variables;
    }

    @Override
    public DiscreteSampling[] getDiscreteSampling() throws IOException, DataStoreException {
        if ("trajectory".equalsIgnoreCase(this.stringValue("featureType"))) {
            try {
                return FeaturesInfo.create(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DataStoreException(illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
            }
        }
        return new FeaturesInfo[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GridGeometry[] getGridGeometries() {
        if (this.gridGeometries == null) {
            IdentityHashMap identityHashMap = new IdentityHashMap();
            for (VariableInfo variableInfo : this.variables) {
                if (!variableInfo.isCoordinateSystemAxis()) continue;
                for (Dimension object : variableInfo.dimensions) {
                    CollectionsExt.addToMultiValuesMap(identityHashMap, (Object)object, (Object)variableInfo);
                }
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet(4);
            LinkedHashMap<List<Dimension>, GridGeometryInfo> linkedHashMap = new LinkedHashMap<List<Dimension>, GridGeometryInfo>();
            block2: for (VariableInfo variableInfo : this.variables) {
                void var9_20;
                if (variableInfo.isCoordinateSystemAxis()) continue;
                List<Dimension> list = Arrays.asList(variableInfo.dimensions);
                GridGeometryInfo gridGeometryInfo = (GridGeometryInfo)linkedHashMap.get(list);
                if (gridGeometryInfo == null) {
                    for (Dimension dimension : variableInfo.dimensions) {
                        List list2 = (List)identityHashMap.get(dimension);
                        if (list2 == null) {
                            linkedHashSet.clear();
                            continue block2;
                        }
                        linkedHashSet.addAll(list2);
                    }
                    GridGeometryInfo gridGeometryInfo2 = new GridGeometryInfo(variableInfo.dimensions, linkedHashSet.toArray(new VariableInfo[linkedHashSet.size()]));
                    linkedHashMap.put(list, gridGeometryInfo2);
                    linkedHashSet.clear();
                }
                variableInfo.gridGeometry = var9_20;
            }
            this.gridGeometries = linkedHashMap.values().toArray(new GridGeometry[linkedHashMap.size()]);
        }
        return this.gridGeometries;
    }

    @Override
    public void close() throws IOException {
        this.input.channel.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SIS driver: \u201c").append(this.getFilename()).append('\u201d');
        if (!this.input.channel.isOpen()) {
            stringBuilder.append(" (closed)");
        }
        return stringBuilder.toString();
    }
}

