/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.referencing.CC_OperationMethod;
import org.apache.sis.internal.jaxb.referencing.CC_OperationParameterGroup;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultTransformation;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;

@XmlType(name="AbstractSingleOperationType", propOrder={"method", "parameters"})
@XmlRootElement(name="AbstractSingleOperation")
@XmlSeeAlso(value={DefaultConversion.class, DefaultTransformation.class})
class AbstractSingleOperation
extends AbstractCoordinateOperation
implements SingleOperation,
Parameterized {
    private static final long serialVersionUID = -2635450075620911309L;
    private OperationMethod method;
    ParameterValueGroup parameters;

    public AbstractSingleOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3, OperationMethod operationMethod, MathTransform mathTransform) {
        super(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, mathTransform);
        ArgumentChecks.ensureNonNull("method", operationMethod);
        ArgumentChecks.ensureNonNull("transform", mathTransform);
        AbstractSingleOperation.checkDimensions(operationMethod, ReferencingUtilities.getDimension(coordinateReferenceSystem3), mathTransform, map);
        this.method = operationMethod;
        this.parameters = Parameters.unmodifiable(Containers.property(map, "parameters", ParameterValueGroup.class));
    }

    AbstractSingleOperation(Map<String, ?> map, OperationMethod operationMethod) {
        super(map);
        ArgumentChecks.ensureNonNull("method", operationMethod);
        this.method = operationMethod;
    }

    protected AbstractSingleOperation(SingleOperation singleOperation) {
        super((CoordinateOperation)singleOperation);
        this.method = singleOperation.getMethod();
        this.parameters = Parameters.unmodifiable(singleOperation.getParameterValues());
    }

    static void checkDimensions(OperationMethod operationMethod, int n, MathTransform mathTransform, Map<String, ?> map) throws IllegalArgumentException {
        int n2 = mathTransform.getSourceDimensions();
        Integer n3 = operationMethod.getSourceDimensions();
        if (n3 != null && n2 > n3 + n) {
            MathTransform mathTransform2 = null;
            for (MathTransform mathTransform3 : MathTransforms.getSteps(mathTransform)) {
                if (AbstractSingleOperation.isIgnorable(mathTransform3)) continue;
                if (mathTransform2 == null && mathTransform3 instanceof PassThroughTransform) {
                    mathTransform2 = ((PassThroughTransform)mathTransform3).getSubTransform();
                    continue;
                }
                mathTransform2 = null;
                break;
            }
            if (mathTransform2 != null) {
                mathTransform = mathTransform2;
                n2 = mathTransform.getSourceDimensions();
            }
        }
        int n4 = 0;
        if (n3 == null || n2 == n3 || n2 == n3 + n) {
            n2 = mathTransform.getTargetDimensions();
            n3 = operationMethod.getTargetDimensions();
            if (n3 == null || n2 == n3 || n2 == n3 + n) {
                return;
            }
            n4 = 1;
        }
        if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)operationMethod, "Affine")) {
            throw new IllegalArgumentException(Resources.forProperties(map).getString((short)37, n4, n3, n2));
        }
    }

    private static boolean isIgnorable(MathTransform mathTransform) {
        Matrix matrix = MathTransforms.getMatrix(mathTransform);
        if (matrix != null) {
            int n = matrix.getNumRow();
            if (matrix.getNumCol() == n) {
                for (int i = 0; i < n; ++i) {
                    int n2 = 0;
                    int n3 = 0;
                    for (int j = 0; j < n; ++j) {
                        if (matrix.getElement(i, j) != 0.0) {
                            ++n2;
                        }
                        if (matrix.getElement(j, i) == 0.0) continue;
                        ++n3;
                    }
                    if (n2 == 1 && n3 == true) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @XmlElement(name="method", required=true)
    public OperationMethod getMethod() {
        return this.method;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.parameters != null ? this.parameters.getDescriptor() : super.getParameterDescriptors();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.parameters != null ? this.parameters : super.getParameterValues();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                AbstractSingleOperation abstractSingleOperation = (AbstractSingleOperation)object;
                return Objects.equals(this.method, abstractSingleOperation.method) && Objects.equals(this.parameters, abstractSingleOperation.parameters);
            }
            case BY_CONTRACT: {
                SingleOperation singleOperation = (SingleOperation)object;
                return Utilities.deepEquals(this.getMethod(), singleOperation.getMethod(), comparisonMode) && Utilities.deepEquals(this.getParameterValues(), singleOperation.getParameterValues(), comparisonMode);
            }
        }
        return true;
    }

    AbstractSingleOperation() {
    }

    private void setMethod(OperationMethod operationMethod) {
        if (this.method == null) {
            this.method = operationMethod;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractSingleOperation.class, "setMethod", "method");
        }
    }

    @XmlElement(name="parameterValue")
    private GeneralParameterValue[] getParameters() {
        List list;
        if (this.parameters != null && (list = this.parameters.values()) != null) {
            return CC_OperationMethod.filterImplicit(list.toArray(new GeneralParameterValue[list.size()]));
        }
        return null;
    }

    private void setParameters(GeneralParameterValue[] generalParameterValueArray) {
        if (this.parameters == null) {
            if (!(this.method instanceof DefaultOperationMethod)) {
                throw new IllegalStateException(Errors.format((short)89, "method"));
            }
            IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor> identityHashMap = new IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor>(4);
            GeneralParameterDescriptor[] generalParameterDescriptorArray = CC_OperationParameterGroup.merge(this.method.getParameters().descriptors(), Parameters.getDescriptors(generalParameterValueArray), identityHashMap);
            for (int i = 0; i < generalParameterDescriptorArray.length; ++i) {
                if (generalParameterDescriptorArray[i] == generalParameterValueArray[i].getDescriptor()) continue;
                ((DefaultOperationMethod)this.method).updateDescriptors(generalParameterDescriptorArray);
                break;
            }
            this.parameters = new DefaultParameterValueGroup(this.method.getParameters());
            CC_OperationMethod.store(generalParameterValueArray, this.parameters.values(), identityHashMap);
            this.parameters = Parameters.unmodifiable(this.parameters);
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractSingleOperation.class, "setParameters", "parameterValue");
        }
    }

    @Override
    final void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        super.afterUnmarshal(unmarshaller, object);
        CoordinateReferenceSystem coordinateReferenceSystem = super.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = super.getTargetCRS();
        if (this.transform == null && coordinateReferenceSystem != null && coordinateReferenceSystem2 != null && this.parameters != null) {
            try {
                this.transform = DefaultFactories.forBuildin(MathTransformFactory.class).createBaseToDerived(coordinateReferenceSystem, this.parameters, coordinateReferenceSystem2.getCoordinateSystem());
            }
            catch (FactoryException factoryException) {
                Context.warningOccured(Context.current(), AbstractSingleOperation.class, "afterUnmarshal", (Exception)((Object)factoryException), true);
            }
        }
    }
}

