/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultGeodeticCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.GeodeticDatum;

@XmlTransient
public class DefaultGeographicCRS
extends DefaultGeodeticCRS
implements GeographicCRS {
    private static final short[] EPSG_CODES = new short[]{4267, 4269, 4326};
    private static final byte[] CRS_CODES = new byte[]{27, 83, 84};
    private static final long serialVersionUID = 861224913438092335L;

    public DefaultGeographicCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, EllipsoidalCS ellipsoidalCS) {
        super(map, geodeticDatum, (CoordinateSystem)ellipsoidalCS);
    }

    protected DefaultGeographicCRS(GeographicCRS geographicCRS) {
        super((GeodeticCRS)geographicCRS);
    }

    public static DefaultGeographicCRS castOrCopy(GeographicCRS geographicCRS) {
        return geographicCRS == null || geographicCRS instanceof DefaultGeographicCRS ? (DefaultGeographicCRS)geographicCRS : new DefaultGeographicCRS(geographicCRS);
    }

    public Class<? extends GeographicCRS> getInterface() {
        return GeographicCRS.class;
    }

    @Override
    public final GeodeticDatum getDatum() {
        return super.getDatum();
    }

    public EllipsoidalCS getCoordinateSystem() {
        return (EllipsoidalCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultGeographicCRS forConvention(AxesConvention axesConvention) {
        return (DefaultGeographicCRS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(0);
        if (coordinateSystemAxis.getMinimumValue() == -180.0 && coordinateSystemAxis.getMaximumValue() == 180.0) {
            for (ReferenceIdentifier referenceIdentifier : super.getIdentifiers()) {
                if (!"EPSG".equals(referenceIdentifier.getCodeSpace())) continue;
                try {
                    int n = Arrays.binarySearch(EPSG_CODES, Short.parseShort(referenceIdentifier.getCode()));
                    if (n < 0) continue;
                    HashMap hashMap = new HashMap(map);
                    hashMap.put("identifiers", new ImmutableIdentifier(Citations.WMS, "CRS", Short.toString(CRS_CODES[n])));
                    map = hashMap;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return new DefaultGeographicCRS(map, super.getDatum(), (EllipsoidalCS)coordinateSystem);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        return super.formatTo(formatter);
    }

    private DefaultGeographicCRS() {
    }

    DefaultGeographicCRS(GeodeticCRS geodeticCRS) {
        super(geodeticCRS);
        CoordinateSystem coordinateSystem = super.getCoordinateSystem();
        if (!(coordinateSystem instanceof EllipsoidalCS)) {
            throw new IllegalArgumentException(Errors.format((short)50, EllipsoidalCS.class, coordinateSystem.getClass()));
        }
    }
}

