/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.SupportsCondition;
import com.github.sommeri.less4j.core.ast.SupportsLogicalOperator;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class SupportsLogicalCondition
extends SupportsCondition {
    private List<SupportsLogicalOperator> logicalOperators = new ArrayList<SupportsLogicalOperator>();
    private List<SupportsCondition> conditions = new ArrayList<SupportsCondition>();

    public SupportsLogicalCondition(HiddenTokenAwareTree token, SupportsCondition firstCondition) {
        super(token);
        this.conditions.add(firstCondition);
    }

    public void addCondition(SupportsLogicalOperator logicalOperator, SupportsCondition condition) {
        this.logicalOperators.add(logicalOperator);
        this.conditions.add(condition);
    }

    public List<SupportsLogicalOperator> getLogicalOperators() {
        return this.logicalOperators;
    }

    public List<SupportsCondition> getConditions() {
        return this.conditions;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        ArrayList<SupportsLogicalOperator> childs = new ArrayList<SupportsLogicalOperator>(this.logicalOperators);
        childs.addAll(this.conditions);
        return childs;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.SUPPORTS_CONDITION_LOGICAL;
    }

    @Override
    public SupportsLogicalCondition clone() {
        SupportsLogicalCondition result = (SupportsLogicalCondition)super.clone();
        result.logicalOperators = ArraysUtils.deeplyClonedList(this.logicalOperators);
        result.conditions = ArraysUtils.deeplyClonedList(this.conditions);
        result.configureParentToAllChilds();
        return result;
    }
}

