/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty;

import java.util.Set;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.channel.ChannelHandler;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelState;
import org.elasticsearch.common.netty.channel.ChannelStateEvent;
import org.elasticsearch.common.netty.channel.ChannelUpstreamHandler;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

@ChannelHandler.Sharable
public class OpenChannelsHandler
implements ChannelUpstreamHandler {
    final Set<Channel> openChannels = ConcurrentCollections.newConcurrentSet();
    final CounterMetric openChannelsMetric = new CounterMetric();
    final CounterMetric totalChannelsMetric = new CounterMetric();
    final ESLogger logger;
    final ChannelFutureListener remover = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            boolean removed = OpenChannelsHandler.this.openChannels.remove(future.getChannel());
            if (removed) {
                OpenChannelsHandler.this.openChannelsMetric.dec();
            }
            if (OpenChannelsHandler.this.logger.isTraceEnabled()) {
                OpenChannelsHandler.this.logger.trace("channel closed: {}", future.getChannel());
            }
        }
    };

    public OpenChannelsHandler(ESLogger logger) {
        this.logger = logger;
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        ChannelStateEvent evt;
        if (e instanceof ChannelStateEvent && (evt = (ChannelStateEvent)e).getState() == ChannelState.OPEN && Boolean.TRUE.equals(evt.getValue())) {
            boolean added;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("channel opened: {}", ctx.getChannel());
            }
            if (added = this.openChannels.add(ctx.getChannel())) {
                this.openChannelsMetric.inc();
                this.totalChannelsMetric.inc();
                ctx.getChannel().getCloseFuture().addListener(this.remover);
            }
        }
        ctx.sendUpstream(e);
    }

    public long numberOfOpenChannels() {
        return this.openChannelsMetric.count();
    }

    public long totalChannels() {
        return this.totalChannelsMetric.count();
    }

    public void close() {
        for (Channel channel : this.openChannels) {
            channel.close().awaitUninterruptibly();
        }
    }
}

