/*
 * Decompiled with CFR 0.152.
 */
package org.apache.neethi.util;

import java.util.List;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyComparator {
    private PolicyComparator() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean compare(Policy arg1, Policy arg2) {
        if (arg1.getName() != null) {
            if (arg2.getName() == null) return false;
            arg1.getName().equals(arg2.getName());
        } else if (arg2.getName() != null) {
            return false;
        }
        if (arg1.getNamespace() != null && !arg1.getNamespace().equals(arg2.getNamespace())) {
            return false;
        }
        if (arg1.getId() != null) {
            if (arg2.getId() == null) return false;
            arg1.getId().equals(arg2.getId());
            return PolicyComparator.compare(arg1.getPolicyComponents(), arg2.getPolicyComponents());
        } else {
            if (arg2.getId() == null) return PolicyComparator.compare(arg1.getPolicyComponents(), arg2.getPolicyComponents());
            return false;
        }
    }

    public static boolean compare(PolicyComponent arg1, PolicyComponent arg2) {
        if (!arg1.getClass().equals(arg2.getClass())) {
            return false;
        }
        if (arg1 instanceof Policy) {
            return PolicyComparator.compare((Policy)arg1, (Policy)arg2);
        }
        if (arg1 instanceof All) {
            return PolicyComparator.compare((All)arg1, (All)arg2);
        }
        if (arg1 instanceof ExactlyOne) {
            return PolicyComparator.compare((ExactlyOne)arg1, (ExactlyOne)arg2);
        }
        if (arg1 instanceof Assertion) {
            return PolicyComparator.compare((Assertion)arg1, (Assertion)arg2);
        }
        return false;
    }

    public static boolean compare(All arg1, All arg2) {
        return PolicyComparator.compare(arg1.getPolicyComponents(), arg2.getPolicyComponents());
    }

    public static boolean compare(ExactlyOne arg1, ExactlyOne arg2) {
        return PolicyComparator.compare(arg1.getPolicyComponents(), arg2.getPolicyComponents());
    }

    public static boolean compare(Assertion arg1, Assertion arg2) {
        return arg1.getName().equals(arg2.getName());
    }

    private static boolean compare(List<PolicyComponent> arg1, List<PolicyComponent> arg2) {
        if (arg1.size() != arg2.size()) {
            return false;
        }
        for (PolicyComponent assertion1 : arg1) {
            boolean match = false;
            for (PolicyComponent assertion2 : arg2) {
                if (!PolicyComparator.compare(assertion1, assertion2)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }
}

