/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.AbstractLayout;

public abstract class AbstractStringLayout
extends AbstractLayout<String> {
    protected static final int DEFAULT_STRING_BUILDER_SIZE = 1024;
    private static final ThreadLocal<StringBuilder> threadLocal = new ThreadLocal();
    private static final long serialVersionUID = 1L;
    private final Charset charset;
    private final String charsetName;
    private final boolean useCustomEncoding;

    protected AbstractStringLayout(Charset charset) {
        this(charset, null, null);
    }

    protected AbstractStringLayout(Charset charset, byte[] header, byte[] footer) {
        super(header, footer);
        this.charset = charset == null ? StandardCharsets.UTF_8 : charset;
        this.charsetName = this.charset.name();
        this.useCustomEncoding = AbstractStringLayout.isPreJava8() && (StandardCharsets.ISO_8859_1.equals(charset) || StandardCharsets.US_ASCII.equals(charset));
    }

    private static boolean isPreJava8() {
        String version = System.getProperty("java.version");
        String[] parts = version.split("\\.");
        try {
            int major = Integer.parseInt(parts[1]);
            return major < 8;
        }
        catch (Exception ex) {
            return true;
        }
    }

    static byte[] toBytes(String str, Charset charset) {
        if (str != null) {
            if (StandardCharsets.ISO_8859_1.equals(charset)) {
                return AbstractStringLayout.encodeSingleByteChars(str);
            }
            Charset actual = charset != null ? charset : Charset.defaultCharset();
            try {
                return str.getBytes(actual.name());
            }
            catch (UnsupportedEncodingException e) {
                return str.getBytes(actual);
            }
        }
        return null;
    }

    protected StringBuilder getStringBuilder() {
        StringBuilder result = threadLocal.get();
        if (result == null) {
            result = new StringBuilder(1024);
            threadLocal.set(result);
        }
        result.setLength(0);
        return result;
    }

    protected byte[] getBytes(String s) {
        if (this.useCustomEncoding) {
            return AbstractStringLayout.encodeSingleByteChars(s);
        }
        try {
            return s.getBytes(this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes(this.charset);
        }
    }

    private static byte[] encodeSingleByteChars(String s) {
        int length = s.length();
        byte[] result = new byte[length];
        AbstractStringLayout.encodeString(s, 0, length, result);
        return result;
    }

    private static int encodeIsoChars(String charArray, int charIndex, byte[] byteArray, int byteIndex, int length) {
        char c;
        int i;
        for (i = 0; i < length && (c = charArray.charAt(charIndex++)) <= '\u00ff'; ++i) {
            byteArray[byteIndex++] = (byte)c;
        }
        return i;
    }

    private static int encodeString(String charArray, int charOffset, int charLength, byte[] byteArray) {
        int byteOffset = 0;
        int length = Math.min(charLength, byteArray.length);
        int charDoneIndex = charOffset + length;
        while (charOffset < charDoneIndex) {
            char c;
            int done = AbstractStringLayout.encodeIsoChars(charArray, charOffset, byteArray, byteOffset, length);
            charOffset += done;
            byteOffset += done;
            if (done == length) continue;
            if (Character.isHighSurrogate(c = charArray.charAt(charOffset++)) && charOffset < charDoneIndex && Character.isLowSurrogate(charArray.charAt(charOffset))) {
                if (charLength > byteArray.length) {
                    ++charDoneIndex;
                    --charLength;
                }
                ++charOffset;
            }
            byteArray[byteOffset++] = 63;
            length = Math.min(charDoneIndex - charOffset, byteArray.length - byteOffset);
        }
        return byteOffset;
    }

    protected Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public byte[] toByteArray(LogEvent event) {
        return this.getBytes((String)this.toSerializable(event));
    }
}

