/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Map;
import javax.measure.IncommensurableException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.MismatchedDatumException;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;

@XmlType(name="ConversionType")
@XmlRootElement(name="Conversion")
public class DefaultConversion
extends AbstractSingleOperation
implements Conversion {
    private static final long serialVersionUID = -2148164324805562793L;

    public DefaultConversion(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3, OperationMethod operationMethod, MathTransform mathTransform) {
        super(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, operationMethod, mathTransform);
        ArgumentChecks.ensureNonNull("sourceCRS", coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull("targetCRS", coordinateReferenceSystem2);
    }

    public DefaultConversion(Map<String, ?> map, OperationMethod operationMethod, MathTransform mathTransform, ParameterValueGroup parameterValueGroup) {
        super(map, operationMethod);
        if (mathTransform != null) {
            this.transform = mathTransform;
            DefaultConversion.checkDimensions(operationMethod, 0, mathTransform, map);
        } else if (parameterValueGroup == null) {
            throw new IllegalArgumentException(Resources.forProperties(map).getString((short)70));
        }
        if (parameterValueGroup != null) {
            this.parameters = Parameters.unmodifiable(parameterValueGroup);
        }
        this.checkDimensions(map);
    }

    DefaultConversion(Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransformFactory mathTransformFactory, OperationMethod[] operationMethodArray) throws FactoryException {
        super((SingleOperation)conversion);
        int n = ReferencingUtilities.getDimension(super.getInterpolationCRS());
        if (this.transform == null) {
            if (this.parameters == null) {
                throw new IllegalArgumentException(Resources.format((short)70));
            }
            if (mathTransformFactory instanceof DefaultMathTransformFactory) {
                DefaultMathTransformFactory.Context context;
                if (coordinateReferenceSystem2 instanceof GeneralDerivedCRS) {
                    context = ReferencingUtilities.createTransformContext(coordinateReferenceSystem, null, null);
                    context.setTarget(coordinateReferenceSystem2.getCoordinateSystem());
                } else {
                    context = ReferencingUtilities.createTransformContext(coordinateReferenceSystem, coordinateReferenceSystem2, null);
                }
                this.transform = ((DefaultMathTransformFactory)mathTransformFactory).createParameterizedTransform(this.parameters, context);
                this.parameters = Parameters.unmodifiable(context.getCompletedParameters());
            } else {
                this.transform = mathTransformFactory.createBaseToDerived(coordinateReferenceSystem, this.parameters, coordinateReferenceSystem2.getCoordinateSystem());
            }
            operationMethodArray[0] = mathTransformFactory.getLastMethodUsed();
        } else if (this.sourceCRS == null && this.targetCRS == null && mathTransformFactory instanceof DefaultMathTransformFactory) {
            DefaultMathTransformFactory.Context context = new DefaultMathTransformFactory.Context();
            context.setSource(coordinateReferenceSystem.getCoordinateSystem());
            context.setTarget(coordinateReferenceSystem2.getCoordinateSystem());
            this.transform = ((DefaultMathTransformFactory)mathTransformFactory).swapAndScaleAxes(this.transform, context);
        } else {
            this.transform = DefaultConversion.swapAndScaleAxes(this.transform, coordinateReferenceSystem, this.sourceCRS, n, true, mathTransformFactory);
            this.transform = DefaultConversion.swapAndScaleAxes(this.transform, this.targetCRS, coordinateReferenceSystem2, n, false, mathTransformFactory);
            n = 0;
        }
        if (n != 0) {
            this.transform = mathTransformFactory.createPassThroughTransform(n, this.transform, 0);
        }
        this.sourceCRS = coordinateReferenceSystem;
        this.targetCRS = coordinateReferenceSystem2;
    }

    protected DefaultConversion(Conversion conversion) {
        super((SingleOperation)conversion);
    }

    public static DefaultConversion castOrCopy(Conversion conversion) {
        return SubTypes.forConversion(conversion);
    }

    public Class<? extends Conversion> getInterface() {
        return Conversion.class;
    }

    public <T extends Conversion> T specialize(Class<T> clazz, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransformFactory mathTransformFactory) throws FactoryException {
        ArgumentChecks.ensureNonNull("baseType", clazz);
        ArgumentChecks.ensureNonNull("sourceCRS", coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull("targetCRS", coordinateReferenceSystem2);
        ArgumentChecks.ensureNonNull("factory", mathTransformFactory);
        DefaultConversion.ensureCompatibleDatum("sourceCRS", super.getSourceCRS(), coordinateReferenceSystem);
        if (!(coordinateReferenceSystem2 instanceof GeneralDerivedCRS)) {
            DefaultConversion.ensureCompatibleDatum("targetCRS", super.getTargetCRS(), coordinateReferenceSystem2);
        } else if (super.getTargetCRS() != null) {
            DefaultConversion.ensureCompatibleDatum("targetCRS", coordinateReferenceSystem, super.getTargetCRS());
        }
        return SubTypes.create(clazz, this, coordinateReferenceSystem, coordinateReferenceSystem2, mathTransformFactory);
    }

    private static void ensureCompatibleDatum(String string, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        Datum datum;
        if (coordinateReferenceSystem instanceof SingleCRS && coordinateReferenceSystem2 instanceof SingleCRS && (datum = ((SingleCRS)coordinateReferenceSystem).getDatum()) != null && !Utilities.equalsIgnoreMetadata(datum, ((SingleCRS)coordinateReferenceSystem2).getDatum())) {
            throw new MismatchedDatumException(Resources.format((short)28, datum.getName(), string));
        }
    }

    private static MathTransform swapAndScaleAxes(MathTransform mathTransform, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, int n, boolean bl, MathTransformFactory mathTransformFactory) throws FactoryException {
        if (coordinateReferenceSystem != null && coordinateReferenceSystem2 != null && coordinateReferenceSystem != coordinateReferenceSystem2) {
            try {
                Matrix matrix = CoordinateSystems.swapAndScaleAxes(coordinateReferenceSystem.getCoordinateSystem(), coordinateReferenceSystem2.getCoordinateSystem());
                if (!matrix.isIdentity()) {
                    if (n != 0) {
                        matrix = Matrices.createPassThrough(n, matrix, 0);
                    }
                    MathTransform mathTransform2 = mathTransformFactory.createAffineTransform(matrix);
                    mathTransform = mathTransformFactory.createConcatenatedTransform(bl ? mathTransform2 : mathTransform, bl ? mathTransform : mathTransform2);
                }
            }
            catch (IncommensurableException incommensurableException) {
                throw new IllegalArgumentException(Errors.format((short)45, bl ? "sourceCRS" : "targetCRS", (bl ? coordinateReferenceSystem : coordinateReferenceSystem2).getName()), incommensurableException);
            }
        }
        return mathTransform;
    }

    private DefaultConversion() {
    }
}

