/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.validators;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Body;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SupportedCSSBodyMembers {
    public Set<ASTCssNodeType> getSupportedMembers(Body node) {
        if (node.getParent() != null) {
            return this.getSupportedMembers(node.getType(), node.getParent().getType());
        }
        return this.getSupportedMembers(node.getType(), null);
    }

    public Set<ASTCssNodeType> getSupportedMembers(ASTCssNodeType bodyType, ASTCssNodeType ownerType) {
        switch (bodyType) {
            case STYLE_SHEET: {
                return this.topLevelElements();
            }
        }
        if (ownerType == null) {
            return this.allNodeTypes();
        }
        switch (ownerType) {
            case VIEWPORT: {
                return this.createSet(ASTCssNodeType.DECLARATION, ASTCssNodeType.UNKNOWN_AT_RULE, ASTCssNodeType.FAULTY_NODE);
            }
            case RULE_SET: {
                return this.createSet(ASTCssNodeType.DECLARATION, ASTCssNodeType.UNKNOWN_AT_RULE, ASTCssNodeType.FAULTY_NODE);
            }
            case PAGE: {
                return this.createSet(ASTCssNodeType.DECLARATION, ASTCssNodeType.UNKNOWN_AT_RULE, ASTCssNodeType.PAGE_MARGIN_BOX, ASTCssNodeType.FAULTY_NODE);
            }
            case PAGE_MARGIN_BOX: {
                return this.createSet(ASTCssNodeType.DECLARATION, ASTCssNodeType.UNKNOWN_AT_RULE, ASTCssNodeType.FAULTY_NODE);
            }
            case MEDIA: 
            case DOCUMENT: {
                return this.topLevelElements();
            }
            case KEYFRAMES: {
                return this.createSet(ASTCssNodeType.RULE_SET, ASTCssNodeType.UNKNOWN_AT_RULE, ASTCssNodeType.FAULTY_NODE);
            }
        }
        return this.allNodeTypes();
    }

    private Set<ASTCssNodeType> topLevelElements() {
        Set<ASTCssNodeType> result = this.allNodeTypes();
        result.remove((Object)ASTCssNodeType.DECLARATION);
        result.remove((Object)ASTCssNodeType.PAGE_MARGIN_BOX);
        return result;
    }

    private Set<ASTCssNodeType> createSet(ASTCssNodeType ... types) {
        return new HashSet<ASTCssNodeType>(Arrays.asList(types));
    }

    private Set<ASTCssNodeType> allNodeTypes() {
        return new HashSet<ASTCssNodeType>(Arrays.asList(ASTCssNodeType.values()));
    }
}

