/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.Comment;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.problems.BugHappened;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;

public class ASTManipulator {
    public ASTCssNode findParentOfType(ASTCssNode node, ASTCssNodeType ... type) {
        HashSet allTypes = new HashSet();
        Collections.addAll(allTypes, type);
        ASTCssNode candidate = node;
        while (candidate.getParent() != null) {
            if (!allTypes.contains((Object)(candidate = candidate.getParent()).getType())) continue;
            return candidate;
        }
        return candidate;
    }

    public void replace(ASTCssNode oldChild, ASTCssNode newChild) {
        PropertyDescriptor[] propertyDescriptors;
        if (oldChild == newChild) {
            return;
        }
        ASTCssNode parent = oldChild.getParent();
        for (PropertyDescriptor descriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(parent.getClass())) {
            List list;
            if (!this.isAstProperty(descriptor)) continue;
            Class<?> propertyType = descriptor.getPropertyType();
            if (propertyType != null && propertyType.isInstance(newChild)) {
                Object value = this.getPropertyValue(parent, descriptor);
                if (value != oldChild) continue;
                this.replaceInProperty(descriptor, parent, oldChild, newChild);
                return;
            }
            if (!this.isList(propertyType) || !(list = (List)this.getPropertyValue(parent, descriptor)).contains(oldChild)) continue;
            this.replaceInList(parent, list, oldChild, newChild);
            return;
        }
    }

    private boolean isAstProperty(PropertyDescriptor descriptor) {
        Method rm = descriptor.getReadMethod();
        return rm != null && !rm.isAnnotationPresent(NotAstProperty.class);
    }

    private boolean isList(Class<?> propertyType) {
        return propertyType != null && propertyType.isAssignableFrom(List.class);
    }

    private void replaceInList(ASTCssNode parent, List list, ASTCssNode oldChild, ASTCssNode newChild) {
        int childsIndex = list.indexOf(oldChild);
        list.remove(oldChild);
        list.add(childsIndex, newChild);
        oldChild.setParent(null);
        newChild.setParent(parent);
    }

    private void replaceInProperty(PropertyDescriptor propertyDescriptor, ASTCssNode parent, ASTCssNode oldChild, ASTCssNode newChild) {
        newChild.setParent(parent);
        oldChild.setParent(null);
        this.setPropertyValue(parent, newChild, propertyDescriptor);
    }

    public void removeFromBody(ASTCssNode node) {
        ASTCssNode parent = node.getParent();
        if (!(parent instanceof Body)) {
            throw new BugHappened("Parent is not a body instance. " + parent, parent);
        }
        Body pBody = (Body)parent;
        pBody.removeMember(node);
        node.setParent(null);
    }

    public void removeFromBody(Body body, List<ASTCssNode> nodes) {
        body.removeMembers(nodes);
        for (ASTCssNode node : nodes) {
            node.setParent(null);
        }
    }

    public void replaceInBody(ASTCssNode oldNode, ASTCssNode newNode) {
        ASTCssNode parent = oldNode.getParent();
        if (!(parent instanceof Body)) {
            throw new BugHappened("Parent is not a body instance. " + parent, parent);
        }
        Body pBody = (Body)parent;
        pBody.replaceMember(oldNode, newNode);
    }

    public void replaceInBody(ASTCssNode oldNode, List<ASTCssNode> newNodes) {
        ASTCssNode parent = oldNode.getParent();
        if (!(parent instanceof Body)) {
            throw new BugHappened("Parent is not a body instance. " + parent, parent);
        }
        Body pBody = (Body)parent;
        pBody.replaceMember(oldNode, newNodes);
    }

    public void addIntoBody(ASTCssNode newNode, ASTCssNode afterNode) {
        ASTCssNode parent = afterNode.getParent();
        if (!(parent instanceof Body)) {
            throw new BugHappened("Parent is not a body instance. " + parent, parent);
        }
        Body pBody = (Body)parent;
        pBody.addMemberAfter(newNode, afterNode);
        newNode.setParent(parent);
    }

    public void addIntoBody(List<? extends ASTCssNode> newNodes, ASTCssNode afterNode) {
        ASTCssNode parent = afterNode.getParent();
        if (!(parent instanceof Body)) {
            throw new BugHappened("Parent is not a body instance. " + parent, parent);
        }
        Body pBody = (Body)parent;
        pBody.addMembersAfter(newNodes, afterNode);
        for (ASTCssNode aSTCssNode : newNodes) {
            aSTCssNode.setParent(pBody);
        }
    }

    private void setPropertyValue(ASTCssNode parent, ASTCssNode value, String name) {
        try {
            PropertyUtils.setProperty((Object)parent, (String)name, (Object)value);
        }
        catch (IllegalAccessException e) {
            throw new BugHappened(e, value);
        }
        catch (InvocationTargetException e) {
            throw new BugHappened(e, value);
        }
        catch (NoSuchMethodException e) {
            throw new BugHappened(e, value);
        }
    }

    private void setPropertyValue(ASTCssNode parent, ASTCssNode value, PropertyDescriptor descriptor) {
        this.setPropertyValue(parent, value, descriptor.getName());
    }

    private Object getPropertyValue(ASTCssNode object, PropertyDescriptor descriptor) {
        try {
            Object result = PropertyUtils.getProperty((Object)object, (String)descriptor.getName());
            return result;
        }
        catch (IllegalAccessException e) {
            throw new BugHappened(e, object);
        }
        catch (InvocationTargetException e) {
            throw new BugHappened(e, object);
        }
        catch (NoSuchMethodException e) {
            throw new BugHappened(e, object);
        }
    }

    public void removeFromClosestBody(ASTCssNode node) {
        ASTCssNode removeNode;
        for (removeNode = node; removeNode != null && !(removeNode.getParent() instanceof Body); removeNode = removeNode.getParent()) {
        }
        if (removeNode != null) {
            this.removeFromBody(removeNode);
        }
    }

    public void moveMembersBetweenBodies(Body from, Body to) {
        to.addMembers(from.getMembers());
        from.removeAllMembers();
        to.configureParentToAllChilds();
    }

    public void addOpeningComments(ASTCssNode newOwner, List<Comment> comments) {
        newOwner.addOpeningComments(comments);
        for (Comment comment : comments) {
            comment.setParent(newOwner);
        }
    }

    public void setTreeVisibility(ASTCssNode node, ASTCssNode.Visibility visibility) {
        node.setVisibility(visibility);
        for (ASTCssNode aSTCssNode : node.getChilds()) {
            if (aSTCssNode.hasVisibilityBlock() || visibility == aSTCssNode.getVisibility()) continue;
            this.setTreeVisibility(aSTCssNode, visibility);
        }
    }
}

