/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.SolrClientBuilder;
import org.apache.solr.client.solrj.request.IsUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.slf4j.MDC;

public class LBHttpSolrClient
extends SolrClient {
    private static Set<Integer> RETRY_CODES = new HashSet<Integer>(4);
    private final Map<String, ServerWrapper> aliveServers = new LinkedHashMap<String, ServerWrapper>();
    protected final Map<String, ServerWrapper> zombieServers = new ConcurrentHashMap<String, ServerWrapper>();
    private volatile ServerWrapper[] aliveServerList = new ServerWrapper[0];
    private ScheduledExecutorService aliveCheckExecutor;
    private final HttpClient httpClient;
    private final boolean clientIsInternal;
    private HttpSolrClient.Builder httpSolrClientBuilder;
    private final AtomicInteger counter = new AtomicInteger(-1);
    private static final SolrQuery solrQuery;
    private volatile ResponseParser parser;
    private volatile RequestWriter requestWriter;
    private Set<String> queryParams = new HashSet<String>();
    private Integer connectionTimeout;
    private Integer soTimeout;
    private int interval = 60000;
    private static final int CHECK_INTERVAL = 60000;
    private static final int NONSTANDARD_PING_LIMIT = 5;

    @Deprecated
    protected LBHttpSolrClient(HttpSolrClient.Builder httpSolrClientBuilder, HttpClient httpClient, String ... solrServerUrl) {
        this(((Builder)new Builder().withHttpSolrClientBuilder(httpSolrClientBuilder).withHttpClient(httpClient)).withBaseSolrUrls(solrServerUrl));
    }

    @Deprecated
    protected LBHttpSolrClient(HttpClient httpClient, ResponseParser parser, String ... solrServerUrl) {
        this((Builder)((Builder)new Builder().withBaseSolrUrls(solrServerUrl).withResponseParser(parser)).withHttpClient(httpClient));
    }

    protected LBHttpSolrClient(Builder builder) {
        this.clientIsInternal = builder.httpClient == null;
        this.httpSolrClientBuilder = builder.httpSolrClientBuilder;
        this.httpClient = builder.httpClient == null ? this.constructClient(builder.baseSolrUrls.toArray(new String[builder.baseSolrUrls.size()])) : builder.httpClient;
        this.connectionTimeout = builder.connectionTimeoutMillis;
        this.soTimeout = builder.socketTimeoutMillis;
        this.parser = builder.responseParser;
        if (!builder.baseSolrUrls.isEmpty()) {
            for (String s : builder.baseSolrUrls) {
                ServerWrapper wrapper = new ServerWrapper(this.makeSolrClient(s));
                this.aliveServers.put(wrapper.getKey(), wrapper);
            }
        }
        this.updateAliveList();
    }

    private HttpClient constructClient(String[] solrServerUrl) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (solrServerUrl != null && solrServerUrl.length > 1) {
            params.set("retry", false);
        } else {
            params.set("retry", true);
        }
        return HttpClientUtil.createClient(params);
    }

    public Set<String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Set<String> queryParams) {
        this.queryParams = queryParams;
    }

    public void addQueryParams(String queryOnlyParam) {
        this.queryParams.add(queryOnlyParam);
    }

    public static String normalize(String server) {
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSolrClient makeSolrClient(String server) {
        HttpSolrClient client;
        if (this.httpSolrClientBuilder != null) {
            LBHttpSolrClient lBHttpSolrClient = this;
            synchronized (lBHttpSolrClient) {
                this.httpSolrClientBuilder.withBaseSolrUrl(server).withHttpClient(this.httpClient);
                if (this.connectionTimeout != null) {
                    this.httpSolrClientBuilder.withConnectionTimeout(this.connectionTimeout);
                }
                if (this.soTimeout != null) {
                    this.httpSolrClientBuilder.withSocketTimeout(this.soTimeout);
                }
                client = this.httpSolrClientBuilder.build();
            }
        } else {
            HttpSolrClient.Builder clientBuilder = (HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(server).withHttpClient(this.httpClient)).withResponseParser(this.parser);
            if (this.connectionTimeout != null) {
                clientBuilder.withConnectionTimeout(this.connectionTimeout);
            }
            if (this.soTimeout != null) {
                clientBuilder.withSocketTimeout(this.soTimeout);
            }
            client = clientBuilder.build();
        }
        if (this.requestWriter != null) {
            client.setRequestWriter(this.requestWriter);
        }
        if (this.queryParams != null) {
            client.setQueryParams(this.queryParams);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp request(Req req) throws SolrServerException, IOException {
        Rsp rsp = new Rsp();
        Exception ex = null;
        boolean isNonRetryable = req.request instanceof IsUpdateRequest || CommonParams.ADMIN_PATHS.contains(req.request.getPath());
        ArrayList<ServerWrapper> skipped = null;
        Integer numServersToTry = req.getNumServersToTry();
        int numServersTried = 0;
        boolean timeAllowedExceeded = false;
        long timeAllowedNano = this.getTimeAllowedInNanos(req.getRequest());
        long timeOutTime = System.nanoTime() + timeAllowedNano;
        for (String serverStr : req.getServers()) {
            timeAllowedExceeded = this.isTimeExceeded(timeAllowedNano, timeOutTime);
            if (timeAllowedExceeded) break;
            ServerWrapper wrapper = this.zombieServers.get(serverStr = LBHttpSolrClient.normalize(serverStr));
            if (wrapper != null) {
                int numDeadServersToTry = req.getNumDeadServersToTry();
                if (numDeadServersToTry <= 0) continue;
                if (skipped == null) {
                    skipped = new ArrayList<ServerWrapper>(numDeadServersToTry);
                    skipped.add(wrapper);
                    continue;
                }
                if (skipped.size() >= numDeadServersToTry) continue;
                skipped.add(wrapper);
                continue;
            }
            try {
                MDC.put((String)"LBHttpSolrClient.url", (String)serverStr);
                if (numServersToTry == null || numServersTried <= numServersToTry) {
                    HttpSolrClient client = this.makeSolrClient(serverStr);
                    ++numServersTried;
                    ex = this.doRequest(client, req, rsp, isNonRetryable, false, null);
                    if (ex != null) continue;
                    Rsp rsp2 = rsp;
                    return rsp2;
                }
                break;
            }
            finally {
                MDC.remove((String)"LBHttpSolrClient.url");
            }
        }
        if (skipped != null) {
            for (ServerWrapper wrapper : skipped) {
                timeAllowedExceeded = this.isTimeExceeded(timeAllowedNano, timeOutTime);
                if (timeAllowedExceeded || numServersToTry != null && numServersTried > numServersToTry) break;
                try {
                    MDC.put((String)"LBHttpSolrClient.url", (String)wrapper.client.getBaseURL());
                    ++numServersTried;
                    ex = this.doRequest(wrapper.client, req, rsp, isNonRetryable, true, wrapper.getKey());
                    if (ex != null) continue;
                    Rsp rsp3 = rsp;
                    return rsp3;
                }
                finally {
                    MDC.remove((String)"LBHttpSolrClient.url");
                }
            }
        }
        String solrServerExceptionMessage = timeAllowedExceeded ? "Time allowed to handle this request exceeded" : (numServersToTry != null && numServersTried > numServersToTry ? "No live SolrServers available to handle this request: numServersTried=" + numServersTried + " numServersToTry=" + numServersToTry : "No live SolrServers available to handle this request");
        if (ex == null) {
            throw new SolrServerException(solrServerExceptionMessage);
        }
        throw new SolrServerException(solrServerExceptionMessage + ":" + this.zombieServers.keySet(), ex);
    }

    protected Exception addZombie(HttpSolrClient server, Exception e) {
        ServerWrapper wrapper = new ServerWrapper(server);
        wrapper.standard = false;
        this.zombieServers.put(wrapper.getKey(), wrapper);
        this.startAliveCheckExecutor();
        return e;
    }

    protected Exception doRequest(HttpSolrClient client, Req req, Rsp rsp, boolean isNonRetryable, boolean isZombie, String zombieKey) throws SolrServerException, IOException {
        Exception ex = null;
        try {
            rsp.server = client.getBaseURL();
            rsp.rsp = client.request(req.getRequest(), (String)null);
            if (isZombie) {
                this.zombieServers.remove(zombieKey);
            }
        }
        catch (HttpSolrClient.RemoteExecutionException e) {
            throw e;
        }
        catch (SolrException e) {
            if (!isNonRetryable && RETRY_CODES.contains(e.code())) {
                ex = !isZombie ? this.addZombie(client, e) : e;
            }
            if (isZombie) {
                this.zombieServers.remove(zombieKey);
            }
            throw e;
        }
        catch (SocketException e) {
            if (!isNonRetryable || e instanceof ConnectException) {
                ex = !isZombie ? this.addZombie(client, e) : e;
            }
            throw e;
        }
        catch (SocketTimeoutException e) {
            if (!isNonRetryable) {
                ex = !isZombie ? this.addZombie(client, e) : e;
            }
            throw e;
        }
        catch (SolrServerException e) {
            Throwable rootCause = e.getRootCause();
            if (!isNonRetryable && rootCause instanceof IOException) {
                ex = !isZombie ? this.addZombie(client, e) : e;
            }
            if (isNonRetryable && rootCause instanceof ConnectException) {
                ex = !isZombie ? this.addZombie(client, e) : e;
            }
            throw e;
        }
        catch (Exception e) {
            throw new SolrServerException(e);
        }
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAliveList() {
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            this.aliveServerList = this.aliveServers.values().toArray(new ServerWrapper[this.aliveServers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerWrapper removeFromAlive(String key) {
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            ServerWrapper wrapper = this.aliveServers.remove(key);
            if (wrapper != null) {
                this.updateAliveList();
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToAlive(ServerWrapper wrapper) {
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            ServerWrapper prev = this.aliveServers.put(wrapper.getKey(), wrapper);
            this.updateAliveList();
        }
    }

    public void addSolrServer(String server) throws MalformedURLException {
        HttpSolrClient client = this.makeSolrClient(server);
        this.addToAlive(new ServerWrapper(client));
    }

    public String removeSolrServer(String server) {
        try {
            server = new URL(server).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        this.removeFromAlive(server);
        this.zombieServers.remove(server);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            Iterator<ServerWrapper> wrappersIt = this.aliveServers.values().iterator();
            while (wrappersIt.hasNext()) {
                wrappersIt.next().client.setConnectionTimeout(timeout);
            }
        }
        Iterator<ServerWrapper> wrappersIt = this.zombieServers.values().iterator();
        while (wrappersIt.hasNext()) {
            wrappersIt.next().client.setConnectionTimeout(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
        Map<String, ServerWrapper> map = this.aliveServers;
        synchronized (map) {
            Iterator<ServerWrapper> wrappersIt = this.aliveServers.values().iterator();
            while (wrappersIt.hasNext()) {
                wrappersIt.next().client.setSoTimeout(timeout);
            }
        }
        Iterator<ServerWrapper> wrappersIt = this.zombieServers.values().iterator();
        while (wrappersIt.hasNext()) {
            wrappersIt.next().client.setSoTimeout(timeout);
        }
    }

    @Override
    public void close() {
        if (this.aliveCheckExecutor != null) {
            this.aliveCheckExecutor.shutdownNow();
        }
        if (this.clientIsInternal) {
            HttpClientUtil.close(this.httpClient);
        }
    }

    @Override
    public NamedList<Object> request(SolrRequest request, String collection) throws SolrServerException, IOException {
        return this.request(request, collection, null);
    }

    public NamedList<Object> request(SolrRequest request, String collection, Integer numServersToTry) throws SolrServerException, IOException {
        SolrServerException ex = null;
        ServerWrapper[] serverList = this.aliveServerList;
        int maxTries = numServersToTry == null ? serverList.length : numServersToTry;
        int numServersTried = 0;
        HashMap<String, ServerWrapper> justFailed = null;
        boolean timeAllowedExceeded = false;
        long timeAllowedNano = this.getTimeAllowedInNanos(request);
        long timeOutTime = System.nanoTime() + timeAllowedNano;
        for (int attempts = 0; attempts < maxTries && !(timeAllowedExceeded = this.isTimeExceeded(timeAllowedNano, timeOutTime)); ++attempts) {
            int count = this.counter.incrementAndGet() & Integer.MAX_VALUE;
            ServerWrapper wrapper = serverList[count % serverList.length];
            try {
                ++numServersTried;
                return wrapper.client.request(request, collection);
            }
            catch (SolrException e) {
                throw e;
            }
            catch (SolrServerException e) {
                if (e.getRootCause() instanceof IOException) {
                    ex = e;
                    this.moveAliveToDead(wrapper);
                    if (justFailed == null) {
                        justFailed = new HashMap<String, ServerWrapper>();
                    }
                    justFailed.put(wrapper.getKey(), wrapper);
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
        }
        for (ServerWrapper wrapper : this.zombieServers.values()) {
            timeAllowedExceeded = this.isTimeExceeded(timeAllowedNano, timeOutTime);
            if (timeAllowedExceeded) break;
            if (!wrapper.standard || justFailed != null && justFailed.containsKey(wrapper.getKey())) continue;
            try {
                ++numServersTried;
                NamedList<Object> rsp = wrapper.client.request(request, collection);
                this.zombieServers.remove(wrapper.getKey());
                this.addToAlive(wrapper);
                return rsp;
            }
            catch (SolrException e) {
                throw e;
            }
            catch (SolrServerException e) {
                if (e.getRootCause() instanceof IOException) {
                    ex = e;
                    continue;
                }
                throw e;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
        }
        String solrServerExceptionMessage = timeAllowedExceeded ? "Time allowed to handle this request exceeded" : (numServersToTry != null && numServersTried > numServersToTry ? "No live SolrServers available to handle this request: numServersTried=" + numServersTried + " numServersToTry=" + numServersToTry : "No live SolrServers available to handle this request");
        if (ex == null) {
            throw new SolrServerException(solrServerExceptionMessage);
        }
        throw new SolrServerException(solrServerExceptionMessage, ex);
    }

    private long getTimeAllowedInNanos(SolrRequest req) {
        SolrParams reqParams = req.getParams();
        return reqParams == null ? -1L : TimeUnit.NANOSECONDS.convert(reqParams.getInt("timeAllowed", -1), TimeUnit.MILLISECONDS);
    }

    private boolean isTimeExceeded(long timeAllowedNano, long timeOutTime) {
        return timeAllowedNano > 0L && System.nanoTime() > timeOutTime;
    }

    private void checkAZombieServer(ServerWrapper zombieServer) {
        block4: {
            try {
                ServerWrapper wrapper;
                QueryResponse resp = zombieServer.client.query(solrQuery);
                if (resp.getStatus() == 0 && (wrapper = this.zombieServers.remove(zombieServer.getKey())) != null) {
                    wrapper.failedPings = 0;
                    if (wrapper.standard) {
                        this.addToAlive(wrapper);
                    }
                }
            }
            catch (Exception e) {
                ++zombieServer.failedPings;
                if (zombieServer.standard || zombieServer.failedPings < 5) break block4;
                this.zombieServers.remove(zombieServer.getKey());
            }
        }
    }

    private void moveAliveToDead(ServerWrapper wrapper) {
        if ((wrapper = this.removeFromAlive(wrapper.getKey())) == null) {
            return;
        }
        this.zombieServers.put(wrapper.getKey(), wrapper);
        this.startAliveCheckExecutor();
    }

    public void setAliveCheckInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Alive check interval must be positive, specified value = " + interval);
        }
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAliveCheckExecutor() {
        if (this.aliveCheckExecutor == null) {
            LBHttpSolrClient lBHttpSolrClient = this;
            synchronized (lBHttpSolrClient) {
                if (this.aliveCheckExecutor == null) {
                    this.aliveCheckExecutor = Executors.newSingleThreadScheduledExecutor(new SolrjNamedThreadFactory("aliveCheckExecutor"));
                    this.aliveCheckExecutor.scheduleAtFixedRate(LBHttpSolrClient.getAliveCheckRunner(new WeakReference<LBHttpSolrClient>(this)), this.interval, this.interval, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private static Runnable getAliveCheckRunner(WeakReference<LBHttpSolrClient> lbRef) {
        return () -> {
            LBHttpSolrClient lb = (LBHttpSolrClient)lbRef.get();
            if (lb != null && lb.zombieServers != null) {
                for (ServerWrapper zombieServer : lb.zombieServers.values()) {
                    lb.checkAZombieServer(zombieServer);
                }
            }
        };
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    public void setParser(ResponseParser parser) {
        this.parser = parser;
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    public RequestWriter getRequestWriter() {
        return this.requestWriter;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.aliveCheckExecutor != null) {
                this.aliveCheckExecutor.shutdownNow();
            }
        }
        finally {
            super.finalize();
        }
    }

    static {
        RETRY_CODES.add(404);
        RETRY_CODES.add(403);
        RETRY_CODES.add(503);
        RETRY_CODES.add(500);
        solrQuery = new SolrQuery("*:*");
        solrQuery.setRows(0);
        solrQuery.setSort("_docid_", SolrQuery.ORDER.asc);
        solrQuery.setDistrib(false);
    }

    public static class Builder
    extends SolrClientBuilder<Builder> {
        protected final List<String> baseSolrUrls = new ArrayList<String>();
        protected HttpSolrClient.Builder httpSolrClientBuilder;

        public Builder() {
            this.responseParser = new BinaryResponseParser();
        }

        public HttpSolrClient.Builder getHttpSolrClientBuilder() {
            return this.httpSolrClientBuilder;
        }

        public Builder withBaseSolrUrl(String baseSolrUrl) {
            this.baseSolrUrls.add(baseSolrUrl);
            return this;
        }

        public Builder withBaseSolrUrls(String ... solrUrls) {
            for (String baseSolrUrl : solrUrls) {
                this.baseSolrUrls.add(baseSolrUrl);
            }
            return this;
        }

        public Builder withHttpSolrClientBuilder(HttpSolrClient.Builder builder) {
            this.httpSolrClientBuilder = builder;
            return this;
        }

        public LBHttpSolrClient build() {
            return new LBHttpSolrClient(this);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }

    public static class Rsp {
        protected String server;
        protected NamedList<Object> rsp;

        public NamedList<Object> getResponse() {
            return this.rsp;
        }

        public String getServer() {
            return this.server;
        }
    }

    public static class Req {
        protected SolrRequest request;
        protected List<String> servers;
        protected int numDeadServersToTry;
        private final Integer numServersToTry;

        public Req(SolrRequest request, List<String> servers) {
            this(request, servers, null);
        }

        public Req(SolrRequest request, List<String> servers, Integer numServersToTry) {
            this.request = request;
            this.servers = servers;
            this.numDeadServersToTry = servers.size();
            this.numServersToTry = numServersToTry;
        }

        public SolrRequest getRequest() {
            return this.request;
        }

        public List<String> getServers() {
            return this.servers;
        }

        public int getNumDeadServersToTry() {
            return this.numDeadServersToTry;
        }

        public void setNumDeadServersToTry(int numDeadServersToTry) {
            this.numDeadServersToTry = numDeadServersToTry;
        }

        public Integer getNumServersToTry() {
            return this.numServersToTry;
        }
    }

    protected static class ServerWrapper {
        final HttpSolrClient client;
        boolean standard = true;
        int failedPings = 0;

        public ServerWrapper(HttpSolrClient client) {
            this.client = client;
        }

        public String toString() {
            return this.client.getBaseURL();
        }

        public String getKey() {
            return this.client.getBaseURL();
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ServerWrapper)) {
                return false;
            }
            return this.getKey().equals(((ServerWrapper)obj).getKey());
        }
    }
}

