/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.awt;

import com.vividsolutions.jts.awt.GeometryCollectionShape;
import com.vividsolutions.jts.awt.IdentityPointTransformation;
import com.vividsolutions.jts.awt.PointShapeFactory;
import com.vividsolutions.jts.awt.PointTransformation;
import com.vividsolutions.jts.awt.PolygonShape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ShapeWriter {
    public static final PointTransformation DEFAULT_POINT_TRANSFORMATION = new IdentityPointTransformation();
    public static final PointShapeFactory DEFAULT_POINT_FACTORY = new PointShapeFactory.Square(3.0);
    private PointTransformation pointTransformer = DEFAULT_POINT_TRANSFORMATION;
    private PointShapeFactory pointFactory = DEFAULT_POINT_FACTORY;
    private Point2D transPoint = new Point2D.Double();

    public ShapeWriter(PointTransformation pointTransformer, PointShapeFactory pointFactory) {
        if (pointTransformer != null) {
            this.pointTransformer = pointTransformer;
        }
        if (pointFactory != null) {
            this.pointFactory = pointFactory;
        }
    }

    public ShapeWriter(PointTransformation pointTransformer) {
        this(pointTransformer, null);
    }

    public ShapeWriter() {
    }

    public Shape toShape(Geometry geometry) {
        if (geometry.isEmpty()) {
            return new GeneralPath();
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof LineString) {
            return this.toShape((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.toShape((MultiLineString)geometry);
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unrecognized Geometry class: " + geometry.getClass());
    }

    private Shape toShape(Polygon p) {
        PolygonShape poly = new PolygonShape();
        this.append(poly, p.getExteriorRing().getCoordinates());
        for (int j = 0; j < p.getNumInteriorRing(); ++j) {
            this.append(poly, p.getInteriorRingN(j).getCoordinates());
        }
        return poly;
    }

    private void append(PolygonShape poly, Coordinate[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            this.transformPoint(coords[i], this.transPoint);
            poly.addToRing(this.transPoint);
        }
        poly.endRing();
    }

    private Shape toShape(GeometryCollection gc) {
        GeometryCollectionShape shape = new GeometryCollectionShape();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            shape.add(this.toShape(g));
        }
        return shape;
    }

    private GeneralPath toShape(MultiLineString mls) {
        GeneralPath path = new GeneralPath();
        for (int i = 0; i < mls.getNumGeometries(); ++i) {
            LineString lineString = (LineString)mls.getGeometryN(i);
            path.append(this.toShape(lineString), false);
        }
        return path;
    }

    private GeneralPath toShape(LineString lineString) {
        GeneralPath shape = new GeneralPath();
        this.transformPoint(lineString.getCoordinateN(0), this.transPoint);
        shape.moveTo((float)this.transPoint.getX(), (float)this.transPoint.getY());
        for (int i = 1; i < lineString.getNumPoints(); ++i) {
            this.transformPoint(lineString.getCoordinateN(i), this.transPoint);
            shape.lineTo((float)this.transPoint.getX(), (float)this.transPoint.getY());
        }
        return shape;
    }

    private Shape toShape(Point point) {
        Point2D viewPoint = this.transformPoint(point.getCoordinate());
        return this.pointFactory.createPoint(viewPoint);
    }

    private Point2D transformPoint(Coordinate model) {
        return this.transformPoint(model, new Point2D.Double());
    }

    private Point2D transformPoint(Coordinate model, Point2D view) {
        this.pointTransformer.transform(model, view);
        view.setLocation(Math.round(view.getX()), Math.round(view.getY()));
        return view;
    }
}

