/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.date;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.date.InternalDateRange;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatter;
import org.elasticsearch.search.aggregations.support.numeric.ValueParser;
import org.elasticsearch.search.internal.SearchContext;

public class DateRangeParser
implements Aggregator.Parser {
    @Override
    public String type() {
        return InternalDateRange.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        ValuesSourceConfig<NumericValuesSource> config = new ValuesSourceConfig<NumericValuesSource>(NumericValuesSource.class);
        String field = null;
        ArrayList<RangeAggregator.Range> ranges = null;
        String script = null;
        String scriptLang = null;
        Map<String, Object> scriptParams = null;
        boolean keyed = false;
        String format = null;
        boolean assumeSorted = false;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("field".equals(currentFieldName)) {
                    field = parser.text();
                    continue;
                }
                if ("script".equals(currentFieldName)) {
                    script = parser.text();
                    continue;
                }
                if ("lang".equals(currentFieldName)) {
                    scriptLang = parser.text();
                    continue;
                }
                if ("format".equals(currentFieldName)) {
                    format = parser.text();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (!"ranges".equals(currentFieldName)) continue;
                ranges = new ArrayList<RangeAggregator.Range>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    double from = Double.NEGATIVE_INFINITY;
                    String fromAsStr = null;
                    double to = Double.POSITIVE_INFINITY;
                    String toAsStr = null;
                    String key = null;
                    String toOrFromOrKey = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            toOrFromOrKey = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            if ("from".equals(toOrFromOrKey)) {
                                from = parser.doubleValue();
                                continue;
                            }
                            if ("to".equals(toOrFromOrKey)) {
                                to = parser.doubleValue();
                                continue;
                            }
                            throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
                        }
                        if (token != XContentParser.Token.VALUE_STRING) continue;
                        if ("from".equals(toOrFromOrKey)) {
                            fromAsStr = parser.text();
                            continue;
                        }
                        if ("to".equals(toOrFromOrKey)) {
                            toAsStr = parser.text();
                            continue;
                        }
                        if ("key".equals(toOrFromOrKey)) {
                            key = parser.text();
                            continue;
                        }
                        throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
                    }
                    ranges.add(new RangeAggregator.Range(key, from, fromAsStr, to, toAsStr));
                }
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("params".equals(currentFieldName)) {
                    scriptParams = parser.map();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if ("keyed".equals(currentFieldName)) {
                    keyed = parser.booleanValue();
                    continue;
                }
                if ("script_values_sorted".equals(currentFieldName) || "scriptValuesSorted".equals(currentFieldName)) {
                    assumeSorted = parser.booleanValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].");
        }
        if (ranges == null) {
            throw new SearchParseException(context, "Missing [ranges] in ranges aggregator [" + aggregationName + "]");
        }
        if (script != null) {
            config.script(context.scriptService().search(context.lookup(), scriptLang, script, scriptParams));
        }
        if (!assumeSorted) {
            config.ensureSorted(true);
        }
        if (format != null) {
            config.formatter(new ValueFormatter.DateTime(format));
        } else {
            config.formatter(ValueFormatter.DateTime.DEFAULT);
        }
        config.parser(ValueParser.DateMath.DEFAULT);
        if (field == null) {
            return new RangeAggregator.Factory(aggregationName, config, InternalDateRange.FACTORY, ranges, keyed);
        }
        FieldMapper mapper = context.smartNameFieldMapper(field);
        if (mapper == null) {
            config.unmapped(true);
            return new RangeAggregator.Factory(aggregationName, config, InternalDateRange.FACTORY, ranges, keyed);
        }
        if (!(mapper instanceof DateFieldMapper)) {
            throw new AggregationExecutionException("date_range aggregation can only be applied to date fields which is not the case with field [" + field + "]");
        }
        Object indexFieldData = context.fieldData().getForField(mapper);
        config.fieldContext(new FieldContext(field, (IndexFieldData<?>)indexFieldData));
        if (format == null) {
            config.formatter(new ValueFormatter.DateTime(((DateFieldMapper)mapper).dateTimeFormatter()));
        }
        config.parser(new ValueParser.DateMath(((DateFieldMapper)mapper).dateMathParser()));
        return new RangeAggregator.Factory(aggregationName, config, InternalDateRange.FACTORY, ranges, keyed);
    }
}

