/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.dump;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.monitor.dump.DumpContributionFailedException;
import org.elasticsearch.monitor.dump.DumpContributor;
import org.elasticsearch.monitor.dump.DumpGenerationFailedException;
import org.elasticsearch.monitor.dump.DumpGenerator;
import org.elasticsearch.monitor.dump.SimpleDump;

public class SimpleDumpGenerator
implements DumpGenerator {
    private final File dumpLocation;
    private final ImmutableMap<String, DumpContributor> contributors;

    public SimpleDumpGenerator(File dumpLocation, Map<String, DumpContributor> contributors) {
        this.dumpLocation = dumpLocation;
        this.contributors = ImmutableMap.copyOf(contributors);
    }

    @Override
    public DumpGenerator.Result generateDump(String cause, @Nullable Map<String, Object> context) throws DumpGenerationFailedException {
        return this.generateDump(cause, context, ((ImmutableCollection)((Object)this.contributors.keySet())).toArray(new String[this.contributors.size()]));
    }

    @Override
    public DumpGenerator.Result generateDump(String cause, @Nullable Map<String, Object> context, String ... contributors) throws DumpGenerationFailedException {
        SimpleDump dump;
        long timestamp = System.currentTimeMillis();
        String fileName = "";
        if (context.containsKey("localNode")) {
            DiscoveryNode localNode = (DiscoveryNode)context.get("localNode");
            if (localNode.name() != null) {
                fileName = fileName + localNode.name() + "-";
            }
            fileName = fileName + localNode.id() + "-";
        }
        File file = new File(this.dumpLocation, fileName + cause + "-" + timestamp);
        FileSystemUtils.mkdirs(file);
        try {
            dump = new SimpleDump(System.currentTimeMillis(), cause, context, file);
        }
        catch (FileNotFoundException e) {
            throw new DumpGenerationFailedException("Failed to generate dump", e);
        }
        ArrayList<DumpContributionFailedException> failedContributors = new ArrayList<DumpContributionFailedException>();
        for (String name : contributors) {
            DumpContributor contributor = this.contributors.get(name);
            if (contributor == null) {
                failedContributors.add(new DumpContributionFailedException(name, "No contributor"));
                continue;
            }
            try {
                contributor.contribute(dump);
            }
            catch (DumpContributionFailedException e) {
                failedContributors.add(e);
            }
            catch (Exception e) {
                failedContributors.add(new DumpContributionFailedException(contributor.getName(), "Failed", e));
            }
        }
        dump.finish();
        return new DumpGenerator.Result(file, failedContributors);
    }
}

