/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.search.internal.SearchContext;

abstract class ParentIdCollector
extends NoopCollector {
    protected final String type;
    protected final SearchContext context;
    private IdReaderTypeCache typeCache;

    protected ParentIdCollector(String parentType, SearchContext context) {
        this.type = parentType;
        this.context = context;
    }

    @Override
    public final void collect(int doc) throws IOException {
        HashedBytesArray parentIdByDoc;
        if (this.typeCache != null && (parentIdByDoc = this.typeCache.parentIdByDoc(doc)) != null) {
            this.collect(doc, parentIdByDoc);
        }
    }

    protected abstract void collect(int var1, HashedBytesArray var2) throws IOException;

    @Override
    public void setNextReader(AtomicReaderContext readerContext) throws IOException {
        this.typeCache = this.context.idCache().reader(readerContext.reader()).type(this.type);
    }
}

