/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParserMapper;
import org.elasticsearch.index.query.functionscore.exp.ExponentialDecayFunctionParser;
import org.elasticsearch.index.query.functionscore.factor.FactorParser;
import org.elasticsearch.index.query.functionscore.gauss.GaussDecayFunctionParser;
import org.elasticsearch.index.query.functionscore.lin.LinearDecayFunctionParser;
import org.elasticsearch.index.query.functionscore.random.RandomScoreFunctionParser;
import org.elasticsearch.index.query.functionscore.script.ScriptScoreFunctionParser;

public class FunctionScoreModule
extends AbstractModule {
    private List<Class<? extends ScoreFunctionParser>> parsers = Lists.newArrayList();

    public FunctionScoreModule() {
        this.registerParser(FactorParser.class);
        this.registerParser(ScriptScoreFunctionParser.class);
        this.registerParser(GaussDecayFunctionParser.class);
        this.registerParser(LinearDecayFunctionParser.class);
        this.registerParser(ExponentialDecayFunctionParser.class);
        this.registerParser(RandomScoreFunctionParser.class);
    }

    public void registerParser(Class<? extends ScoreFunctionParser> parser) {
        this.parsers.add(parser);
    }

    @Override
    protected void configure() {
        Multibinder<ScoreFunctionParser> parserMapBinder = Multibinder.newSetBinder(this.binder(), ScoreFunctionParser.class);
        for (Class<? extends ScoreFunctionParser> clazz : this.parsers) {
            parserMapBinder.addBinding().to(clazz);
        }
        this.bind(ScoreFunctionParserMapper.class);
    }
}

