/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.common.geo.builders.PointCollection;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class BaseLineStringBuilder<E extends BaseLineStringBuilder<E>>
extends PointCollection<E> {
    protected BaseLineStringBuilder() {
        this(new ArrayList<Coordinate>());
    }

    protected BaseLineStringBuilder(ArrayList<Coordinate> points) {
        super(points);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.coordinatesToXcontent(builder, false);
    }

    @Override
    public Shape build() {
        Geometry geometry;
        Coordinate[] coordinates = this.points.toArray(new Coordinate[this.points.size()]);
        ArrayList<LineString> strings = BaseLineStringBuilder.decompose(FACTORY, coordinates, new ArrayList<LineString>());
        if (strings.size() == 1) {
            geometry = (Geometry)strings.get(0);
        } else {
            LineString[] linestrings = strings.toArray(new LineString[strings.size()]);
            geometry = FACTORY.createMultiLineString(linestrings);
        }
        return new JtsGeometry(geometry, SPATIAL_CONTEXT, false);
    }

    protected static ArrayList<LineString> decompose(GeometryFactory factory, Coordinate[] coordinates, ArrayList<LineString> strings) {
        for (Coordinate[] part : BaseLineStringBuilder.decompose(180.0, coordinates)) {
            for (Coordinate[] line : BaseLineStringBuilder.decompose(-180.0, part)) {
                strings.add(factory.createLineString(line));
            }
        }
        return strings;
    }

    protected static Coordinate[][] decompose(double dateline, Coordinate[] coordinates) {
        int offset = 0;
        ArrayList<Coordinate[]> parts = new ArrayList<Coordinate[]>();
        double shift = coordinates[0].x > 180.0 ? 180.0 : (coordinates[0].x < -180.0 ? -180.0 : 0.0);
        for (int i = 1; i < coordinates.length; ++i) {
            Coordinate[] part;
            double t = BaseLineStringBuilder.intersection(coordinates[i - 1], coordinates[i], dateline);
            if (Double.isNaN(t)) continue;
            if (t < 1.0) {
                part = Arrays.copyOfRange(coordinates, offset, i + 1);
                part[part.length - 1] = ShapeBuilder.Edge.position(coordinates[i - 1], coordinates[i], t);
                coordinates[offset + i - 1] = ShapeBuilder.Edge.position(coordinates[i - 1], coordinates[i], t);
                BaseLineStringBuilder.shift(shift, part);
                offset = i - 1;
                shift = coordinates[i].x > 180.0 ? 180.0 : (coordinates[i].x < -180.0 ? -180.0 : 0.0);
            } else {
                part = BaseLineStringBuilder.shift(shift, Arrays.copyOfRange(coordinates, offset, i + 1));
                offset = i;
            }
            parts.add(part);
        }
        if (offset == 0) {
            parts.add(BaseLineStringBuilder.shift(shift, coordinates));
        } else if (offset < coordinates.length - 1) {
            Coordinate[] part = Arrays.copyOfRange(coordinates, offset, coordinates.length);
            parts.add(BaseLineStringBuilder.shift(shift, part));
        }
        return (Coordinate[][])parts.toArray((T[])new Coordinate[parts.size()][]);
    }

    private static Coordinate[] shift(double shift, Coordinate ... coordinates) {
        if (shift != 0.0) {
            for (int j = 0; j < coordinates.length; ++j) {
                coordinates[j] = new Coordinate(coordinates[j].x - 2.0 * shift, coordinates[j].y);
            }
        }
        return coordinates;
    }
}

