/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.util.FactoryException;

public final class ReferencingUtilities
extends Static {
    private ReferencingUtilities() {
    }

    public static double getGreenwichLongitude(PrimeMeridian primeMeridian, Unit<Angle> unit) {
        if (primeMeridian == null) {
            return 0.0;
        }
        if (primeMeridian instanceof DefaultPrimeMeridian) {
            return ((DefaultPrimeMeridian)primeMeridian).getGreenwichLongitude(unit);
        }
        return primeMeridian.getAngularUnit().getConverterTo(unit).convert(primeMeridian.getGreenwichLongitude());
    }

    public static Unit<?> getUnit(CoordinateSystem coordinateSystem) {
        Unit unit = null;
        if (coordinateSystem != null) {
            int n = coordinateSystem.getDimension();
            while (--n >= 0) {
                Unit unit2;
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n);
                if (coordinateSystemAxis == null || (unit2 = coordinateSystemAxis.getUnit()) == null) continue;
                if (unit == null) {
                    unit = unit2;
                    continue;
                }
                if (unit.equals(unit2)) continue;
                return null;
            }
        }
        return unit;
    }

    public static int getDimension(CoordinateReferenceSystem coordinateReferenceSystem) {
        CoordinateSystem coordinateSystem;
        if (coordinateReferenceSystem != null && (coordinateSystem = coordinateReferenceSystem.getCoordinateSystem()) != null) {
            return coordinateSystem.getDimension();
        }
        return 0;
    }

    public static boolean getSingleComponents(Iterable<? extends CoordinateReferenceSystem> iterable, Collection<? super SingleCRS> collection) throws ClassCastException {
        boolean bl = true;
        for (CoordinateReferenceSystem coordinateReferenceSystem : iterable) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                ReferencingUtilities.getSingleComponents(((CompoundCRS)coordinateReferenceSystem).getComponents(), collection);
                bl = false;
                continue;
            }
            collection.add((SingleCRS)((SingleCRS)coordinateReferenceSystem));
        }
        return bl;
    }

    public static boolean isEllipsoidalHeight(VerticalDatum verticalDatum) {
        VerticalDatumType verticalDatumType;
        if (verticalDatum != null && (verticalDatumType = verticalDatum.getVerticalDatumType()) != null) {
            return "ELLIPSOIDAL".equalsIgnoreCase(verticalDatumType.name());
        }
        return false;
    }

    public static Ellipsoid getEllipsoidOfGeographicCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        while (!(coordinateReferenceSystem instanceof GeodeticCRS)) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                coordinateReferenceSystem = (CoordinateReferenceSystem)((CompoundCRS)coordinateReferenceSystem).getComponents().get(0);
                continue;
            }
            return null;
        }
        if (coordinateReferenceSystem.getCoordinateSystem() instanceof EllipsoidalCS) {
            return ((GeodeticCRS)coordinateReferenceSystem).getDatum().getEllipsoid();
        }
        return null;
    }

    public static GeographicCRS toNormalizedGeographicCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        while (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            coordinateReferenceSystem = ((GeneralDerivedCRS)coordinateReferenceSystem).getBaseCRS();
        }
        if (coordinateReferenceSystem instanceof GeodeticCRS) {
            if (coordinateReferenceSystem instanceof DefaultGeographicCRS && coordinateReferenceSystem.getCoordinateSystem().getDimension() == 2) {
                return ((DefaultGeographicCRS)coordinateReferenceSystem).forConvention(AxesConvention.NORMALIZED);
            }
            EllipsoidalCS ellipsoidalCS = CommonCRS.defaultGeographic().getCoordinateSystem();
            if (coordinateReferenceSystem instanceof GeographicCRS && Utilities.equalsIgnoreMetadata(ellipsoidalCS, coordinateReferenceSystem.getCoordinateSystem())) {
                return (GeographicCRS)coordinateReferenceSystem;
            }
            return new DefaultGeographicCRS(Collections.singletonMap("name", NilReferencingObject.UNNAMED), ((GeodeticCRS)coordinateReferenceSystem).getDatum(), ellipsoidalCS);
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                GeographicCRS geographicCRS = ReferencingUtilities.toNormalizedGeographicCRS(coordinateReferenceSystem2);
                if (geographicCRS == null) continue;
                return geographicCRS;
            }
        }
        return null;
    }

    public static Map<String, ?> getPropertiesForModifiedCRS(IdentifiedObject identifiedObject) {
        String string;
        Map<String, ?> map = IdentifiedObjects.getProperties(identifiedObject, "identifiers");
        Identifier identifier = (Identifier)map.get("name");
        if (identifier != null && (string = identifier.getCode()) != null) {
            int n;
            for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                String string2;
                int n2;
                n = string.codePointAt(i);
                if (Character.isUnicodeIdentifierPart(n) || Character.isSpaceChar(n)) continue;
                if (n == 40 && (n2 = string.indexOf(41, i)) >= 0 && CharSequences.isUnicodeIdentifier(string2 = string.substring(i + 1, n2))) {
                    i += string2.length() + 2;
                }
                if ((string = CharSequences.trimWhitespaces(string, 0, i).toString()).isEmpty()) continue;
                HashMap hashMap = new HashMap(map);
                hashMap.put("name", string);
                return hashMap;
            }
        }
        return map;
    }

    public static StringBuilder toPropertyName(Class<?> clazz, Class<?> clazz2) {
        String string;
        int n;
        StringBuilder serializable2;
        Class<?>[] classArray;
        UML uML = clazz2.getAnnotation(UML.class);
        if (uML != null && (classArray = uML.specification()) == Specification.ISO_19111 && (serializable2 = new StringBuilder(n = (string = uML.identifier()).length()).append(string, string.indexOf(95) + 1, n)).length() != 0) {
            serializable2.setCharAt(0, Character.toLowerCase(serializable2.charAt(0)));
            return serializable2;
        }
        for (Class<?> clazz3 : clazz2.getInterfaces()) {
            StringBuilder stringBuilder;
            if (!clazz.isAssignableFrom(clazz3) || (stringBuilder = ReferencingUtilities.toPropertyName(clazz, clazz3)) == null) continue;
            return stringBuilder;
        }
        return null;
    }

    public static DefaultMathTransformFactory.Context createTransformContext(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, DefaultMathTransformFactory.Context context) {
        CoordinateSystem coordinateSystem;
        if (context == null) {
            context = new DefaultMathTransformFactory.Context();
        }
        CoordinateSystem coordinateSystem2 = coordinateReferenceSystem != null ? coordinateReferenceSystem.getCoordinateSystem() : null;
        CoordinateSystem coordinateSystem3 = coordinateSystem = coordinateReferenceSystem2 != null ? coordinateReferenceSystem2.getCoordinateSystem() : null;
        if (coordinateReferenceSystem instanceof GeodeticCRS && coordinateSystem2 instanceof EllipsoidalCS) {
            context.setSource((EllipsoidalCS)coordinateSystem2, ((GeodeticCRS)coordinateReferenceSystem).getDatum().getEllipsoid());
        } else {
            context.setSource(coordinateSystem2);
        }
        if (coordinateReferenceSystem2 instanceof GeodeticCRS && coordinateSystem instanceof EllipsoidalCS) {
            context.setTarget((EllipsoidalCS)coordinateSystem, ((GeodeticCRS)coordinateReferenceSystem2).getDatum().getEllipsoid());
        } else {
            context.setTarget(coordinateSystem);
        }
        return context;
    }

    public static ProjectedCRS createProjectedCRS(Map<String, String> map, GeographicCRS geographicCRS, ParameterValueGroup parameterValueGroup, CartesianCS cartesianCS) throws FactoryException {
        DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = DefaultFactories.forBuildin(CoordinateOperationFactory.class, DefaultCoordinateOperationFactory.class);
        return DefaultFactories.forBuildin(CRSFactory.class).createProjectedCRS(map, geographicCRS, defaultCoordinateOperationFactory.createDefiningConversion(map, defaultCoordinateOperationFactory.getOperationMethod(parameterValueGroup.getDescriptor().getName().getCode()), parameterValueGroup), cartesianCS);
    }

    public static Map<Integer, String> identifierToName(ParameterDescriptorGroup parameterDescriptorGroup, Citation citation) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (GeneralParameterDescriptor generalParameterDescriptor : parameterDescriptorGroup.descriptors()) {
            Identifier identifier = IdentifiedObjects.getIdentifier((IdentifiedObject)generalParameterDescriptor, citation);
            if (identifier == null) continue;
            String string = IdentifiedObjects.getName((IdentifiedObject)generalParameterDescriptor, citation);
            if (string == null) {
                string = IdentifiedObjects.getName((IdentifiedObject)generalParameterDescriptor, null);
            }
            if (hashMap.put(Integer.valueOf(identifier.getCode()), string) == null) continue;
            throw new IllegalArgumentException(Errors.format((short)25, identifier));
        }
        return hashMap;
    }
}

