/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.elasticsearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class ElasticSearchParam
extends HashMap<ParameterEnum, String> {
    private static final long serialVersionUID = -1593234685772720029L;

    protected ElasticSearchParam(ParameterEnum[] params) {
        super(params.length);
    }

    public final Map<String, Object> buildMap(IHTTPOutput out) throws ManifoldCFException {
        HashMap<String, Object> rval = new HashMap<String, Object>();
        for (Map.Entry entry : this.entrySet()) {
            String key = ((ParameterEnum)((Object)entry.getKey())).name();
            boolean isPassword = key.endsWith("PASSWORD");
            boolean isKeystore = key.endsWith("KEYSTORE");
            if (isPassword) {
                rval.put(key, out.mapPasswordToKey((String)entry.getValue()));
                continue;
            }
            if (isKeystore) {
                String[] contents;
                String keystore = (String)entry.getValue();
                IKeystoreManager localKeystore = keystore == null || keystore.length() == 0 ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)keystore);
                ArrayList certificates = new ArrayList();
                for (String alias : contents = localKeystore.getContents()) {
                    String description = localKeystore.getDescription(alias);
                    if (description.length() > 128) {
                        description = description.substring(0, 125) + "...";
                    }
                    HashMap<String, String> certificate = new HashMap<String, String>();
                    certificate.put("ALIAS", alias);
                    certificate.put("DESCRIPTION", description);
                    certificates.add(certificate);
                }
                rval.put(key, keystore);
                rval.put(key + "_LIST", certificates);
                continue;
            }
            rval.put(key, entry.getValue());
        }
        return rval;
    }

    public static enum ParameterEnum {
        SERVERLOCATION("http://localhost:9200/"),
        INDEXNAME("index"),
        USERNAME(""),
        PASSWORD(""),
        SERVERKEYSTORE(""),
        INDEXTYPE("generic"),
        USEMAPPERATTACHMENTS("false"),
        PIPELINENAME(""),
        CONTENTATTRIBUTENAME("content"),
        URIATTRIBUTENAME("url"),
        CREATEDDATEATTRIBUTENAME("created"),
        MODIFIEDDATEATTRIBUTENAME("last-modified"),
        INDEXINGDATEATTRIBUTENAME("indexed"),
        MIMETYPEATTRIBUTENAME("mime-type"),
        FIELDLIST("");

        protected final String defaultValue;

        private ParameterEnum(String defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

