/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.elasticsearch;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchConfig;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchConnection;
import org.apache.manifoldcf.core.common.Base64;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.system.Logging;

public class ElasticSearchIndex
extends ElasticSearchConnection {
    protected static final String allowAttributeName = "allow_token_";
    protected static final String denyAttributeName = "deny_token_";
    protected static final String noSecurityToken = "__nosecurity__";
    protected static final boolean useNullValue = false;
    private static final SimpleDateFormat DATE_FORMATTER;

    protected static boolean writeField(PrintWriter pw, boolean needComma, String fieldName, String[] fieldValues) throws IOException {
        if (fieldValues == null) {
            return needComma;
        }
        if (fieldValues.length == 1) {
            if (needComma) {
                pw.print(",");
            }
            pw.print(ElasticSearchIndex.jsonStringEscape(fieldName) + " : " + ElasticSearchIndex.jsonStringEscape(fieldValues[0]));
            needComma = true;
            return needComma;
        }
        if (fieldValues.length > 1) {
            if (needComma) {
                pw.print(",");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int j = 0; j < fieldValues.length; ++j) {
                sb.append(ElasticSearchIndex.jsonStringEscape(fieldValues[j])).append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append("]");
            pw.print(ElasticSearchIndex.jsonStringEscape(fieldName) + " : " + sb.toString());
            needComma = true;
        }
        return needComma;
    }

    protected static String formatAsString(Date dateValue) {
        return DATE_FORMATTER.format(dateValue);
    }

    protected static boolean writeField(PrintWriter pw, boolean needComma, String fieldName, Date[] fieldValues) throws IOException {
        if (fieldValues == null) {
            return needComma;
        }
        if (fieldValues.length == 1) {
            if (needComma) {
                pw.print(",");
            }
            pw.print(ElasticSearchIndex.jsonStringEscape(fieldName) + " : " + ElasticSearchIndex.jsonStringEscape(ElasticSearchIndex.formatAsString(fieldValues[0])));
            needComma = true;
            return needComma;
        }
        if (fieldValues.length > 1) {
            if (needComma) {
                pw.print(",");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int j = 0; j < fieldValues.length; ++j) {
                sb.append(ElasticSearchIndex.jsonStringEscape(ElasticSearchIndex.formatAsString(fieldValues[j]))).append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append("]");
            pw.print(ElasticSearchIndex.jsonStringEscape(fieldName) + " : " + sb.toString());
            needComma = true;
        }
        return needComma;
    }

    protected static boolean writeACLs(PrintWriter pw, boolean needComma, String aclType, String[] acl, String[] denyAcl) throws IOException {
        String metadataACLName = allowAttributeName + aclType;
        needComma = acl != null && acl.length > 0 ? ElasticSearchIndex.writeField(pw, needComma, metadataACLName, acl) : ElasticSearchIndex.writeField(pw, needComma, metadataACLName, new String[]{noSecurityToken});
        String metadataDenyACLName = denyAttributeName + aclType;
        needComma = denyAcl != null && denyAcl.length > 0 ? ElasticSearchIndex.writeField(pw, needComma, metadataDenyACLName, denyAcl) : ElasticSearchIndex.writeField(pw, needComma, metadataDenyACLName, new String[]{noSecurityToken});
        return needComma;
    }

    protected static String jsonStringEscape(String value) {
        StringBuilder sb = new StringBuilder("\"");
        for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            if (x == '\n') {
                sb.append('\\').append('n');
                continue;
            }
            if (x == '\r') {
                sb.append('\\').append('r');
                continue;
            }
            if (x == '\t') {
                sb.append('\\').append('t');
                continue;
            }
            if (x == '\b') {
                sb.append('\\').append('b');
                continue;
            }
            if (x == '\f') {
                sb.append('\\').append('f');
                continue;
            }
            if (x < ' ') {
                sb.append("\\u").append(String.format(Locale.ROOT, "%04x", (int)x));
                continue;
            }
            if (x == '\"' || x == '\\' || x == '/') {
                sb.append('\\');
            }
            sb.append(x);
        }
        sb.append("\"");
        return sb.toString();
    }

    public ElasticSearchIndex(HttpClient client, ElasticSearchConfig config) {
        super(config, client);
    }

    public boolean execute(String documentURI, RepositoryDocument document, InputStream inputStream, String[] acls, String[] denyAcls, String[] shareAcls, String[] shareDenyAcls, String[] parentAcls, String[] parentDenyAcls) throws ManifoldCFException, ServiceInterruption {
        String idField = URLEncoder.encode((String)documentURI);
        String encodedPipelineName = this.config.getPipelineName() == null || this.config.getPipelineName().length() == 0 ? null : URLEncoder.encode((String)this.config.getPipelineName());
        String command = this.config.getIndexType() + "/" + idField;
        String fullCommand = encodedPipelineName == null ? command : command + "?pipeline=" + encodedPipelineName;
        StringBuffer url = this.getApiUrl(fullCommand, false);
        HttpPut put = new HttpPut(url.toString());
        Logging.connectors.debug((Object)("HttPutUri: " + url.toString()));
        put.setEntity((HttpEntity)new IndexRequestEntity(document, inputStream, acls, denyAcls, shareAcls, shareDenyAcls, parentAcls, parentDenyAcls, this.config.getUseMapperAttachments(), this.config.getContentAttributeName(), this.config.getCreatedDateAttributeName(), this.config.getModifiedDateAttributeName(), this.config.getIndexingDateAttributeName(), this.config.getMimeTypeAttributeName()));
        if (!this.call((HttpRequestBase)put)) {
            return false;
        }
        String error = this.checkJson("\"error\"");
        if (this.getResult() == ElasticSearchConnection.Result.OK && error == null) {
            return true;
        }
        this.setResult("JSONERROR", ElasticSearchConnection.Result.ERROR, error);
        Logging.connectors.warn((Object)("ES: Index failed: " + this.getResponse()));
        return true;
    }

    static {
        String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
        TimeZone UTC = TimeZone.getTimeZone("UTC");
        DATE_FORMATTER = new SimpleDateFormat(ISO_FORMAT, Locale.ROOT);
        DATE_FORMATTER.setTimeZone(UTC);
    }

    private class IndexRequestEntity
    implements HttpEntity {
        private final RepositoryDocument document;
        private final InputStream inputStream;
        private final String[] acls;
        private final String[] denyAcls;
        private final String[] shareAcls;
        private final String[] shareDenyAcls;
        private final String[] parentAcls;
        private final String[] parentDenyAcls;
        private final boolean useMapperAttachments;
        private final String contentAttributeName;
        private final String createdDateAttributeName;
        private final String modifiedDateAttributeName;
        private final String indexingDateAttributeName;
        private final String mimeTypeAttributeName;

        public IndexRequestEntity(RepositoryDocument document, InputStream inputStream, String[] acls, String[] denyAcls, String[] shareAcls, String[] shareDenyAcls, String[] parentAcls, String[] parentDenyAcls, boolean useMapperAttachments, String contentAttributeName, String createdDateAttributeName, String modifiedDateAttributeName, String indexingDateAttributeName, String mimeTypeAttributeName) throws ManifoldCFException {
            this.document = document;
            this.inputStream = inputStream;
            this.acls = acls;
            this.denyAcls = denyAcls;
            this.shareAcls = shareAcls;
            this.shareDenyAcls = shareDenyAcls;
            this.parentAcls = parentAcls;
            this.parentDenyAcls = parentDenyAcls;
            this.useMapperAttachments = useMapperAttachments;
            this.contentAttributeName = contentAttributeName;
            this.createdDateAttributeName = createdDateAttributeName;
            this.modifiedDateAttributeName = modifiedDateAttributeName;
            this.indexingDateAttributeName = indexingDateAttributeName;
            this.mimeTypeAttributeName = mimeTypeAttributeName;
        }

        public boolean isChunked() {
            return false;
        }

        @Deprecated
        public void consumeContent() throws IOException {
            EntityUtils.consume((HttpEntity)this);
        }

        public boolean isRepeatable() {
            return false;
        }

        public boolean isStreaming() {
            return false;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return this.inputStream;
        }

        public void writeTo(OutputStream out) throws IOException {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
            try {
                String mimeType;
                Date indexingDate;
                Date modifiedDate;
                pw.print("{");
                Iterator i = this.document.getFields();
                boolean needComma = false;
                while (i.hasNext()) {
                    String fieldName = (String)i.next();
                    Date[] dateFieldValues = this.document.getFieldAsDates(fieldName);
                    if (dateFieldValues != null) {
                        needComma = ElasticSearchIndex.writeField(pw, needComma, fieldName, dateFieldValues);
                        continue;
                    }
                    String[] fieldValues = this.document.getFieldAsStrings(fieldName);
                    needComma = ElasticSearchIndex.writeField(pw, needComma, fieldName, fieldValues);
                }
                Date createdDate = this.document.getCreatedDate();
                if (createdDate != null && this.createdDateAttributeName != null && this.createdDateAttributeName.length() > 0) {
                    needComma = ElasticSearchIndex.writeField(pw, needComma, this.createdDateAttributeName, new Date[]{createdDate});
                }
                if ((modifiedDate = this.document.getModifiedDate()) != null && this.modifiedDateAttributeName != null && this.modifiedDateAttributeName.length() > 0) {
                    needComma = ElasticSearchIndex.writeField(pw, needComma, this.modifiedDateAttributeName, new Date[]{modifiedDate});
                }
                if ((indexingDate = this.document.getIndexingDate()) != null && this.indexingDateAttributeName != null && this.indexingDateAttributeName.length() > 0) {
                    needComma = ElasticSearchIndex.writeField(pw, needComma, this.indexingDateAttributeName, new Date[]{indexingDate});
                }
                if ((mimeType = this.document.getMimeType()) != null && this.mimeTypeAttributeName != null && this.mimeTypeAttributeName.length() > 0) {
                    needComma = ElasticSearchIndex.writeField(pw, needComma, this.mimeTypeAttributeName, new String[]{mimeType});
                }
                needComma = ElasticSearchIndex.writeACLs(pw, needComma, "document", this.acls, this.denyAcls);
                needComma = ElasticSearchIndex.writeACLs(pw, needComma, "share", this.shareAcls, this.shareDenyAcls);
                needComma = ElasticSearchIndex.writeACLs(pw, needComma, "parent", this.parentAcls, this.parentDenyAcls);
                if (this.useMapperAttachments && this.inputStream != null) {
                    String fileName;
                    if (needComma) {
                        pw.print(",");
                    }
                    pw.print("\"file\" : {");
                    String contentType = this.document.getMimeType();
                    if (contentType != null) {
                        pw.print("\"_content_type\" : " + ElasticSearchIndex.jsonStringEscape(contentType) + ",");
                    }
                    if ((fileName = this.document.getFileName()) != null) {
                        pw.print("\"_name\" : " + ElasticSearchIndex.jsonStringEscape(fileName) + ",");
                    }
                    pw.print(" \"_content\" : \"");
                    Base64 base64 = new Base64();
                    base64.encodeStream(this.inputStream, (Writer)pw);
                    pw.print("\"}");
                    needComma = true;
                }
                if (!this.useMapperAttachments && this.inputStream != null && this.contentAttributeName != null) {
                    int amt;
                    InputStreamReader r = new InputStreamReader(this.inputStream, Consts.UTF_8);
                    if (needComma) {
                        pw.print(",");
                    }
                    pw.append(ElasticSearchIndex.jsonStringEscape(this.contentAttributeName)).append(" : \"");
                    char[] buffer = new char[65536];
                    while ((amt = ((Reader)r).read(buffer, 0, buffer.length)) != -1) {
                        for (int j = 0; j < amt; ++j) {
                            char x = buffer[j];
                            if (x == '\n') {
                                pw.append('\\').append('n');
                                continue;
                            }
                            if (x == '\r') {
                                pw.append('\\').append('r');
                                continue;
                            }
                            if (x == '\t') {
                                pw.append('\\').append('t');
                                continue;
                            }
                            if (x == '\b') {
                                pw.append('\\').append('b');
                                continue;
                            }
                            if (x == '\f') {
                                pw.append('\\').append('f');
                                continue;
                            }
                            if (x < ' ') {
                                pw.append("\\u").append(String.format(Locale.ROOT, "%04x", (int)x));
                                continue;
                            }
                            if (x == '\"' || x == '\\' || x == '/') {
                                pw.append('\\');
                            }
                            pw.append(x);
                        }
                    }
                    pw.append("\"");
                    needComma = true;
                }
                pw.print("}");
            }
            catch (ManifoldCFException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                pw.flush();
                IOUtils.closeQuietly((Writer)pw);
            }
        }

        public long getContentLength() {
            return -1L;
        }

        public Header getContentType() {
            return new BasicHeader("Content-type", "application/json");
        }

        public Header getContentEncoding() {
            return null;
        }
    }
}

