/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.INotificationConnectorPool;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectorPool;
import org.apache.manifoldcf.crawler.interfaces.NotificationConnectorPoolFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorPoolFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class IdleCleanupThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: IdleCleanupThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected final String processID;

    public IdleCleanupThread(String processID) throws ManifoldCFException {
        this.processID = processID;
        this.setName("Crawler idle cleanup thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        Logging.threads.debug((Object)"Start up crawler idle cleanup thread");
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IRepositoryConnectorPool repositoryConnectorPool = RepositoryConnectorPoolFactory.make(threadContext);
            INotificationConnectorPool notificationConnectorPool = NotificationConnectorPoolFactory.make(threadContext);
            while (true) {
                try {
                    while (true) {
                        repositoryConnectorPool.pollAllConnectors();
                        notificationConnectorPool.pollAllConnectors();
                        ManifoldCF.sleep((long)5000L);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        Logging.threads.error((Object)("Idle cleanup thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("IdleCleanupThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }
}

