/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.reprioritizationtracker;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.BinManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.IBinManager;
import org.apache.manifoldcf.crawler.interfaces.IReprioritizationTracker;
import org.apache.manifoldcf.crawler.system.Logging;

public class ReprioritizationTracker
implements IReprioritizationTracker {
    public static final String _rcsid = "@(#)$Id: ReprioritizationTracker.java 1718072 2015-12-05 12:36:29Z kwright $";
    protected static final String trackerWriteLock = "_REPR_TRACKER_LOCK_";
    protected static final String trackerProcessIDResource = "_REPR_TRACKER_PID_";
    protected static final String trackerReproIDResource = "_REPR_TRACKER_RID_";
    protected static final String trackerMinimumDepthResource = "_REPR_MINDEPTH_";
    protected final ILockManager lockManager;
    protected final IBinManager binManager;
    protected final Map<PreloadKey, PreloadRequest> preloadRequests = new HashMap<PreloadKey, PreloadRequest>();
    protected final Map<PreloadKey, PreloadedValues> preloadedValues = new HashMap<PreloadKey, PreloadedValues>();

    public ReprioritizationTracker(IThreadContext threadContext) throws ManifoldCFException {
        this.lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        this.binManager = BinManagerFactory.make(threadContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReprioritization(String processID, String reproID) throws ManifoldCFException {
        this.lockManager.enterWriteLock(trackerWriteLock);
        try {
            String currentProcessID = this.readProcessID();
            if (currentProcessID != null) {
                return;
            }
            this.writeProcessID(processID);
            this.writeReproID(reproID);
            try {
                this.binManager.reset();
            }
            catch (Throwable e) {
                this.writeProcessID(null);
                this.writeReproID(null);
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof ManifoldCFException) {
                    throw (ManifoldCFException)e;
                }
                throw new RuntimeException("Unknown exception: " + e.getClass().getName() + ": " + e.getMessage(), e);
            }
            this.writeMinimumDepth(0.0);
        }
        finally {
            this.lockManager.leaveWriteLock(trackerWriteLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doneReprioritization(String reproID) throws ManifoldCFException {
        this.lockManager.enterWriteLock(trackerWriteLock);
        try {
            String currentProcessID = this.readProcessID();
            String currentReproID = this.readReproID();
            if (currentProcessID != null && currentReproID != null && currentReproID.equals(reproID)) {
                this.writeProcessID(null);
                this.writeReproID(null);
            }
        }
        finally {
            this.lockManager.leaveWriteLock(trackerWriteLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String isSpecifiedProcessReprioritizing(String processID) throws ManifoldCFException {
        this.lockManager.enterWriteLock(trackerWriteLock);
        try {
            String currentProcessID = this.readProcessID();
            String currentReproID = this.readReproID();
            if (currentProcessID != null && currentReproID != null && currentProcessID.equals(processID)) {
                String string = currentReproID;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.lockManager.leaveWriteLock(trackerWriteLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assessMinimumDepth(Double[] binNamesSet) throws ManifoldCFException {
        double newMinPriority = Double.MAX_VALUE;
        for (Double binValue : binNamesSet) {
            if (!(binValue < newMinPriority)) continue;
            newMinPriority = binValue;
        }
        if (newMinPriority != Double.MAX_VALUE) {
            this.lockManager.enterWriteLock(trackerWriteLock);
            try {
                String processID = this.readProcessID();
                if (processID == null) {
                    double currentMinimumDepth = this.readMinimumDepth();
                    double newMinDepth = Math.exp(newMinPriority) - 1.0;
                    if (newMinDepth > currentMinimumDepth) {
                        this.writeMinimumDepth(newMinDepth);
                        if (Logging.scheduling.isDebugEnabled()) {
                            Logging.scheduling.debug((Object)("Setting new minimum depth value to " + new Double(currentMinimumDepth).toString()));
                        }
                    } else if (newMinDepth < currentMinimumDepth && Logging.scheduling.isDebugEnabled()) {
                        Logging.scheduling.debug((Object)("Minimum depth value seems to have been set too high too early! currentMin = " + new Double(currentMinimumDepth).toString() + "; queue value = " + new Double(newMinDepth).toString()));
                    }
                }
            }
            finally {
                this.lockManager.leaveWriteLock(trackerWriteLock);
            }
        }
    }

    @Override
    public double getMinimumDepth() throws ManifoldCFException {
        this.lockManager.enterReadLock(trackerWriteLock);
        try {
            double d = this.readMinimumDepth();
            return d;
        }
        finally {
            this.lockManager.leaveReadLock(trackerWriteLock);
        }
    }

    @Override
    public void addPreloadRequest(String connectorClass, String binName, double weightedMinimumDepth) {
        PreloadKey pk = new PreloadKey(connectorClass, binName);
        PreloadRequest pr = this.preloadRequests.get(pk);
        if (pr == null) {
            pr = new PreloadRequest(weightedMinimumDepth);
            this.preloadRequests.put(pk, pr);
        } else {
            pr.updateRequest(weightedMinimumDepth);
        }
    }

    @Override
    public void preloadBinValues() throws ManifoldCFException {
        for (PreloadKey pk : this.preloadRequests.keySet()) {
            PreloadRequest pr = this.preloadRequests.get(pk);
            double[] newValues = this.binManager.getIncrementBinValuesInTransaction(pk.connectorClass, pk.binName, pr.getWeightedMinimumDepth(), pr.getRequestCount());
            PreloadedValues pv = new PreloadedValues(newValues);
            this.preloadedValues.put(pk, pv);
        }
        this.preloadRequests.clear();
    }

    @Override
    public void clearPreloadRequests() {
        this.preloadRequests.clear();
    }

    @Override
    public void clearPreloadedValues() {
        this.preloadedValues.clear();
    }

    @Override
    public double getIncrementBinValue(String connectorClass, String binName, double weightedMinimumDepth) throws ManifoldCFException {
        Double rval;
        PreloadKey key = new PreloadKey(connectorClass, binName);
        PreloadedValues pv = this.preloadedValues.get(key);
        if (pv != null && (rval = pv.getNextValue()) != null) {
            return rval;
        }
        return this.binManager.getIncrementBinValues(connectorClass, binName, weightedMinimumDepth, 1)[0];
    }

    protected String readProcessID() throws ManifoldCFException {
        byte[] processIDData = this.lockManager.readData(trackerProcessIDResource);
        if (processIDData == null) {
            return null;
        }
        return new String(processIDData, StandardCharsets.UTF_8);
    }

    protected void writeProcessID(String processID) throws ManifoldCFException {
        if (processID == null) {
            this.lockManager.writeData(trackerProcessIDResource, null);
        } else {
            byte[] processIDData = processID.getBytes(StandardCharsets.UTF_8);
            this.lockManager.writeData(trackerProcessIDResource, processIDData);
        }
    }

    protected String readReproID() throws ManifoldCFException {
        byte[] reproIDData = this.lockManager.readData(trackerReproIDResource);
        if (reproIDData == null) {
            return null;
        }
        return new String(reproIDData, StandardCharsets.UTF_8);
    }

    protected void writeReproID(String reproID) throws ManifoldCFException {
        if (reproID == null) {
            this.lockManager.writeData(trackerReproIDResource, null);
        } else {
            byte[] reproIDData = reproID.getBytes(StandardCharsets.UTF_8);
            this.lockManager.writeData(trackerReproIDResource, reproIDData);
        }
    }

    protected double readMinimumDepth() throws ManifoldCFException {
        byte[] data = this.lockManager.readData(trackerMinimumDepthResource);
        if (data == null || data.length != 8) {
            return 0.0;
        }
        long dataLong = ((long)data[0] & 0xFFL) + ((long)data[1] << 8 & 0xFF00L) + ((long)data[2] << 16 & 0xFF0000L) + ((long)data[3] << 24 & 0xFF000000L) + ((long)data[4] << 32 & 0xFF00000000L) + ((long)data[5] << 40 & 0xFF0000000000L) + ((long)data[6] << 48 & 0xFF000000000000L) + ((long)data[7] << 56 & 0xFF00000000000000L);
        return Double.longBitsToDouble(dataLong);
    }

    protected void writeMinimumDepth(double depth) throws ManifoldCFException {
        long dataLong = Double.doubleToLongBits(depth);
        byte[] data = new byte[]{(byte)(dataLong & 0xFFL), (byte)(dataLong >> 8 & 0xFFL), (byte)(dataLong >> 16 & 0xFFL), (byte)(dataLong >> 24 & 0xFFL), (byte)(dataLong >> 32 & 0xFFL), (byte)(dataLong >> 40 & 0xFFL), (byte)(dataLong >> 48 & 0xFFL), (byte)(dataLong >> 56 & 0xFFL)};
        this.lockManager.writeData(trackerMinimumDepthResource, data);
    }

    protected static class PreloadKey {
        public final String connectorClass;
        public final String binName;

        public PreloadKey(String connectorClass, String binName) {
            this.connectorClass = connectorClass;
            this.binName = binName;
        }

        public int hashCode() {
            return this.connectorClass.hashCode() + this.binName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PreloadKey)) {
                return false;
            }
            PreloadKey pk = (PreloadKey)o;
            return this.connectorClass.equals(pk.connectorClass) && this.binName.equals(pk.binName);
        }
    }

    protected static class PreloadedValues {
        protected double[] values;
        protected int valueIndex;

        public PreloadedValues(double[] values) {
            this.values = values;
            this.valueIndex = this.valueIndex;
        }

        public Double getNextValue() {
            if (this.valueIndex == this.values.length) {
                return null;
            }
            return new Double(this.values[this.valueIndex++]);
        }
    }

    protected static class PreloadRequest {
        protected double weightedMinimumDepth;
        protected int requestCount;

        public PreloadRequest(double weightedMinimumDepth) {
            this.weightedMinimumDepth = weightedMinimumDepth;
            this.requestCount = 1;
        }

        public void updateRequest(double weightedMinimumDepth) {
            if (this.weightedMinimumDepth < weightedMinimumDepth) {
                this.weightedMinimumDepth = weightedMinimumDepth;
            }
            ++this.requestCount;
        }

        public double getWeightedMinimumDepth() {
            return this.weightedMinimumDepth;
        }

        public int getRequestCount() {
            return this.requestCount;
        }
    }
}

