/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.JoinClause;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.jobs.JobDescription;

public class NotificationManager
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: NotificationManager.java 1647585 2014-12-23 14:46:43Z kwright $";
    public static final String ownerIDField = "ownerid";
    public static final String ordinalField = "ordinal";
    public static final String notificationNameField = "notificationname";
    public static final String connectionDescriptionField = "connectiondesc";
    public static final String connectionSpecField = "connectionspec";

    public NotificationManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "jobnotifications");
    }

    public void install(String ownerTable, String owningTablePrimaryKey, String notificationTableName, String notificationTableNameField) throws ManifoldCFException {
        block5: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(ownerIDField, new ColumnDescription("BIGINT", false, false, ownerTable, owningTablePrimaryKey, false));
                map.put(ordinalField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(notificationNameField, new ColumnDescription("VARCHAR(32)", false, true, notificationTableName, notificationTableNameField, false));
                map.put(connectionDescriptionField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(connectionSpecField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription ownerIndex = new IndexDescription(false, new String[]{ownerIDField});
            IndexDescription notificationNameIndex = new IndexDescription(false, new String[]{notificationNameField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (ownerIndex != null && id.equals((Object)ownerIndex)) {
                    ownerIndex = null;
                    continue;
                }
                if (notificationNameIndex != null && id.equals((Object)notificationNameIndex)) {
                    notificationNameIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (ownerIndex != null) {
                this.performAddIndex(null, ownerIndex);
            }
            if (notificationNameIndex == null) break block5;
            this.performAddIndex(null, notificationNameIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public void buildNotificationQueryClause(StringBuilder query, ArrayList params, String parentIDField, List<String> connectionNames) {
        query.append("SELECT 'x' FROM ").append(this.getTableName()).append(" WHERE ");
        query.append(this.buildConjunctionClause(params, new ClauseDescription[]{new JoinClause(parentIDField, ownerIDField), new MultiClause(notificationNameField, connectionNames)}));
    }

    public String[] getNotificationConnectionNames(Long ownerID) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        StringBuilder query = new StringBuilder("SELECT ");
        query.append(notificationNameField).append(" FROM ").append(this.getTableName()).append(" WHERE ");
        query.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(ownerIDField, (Object)ownerID)}));
        IResultSet set = this.performQuery(query.toString(), newList, null, null);
        String[] rval = new String[set.getRowCount()];
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (String)row.getValue(notificationNameField);
        }
        return rval;
    }

    public void getRows(Map<Long, JobDescription> returnValues, String ownerIDList, ArrayList ownerIDParams) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + ownerIDField + " IN (" + ownerIDList + ") ORDER BY " + ordinalField + " ASC", ownerIDParams, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            Long ownerID = (Long)row.getValue(ownerIDField);
            String notificationName = (String)row.getValue(notificationNameField);
            String notificationDesc = (String)row.getValue(connectionDescriptionField);
            String notificationSpec = (String)row.getValue(connectionSpecField);
            JobDescription jd = returnValues.get(ownerID);
            jd.addNotification(notificationName, notificationDesc).fromXML(notificationSpec);
        }
    }

    public boolean compareRows(Long ownerID, IJobDescription job) throws ManifoldCFException {
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(ownerIDField, (Object)ownerID)});
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + query + " ORDER BY " + ordinalField + " ASC", params, null, null);
        if (set.getRowCount() != job.countNotifications()) {
            return false;
        }
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            String notificationConnectionName = (String)row.getValue(notificationNameField);
            String spec = (String)row.getValue(connectionSpecField);
            if (spec == null) {
                spec = "";
            }
            if (!job.getNotificationConnectionName(i).equals(notificationConnectionName)) {
                return false;
            }
            if (job.getNotificationSpecification(i).toXML().equals(spec)) continue;
            return false;
        }
        return true;
    }

    public void writeRows(Long ownerID, IJobDescription job) throws ManifoldCFException {
        this.beginTransaction();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < job.countNotifications(); ++i) {
                String notificationConnectionName = job.getNotificationConnectionName(i);
                String notificationDescription = job.getNotificationDescription(i);
                Specification os = job.getNotificationSpecification(i);
                map.clear();
                map.put(ownerIDField, ownerID);
                map.put(ordinalField, new Long(i));
                map.put(notificationNameField, notificationConnectionName);
                if (notificationDescription != null && notificationDescription.length() > 0) {
                    map.put(connectionDescriptionField, notificationDescription);
                }
                map.put(connectionSpecField, os.toXML());
                this.performInsert(map, null);
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void deleteRows(Long ownerID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(ownerIDField, (Object)ownerID)});
        this.performDelete("WHERE " + query, list, null);
    }
}

