/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableBase;
import org.apache.manifoldcf.scriptengine.VariableBoolean;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class VariableFloat
extends VariableBase {
    protected double value;

    public VariableFloat(double value) {
        this.value = value;
    }

    public int hashCode() {
        return new Double(this.value).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableFloat)) {
            return false;
        }
        return ((VariableFloat)o).value == this.value;
    }

    @Override
    public boolean hasStringValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasScriptValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasIntValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean hasDoubleValue() throws ScriptException {
        return true;
    }

    @Override
    public String getScriptValue() throws ScriptException {
        return new Double(this.value).toString();
    }

    @Override
    public String getStringValue() throws ScriptException {
        return new Double(this.value).toString();
    }

    @Override
    public int getIntValue() throws ScriptException {
        return (int)this.value;
    }

    @Override
    public double getDoubleValue() throws ScriptException {
        return this.value;
    }

    @Override
    public VariableReference plus(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '+' operand cannot be null"));
        }
        return new VariableFloat(this.value + v.getDoubleValue());
    }

    @Override
    public VariableReference minus(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '-' operand cannot be null"));
        }
        return new VariableFloat(this.value - v.getDoubleValue());
    }

    @Override
    public VariableReference asterisk(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '*' operand cannot be null"));
        }
        return new VariableFloat(this.value * v.getDoubleValue());
    }

    @Override
    public VariableReference slash(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '/' operand cannot be null"));
        }
        return new VariableFloat(this.value / v.getDoubleValue());
    }

    @Override
    public VariableReference unaryMinus() throws ScriptException {
        return new VariableFloat(-this.value);
    }

    @Override
    public VariableReference greaterAngle(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '>' operand cannot be null"));
        }
        return new VariableBoolean(this.value > v.getDoubleValue());
    }

    @Override
    public VariableReference lesserAngle(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '<' operand cannot be null"));
        }
        return new VariableBoolean(this.value < v.getDoubleValue());
    }

    @Override
    public VariableReference doubleEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '==' operand cannot be null"));
        }
        return new VariableBoolean(this.value == v.getDoubleValue());
    }

    @Override
    public VariableReference greaterAngleEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '>=' operand cannot be null"));
        }
        return new VariableBoolean(this.value >= v.getDoubleValue());
    }

    @Override
    public VariableReference lesserAngleEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '<=' operand cannot be null"));
        }
        return new VariableBoolean(this.value <= v.getDoubleValue());
    }

    @Override
    public VariableReference exclamationEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '!=' operand cannot be null"));
        }
        return new VariableBoolean(this.value != v.getDoubleValue());
    }
}

