/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import org.apache.manifoldcf.agents.interfaces.IIncrementalIngester;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.IPipelineConnections;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IncrementalIngesterFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectorPool;
import org.apache.manifoldcf.crawler.interfaces.IReprioritizationTracker;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorPoolFactory;
import org.apache.manifoldcf.crawler.interfaces.ReprioritizationTrackerFactory;
import org.apache.manifoldcf.crawler.system.CleanupQueuedDocument;
import org.apache.manifoldcf.crawler.system.DocCleanupResetManager;
import org.apache.manifoldcf.crawler.system.DocumentCleanupQueue;
import org.apache.manifoldcf.crawler.system.DocumentCleanupSet;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.PipelineConnections;
import org.apache.manifoldcf.crawler.system.PipelineSpecificationBasic;

public class DocumentCleanupThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: DocumentCleanupThread.java 1644399 2014-12-10 13:36:42Z kwright $";
    protected final String id;
    protected final DocumentCleanupQueue documentCleanupQueue;
    protected final DocCleanupResetManager resetManager;
    protected final String processID;

    public DocumentCleanupThread(String id, DocumentCleanupQueue documentCleanupQueue, DocCleanupResetManager resetManager, String processID) throws ManifoldCFException {
        this.id = id;
        this.documentCleanupQueue = documentCleanupQueue;
        this.resetManager = resetManager;
        this.processID = processID;
        this.setName("Document cleanup thread '" + id + "'");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.resetManager.registerMe();
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IIncrementalIngester ingester = IncrementalIngesterFactory.make((IThreadContext)threadContext);
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            IRepositoryConnectionManager connMgr = RepositoryConnectionManagerFactory.make(threadContext);
            ITransformationConnectionManager transformationConnectionManager = TransformationConnectionManagerFactory.make((IThreadContext)threadContext);
            IOutputConnectionManager outputConnectionManager = OutputConnectionManagerFactory.make((IThreadContext)threadContext);
            IReprioritizationTracker rt = ReprioritizationTrackerFactory.make(threadContext);
            IRepositoryConnectorPool repositoryConnectorPool = RepositoryConnectorPoolFactory.make(threadContext);
            while (true) {
                try {
                    DocumentCleanupSet dds;
                    block21: while (true) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        this.resetManager.waitForReset(threadContext);
                        dds = this.documentCleanupQueue.getDocuments();
                        if (dds == null) continue;
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        IJobDescription job = dds.getJobDescription();
                        String connectionName = job.getConnectionName();
                        PipelineConnections pipelineConnections = new PipelineConnections(new PipelineSpecificationBasic(job), transformationConnectionManager, outputConnectionManager);
                        try {
                            long currentTime = System.currentTimeMillis();
                            IRepositoryConnection connection = connMgr.load(connectionName);
                            ArrayList<String> arrayDocHashes = new ArrayList<String>();
                            ArrayList<CleanupQueuedDocument> arrayDocsToDelete = new ArrayList<CleanupQueuedDocument>();
                            ArrayList<String[]> arrayRelationshipTypes = new ArrayList<String[]>();
                            ArrayList<Integer> hopcountMethods = new ArrayList<Integer>();
                            for (int j = 0; j < dds.getCount(); ++j) {
                                String[] legalLinkTypes;
                                CleanupQueuedDocument dqd = dds.getDocument(j);
                                DocumentDescription ddd = dqd.getDocumentDescription();
                                if (job == null || connection == null || (legalLinkTypes = RepositoryConnectorFactory.getRelationshipTypes(threadContext, connection.getClassName())) == null) continue;
                                arrayDocHashes.add(ddd.getDocumentIdentifierHash());
                                arrayDocsToDelete.add(dqd);
                                arrayRelationshipTypes.add(legalLinkTypes);
                                hopcountMethods.add(new Integer(job.getHopcountMode()));
                            }
                            IRepositoryConnector connector = repositoryConnectorPool.grab(connection);
                            try {
                                int k;
                                boolean[] deleteFromQueue = new boolean[arrayDocHashes.size()];
                                int removeCount = 0;
                                for (int k2 = 0; k2 < arrayDocHashes.size(); ++k2) {
                                    if (((CleanupQueuedDocument)arrayDocsToDelete.get(k2)).shouldBeRemovedFromIndex()) {
                                        deleteFromQueue[k2] = false;
                                        ++removeCount;
                                        continue;
                                    }
                                    deleteFromQueue[k2] = true;
                                }
                                String[] docClassesToRemove = new String[removeCount];
                                String[] hashedDocsToRemove = new String[removeCount];
                                removeCount = 0;
                                for (int k3 = 0; k3 < arrayDocHashes.size(); ++k3) {
                                    if (!((CleanupQueuedDocument)arrayDocsToDelete.get(k3)).shouldBeRemovedFromIndex()) continue;
                                    docClassesToRemove[removeCount] = connectionName;
                                    hashedDocsToRemove[removeCount] = (String)arrayDocHashes.get(k3);
                                    ++removeCount;
                                }
                                OutputRemoveActivity activities = new OutputRemoveActivity(connectionName, connMgr);
                                try {
                                    ingester.documentDeleteMultiple((IPipelineConnections)pipelineConnections, docClassesToRemove, hashedDocsToRemove, (IOutputRemoveActivity)activities);
                                    for (k = 0; k < arrayDocHashes.size(); ++k) {
                                        if (!((CleanupQueuedDocument)arrayDocsToDelete.get(k)).shouldBeRemovedFromIndex()) continue;
                                        deleteFromQueue[k] = true;
                                    }
                                }
                                catch (ServiceInterruption e) {
                                    for (int k4 = 0; k4 < arrayDocHashes.size(); ++k4) {
                                        CleanupQueuedDocument cqd = (CleanupQueuedDocument)arrayDocsToDelete.get(k4);
                                        if (!cqd.shouldBeRemovedFromIndex()) continue;
                                        DocumentDescription dd = cqd.getDocumentDescription();
                                        jobManager.resetCleaningDocument(dd, e.getRetryTime());
                                        cqd.setProcessed();
                                    }
                                }
                                k = 0;
                                while (true) {
                                    if (k >= arrayDocHashes.size()) continue block21;
                                    if (deleteFromQueue[k]) {
                                        CleanupQueuedDocument dqd = (CleanupQueuedDocument)arrayDocsToDelete.get(k);
                                        DocumentDescription ddd = dqd.getDocumentDescription();
                                        Long jobID = ddd.getJobID();
                                        int hopcountMethod = (Integer)hopcountMethods.get(k);
                                        String[] legalLinkTypes = (String[])arrayRelationshipTypes.get(k);
                                        DocumentDescription[] requeueCandidates = jobManager.markDocumentCleanedUp(jobID, legalLinkTypes, ddd, hopcountMethod);
                                        ManifoldCF.requeueDocumentsDueToCarrydown(jobManager, requeueCandidates, connector, connection, rt, currentTime);
                                        dqd.setProcessed();
                                    }
                                    ++k;
                                }
                            }
                            finally {
                                repositoryConnectorPool.release(connection, connector);
                            }
                        }
                        catch (ManifoldCFException e) {
                            if (e.getErrorCode() == 2) {
                            }
                            if (e.getErrorCode() == 4) {
                                throw e;
                            }
                            if (jobManager.errorAbort(dds.getJobDescription().getID(), e.getMessage())) {
                                Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                            }
                        }
                    }
                    finally {
                        for (int j = 0; j < dds.getCount(); ++j) {
                            CleanupQueuedDocument dqd = dds.getDocument(j);
                            if (dqd.wasProcessed()) continue;
                            DocumentDescription ddd = dqd.getDocumentDescription();
                            jobManager.resetCleaningDocument(ddd, 0L);
                            dqd.setProcessed();
                        }
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        this.resetManager.noteEvent();
                        Logging.threads.error((Object)("Document cleanup thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("DocumentCleanupThread " + this.id + " initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }

    protected static class OutputRemoveActivity
    implements IOutputRemoveActivity {
        protected final String connectionName;
        protected final IRepositoryConnectionManager connMgr;

        public OutputRemoveActivity(String connectionName, IRepositoryConnectionManager connMgr) {
            this.connectionName = connectionName;
            this.connMgr = connMgr;
        }

        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityURI, String resultCode, String resultDescription) throws ManifoldCFException {
            this.connMgr.recordHistory(this.connectionName, startTime, activityType, dataSize, entityURI, resultCode, resultDescription, null);
        }
    }
}

