/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.NullCheckClause;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.interfaces.DocumentDescription;
import org.apache.manifoldcf.crawler.interfaces.IPriorityCalculator;
import org.apache.manifoldcf.crawler.jobs.PrereqEventManager;
import org.apache.manifoldcf.crawler.jobs.TrackerClass;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class JobQueue
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: JobQueue.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final int SEEDSTATUS_NOTSEED = 0;
    public static final int SEEDSTATUS_SEED = 1;
    public static final int SEEDSTATUS_NEWSEED = 2;
    public static final int STATUS_PENDING = 0;
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_COMPLETE = 2;
    public static final int STATUS_UNCHANGED = 3;
    public static final int STATUS_PENDINGPURGATORY = 4;
    public static final int STATUS_ACTIVEPURGATORY = 5;
    public static final int STATUS_PURGATORY = 6;
    public static final int STATUS_BEINGDELETED = 7;
    public static final int STATUS_ACTIVENEEDRESCAN = 8;
    public static final int STATUS_ACTIVENEEDRESCANPURGATORY = 9;
    public static final int STATUS_BEINGCLEANED = 10;
    public static final int STATUS_ELIGIBLEFORDELETE = 11;
    public static final int STATUS_HOPCOUNTREMOVED = 12;
    public static final int ACTION_RESCAN = 0;
    public static final int ACTION_REMOVE = 1;
    public static final int NEEDPRIORITY_FALSE = 0;
    public static final int NEEDPRIORITY_INPROGRESS = 1;
    public static final int NEEDPRIORITY_TRUE = 2;
    public static final String idField = "id";
    public static final String jobIDField = "jobid";
    public static final String docHashField = "dochash";
    public static final String docIDField = "docid";
    public static final String checkTimeField = "checktime";
    public static final String statusField = "status";
    public static final String failTimeField = "failtime";
    public static final String failCountField = "failcount";
    public static final String isSeedField = "isseed";
    public static final String docPriorityField = "docpriority";
    public static final String checkActionField = "checkaction";
    public static final String processIDField = "processid";
    public static final String seedingProcessIDField = "seedingprocessid";
    public static final String needPriorityField = "needpriority";
    public static final String needPriorityProcessIDField = "needpriorityprocessid";
    public static final double noDocPriorityValue = 1.0E9;
    public static final Double nullDocPriority = new Double(1.000000001E9);
    protected static final Map<String, Integer> statusMap = new HashMap<String, Integer>();
    protected static final Map<String, Integer> seedstatusMap;
    protected static final Map<String, Integer> actionMap;
    protected static final Map<String, Integer> needPriorityMap;
    protected PrereqEventManager prereqEventManager;
    protected IThreadContext threadContext;
    protected String getNextDocumentsIndexHint = null;

    public JobQueue(IThreadContext tc, IDBInterface database) throws ManifoldCFException {
        super(database, "jobqueue");
        this.threadContext = tc;
        this.prereqEventManager = new PrereqEventManager(database);
    }

    public void install(String jobsTable, String jobsColumn) throws ManifoldCFException {
        block15: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(idField, new ColumnDescription("BIGINT", true, false, null, null, false));
                map.put(jobIDField, new ColumnDescription("BIGINT", false, false, jobsTable, jobsColumn, false));
                map.put(docHashField, new ColumnDescription("VARCHAR(40)", false, false, null, null, false));
                map.put(docIDField, new ColumnDescription("LONGTEXT", false, false, null, null, false));
                map.put(checkTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(failTimeField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(failCountField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(statusField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                map.put(isSeedField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                map.put(docPriorityField, new ColumnDescription("FLOAT", false, true, null, null, false));
                map.put(checkActionField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                map.put(processIDField, new ColumnDescription("VARCHAR(16)", false, true, null, null, false));
                map.put(seedingProcessIDField, new ColumnDescription("VARCHAR(16)", false, true, null, null, false));
                map.put(needPriorityField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                map.put(needPriorityProcessIDField, new ColumnDescription("VARCHAR(16)", false, true, null, null, false));
                this.performCreate(map, null);
            }
            this.prereqEventManager.install(this.getTableName(), idField);
            IndexDescription uniqueIndex = new IndexDescription(true, new String[]{docHashField, jobIDField});
            IndexDescription jobStatusIndex = new IndexDescription(false, new String[]{jobIDField, statusField});
            IndexDescription jobSeedIndex = new IndexDescription(false, new String[]{isSeedField, jobIDField});
            IndexDescription failTimeIndex = new IndexDescription(false, new String[]{failTimeField, jobIDField});
            IndexDescription actionTimeStatusIndex = new IndexDescription(false, new String[]{statusField, checkActionField, checkTimeField});
            IndexDescription needPriorityIndex = new IndexDescription(false, new String[]{needPriorityField});
            IndexDescription docpriorityIndex = new IndexDescription(false, new String[]{docPriorityField, statusField, checkActionField, checkTimeField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (uniqueIndex != null && id.equals((Object)uniqueIndex)) {
                    uniqueIndex = null;
                    continue;
                }
                if (needPriorityIndex != null && id.equals((Object)needPriorityIndex)) {
                    needPriorityIndex = null;
                    continue;
                }
                if (jobStatusIndex != null && id.equals((Object)jobStatusIndex)) {
                    jobStatusIndex = null;
                    continue;
                }
                if (jobSeedIndex != null && id.equals((Object)jobSeedIndex)) {
                    jobSeedIndex = null;
                    continue;
                }
                if (failTimeIndex != null && id.equals((Object)failTimeIndex)) {
                    failTimeIndex = null;
                    continue;
                }
                if (actionTimeStatusIndex != null && id.equals((Object)actionTimeStatusIndex)) {
                    actionTimeStatusIndex = null;
                    continue;
                }
                if (docpriorityIndex != null && id.equals((Object)docpriorityIndex)) {
                    docpriorityIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (jobStatusIndex != null) {
                this.performAddIndex(null, jobStatusIndex);
            }
            if (needPriorityIndex != null) {
                this.performAddIndex(null, needPriorityIndex);
            }
            if (jobSeedIndex != null) {
                this.performAddIndex(null, jobSeedIndex);
            }
            if (failTimeIndex != null) {
                this.performAddIndex(null, failTimeIndex);
            }
            if (actionTimeStatusIndex != null) {
                this.performAddIndex(null, actionTimeStatusIndex);
            }
            if (docpriorityIndex != null) {
                this.performAddIndex(null, docpriorityIndex);
            }
            if (uniqueIndex == null) break block15;
            this.performAddIndex(null, uniqueIndex);
        }
    }

    public String getGetNextDocumentsIndexHint() throws ManifoldCFException {
        if (this.getNextDocumentsIndexHint == null) {
            this.getNextDocumentsIndexHint = this.getDBInterface().constructIndexHintClause(this.getTableName(), new IndexDescription(false, new String[]{docPriorityField, statusField, checkActionField, checkTimeField}));
        }
        return this.getNextDocumentsIndexHint;
    }

    public void unconditionallyAnalyzeTables() throws ManifoldCFException {
        long startTime = System.currentTimeMillis();
        Logging.perf.debug((Object)"Beginning to analyze jobqueue table");
        this.analyzeTable();
        Logging.perf.debug((Object)("Done analyzing jobqueue table in " + new Long(System.currentTimeMillis() - startTime) + " ms"));
    }

    public void deinstall() throws ManifoldCFException {
        this.beginTransaction();
        try {
            this.prereqEventManager.deinstall();
            this.performDrop(null);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void restart(String processID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        map.put(needPriorityField, JobQueue.needPriorityToString(2));
        map.put(needPriorityProcessIDField, null);
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(needPriorityField, (Object)JobQueue.needPriorityToString(1)), new UnitaryClause(processIDField, (Object)processID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        map.clear();
        list.clear();
        map.put(statusField, JobQueue.statusToString(0));
        map.put(processIDField, null);
        map.put(needPriorityField, JobQueue.needPriorityToString(2));
        map.put(needPriorityProcessIDField, null);
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{JobQueue.statusToString(1), JobQueue.statusToString(8)}), new UnitaryClause(processIDField, (Object)processID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        map.put(statusField, JobQueue.statusToString(4));
        map.put(processIDField, null);
        map.put(needPriorityField, JobQueue.needPriorityToString(2));
        map.put(needPriorityProcessIDField, null);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{JobQueue.statusToString(5), JobQueue.statusToString(9)}), new UnitaryClause(processIDField, (Object)processID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        map.put(statusField, JobQueue.statusToString(11));
        map.put(processIDField, null);
        map.put(checkTimeField, new Long(0L));
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)JobQueue.statusToString(7)), new UnitaryClause(processIDField, (Object)processID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        map.put(statusField, JobQueue.statusToString(6));
        map.put(processIDField, null);
        map.put(checkTimeField, new Long(0L));
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)JobQueue.statusToString(10)), new UnitaryClause(processIDField, (Object)processID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        map.clear();
        map.put(isSeedField, JobQueue.seedstatusToString(1));
        map.put(seedingProcessIDField, null);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(isSeedField, (Object)JobQueue.seedstatusToString(2)), new UnitaryClause(seedingProcessIDField, (Object)processID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 50000, 0);
        this.unconditionallyAnalyzeTables();
        TrackerClass.noteGlobalChange("Restart");
    }

    public void restart() throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        map.put(needPriorityField, JobQueue.needPriorityToString(2));
        map.put(needPriorityProcessIDField, null);
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(needPriorityField, (Object)JobQueue.needPriorityToString(1))});
        this.performUpdate(map, "WHERE " + query, list, null);
        map.clear();
        list.clear();
        map.put(statusField, JobQueue.statusToString(0));
        map.put(processIDField, null);
        map.put(needPriorityField, JobQueue.needPriorityToString(2));
        map.put(needPriorityProcessIDField, null);
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{JobQueue.statusToString(1), JobQueue.statusToString(8)})});
        this.performUpdate(map, "WHERE " + query, list, null);
        map.put(statusField, JobQueue.statusToString(4));
        map.put(processIDField, null);
        map.put(needPriorityField, JobQueue.needPriorityToString(2));
        map.put(needPriorityProcessIDField, null);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{JobQueue.statusToString(5), JobQueue.statusToString(9)})});
        this.performUpdate(map, "WHERE " + query, list, null);
        map.put(statusField, JobQueue.statusToString(11));
        map.put(processIDField, null);
        map.put(checkTimeField, new Long(0L));
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)JobQueue.statusToString(7))});
        this.performUpdate(map, "WHERE " + query, list, null);
        map.put(statusField, JobQueue.statusToString(6));
        map.put(processIDField, null);
        map.put(checkTimeField, new Long(0L));
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)JobQueue.statusToString(10))});
        this.performUpdate(map, "WHERE " + query, list, null);
        map.clear();
        map.put(isSeedField, JobQueue.seedstatusToString(1));
        map.put(seedingProcessIDField, null);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(isSeedField, (Object)JobQueue.seedstatusToString(2))});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 50000, 0);
        this.unconditionallyAnalyzeTables();
        TrackerClass.noteGlobalChange("Restart cluster");
    }

    public void restartCluster() throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(failTimeField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new NullCheckClause(failTimeField, false)});
        this.performUpdate(map, "WHERE " + query, list, null);
    }

    public void reactivateHopcountRemovedRecords(Long jobID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(0));
        map.put(needPriorityField, JobQueue.needPriorityToString(2));
        map.put(needPriorityProcessIDField, null);
        map.put(checkTimeField, new Long(0L));
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(statusField, (Object)JobQueue.statusToString(12))});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.unconditionallyAnalyzeTables();
        TrackerClass.noteJobChange(jobID, "Map HOPCOUNTREMOVED to PENDING");
    }

    public void clearFailTimes(Long jobID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(failTimeField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new NullCheckClause(failTimeField, false), new UnitaryClause(jobIDField, (Object)jobID)});
        this.performUpdate(map, "WHERE " + query, list, null);
    }

    public void resetDocumentWorkerStatus(String processID) throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, JobQueue.statusToString(0));
        map.put(processIDField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{JobQueue.statusToString(1), JobQueue.statusToString(8)}), new UnitaryClause(processIDField, (Object)processID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        map.put(statusField, JobQueue.statusToString(4));
        map.put(processIDField, null);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(statusField, new Object[]{JobQueue.statusToString(5), JobQueue.statusToString(9)}), new UnitaryClause(processIDField, (Object)processID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.unconditionallyAnalyzeTables();
        TrackerClass.noteGlobalChange("Reset document worker status");
    }

    public void resetDocDeleteWorkerStatus(String processID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(11));
        map.put(processIDField, null);
        map.put(checkTimeField, new Long(0L));
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)JobQueue.statusToString(7)), new UnitaryClause(processIDField, (Object)processID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.unconditionallyAnalyzeTables();
        TrackerClass.noteGlobalChange("Reset document delete worker status");
    }

    public void resetDocCleanupWorkerStatus(String processID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(6));
        map.put(processIDField, null);
        map.put(checkTimeField, new Long(0L));
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(statusField, (Object)JobQueue.statusToString(10)), new UnitaryClause(processIDField, (Object)processID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.unconditionallyAnalyzeTables();
        TrackerClass.noteGlobalChange("Reset document cleanup worker status");
    }

    public void prepareDeleteScan(Long jobID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause("t0.jobid", (Object)jobID), new MultiClause("t0.status", new Object[]{JobQueue.statusToString(0), JobQueue.statusToString(12)})});
        this.prereqEventManager.deleteRows(this.getTableName() + " t0", "t0.id", query, list);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(statusField, new Object[]{JobQueue.statusToString(0), JobQueue.statusToString(12)})});
        this.performDelete("WHERE " + query, list, null);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(11));
        map.put(checkTimeField, new Long(0L));
        map.put(checkActionField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(statusField, new Object[]{JobQueue.statusToString(4), JobQueue.statusToString(2), JobQueue.statusToString(3), JobQueue.statusToString(6)})});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 2, 0);
        this.unconditionallyAnalyzeTables();
        TrackerClass.noteJobChange(jobID, "Prepare delete scan");
    }

    public void prepareFullScan(Long jobID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause("t0.jobid", (Object)jobID), new MultiClause("t0.status", new Object[]{JobQueue.statusToString(0), JobQueue.statusToString(12)})});
        this.prereqEventManager.deleteRows(this.getTableName() + " t0", "t0.id", query, list);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(statusField, new Object[]{JobQueue.statusToString(0), JobQueue.statusToString(12)})});
        this.performDelete("WHERE " + query, list, null);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(6));
        map.put(checkTimeField, new Long(0L));
        map.put(checkActionField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(statusField, new Object[]{JobQueue.statusToString(4), JobQueue.statusToString(3), JobQueue.statusToString(2)})});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 2, 0);
        this.unconditionallyAnalyzeTables();
        TrackerClass.noteJobChange(jobID, "Prepare full scan");
    }

    public void resetPendingDocumentSchedules(Long jobID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(checkTimeField, new Long(0L));
        map.put(checkActionField, JobQueue.actionToString(0));
        map.put(failTimeField, null);
        map.put(failCountField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(statusField, new Object[]{JobQueue.statusToString(4), JobQueue.statusToString(0)})});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
    }

    public void queueAllExisting(Long jobID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(4));
        map.put(needPriorityField, JobQueue.needPriorityToString(2));
        map.put(needPriorityProcessIDField, null);
        map.put(checkTimeField, new Long(0L));
        map.put(checkActionField, JobQueue.actionToString(0));
        map.put(failTimeField, null);
        map.put(failCountField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(statusField, (Object)JobQueue.statusToString(2))});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
        this.unconditionallyAnalyzeTables();
    }

    public void preparePartialScan(Long jobID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(3));
        map.put(checkTimeField, new Long(0L));
        map.put(checkActionField, JobQueue.actionToString(0));
        map.put(failTimeField, null);
        map.put(failCountField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(statusField, (Object)JobQueue.statusToString(2))});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
        this.unconditionallyAnalyzeTables();
    }

    public void prepareIncrementalScan(Long jobID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(4));
        map.put(needPriorityField, JobQueue.needPriorityToString(2));
        map.put(needPriorityProcessIDField, null);
        map.put(checkTimeField, new Long(0L));
        map.put(checkActionField, JobQueue.actionToString(0));
        map.put(failTimeField, null);
        map.put(failCountField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(statusField, new Object[]{JobQueue.statusToString(2), JobQueue.statusToString(3)})});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
        this.unconditionallyAnalyzeTables();
        TrackerClass.noteJobChange(jobID, "Prepare incremental scan");
    }

    public void deleteIngestedDocumentIdentifiers(DocumentDescription[] identifiers) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < identifiers.length; ++i) {
            list.add(identifiers[i].getID());
        }
        if (list.size() > 0) {
            this.doDeletes(list);
        }
        this.noteModifications(0, 0, identifiers.length);
    }

    public boolean checkJobBusy(Long jobID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(statusField, new Object[]{JobQueue.statusToString(1), JobQueue.statusToString(5), JobQueue.statusToString(8), JobQueue.statusToString(9)})});
        IResultSet set = this.performQuery("SELECT dochash FROM " + this.getTableName() + " WHERE " + query + " " + this.constructOffsetLimitClause(0, 1), list, null, null, 1);
        return set.getRowCount() > 0;
    }

    public void deleteAllJobRecords(Long jobID) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(jobID);
        this.prereqEventManager.deleteRows(this.getTableName() + " t0", "t0.id", "t0.jobid=?", list);
        list.clear();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID)});
        this.performDelete("WHERE " + query, list, null);
        this.noteModifications(0, 0, 1);
    }

    public void markNeedPriorityInProgress(Long rowID, String processID) throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(needPriorityField, JobQueue.needPriorityToString(1));
        map.put(needPriorityProcessIDField, processID);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)rowID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
    }

    public void writeDocPriority(Long rowID, IPriorityCalculator priority) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(needPriorityField, JobQueue.needPriorityToString(0));
        map.put(needPriorityProcessIDField, null);
        map.put(docPriorityField, new Double(priority.getDocumentPriority()));
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)rowID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
    }

    public void prioritizeQueuedDocuments(Long jobID) throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(needPriorityField, JobQueue.needPriorityToString(2));
        map.put(needPriorityProcessIDField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(statusField, new Object[]{JobQueue.statusToString(0), JobQueue.statusToString(4)})});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
    }

    public void noDocPriorities(Long jobID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(needPriorityField, JobQueue.needPriorityToString(0));
        map.put(needPriorityProcessIDField, null);
        map.put(docPriorityField, nullDocPriority);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
    }

    public void clearAllDocPriorities() throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(needPriorityField, JobQueue.needPriorityToString(2));
        map.put(needPriorityProcessIDField, null);
        map.put(docPriorityField, nullDocPriority);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(docPriorityField, "<", (Object)nullDocPriority)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
    }

    public void updateCompletedRecord(Long recID, int currentStatus) throws ManifoldCFException {
        Long checkTimeValue;
        String actionFieldValue;
        int newStatus;
        HashMap<String, Object> map = new HashMap<String, Object>();
        switch (currentStatus) {
            case 1: 
            case 5: {
                newStatus = 2;
                actionFieldValue = null;
                checkTimeValue = null;
                map.put(docPriorityField, nullDocPriority);
                map.put(needPriorityField, JobQueue.needPriorityToString(0));
                break;
            }
            case 8: 
            case 9: {
                newStatus = 4;
                actionFieldValue = JobQueue.actionToString(0);
                checkTimeValue = new Long(0L);
                break;
            }
            default: {
                TrackerClass.printForensics(recID, currentStatus);
                throw new ManifoldCFException("Unexpected jobqueue status - record id " + recID.toString() + ", expecting active status, saw " + Integer.toString(currentStatus));
            }
        }
        map.put(statusField, JobQueue.statusToString(newStatus));
        map.put(processIDField, null);
        map.put(checkTimeField, checkTimeValue);
        map.put(checkActionField, actionFieldValue);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)recID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
        TrackerClass.noteRecordChange(recID, newStatus, "Note completion");
    }

    public boolean updateOrHopcountRemoveRecord(Long recID, int currentStatus) throws ManifoldCFException {
        boolean rval;
        Long checkTimeValue;
        String actionFieldValue;
        int newStatus;
        HashMap<String, Object> map = new HashMap<String, Object>();
        switch (currentStatus) {
            case 1: 
            case 5: {
                newStatus = 12;
                map.put(needPriorityField, JobQueue.needPriorityToString(0));
                map.put(needPriorityProcessIDField, null);
                map.put(docPriorityField, nullDocPriority);
                actionFieldValue = JobQueue.actionToString(0);
                checkTimeValue = new Long(0L);
                rval = true;
                break;
            }
            case 8: 
            case 9: {
                newStatus = 4;
                actionFieldValue = JobQueue.actionToString(0);
                checkTimeValue = new Long(0L);
                rval = false;
                break;
            }
            default: {
                TrackerClass.printForensics(recID, currentStatus);
                throw new ManifoldCFException("Unexpected jobqueue status - record id " + recID.toString() + ", expecting active status, saw " + Integer.toString(currentStatus));
            }
        }
        map.put(statusField, JobQueue.statusToString(newStatus));
        map.put(processIDField, null);
        map.put(checkTimeField, checkTimeValue);
        map.put(checkActionField, actionFieldValue);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)recID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
        TrackerClass.noteRecordChange(recID, newStatus, "Update or hopcount remove");
        return rval;
    }

    public void updateActiveRecord(Long id, int currentStatus, String processID) throws ManifoldCFException {
        int newStatus;
        switch (currentStatus) {
            case 0: {
                newStatus = 1;
                break;
            }
            case 4: {
                newStatus = 5;
                break;
            }
            default: {
                TrackerClass.printForensics(id, currentStatus);
                throw new ManifoldCFException("Unexpected status value for jobqueue record " + id.toString() + "; got " + Integer.toString(currentStatus));
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, JobQueue.statusToString(newStatus));
        map.put(processIDField, processID);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)id)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
        TrackerClass.noteRecordChange(id, newStatus, "Make active");
    }

    public void setRequeuedStatus(Long id, Long checkTime, int action, long failTime, int failCount) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(4));
        map.put(processIDField, null);
        map.put(checkTimeField, checkTime);
        map.put(checkActionField, JobQueue.actionToString(action));
        if (failTime == -1L) {
            map.put(failTimeField, null);
        } else {
            map.put(failTimeField, new Long(failTime));
        }
        if (failCount == -1) {
            map.put(failCountField, null);
        } else {
            map.put(failCountField, new Long(failCount));
        }
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)id), new UnitaryClause(docPriorityField, "<", (Object)nullDocPriority)});
        this.performUpdate(map, "WHERE " + query, list, null);
        map.put(needPriorityField, JobQueue.needPriorityToString(2));
        map.put(needPriorityProcessIDField, null);
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)id), new UnitaryClause(docPriorityField, (Object)nullDocPriority)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
        TrackerClass.noteRecordChange(id, 4, "Set requeued status");
    }

    public void setDeletingStatus(Long id, String processID) throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, JobQueue.statusToString(7));
        map.put(processIDField, processID);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)id)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
        TrackerClass.noteRecordChange(id, 7, "Set deleting status");
    }

    public void setUndeletingStatus(Long id, long checkTime) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(11));
        map.put(processIDField, null);
        map.put(checkTimeField, new Long(checkTime));
        map.put(checkActionField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)id)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
        TrackerClass.noteRecordChange(id, 11, "Set undeleting status");
    }

    public void setCleaningStatus(Long id, String processID) throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(statusField, JobQueue.statusToString(10));
        map.put(processIDField, processID);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)id)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
        TrackerClass.noteRecordChange(id, 10, "Set cleaning status");
    }

    public void setUncleaningStatus(Long id, long checkTime) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(statusField, JobQueue.statusToString(6));
        map.put(processIDField, null);
        map.put(checkTimeField, new Long(checkTime));
        map.put(checkActionField, null);
        map.put(failTimeField, null);
        map.put(failCountField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)id)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.noteModifications(0, 1, 0);
        TrackerClass.noteRecordChange(id, 6, "Set uncleaning status");
    }

    public void deleteRecordMultiple(Long[] ids) throws ManifoldCFException {
        int maxClause = this.maxClauseDoDeletes();
        ArrayList<Long> list = new ArrayList<Long>();
        int j = 0;
        int i = 0;
        while (i < ids.length) {
            if (j == maxClause) {
                this.doDeletes(list);
                list.clear();
                j = 0;
            }
            list.add(ids[i++]);
            ++j;
        }
        if (j > 0) {
            this.doDeletes(list);
        }
        this.noteModifications(0, 0, ids.length);
    }

    protected int maxClauseDoDeletes() {
        return this.findConjunctionClauseMax(new ClauseDescription[0]);
    }

    protected void doDeletes(ArrayList list) throws ManifoldCFException {
        this.prereqEventManager.deleteRows(list);
        ArrayList newList = new ArrayList();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new MultiClause(idField, (List)list)});
        this.performDelete("WHERE " + query, newList, null);
    }

    public void deleteRecord(Long id) throws ManifoldCFException {
        this.deleteRecordMultiple(new Long[]{id});
    }

    public void updateExistingRecordInitial(Long recordID, int currentStatus, Long checkTimeValue, long desiredExecuteTime, IPriorityCalculator desiredPriority, String[] prereqEvents, String processID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        switch (currentStatus) {
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                map.put(statusField, JobQueue.statusToString(4));
                TrackerClass.noteRecordChange(recordID, 4, "Update existing record initial");
                if (desiredExecuteTime == -1L) {
                    map.put(checkTimeField, new Long(0L));
                } else {
                    map.put(checkTimeField, new Long(desiredExecuteTime));
                }
                map.put(checkActionField, JobQueue.actionToString(0));
                map.put(failTimeField, null);
                map.put(failCountField, null);
                map.put(docPriorityField, new Double(desiredPriority.getDocumentPriority()));
                map.put(needPriorityField, JobQueue.needPriorityToString(0));
                break;
            }
            case 0: {
                Long cv = checkTimeValue;
                if (cv != null) {
                    long currentExecuteTime = cv;
                    if (desiredExecuteTime == -1L || currentExecuteTime <= desiredExecuteTime) {
                        break;
                    }
                } else if (desiredExecuteTime == -1L) break;
                map.put(checkTimeField, new Long(desiredExecuteTime));
                map.put(checkActionField, JobQueue.actionToString(0));
                map.put(failTimeField, null);
                map.put(failCountField, null);
                break;
            }
            case 4: {
                break;
            }
        }
        map.put(isSeedField, JobQueue.seedstatusToString(2));
        map.put(seedingProcessIDField, processID);
        this.prereqEventManager.deleteRows(recordID);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)recordID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.prereqEventManager.addRows(recordID, prereqEvents);
        this.noteModifications(0, 1, 0);
    }

    public void insertNewRecordInitial(Long jobID, String docHash, String docID, IPriorityCalculator desiredDocPriority, long desiredExecuteTime, String[] prereqEvents, String processID) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long recordID = new Long(IDFactory.make((IThreadContext)this.threadContext));
        map.put(idField, recordID);
        if (desiredExecuteTime == -1L) {
            map.put(checkTimeField, new Long(0L));
        } else {
            map.put(checkTimeField, new Long(desiredExecuteTime));
        }
        map.put(checkActionField, JobQueue.actionToString(0));
        map.put(jobIDField, jobID);
        map.put(docHashField, docHash);
        map.put(docIDField, docID);
        map.put(statusField, JobQueue.statusToString(0));
        map.put(isSeedField, JobQueue.seedstatusToString(2));
        map.put(seedingProcessIDField, processID);
        map.put(docPriorityField, new Double(desiredDocPriority.getDocumentPriority()));
        map.put(needPriorityField, JobQueue.needPriorityToString(0));
        this.performInsert(map, null);
        this.prereqEventManager.addRows(recordID, prereqEvents);
        this.noteModifications(1, 0, 0);
        TrackerClass.noteRecordChange(recordID, 0, "Create initial");
    }

    public void addRemainingDocumentsInitial(Long jobID, String[] docIDHashes, String processID) throws ManifoldCFException {
        if (docIDHashes.length == 0) {
            return;
        }
        HashMap<String, String> inSet = new HashMap<String, String>();
        int j = 0;
        while (j < docIDHashes.length) {
            String docIDHash = docIDHashes[j++];
            inSet.put(docIDHash, docIDHash);
        }
        HashMap idMap = new HashMap();
        int k = 0;
        int maxClause = 1;
        ArrayList<String> list = new ArrayList<String>();
        j = 0;
        while (j < docIDHashes.length) {
            String docIDHash = docIDHashes[j++];
            if (k == maxClause) {
                this.processRemainingDocuments(idMap, jobID, list, inSet);
                k = 0;
                list.clear();
            }
            list.add(docIDHash);
            ++k;
        }
        if (k > 0) {
            this.processRemainingDocuments(idMap, jobID, list, inSet);
        }
        k = 0;
        list.clear();
        maxClause = this.maxClauseUpdateRemainingDocuments();
        Iterator idValues = idMap.keySet().iterator();
        while (idValues.hasNext()) {
            if (k == maxClause) {
                this.updateRemainingDocuments(list, processID);
                k = 0;
                list.clear();
            }
            list.add((String)idValues.next());
            ++k;
        }
        if (k > 0) {
            this.updateRemainingDocuments(list, processID);
        }
        this.noteModifications(0, docIDHashes.length, 0);
    }

    protected int maxClauseProcessRemainingDocuments(Long jobID) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID)});
    }

    protected void processRemainingDocuments(Map idMap, Long jobID, ArrayList list, Map inSet) throws ManifoldCFException {
        ArrayList<String> newList = new ArrayList<String>();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new MultiClause(docHashField, (List)list), new UnitaryClause(jobIDField, (Object)jobID)});
        newList.add(JobQueue.seedstatusToString(1));
        IResultSet set = this.performQuery("SELECT id,dochash FROM " + this.getTableName() + " WHERE " + query + " AND " + isSeedField + "=? FOR UPDATE", newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row;
            String docIDHash;
            if (inSet.get(docIDHash = (String)(row = set.getRow(i++)).getValue(docHashField)) == null) continue;
            Long idValue = (Long)row.getValue(idField);
            idMap.put(idValue, idValue);
        }
    }

    protected int maxClauseUpdateRemainingDocuments() {
        return this.findConjunctionClauseMax(new ClauseDescription[0]);
    }

    protected void updateRemainingDocuments(ArrayList list, String processID) throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(isSeedField, JobQueue.seedstatusToString(2));
        map.put(seedingProcessIDField, processID);
        ArrayList newList = new ArrayList();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new MultiClause(idField, (List)list)});
        this.performUpdate(map, "WHERE " + query, newList, null);
    }

    public void doneDocumentsInitial(Long jobID, boolean isPartial) throws ManifoldCFException {
        String query;
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        if (!isPartial) {
            query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(isSeedField, (Object)JobQueue.seedstatusToString(1)), new UnitaryClause(jobIDField, (Object)jobID)});
            map.put(isSeedField, JobQueue.seedstatusToString(0));
            this.performUpdate(map, "WHERE " + query, list, null);
            list.clear();
        }
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(isSeedField, (Object)JobQueue.seedstatusToString(1)), new UnitaryClause(jobIDField, (Object)jobID)});
        map.put(isSeedField, JobQueue.seedstatusToString(1));
        map.put(seedingProcessIDField, null);
        this.performUpdate(map, "WHERE " + query, list, null);
    }

    public String[] getAllSeeds(Long jobID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(isSeedField, (Object)JobQueue.seedstatusToString(1)), new UnitaryClause(jobIDField, (Object)jobID)});
        IResultSet set = this.performQuery("SELECT dochash FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        String[] rval = new String[set.getRowCount()];
        int i = 0;
        while (i < rval.length) {
            IResultRow row = set.getRow(i);
            rval[i++] = (String)row.getValue(docHashField);
        }
        return rval;
    }

    public void updateExistingRecord(Long recordID, int currentStatus, Long checkTimeValue, long desiredExecuteTime, boolean otherChangesSeen, IPriorityCalculator desiredPriority, String[] prereqEvents) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        switch (currentStatus) {
            case 3: 
            case 6: {
                map.put(statusField, JobQueue.statusToString(4));
                TrackerClass.noteRecordChange(recordID, 4, "Update existing");
                map.put(checkTimeField, new Long(desiredExecuteTime));
                map.put(checkActionField, JobQueue.actionToString(0));
                map.put(failTimeField, null);
                map.put(failCountField, null);
                map.put(docPriorityField, new Double(desiredPriority.getDocumentPriority()));
                map.put(needPriorityField, JobQueue.needPriorityToString(0));
                break;
            }
            case 2: 
            case 10: {
                if (otherChangesSeen) {
                    map.put(statusField, JobQueue.statusToString(4));
                    TrackerClass.noteRecordChange(recordID, 4, "Update existing");
                    map.put(checkTimeField, new Long(desiredExecuteTime));
                    map.put(checkActionField, JobQueue.actionToString(0));
                    map.put(failTimeField, null);
                    map.put(failCountField, null);
                    map.put(docPriorityField, new Double(desiredPriority.getDocumentPriority()));
                    map.put(needPriorityField, JobQueue.needPriorityToString(0));
                    break;
                }
                return;
            }
            case 8: 
            case 9: {
                return;
            }
            case 1: {
                if (otherChangesSeen) {
                    map.put(statusField, JobQueue.statusToString(8));
                    TrackerClass.noteRecordChange(recordID, 8, "Update existing");
                    map.put(checkTimeField, new Long(desiredExecuteTime));
                    map.put(checkActionField, JobQueue.actionToString(0));
                    map.put(failTimeField, null);
                    map.put(failCountField, null);
                    map.put(docPriorityField, new Double(desiredPriority.getDocumentPriority()));
                    map.put(needPriorityField, JobQueue.needPriorityToString(0));
                    break;
                }
                return;
            }
            case 5: {
                if (otherChangesSeen) {
                    map.put(statusField, JobQueue.statusToString(9));
                    TrackerClass.noteRecordChange(recordID, 9, "Update existing");
                    map.put(checkTimeField, new Long(desiredExecuteTime));
                    map.put(checkActionField, JobQueue.actionToString(0));
                    map.put(failTimeField, null);
                    map.put(failCountField, null);
                    map.put(docPriorityField, new Double(desiredPriority.getDocumentPriority()));
                    map.put(needPriorityField, JobQueue.needPriorityToString(0));
                    break;
                }
                return;
            }
            case 0: {
                long currentExecuteTime;
                Long cv = checkTimeValue;
                if (cv != null && (currentExecuteTime = cv.longValue()) <= desiredExecuteTime) {
                    return;
                }
                map.put(checkTimeField, new Long(desiredExecuteTime));
                map.put(checkActionField, JobQueue.actionToString(0));
                map.put(failTimeField, null);
                map.put(failCountField, null);
                break;
            }
            default: {
                return;
            }
        }
        this.prereqEventManager.deleteRows(recordID);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)recordID)});
        this.performUpdate(map, "WHERE " + query, list, null);
        this.prereqEventManager.addRows(recordID, prereqEvents);
        this.noteModifications(0, 1, 0);
    }

    public void insertNewRecord(Long jobID, String docIDHash, String docID, IPriorityCalculator desiredDocPriority, long desiredExecuteTime, String[] prereqEvents) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long recordID = new Long(IDFactory.make((IThreadContext)this.threadContext));
        map.put(idField, recordID);
        map.put(checkTimeField, new Long(desiredExecuteTime));
        map.put(checkActionField, JobQueue.actionToString(0));
        map.put(jobIDField, jobID);
        map.put(docHashField, docIDHash);
        map.put(docIDField, docID);
        map.put(statusField, JobQueue.statusToString(0));
        map.put(docPriorityField, new Double(desiredDocPriority.getDocumentPriority()));
        map.put(needPriorityField, JobQueue.needPriorityToString(0));
        this.performInsert(map, null);
        this.prereqEventManager.addRows(recordID, prereqEvents);
        this.noteModifications(1, 0, 0);
        TrackerClass.noteRecordChange(recordID, 0, "Create new");
    }

    public static String seedstatusToString(int status) throws ManifoldCFException {
        switch (status) {
            case 0: {
                return "F";
            }
            case 1: {
                return "S";
            }
            case 2: {
                return "N";
            }
        }
        throw new ManifoldCFException("Invalid seed status: " + Integer.toString(status));
    }

    public static int stringToSeedstatus(String x) throws ManifoldCFException {
        if (x == null || x.length() == 0) {
            return 0;
        }
        Integer y = seedstatusMap.get(x);
        if (y == null) {
            throw new ManifoldCFException("Unknown seed status code: " + x);
        }
        return y;
    }

    public static int stringToAction(String value) throws ManifoldCFException {
        Integer x = actionMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Unknown action string: '" + value + "'");
        }
        return x;
    }

    public static String actionToString(int action) throws ManifoldCFException {
        switch (action) {
            case 0: {
                return "R";
            }
            case 1: {
                return "D";
            }
        }
        throw new ManifoldCFException("Bad action value: " + Integer.toString(action));
    }

    public static int stringToNeedPriority(String value) throws ManifoldCFException {
        if (value == null || value.length() == 0) {
            return 0;
        }
        Integer x = needPriorityMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Unknown needpriority string: '" + value + "'");
        }
        return x;
    }

    public static String needPriorityToString(int value) throws ManifoldCFException {
        switch (value) {
            case 2: {
                return "T";
            }
            case 0: {
                return "F";
            }
            case 1: {
                return "I";
            }
        }
        throw new ManifoldCFException("Bad needpriority value: " + Integer.toString(value));
    }

    public static int stringToStatus(String value) throws ManifoldCFException {
        Integer x = statusMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Unknown status string: '" + value + "'");
        }
        return x;
    }

    public static String statusToString(int status) throws ManifoldCFException {
        switch (status) {
            case 0: {
                return "P";
            }
            case 1: {
                return "A";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "U";
            }
            case 4: {
                return "G";
            }
            case 5: {
                return "F";
            }
            case 6: {
                return "Z";
            }
            case 11: {
                return "E";
            }
            case 7: {
                return "D";
            }
            case 8: {
                return "a";
            }
            case 9: {
                return "f";
            }
            case 10: {
                return "d";
            }
            case 12: {
                return "H";
            }
        }
        throw new ManifoldCFException("Bad status value: " + Integer.toString(status));
    }

    public static String getHashCode(String documentIdentifier) throws ManifoldCFException {
        return ManifoldCF.hash((String)documentIdentifier);
    }

    static {
        statusMap.put("P", new Integer(0));
        statusMap.put("A", new Integer(1));
        statusMap.put("C", new Integer(2));
        statusMap.put("U", new Integer(3));
        statusMap.put("G", new Integer(4));
        statusMap.put("F", new Integer(5));
        statusMap.put("Z", new Integer(6));
        statusMap.put("E", new Integer(11));
        statusMap.put("D", new Integer(7));
        statusMap.put("a", new Integer(8));
        statusMap.put("f", new Integer(9));
        statusMap.put("d", new Integer(10));
        statusMap.put("H", new Integer(12));
        seedstatusMap = new HashMap<String, Integer>();
        seedstatusMap.put("F", new Integer(0));
        seedstatusMap.put("S", new Integer(1));
        seedstatusMap.put("N", new Integer(2));
        actionMap = new HashMap<String, Integer>();
        actionMap.put("R", new Integer(0));
        actionMap.put("D", new Integer(1));
        needPriorityMap = new HashMap<String, Integer>();
        needPriorityMap.put("T", new Integer(2));
        needPriorityMap.put("I", new Integer(1));
        needPriorityMap.put("F", new Integer(0));
    }

    protected static class DuplicateFinder
    implements ILimitChecker {
        protected Long prevJobID = null;
        protected String prevDocIDHash = null;

        public boolean doesCompareWork() {
            return false;
        }

        public ILimitChecker duplicate() {
            DuplicateFinder df = new DuplicateFinder();
            df.prevJobID = this.prevJobID;
            df.prevDocIDHash = this.prevDocIDHash;
            return df;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }

        public boolean checkInclude(IResultRow row) throws ManifoldCFException {
            Long jobID = (Long)row.getValue(JobQueue.jobIDField);
            String docIDHash = (String)row.getValue(JobQueue.docHashField);
            if (this.prevJobID != null && jobID.equals(this.prevJobID) && docIDHash.equals(this.prevDocIDHash)) {
                return true;
            }
            this.prevJobID = jobID;
            this.prevDocIDHash = docIDHash;
            return false;
        }

        public boolean checkContinue() throws ManifoldCFException {
            return true;
        }
    }
}

