/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.system;

import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorPoolFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectorPool;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnectorPool;
import org.apache.manifoldcf.authorities.interfaces.MappingConnectorPoolFactory;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;

public class IdleCleanupThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: IdleCleanupThread.java 988245 2010-08-23 18:39:35Z kwright $";

    public IdleCleanupThread() throws ManifoldCFException {
        this.setName("Authorities idle cleanup thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IAuthorityConnectorPool authorityConnectorPool = AuthorityConnectorPoolFactory.make(threadContext);
            IMappingConnectorPool mappingConnectorPool = MappingConnectorPoolFactory.make(threadContext);
            while (true) {
                try {
                    while (true) {
                        authorityConnectorPool.pollAllConnectors();
                        mappingConnectorPool.pollAllConnectors();
                        ManifoldCF.pollAll((IThreadContext)threadContext);
                        ManifoldCF.sleep((long)5000L);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() != 2) {
                        Logging.authorityService.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                        if (e.getErrorCode() != 3) continue;
                        System.exit(1);
                        continue;
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Throwable e) {
                    Logging.authorityService.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("Authority service idle cleanup could not start - shutting down");
            Logging.authorityService.fatal((Object)("IdleCleanupThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }
}

