/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.sharedrive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import jcifs.ACE;
import jcifs.Credentials;
import jcifs.context.SingletonContext;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileFilter;
import jcifs.util.transport.TransportException;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.extmimemap.ExtensionMimeMap;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.common.DateParser;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.sharedrive.MatchMap;
import org.apache.manifoldcf.crawler.connectors.sharedrive.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IFingerprintActivity;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.ui.util.Encoder;

public class SharedDriveConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: SharedDriveConnector.java 996524 2010-09-13 13:38:01Z kwright $";
    public static final String ACTIVITY_ACCESS = "access";
    public static final String NODE_STARTPOINT = "startpoint";
    public static final String NODE_INCLUDE = "include";
    public static final String NODE_EXCLUDE = "exclude";
    public static final String NODE_PATHNAMEATTRIBUTE = "pathnameattribute";
    public static final String NODE_PATHMAP = "pathmap";
    public static final String NODE_FILEMAP = "filemap";
    public static final String NODE_URIMAP = "urimap";
    public static final String NODE_SHAREACCESS = "shareaccess";
    public static final String NODE_SHARESECURITY = "sharesecurity";
    public static final String NODE_PARENTFOLDERACCESS = "parentfolderaccess";
    public static final String NODE_PARENTFOLDERSECURITY = "parentfoldersecurity";
    public static final String NODE_MAXLENGTH = "maxlength";
    public static final String NODE_ACCESS = "access";
    public static final String NODE_SECURITY = "security";
    public static final String ATTRIBUTE_PATH = "path";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_INDEXABLE = "indexable";
    public static final String ATTRIBUTE_FILESPEC = "filespec";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_TOKEN = "token";
    public static final String ATTRIBUTE_MATCH = "match";
    public static final String ATTRIBUTE_REPLACE = "replace";
    public static final String VALUE_DIRECTORY = "directory";
    public static final String VALUE_FILE = "file";
    public static final String PROPERTY_JCIFS_USE_NTLM_V1 = "org.apache.manifoldcf.crawler.connectors.jcifs.usentlmv1";
    private String smbconnectionPath = null;
    private String server = null;
    private String domain = null;
    private String username = null;
    private String password = null;
    private boolean useSIDs = true;
    private String binName = null;
    private NtlmPasswordAuthenticator pa;
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";

    public void setThreadContext(IThreadContext threadContext) throws ManifoldCFException {
        super.setThreadContext(threadContext);
        boolean useV1 = LockManagerFactory.getBooleanProperty((IThreadContext)threadContext, (String)PROPERTY_JCIFS_USE_NTLM_V1, (boolean)false);
        if (!useV1) {
            System.setProperty("jcifs.smb.lmCompatibility", "3");
            System.setProperty("jcifs.smb.client.useExtendedSecurity", "true");
        } else {
            System.setProperty("jcifs.smb.lmCompatibility", "0");
            System.setProperty("jcifs.smb.client.useExtendedSecurity", "false");
        }
    }

    protected void getSession() throws ManifoldCFException {
        if (this.smbconnectionPath == null) {
            if (this.server == null || this.server.length() == 0) {
                throw new ManifoldCFException("Missing parameter 'Server'");
            }
            if (this.domain == null || this.domain.length() == 0) {
                this.domain = null;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Connecting to: smb://" + (this.domain == null ? "" : this.domain) + ";" + this.username + ":<password>@" + this.server + "/"));
            }
            try {
                this.pa = new NtlmPasswordAuthenticator(this.domain, this.username, this.password);
                SmbFile smbconnection = new SmbFile("smb://" + this.server + "/", SingletonContext.getInstance().withCredentials((Credentials)this.pa));
                this.smbconnectionPath = SharedDriveConnector.getFileCanonicalPath(smbconnection);
            }
            catch (MalformedURLException e) {
                Logging.connectors.error((Object)("Unable to access SMB/CIFS share: smb://" + (this.domain == null ? "" : this.domain) + ";" + this.username + ":<password>@" + this.server + "/\n" + e));
                throw new ManifoldCFException("Unable to access SMB/CIFS share: " + this.server, (Throwable)e, 5);
            }
        }
    }

    public String[] getActivitiesList() {
        return new String[]{"access"};
    }

    public void disconnect() throws ManifoldCFException {
        this.server = null;
        this.domain = null;
        this.username = null;
        this.password = null;
        this.pa = null;
        this.smbconnectionPath = null;
        this.binName = null;
        super.disconnect();
    }

    public void connect(ConfigParams configParameters) {
        String userDomain;
        int index;
        String useSIDsString;
        super.connect(configParameters);
        this.server = configParameters.getParameter("Server");
        this.domain = configParameters.getParameter("Domain/Realm");
        this.username = configParameters.getParameter("User Name");
        if (this.username == null) {
            this.username = "";
        }
        this.password = configParameters.getObfuscatedParameter("Password");
        if (this.password == null) {
            this.password = "";
        }
        if ((useSIDsString = configParameters.getParameter("Use SIDs")) == null) {
            useSIDsString = "true";
        }
        this.useSIDs = "true".equals(useSIDsString);
        String configBinName = configParameters.getParameter("Bin Name");
        String string = this.binName = configBinName == null || configBinName.length() == 0 ? this.server : configBinName;
        if (this.binName.length() > 255) {
            this.binName = this.binName.substring(0, 255);
        }
        if ((index = this.username.indexOf("@")) != -1) {
            userDomain = this.username.substring(index + 1);
            if (this.domain == null || this.domain.length() == 0) {
                this.domain = userDomain;
            }
            this.username = this.username.substring(0, index);
        }
        if ((index = this.username.indexOf("\\")) != -1) {
            userDomain = this.username.substring(0, index);
            if (this.domain == null || this.domain.length() == 0) {
                this.domain = userDomain;
            }
            this.username = this.username.substring(index + 1);
        }
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.binName};
    }

    protected static String convertToURI(String documentIdentifier, MatchMap fileMap, MatchMap uriMap) throws ManifoldCFException {
        String serverPath = documentIdentifier.substring("smb://".length());
        serverPath = fileMap.translate(serverPath);
        if (uriMap.getMatchCount() != 0) {
            byte[] byteArray = serverPath.getBytes(StandardCharsets.UTF_8);
            StringBuilder output = new StringBuilder();
            int i = 0;
            while (i < byteArray.length) {
                int x;
                if ((x = byteArray[i++] & 0xFF) >= 128 || x >= 0 && x <= 32 || x == 58 || x == 63 || x == 94 || x == 123 || x == 125 || x == 37 || x == 35 || x == 96 || x == 59 || x == 64 || x == 38 || x == 61 || x == 43 || x == 36 || x == 44) {
                    output.append('%');
                    String hexValue = Integer.toHexString(x).toUpperCase(Locale.ROOT);
                    if (hexValue.length() == 1) {
                        output.append('0');
                    }
                    output.append(hexValue);
                    continue;
                }
                output.append((char)x);
            }
            return uriMap.translate(output.toString());
        }
        StringBuilder output = new StringBuilder();
        int i = 0;
        while (i < serverPath.length()) {
            int pos = serverPath.indexOf("/", i);
            if (pos == -1) {
                pos = serverPath.length();
            }
            String piece = serverPath.substring(i, pos);
            String replacePiece = URLEncoder.encode((String)piece);
            int j = 0;
            while (j < replacePiece.length()) {
                int plusPos = replacePiece.indexOf("+", j);
                if (plusPos == -1) {
                    plusPos = replacePiece.length();
                }
                output.append(replacePiece.substring(j, plusPos));
                if (plusPos < replacePiece.length()) {
                    output.append("%20");
                }
                j = ++plusPos;
            }
            if (pos < serverPath.length()) {
                output.append("/");
            }
            i = ++pos;
        }
        return "file://///" + output.toString();
    }

    public boolean requestInfo(Configuration output, String command) throws ManifoldCFException {
        if (command.startsWith("folders/")) {
            String parentFolder = command.substring("folders/".length());
            try {
                String[] folders = this.getChildFolderNames(parentFolder);
                int i = 0;
                while (i < folders.length) {
                    String folder = folders[i++];
                    ConfigurationNode node = new ConfigurationNode("folder");
                    node.setValue(folder);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("folder/")) {
            String folder = command.substring("folder/".length());
            try {
                String canonicalFolder = this.validateFolderName(folder);
                if (canonicalFolder != null) {
                    ConfigurationNode node = new ConfigurationNode("folder");
                    node.setValue(canonicalFolder);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else {
            return super.requestInfo(output, command);
        }
        return true;
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        try {
            for (int i = 0; i < spec.getChildCount(); ++i) {
                SpecificationNode n = spec.getChild(i);
                if (!n.getType().equals(NODE_STARTPOINT)) continue;
                String seed = this.mapToIdentifier(n.getAttributeValue(ATTRIBUTE_PATH));
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Seed = '" + seed + "'"));
                }
                activities.addSeedDocument(seed);
            }
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Could not get a canonical path: " + e.getMessage(), (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw new ManifoldCFException("Could not get a canonical path: " + e.getMessage(), (Throwable)e);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        String[] acls = SharedDriveConnector.getForcedAcls(spec);
        String[] shareAcls = SharedDriveConnector.getForcedShareAcls(spec);
        String[] parentFolderAcls = SharedDriveConnector.getForcedParentFolderAcls(spec);
        String pathAttributeName = null;
        MatchMap matchMap = new MatchMap();
        MatchMap fileMap = new MatchMap();
        MatchMap uriMap = new MatchMap();
        int i = 0;
        while (i < spec.getChildCount()) {
            String pathReplace;
            String pathMatch;
            SpecificationNode n;
            if ((n = spec.getChild(i++)).getType().equals(NODE_PATHNAMEATTRIBUTE)) {
                pathAttributeName = n.getAttributeValue(ATTRIBUTE_VALUE);
                continue;
            }
            if (n.getType().equals(NODE_PATHMAP)) {
                pathMatch = n.getAttributeValue(ATTRIBUTE_MATCH);
                pathReplace = n.getAttributeValue(ATTRIBUTE_REPLACE);
                matchMap.appendMatchPair(pathMatch, pathReplace);
                continue;
            }
            if (n.getType().equals(NODE_FILEMAP)) {
                pathMatch = n.getAttributeValue(ATTRIBUTE_MATCH);
                pathReplace = n.getAttributeValue(ATTRIBUTE_REPLACE);
                fileMap.appendMatchPair(pathMatch, pathReplace);
                continue;
            }
            if (!n.getType().equals(NODE_URIMAP)) continue;
            pathMatch = n.getAttributeValue(ATTRIBUTE_MATCH);
            pathReplace = n.getAttributeValue(ATTRIBUTE_REPLACE);
            uriMap.appendMatchPair(pathMatch, pathReplace);
        }
        String[] stringArray = documentIdentifiers;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            block90: {
                String versionString;
                SmbFile file;
                boolean fileIsDirectory;
                boolean fileExists;
                long lastModified;
                long fileLength;
                String[] documentDeny;
                String[] documentAllow;
                String[] parentDeny;
                String[] parentAllow;
                String[] shareDeny;
                String[] shareAllow;
                String pathAttributeValue;
                String ingestionURI;
                String documentIdentifier;
                block89: {
                    if (n2 >= n) {
                        return;
                    }
                    documentIdentifier = stringArray[n2];
                    this.getSession();
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("JCIFS: Processing '" + documentIdentifier + "'"));
                    }
                    ingestionURI = null;
                    pathAttributeValue = null;
                    shareAllow = null;
                    shareDeny = null;
                    boolean shareSecurityOn = false;
                    parentAllow = null;
                    parentDeny = null;
                    boolean parentSecurityOn = false;
                    documentAllow = null;
                    documentDeny = null;
                    boolean documentSecurityOn = false;
                    fileLength = 0L;
                    lastModified = 0L;
                    fileExists = false;
                    fileIsDirectory = false;
                    try {
                        file = new SmbFile(documentIdentifier, SingletonContext.getInstance().withCredentials((Credentials)this.pa));
                        fileExists = SharedDriveConnector.fileExists(file);
                        String newPath = SharedDriveConnector.getFileCanonicalPath(file);
                        if (fileExists && newPath != null) {
                            fileIsDirectory = SharedDriveConnector.fileIsDirectory(file);
                            if (this.checkInclude(fileIsDirectory, newPath, spec)) {
                                if (fileIsDirectory) {
                                    versionString = "";
                                    break block89;
                                }
                                fileLength = SharedDriveConnector.fileLength(file);
                                if (SharedDriveConnector.checkIncludeFile(fileLength, newPath, spec, (IFingerprintActivity)activities)) {
                                    SmbFile parentFolder = new SmbFile(file.getParent(), SingletonContext.getInstance().withCredentials((Credentials)this.pa));
                                    String[] modelArray = new String[]{};
                                    ArrayList<String> allowList = new ArrayList<String>();
                                    ArrayList<String> denyList = new ArrayList<String>();
                                    shareSecurityOn = this.getFileShareSecuritySet(allowList, denyList, file, shareAcls);
                                    shareAllow = allowList.toArray(modelArray);
                                    shareDeny = denyList.toArray(modelArray);
                                    allowList.clear();
                                    denyList.clear();
                                    parentSecurityOn = this.getFileSecuritySet(allowList, denyList, parentFolder, parentFolderAcls);
                                    parentAllow = allowList.toArray(modelArray);
                                    parentDeny = denyList.toArray(modelArray);
                                    allowList.clear();
                                    denyList.clear();
                                    documentSecurityOn = this.getFileSecuritySet(allowList, denyList, file, acls);
                                    documentAllow = allowList.toArray(modelArray);
                                    documentDeny = denyList.toArray(modelArray);
                                    lastModified = SharedDriveConnector.fileLastModified(file);
                                    StringBuilder sb = new StringBuilder();
                                    SharedDriveConnector.addSecuritySet(sb, shareSecurityOn, shareAllow, shareDeny);
                                    SharedDriveConnector.addSecuritySet(sb, parentSecurityOn, parentAllow, parentDeny);
                                    SharedDriveConnector.addSecuritySet(sb, documentSecurityOn, documentAllow, documentDeny);
                                    if (pathAttributeName != null) {
                                        sb.append('+');
                                        SharedDriveConnector.pack((StringBuilder)sb, (String)pathAttributeName, (char)'+');
                                        pathAttributeValue = documentIdentifier;
                                        if (pathAttributeValue.startsWith("smb://")) {
                                            int index = pathAttributeValue.indexOf("/", "smb://".length());
                                            if (index == -1) {
                                                index = pathAttributeValue.length();
                                            }
                                            pathAttributeValue = pathAttributeValue.substring(index);
                                        }
                                        pathAttributeValue = matchMap.translate(pathAttributeValue);
                                        SharedDriveConnector.pack((StringBuilder)sb, (String)pathAttributeValue, (char)'+');
                                    } else {
                                        sb.append('-');
                                    }
                                    ingestionURI = SharedDriveConnector.convertToURI(documentIdentifier, fileMap, uriMap);
                                    SharedDriveConnector.pack((StringBuilder)sb, (String)ingestionURI, (char)'+');
                                    sb.append(new Long(lastModified).toString()).append(":").append(new Long(fileLength).toString());
                                    boolean ifIndexable = this.wouldFileBeIncluded(newPath, spec, true);
                                    boolean ifNotIndexable = this.wouldFileBeIncluded(newPath, spec, false);
                                    if (ifIndexable == ifNotIndexable) {
                                        sb.append("I");
                                    } else {
                                        sb.append(ifIndexable ? "Y" : "N");
                                    }
                                    versionString = sb.toString();
                                    break block89;
                                }
                                activities.deleteDocument(documentIdentifier);
                                break block90;
                            }
                            activities.deleteDocument(documentIdentifier);
                            break block90;
                        }
                        activities.deleteDocument(documentIdentifier);
                        break block90;
                    }
                    catch (SmbAuthException e) {
                        Logging.connectors.warn((Object)("JCIFS: Authorization exception reading version information for " + documentIdentifier + " - skipping"));
                        if (e.getMessage().equals("Logon failure: unknown user name or bad password.")) {
                            throw new ManifoldCFException("SmbAuthException thrown: " + e.getMessage(), (Throwable)e);
                        }
                        activities.deleteDocument(documentIdentifier);
                        break block90;
                    }
                    catch (MalformedURLException mue) {
                        Logging.connectors.error((Object)("JCIFS: MalformedURLException thrown: " + mue.getMessage()), (Throwable)mue);
                        throw new ManifoldCFException("MalformedURLException thrown: " + mue.getMessage(), (Throwable)mue);
                    }
                    catch (SmbException se) {
                        SharedDriveConnector.processSMBException(se, documentIdentifier, "getting document version", "fetching share security");
                        activities.deleteDocument(documentIdentifier);
                        break block90;
                    }
                    catch (SocketTimeoutException e) {
                        long currentTime = System.currentTimeMillis();
                        Logging.connectors.warn((Object)("JCIFS: Socket timeout reading version information for document " + documentIdentifier + ": " + e.getMessage()), (Throwable)e);
                        throw new ServiceInterruption("Timeout or other service interruption: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
                    }
                    catch (InterruptedIOException e) {
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        long currentTime = System.currentTimeMillis();
                        Logging.connectors.warn((Object)("JCIFS: I/O error reading version information for document " + documentIdentifier + ": " + e.getMessage()), (Throwable)e);
                        throw new ServiceInterruption("Timeout or other service interruption: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
                    }
                }
                if (versionString.length() == 0 || activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) {
                    long startFetchTime;
                    Long fileLengthLong;
                    String errorDesc;
                    String errorCode;
                    block95: {
                        block94: {
                            errorCode = null;
                            errorDesc = null;
                            fileLengthLong = null;
                            startFetchTime = System.currentTimeMillis();
                            try {
                                block91: {
                                    String contentType;
                                    Long originalLength;
                                    Date creationDate;
                                    Date lastModifiedDate;
                                    String fileNameString;
                                    String uri;
                                    String fileName;
                                    byte[] transferBuffer;
                                    block92: {
                                        transferBuffer = null;
                                        try {
                                            if (!fileExists) break block90;
                                            if (fileIsDirectory) {
                                                if (Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("JCIFS: '" + documentIdentifier + "' is a directory"));
                                                }
                                                ProcessDocumentsFilter filter = new ProcessDocumentsFilter(activities, spec);
                                                SharedDriveConnector.fileListFiles(file, filter);
                                                filter.checkAndThrow();
                                                break block90;
                                            }
                                            if (Logging.connectors.isDebugEnabled()) {
                                                Logging.connectors.debug((Object)("JCIFS: '" + documentIdentifier + "' is a file"));
                                            }
                                            if ((fileName = SharedDriveConnector.getFileCanonicalPath(file)) == null || file.isHidden()) break block91;
                                            uri = ingestionURI;
                                            fileNameString = file.getName();
                                            lastModifiedDate = new Date(lastModified);
                                            creationDate = new Date(file.createTime());
                                            originalLength = new Long(fileLength);
                                            contentType = SharedDriveConnector.mapExtensionToMimeType(fileNameString);
                                            if (activities.checkURLIndexable(uri)) break block92;
                                            Logging.connectors.debug((Object)("JCIFS: Skipping file because output connector cannot accept URL ('" + uri + "')"));
                                            errorCode = "EXCLUDEDURL";
                                            errorDesc = "Rejected due to URL ('" + uri + "')";
                                            activities.noDocument(documentIdentifier, versionString);
                                            break block90;
                                        }
                                        catch (MalformedURLException mue) {
                                            Logging.connectors.error((Object)("MalformedURLException tossed: " + mue.getMessage()), (Throwable)mue);
                                            errorCode = mue.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                            errorDesc = "Malformed URL: " + mue.getMessage();
                                            throw new ManifoldCFException("MalformedURLException tossed: " + mue.getMessage(), (Throwable)mue);
                                        }
                                        catch (SmbAuthException e) {
                                            Logging.connectors.warn((Object)("JCIFS: Authorization exception reading document/directory " + documentIdentifier + " - skipping"));
                                            errorCode = ((Object)((Object)e)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                            errorDesc = "Authorization: " + e.getMessage();
                                            if (e.getMessage().equals("Logon failure: unknown user name or bad password.")) {
                                                throw new ManifoldCFException("SmbAuthException thrown: " + e.getMessage(), (Throwable)e);
                                            }
                                            activities.noDocument(documentIdentifier, versionString);
                                            break block90;
                                        }
                                        catch (SmbException se) {
                                            long currentTime = System.currentTimeMillis();
                                            Throwable cause = se.getRootCause();
                                            if (cause != null && cause instanceof TransportException) {
                                                TransportException te = (TransportException)cause;
                                                if (te.getRootCause() != null && te.getRootCause() instanceof InterruptedException) {
                                                    throw new ManifoldCFException(te.getRootCause().getMessage(), te.getRootCause(), 2);
                                                }
                                                Logging.connectors.warn((Object)("JCIFS: Timeout processing document/directory " + documentIdentifier + ": retrying..."), (Throwable)se);
                                                errorCode = cause.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                                errorDesc = "Transport: " + cause.getMessage();
                                                throw new ServiceInterruption("Timeout or other service interruption: " + cause.getMessage(), cause, currentTime + 300000L, currentTime + 43200000L, -1, false);
                                            }
                                            if (se.getMessage().toLowerCase(Locale.ROOT).indexOf("reset by peer") != -1 || se.getMessage().toLowerCase(Locale.ROOT).indexOf("busy") != -1 || se.getMessage().toLowerCase(Locale.ROOT).indexOf("file in use") != -1 || se.getMessage().toLowerCase(Locale.ROOT).indexOf("is being used") != -1 || se.getMessage().indexOf("0xC0000054") != -1) {
                                                Logging.connectors.warn((Object)("JCIFS: 'Busy' response when processing document/directory for " + documentIdentifier + ": retrying..."), (Throwable)se);
                                                errorCode = ((Object)((Object)se)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                                errorDesc = "Busy: " + se.getMessage();
                                                throw new ServiceInterruption("Timeout or other service interruption: " + se.getMessage(), (Throwable)se, currentTime + 300000L, currentTime + 10800000L, -1, false);
                                            }
                                            if (se.getMessage().indexOf("handle is invalid") != -1) {
                                                Logging.connectors.warn((Object)("JCIFS: 'Handle is invalid' response when processing document/directory for " + documentIdentifier + ": retrying..."), (Throwable)se);
                                                errorCode = ((Object)((Object)se)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                                errorDesc = "Expiration: " + se.getMessage();
                                                throw new ServiceInterruption("Timeout or other service interruption: " + se.getMessage(), (Throwable)se, currentTime + 300000L, currentTime + 10800000L, -1, false);
                                            }
                                            if (se.getMessage().indexOf("parameter is incorrect") != -1) {
                                                Logging.connectors.warn((Object)("JCIFS: 'Parameter is incorrect' response when processing document/directory for " + documentIdentifier + ": retrying..."), (Throwable)se);
                                                errorCode = ((Object)((Object)se)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                                errorDesc = "Expiration: " + se.getMessage();
                                                throw new ServiceInterruption("Timeout or other service interruption: " + se.getMessage(), (Throwable)se, currentTime + 300000L, currentTime + 10800000L, -1, false);
                                            }
                                            if (se.getMessage().indexOf("no longer available") != -1) {
                                                Logging.connectors.warn((Object)("JCIFS: 'No longer available' response when processing document/directory for " + documentIdentifier + ": retrying..."), (Throwable)se);
                                                errorCode = ((Object)((Object)se)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                                errorDesc = "Expiration: " + se.getMessage();
                                                throw new ServiceInterruption("Timeout or other service interruption: " + se.getMessage(), (Throwable)se, currentTime + 300000L, currentTime + 10800000L, -1, false);
                                            }
                                            if (se.getMessage().indexOf("cannot find") != -1 || se.getMessage().indexOf("cannot be found") != -1) {
                                                if (Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("JCIFS: Skipping document/directory " + documentIdentifier + " because it cannot be found"));
                                                }
                                                errorCode = ((Object)((Object)se)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                                errorDesc = "Not found: " + se.getMessage();
                                                activities.noDocument(documentIdentifier, versionString);
                                                break block90;
                                            }
                                            if (se.getMessage().indexOf("0xC0000205") != -1) {
                                                Logging.connectors.warn((Object)("JCIFS: Out of resources exception reading document/directory " + documentIdentifier + " - skipping"));
                                                errorCode = ((Object)((Object)se)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                                errorDesc = "Resources: " + se.getMessage();
                                                activities.noDocument(documentIdentifier, versionString);
                                                break block90;
                                            } else {
                                                if (se.getMessage().indexOf("is denied") == -1) {
                                                    Logging.connectors.error((Object)("JCIFS: SmbException tossed processing " + documentIdentifier), (Throwable)se);
                                                    errorCode = ((Object)((Object)se)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                                    errorDesc = "Unknown: " + se.getMessage();
                                                    throw new ManifoldCFException("SmbException tossed: " + se.getMessage(), (Throwable)se);
                                                }
                                                Logging.connectors.warn((Object)("JCIFS: Access exception reading document/directory " + documentIdentifier + " - skipping"));
                                                errorCode = ((Object)((Object)se)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                                errorDesc = "Authorization: " + se.getMessage();
                                                activities.noDocument(documentIdentifier, versionString);
                                            }
                                            break block90;
                                        }
                                        catch (IOException e) {
                                            errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                            errorDesc = e.getMessage();
                                            SharedDriveConnector.handleIOException(documentIdentifier, e);
                                            break block90;
                                        }
                                    }
                                    if (!activities.checkMimeTypeIndexable(contentType)) {
                                        Logging.connectors.debug((Object)("JCIFS: Skipping file because output connector cannot accept content type ('" + contentType + "')"));
                                        errorCode = "EXCLUDEDMIMETYPE";
                                        errorDesc = "Rejected due to mime type (" + contentType + ")";
                                        activities.noDocument(documentIdentifier, versionString);
                                        break block90;
                                    }
                                    if (!activities.checkDateIndexable(lastModifiedDate)) {
                                        Logging.connectors.debug((Object)("JCIFS: Skipping file because output connector cannot accept date (" + lastModifiedDate + ")"));
                                        errorCode = "EXCLUDEDDATE";
                                        errorDesc = "Rejected due to date (" + lastModifiedDate + ")";
                                        activities.noDocument(documentIdentifier, versionString);
                                        break block90;
                                    }
                                    RepositoryDocument rd = new RepositoryDocument();
                                    Integer attributes = file.getAttributes();
                                    String shareName = file.getShare();
                                    rd.setFileName(fileNameString);
                                    rd.setOriginalSize(originalLength);
                                    if (contentType != null) {
                                        rd.setMimeType(contentType);
                                    }
                                    rd.addField("lastModified", lastModifiedDate.toString());
                                    rd.addField("fileLastModified", DateParser.formatISO8601Date((Date)lastModifiedDate));
                                    rd.setModifiedDate(lastModifiedDate);
                                    rd.addField("createdOn", creationDate.toString());
                                    rd.addField("fileCreatedOn", DateParser.formatISO8601Date((Date)creationDate));
                                    rd.setCreatedDate(creationDate);
                                    rd.addField("attributes", Integer.toString(attributes));
                                    rd.addField("shareName", shareName);
                                    SharedDriveConnector.setDocumentSecurity(rd, shareAllow, shareDeny, parentAllow, parentDeny, documentAllow, documentDeny);
                                    SharedDriveConnector.setPathMetadata(rd, pathAttributeName, pathAttributeValue);
                                    String newPath = fileName;
                                    if (this.checkNeedFileData(newPath, spec)) {
                                        if (Logging.connectors.isDebugEnabled()) {
                                            Logging.connectors.debug((Object)("JCIFS: Local file data needed for '" + documentIdentifier + "'"));
                                        }
                                        File tempFile = File.createTempFile("_sdc_", null);
                                        try {
                                            InputStream inputStream;
                                            try (FileOutputStream os = new FileOutputStream(tempFile);){
                                                inputStream = SharedDriveConnector.getFileInputStream(file);
                                                try {
                                                    int amt;
                                                    if (transferBuffer == null) {
                                                        transferBuffer = new byte[65536];
                                                    }
                                                    while ((amt = inputStream.read(transferBuffer, 0, transferBuffer.length)) != -1) {
                                                        os.write(transferBuffer, 0, amt);
                                                    }
                                                }
                                                finally {
                                                    inputStream.close();
                                                }
                                            }
                                            if (this.checkIngest(tempFile, newPath, spec, (IFingerprintActivity)activities)) {
                                                if (!activities.checkLengthIndexable(fileLength)) {
                                                    Logging.connectors.debug((Object)("JCIFS: Skipping file because output connector cannot accept length (" + fileLength + ")"));
                                                    errorCode = "EXCLUDEDLENGTH";
                                                    errorDesc = "Rejected due to length (" + fileLength + ")";
                                                    activities.noDocument(documentIdentifier, versionString);
                                                    if (errorCode == null) break block90;
                                                    break block94;
                                                }
                                                if (Logging.connectors.isDebugEnabled()) {
                                                    Logging.connectors.debug((Object)("JCIFS: Decided to ingest '" + documentIdentifier + "'"));
                                                }
                                                inputStream = new FileInputStream(tempFile);
                                                try {
                                                    rd.setBinary(inputStream, fileLength);
                                                    activities.ingestDocumentWithException(documentIdentifier, versionString, uri, rd);
                                                    errorCode = "OK";
                                                    fileLengthLong = new Long(fileLength);
                                                    break block90;
                                                }
                                                finally {
                                                    inputStream.close();
                                                }
                                            }
                                            if (Logging.connectors.isDebugEnabled()) {
                                                Logging.connectors.debug((Object)("JCIFS: Decided to remove '" + documentIdentifier + "'"));
                                            }
                                            activities.noDocument(documentIdentifier, versionString);
                                            errorCode = "NOWORKNEEDED";
                                            errorDesc = "No indexing needed for document at this time";
                                            break block90;
                                        }
                                        finally {
                                            tempFile.delete();
                                        }
                                    }
                                    if (Logging.connectors.isDebugEnabled()) {
                                        Logging.connectors.debug((Object)("JCIFS: Local file data not needed for '" + documentIdentifier + "'"));
                                    }
                                    if (!activities.checkLengthIndexable(fileLength)) {
                                        Logging.connectors.debug((Object)("JCIFS: Skipping file because output connector cannot accept length (" + fileLength + ")"));
                                        errorCode = "EXCLUDEDLENGTH";
                                        errorDesc = "Rejected because of length (" + fileLength + ")";
                                        activities.noDocument(documentIdentifier, versionString);
                                        if (errorCode == null) break block90;
                                        break block95;
                                    }
                                    try (InputStream inputStream = SharedDriveConnector.getFileInputStream(file);){
                                        rd.setBinary(inputStream, fileLength);
                                        activities.ingestDocumentWithException(documentIdentifier, versionString, uri, rd);
                                        errorCode = "OK";
                                        fileLengthLong = new Long(fileLength);
                                        break block90;
                                    }
                                }
                                Logging.connectors.debug((Object)"JCIFS: Skipping file because canonical path is null, or because file is hidden");
                                errorCode = "NULLORHIDDEN";
                                errorDesc = "Null canonical path or hidden file";
                                activities.noDocument(documentIdentifier, versionString);
                                break block90;
                            }
                            catch (ManifoldCFException e) {
                                if (e.getErrorCode() == 2) {
                                    errorCode = null;
                                }
                                throw e;
                            }
                        }
                        activities.recordActivity(new Long(startFetchTime), "access", fileLengthLong, documentIdentifier, errorCode, errorDesc, null);
                        break block90;
                    }
                    activities.recordActivity(new Long(startFetchTime), "access", fileLengthLong, documentIdentifier, errorCode, errorDesc, null);
                    break block90;
                    finally {
                        if (errorCode != null) {
                            activities.recordActivity(new Long(startFetchTime), "access", fileLengthLong, documentIdentifier, errorCode, errorDesc, null);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    protected static void handleIOException(String documentIdentifier, IOException e) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof SocketTimeoutException) {
            long currentTime = System.currentTimeMillis();
            Logging.connectors.warn((Object)("JCIFS: Socket timeout processing " + documentIdentifier + ": " + e.getMessage()), (Throwable)e);
            throw new ServiceInterruption("Timeout or other service interruption: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        long currentTime = System.currentTimeMillis();
        Logging.connectors.warn((Object)("JCIFS: IO error processing " + documentIdentifier + ": " + e.getMessage()), (Throwable)e);
        throw new ServiceInterruption("Timeout or other service interruption: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    protected static String mapExtensionToMimeType(String fileName) {
        int dotIndex;
        int slashIndex = fileName.lastIndexOf("/");
        if (slashIndex != -1) {
            fileName = fileName.substring(slashIndex + 1);
        }
        if ((dotIndex = fileName.lastIndexOf(".")) == -1) {
            return null;
        }
        return ExtensionMimeMap.mapToMimeType((String)fileName.substring(dotIndex + 1).toLowerCase(Locale.ROOT));
    }

    protected static void addSecuritySet(StringBuilder description, boolean enabled, String[] allowTokens, String[] denyTokens) {
        if (enabled) {
            description.append("+");
            Arrays.sort(allowTokens);
            Arrays.sort(denyTokens);
            SharedDriveConnector.packList((StringBuilder)description, (String[])allowTokens, (char)'+');
            SharedDriveConnector.packList((StringBuilder)description, (String[])denyTokens, (char)'+');
        } else {
            description.append("-");
        }
    }

    protected boolean getFileSecuritySet(List<String> allowList, List<String> denyList, SmbFile file, String[] forced) throws ManifoldCFException, IOException {
        if (forced != null) {
            if (forced.length == 0) {
                this.convertACEs(allowList, denyList, SharedDriveConnector.getFileSecurity(file, this.useSIDs));
            } else {
                for (String forcedToken : forced) {
                    allowList.add(forcedToken);
                }
                denyList.add(defaultAuthorityDenyToken);
            }
            return true;
        }
        return false;
    }

    protected boolean getFileShareSecuritySet(List<String> allowList, List<String> denyList, SmbFile file, String[] forced) throws ManifoldCFException, IOException {
        if (forced != null) {
            if (forced.length == 0) {
                this.convertACEs(allowList, denyList, SharedDriveConnector.getFileShareSecurity(file, this.useSIDs));
            } else {
                for (String forcedToken : forced) {
                    allowList.add(forcedToken);
                }
                denyList.add(defaultAuthorityDenyToken);
            }
            return true;
        }
        return false;
    }

    protected void convertACEs(List<String> allowList, List<String> denyList, ACE[] aces) {
        if (aces == null) {
            allowList.add("S-1-1-0");
            denyList.add(defaultAuthorityDenyToken);
        } else {
            denyList.add(defaultAuthorityDenyToken);
            for (ACE ace : aces) {
                if ((ace.getAccessMask() & 1) == 0) continue;
                if (ace.isAllow()) {
                    allowList.add(this.useSIDs ? ace.getSID().toString() : ace.getSID().getAccountName());
                    continue;
                }
                denyList.add(this.useSIDs ? ace.getSID().toString() : ace.getSID().getAccountName());
            }
        }
    }

    protected static void processSMBException(SmbException se, String documentIdentifier, String activity, String operation) throws ManifoldCFException, ServiceInterruption {
        long currentTime = System.currentTimeMillis();
        Throwable cause = se.getRootCause();
        if (cause != null && cause instanceof TransportException) {
            TransportException te = (TransportException)cause;
            if (te.getRootCause() != null && te.getRootCause() instanceof InterruptedException) {
                throw new ManifoldCFException(te.getRootCause().getMessage(), te.getRootCause(), 2);
            }
            Logging.connectors.warn((Object)("JCIFS: Timeout " + activity + " for " + documentIdentifier + ": retrying..."), (Throwable)se);
            throw new ServiceInterruption("Timeout or other service interruption: " + cause.getMessage(), cause, currentTime + 300000L, currentTime + 43200000L, -1, false);
        }
        if (se.getMessage().indexOf("busy") != -1) {
            Logging.connectors.warn((Object)("JCIFS: 'Busy' response when " + activity + " for " + documentIdentifier + ": retrying..."), (Throwable)se);
            throw new ServiceInterruption("Timeout or other service interruption: " + se.getMessage(), (Throwable)se, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        if (se.getMessage().indexOf("0xC0000054") != -1) {
            Logging.connectors.warn((Object)("JCIFS: 'Busy' response when " + activity + " for " + documentIdentifier + ": retrying..."), (Throwable)se);
            throw new ServiceInterruption("Timeout or other service interruption: " + se.getMessage(), (Throwable)se, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        if (se.getMessage().indexOf("handle is invalid") != -1) {
            Logging.connectors.warn((Object)("JCIFS: 'Handle is invalid' response when " + activity + " for " + documentIdentifier + ": retrying..."), (Throwable)se);
            throw new ServiceInterruption("Timeout or other service interruption: " + se.getMessage(), (Throwable)se, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        if (se.getMessage().indexOf("parameter is incorrect") != -1) {
            Logging.connectors.warn((Object)("JCIFS: 'Parameter is incorrect' response when " + activity + " for " + documentIdentifier + ": retrying..."), (Throwable)se);
            throw new ServiceInterruption("Timeout or other service interruption: " + se.getMessage(), (Throwable)se, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        if (se.getMessage().indexOf("no longer available") != -1) {
            Logging.connectors.warn((Object)("JCIFS: 'No longer available' response when " + activity + " for " + documentIdentifier + ": retrying..."), (Throwable)se);
            throw new ServiceInterruption("Timeout or other service interruption: " + se.getMessage(), (Throwable)se, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        if (se.getMessage().indexOf("No process is on the other end of the pipe") != -1) {
            Logging.connectors.warn((Object)("JCIFS: 'No process is on the other end of the pipe' response when " + activity + " for " + documentIdentifier + ": retrying..."), (Throwable)se);
            throw new ServiceInterruption("Timeout or other service interruption: " + se.getMessage(), (Throwable)se, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        if (se.getMessage().toLowerCase(Locale.ROOT).indexOf("busy") != -1 || se.getMessage().toLowerCase(Locale.ROOT).indexOf("file in use") != -1 || se.getMessage().toLowerCase(Locale.ROOT).indexOf("is being used") != -1) {
            Logging.connectors.warn((Object)("JCIFS: 'File in Use' response when " + activity + " for " + documentIdentifier + ": retrying..."), (Throwable)se);
            throw new ServiceInterruption("Timeout or other service interruption: " + se.getMessage(), (Throwable)se, currentTime + 300000L, currentTime + 10800000L, -1, true);
        }
        if (se.getMessage().indexOf("cannot find") != -1 || se.getMessage().indexOf("cannot be found") != -1) {
            return;
        }
        if (se.getMessage().indexOf("is denied") != -1) {
            Logging.connectors.warn((Object)("JCIFS: Access exception when " + activity + " for " + documentIdentifier + " - skipping"));
            return;
        }
        if (se.getMessage().indexOf("Incorrect function") != -1) {
            Logging.connectors.error((Object)("JCIFS: Server does not support a required operation (" + operation + "?) for " + documentIdentifier));
            throw new ManifoldCFException("Server does not support a required operation (" + operation + ", possibly?) accessing document " + documentIdentifier, (Throwable)se);
        }
        Logging.connectors.error((Object)("SmbException thrown " + activity + " for " + documentIdentifier), (Throwable)se);
        throw new ManifoldCFException("SmbException thrown: " + se.getMessage(), (Throwable)se);
    }

    protected static void setDocumentSecurity(RepositoryDocument rd, String[] shareAllow, String[] shareDeny, String[] parentAllow, String[] parentDeny, String[] allow, String[] deny) {
        if (shareAllow.length > 0 || shareDeny.length > 0) {
            rd.setSecurity("share", shareAllow, shareDeny);
        }
        if (parentAllow.length > 0 || parentDeny.length > 0) {
            rd.setSecurity("parent", parentAllow, parentDeny);
        }
        if (allow.length > 0 || deny.length > 0) {
            rd.setSecurity("document", allow, deny);
        }
    }

    protected static void setPathMetadata(RepositoryDocument rd, String pathAttributeName, String pathAttributeValue) throws ManifoldCFException {
        if (pathAttributeName != null && pathAttributeValue != null) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("JCIFS: Path attribute name is '" + pathAttributeName + "'"));
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("JCIFS: Path attribute value is '" + pathAttributeValue + "'"));
            }
            rd.addField(pathAttributeName, pathAttributeValue);
        } else {
            Logging.connectors.debug((Object)"JCIFS: Path attribute name is null");
        }
    }

    public String check() throws ManifoldCFException {
        this.getSession();
        String serverURI = this.smbconnectionPath;
        SmbFile server = null;
        try {
            server = new SmbFile(serverURI, SingletonContext.getInstance().withCredentials((Credentials)this.pa));
        }
        catch (MalformedURLException e1) {
            return "Malformed URL: '" + serverURI + "': " + e1.getMessage();
        }
        try {
            int type = SharedDriveConnector.getFileType(server);
            if (type == 4 || type == 8 || type == 1) {
                try {
                    server.connect();
                    if (!server.exists()) {
                        return "Server or path does not exist";
                    }
                }
                catch (SocketTimeoutException e) {
                    return "Timeout connecting to server: " + e.getMessage();
                }
                catch (InterruptedIOException e) {
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (IOException e) {
                    return "Couldn't connect to server: " + e.getMessage();
                }
                return super.check();
            }
            return "URI is not a server URI: '" + serverURI + "'";
        }
        catch (SmbException e) {
            return "Could not connect: " + e.getMessage();
        }
    }

    protected static boolean checkIncludeFile(long fileLength, String fileName, Specification documentSpecification, IFingerprintActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (!activities.checkLengthIndexable(fileLength) || !activities.checkMimeTypeIndexable(SharedDriveConnector.mapExtensionToMimeType(fileName))) {
            return false;
        }
        long maxFileLength = Long.MAX_VALUE;
        for (int i = 0; i < documentSpecification.getChildCount(); ++i) {
            SpecificationNode sn = documentSpecification.getChild(i);
            if (!sn.getType().equals(NODE_MAXLENGTH)) continue;
            try {
                String value = sn.getAttributeValue(ATTRIBUTE_VALUE);
                if (value == null || value.length() <= 0) continue;
                maxFileLength = new Long(value);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
            }
        }
        return fileLength <= maxFileLength;
    }

    protected boolean checkInclude(boolean isDirectory, String fileName, Specification documentSpecification) throws ManifoldCFException {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("JCIFS: In checkInclude for '" + fileName + "'"));
        }
        try {
            String filePart;
            String pathPart;
            if (isDirectory) {
                pathPart = fileName;
                filePart = null;
            } else {
                int lastSlash = fileName.lastIndexOf("/");
                if (lastSlash == -1) {
                    pathPart = "";
                    filePart = fileName;
                } else {
                    pathPart = fileName.substring(0, lastSlash + 1);
                    filePart = fileName.substring(lastSlash + 1);
                }
            }
            int i = 0;
            while (i < documentSpecification.getChildCount()) {
                int matchEnd;
                SpecificationNode sn;
                if (!(sn = documentSpecification.getChild(i++)).getType().equals(NODE_STARTPOINT)) continue;
                String path = this.mapToIdentifier(sn.getAttributeValue(ATTRIBUTE_PATH));
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("JCIFS: Matching startpoint '" + path + "' against actual '" + pathPart + "'"));
                }
                if ((matchEnd = SharedDriveConnector.matchSubPath(path, pathPart)) == -1) {
                    Logging.connectors.debug((Object)"JCIFS: No match");
                    continue;
                }
                Logging.connectors.debug((Object)"JCIFS: Startpoint found!");
                if (matchEnd == fileName.length()) {
                    Logging.connectors.debug((Object)"JCIFS: Startpoint: always included");
                    boolean bl = true;
                    return bl;
                }
                int j = 0;
                while (j < sn.getChildCount()) {
                    boolean bl;
                    String indexable;
                    SpecificationNode node;
                    String flavor;
                    if (!(flavor = (node = sn.getChild(j++)).getType()).equals(NODE_INCLUDE) && !flavor.equals(NODE_EXCLUDE)) continue;
                    String type = node.getAttributeValue(ATTRIBUTE_TYPE);
                    if (type == null) {
                        type = "";
                    }
                    if ((indexable = node.getAttributeValue(ATTRIBUTE_INDEXABLE)) == null) {
                        indexable = "";
                    }
                    String match = node.getAttributeValue(ATTRIBUTE_FILESPEC);
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("JCIFS: Checking '" + match + "' against '" + fileName.substring(matchEnd - 1) + "'"));
                    }
                    boolean isMatch = SharedDriveConnector.checkMatch(fileName, matchEnd - 1, match);
                    boolean isKnown = true;
                    if (isMatch) {
                        Logging.connectors.debug((Object)"JCIFS: Match found.");
                        isMatch = type.length() == 0 || type.equals(VALUE_DIRECTORY) && isDirectory || type.equals(VALUE_FILE) && !isDirectory;
                    } else {
                        Logging.connectors.debug((Object)"JCIFS: No match!");
                    }
                    if (isMatch && indexable.length() != 0) {
                        if (isDirectory) {
                            boolean isIndexable = false;
                            isMatch = indexable.equals("yes") && isIndexable || indexable.equals("no") && !isIndexable;
                        } else {
                            isKnown = false;
                        }
                    }
                    if (isKnown) {
                        if (!isMatch) continue;
                        if (flavor.equals(NODE_INCLUDE)) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    if (!flavor.equals(NODE_INCLUDE)) continue;
                    bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Couldn't map to canonical path: " + e.getMessage(), (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw new ManifoldCFException("Couldn't map to canonical path: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("JCIFS: Leaving checkInclude for '" + fileName + "'"));
            }
        }
    }

    protected boolean wouldFileBeIncluded(String fileName, Specification documentSpecification, boolean pretendIndexable) throws ManifoldCFException {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("JCIFS: In wouldFileBeIncluded for '" + fileName + "', pretendIndexable=" + (pretendIndexable ? "true" : "false")));
        }
        try {
            String filePart;
            String pathPart;
            boolean isDirectory = false;
            int lastSlash = fileName.lastIndexOf("/");
            if (lastSlash == -1) {
                pathPart = "";
                filePart = fileName;
            } else {
                pathPart = fileName.substring(0, lastSlash + 1);
                filePart = fileName.substring(lastSlash + 1);
            }
            int i = 0;
            while (i < documentSpecification.getChildCount()) {
                String path;
                int matchEnd;
                SpecificationNode sn;
                if (!(sn = documentSpecification.getChild(i++)).getType().equals(NODE_STARTPOINT) || (matchEnd = SharedDriveConnector.matchSubPath(path = this.mapToIdentifier(sn.getAttributeValue(ATTRIBUTE_PATH)), pathPart)) == -1) continue;
                int j = 0;
                while (j < sn.getChildCount()) {
                    boolean bl;
                    String match;
                    boolean isMatch;
                    String indexable;
                    SpecificationNode node;
                    String flavor;
                    if (!(flavor = (node = sn.getChild(j++)).getType()).equals(NODE_INCLUDE) && !flavor.equals(NODE_EXCLUDE)) continue;
                    String type = node.getAttributeValue(ATTRIBUTE_TYPE);
                    if (type == null) {
                        type = "";
                    }
                    if ((indexable = node.getAttributeValue(ATTRIBUTE_INDEXABLE)) == null) {
                        indexable = "";
                    }
                    if (isMatch = SharedDriveConnector.checkMatch(fileName, matchEnd - 1, match = node.getAttributeValue(ATTRIBUTE_FILESPEC))) {
                        boolean bl2 = isMatch = type.length() == 0 || type.equals(VALUE_DIRECTORY) && isDirectory || type.equals(VALUE_FILE) && !isDirectory;
                    }
                    if (isMatch && indexable.length() != 0) {
                        boolean isIndexable = isDirectory ? false : pretendIndexable;
                        boolean bl3 = isMatch = indexable.equals("yes") && isIndexable || indexable.equals("no") && !isIndexable;
                    }
                    if (!isMatch) continue;
                    if (flavor.equals(NODE_INCLUDE)) {
                        bl = true;
                        return bl;
                    }
                    bl = false;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Couldn't map to canonical path: " + e.getMessage(), (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw new ManifoldCFException("Couldn't map to canonical path: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("JCIFS: Leaving wouldFileBeIncluded for '" + fileName + "'"));
            }
        }
    }

    protected boolean checkNeedFileData(String fileName, Specification documentSpecification) throws ManifoldCFException {
        return this.wouldFileBeIncluded(fileName, documentSpecification, true) != this.wouldFileBeIncluded(fileName, documentSpecification, false);
    }

    protected boolean checkIngest(File localFile, String fileName, Specification documentSpecification, IFingerprintActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("JCIFS: In checkIngest for '" + fileName + "'"));
        }
        try {
            String filePart;
            String pathPart;
            boolean isDirectory = false;
            int lastSlash = fileName.lastIndexOf("/");
            if (lastSlash == -1) {
                pathPart = "";
                filePart = fileName;
            } else {
                pathPart = fileName.substring(0, lastSlash + 1);
                filePart = fileName.substring(lastSlash + 1);
            }
            int i = 0;
            while (i < documentSpecification.getChildCount()) {
                String path;
                int matchEnd;
                SpecificationNode sn;
                if (!(sn = documentSpecification.getChild(i++)).getType().equals(NODE_STARTPOINT) || (matchEnd = SharedDriveConnector.matchSubPath(path = this.mapToIdentifier(sn.getAttributeValue(ATTRIBUTE_PATH)), pathPart)) == -1) continue;
                int j = 0;
                while (j < sn.getChildCount()) {
                    boolean bl;
                    String match;
                    boolean isMatch;
                    String indexable;
                    SpecificationNode node;
                    String flavor;
                    if (!(flavor = (node = sn.getChild(j++)).getType()).equals(NODE_INCLUDE) && !flavor.equals(NODE_EXCLUDE)) continue;
                    String type = node.getAttributeValue(ATTRIBUTE_TYPE);
                    if (type == null) {
                        type = "";
                    }
                    if ((indexable = node.getAttributeValue(ATTRIBUTE_INDEXABLE)) == null) {
                        indexable = "";
                    }
                    if (isMatch = SharedDriveConnector.checkMatch(fileName, matchEnd - 1, match = node.getAttributeValue(ATTRIBUTE_FILESPEC))) {
                        boolean bl2 = isMatch = type.length() == 0 || type.equals(VALUE_DIRECTORY) && isDirectory || type.equals(VALUE_FILE) && !isDirectory;
                    }
                    if (isMatch && indexable.length() != 0) {
                        boolean isIndexable = isDirectory ? false : activities.checkDocumentIndexable(localFile);
                        boolean bl3 = isMatch = indexable.equals("yes") && isIndexable || indexable.equals("no") && !isIndexable;
                    }
                    if (!isMatch) continue;
                    if (flavor.equals(NODE_INCLUDE)) {
                        bl = true;
                        return bl;
                    }
                    bl = false;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Couldn't map to canonical path: " + e.getMessage(), (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw new ManifoldCFException("Couldn't map to canonical path: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("JCIFS: Leaving checkIngest for '" + fileName + "'"));
            }
        }
    }

    protected static int matchSubPath(String subPath, String fullPath) {
        if (subPath.length() > fullPath.length()) {
            return -1;
        }
        if (!fullPath.startsWith(subPath)) {
            return -1;
        }
        int rval = subPath.length();
        if (fullPath.length() == rval) {
            return rval;
        }
        char x = fullPath.charAt(rval);
        if (x == File.separatorChar) {
            ++rval;
        }
        return rval;
    }

    protected static boolean checkMatch(String sourceMatch, int sourceIndex, String match) {
        boolean caseSensitive = false;
        return SharedDriveConnector.processCheck(caseSensitive, sourceMatch, sourceIndex, match, 0);
    }

    protected static boolean processCheck(boolean caseSensitive, String sourceMatch, int sourceIndex, String match, int matchIndex) {
        while (true) {
            if (sourceMatch.length() == sourceIndex && match.length() == matchIndex) {
                return true;
            }
            if (match.length() == matchIndex) {
                return false;
            }
            if (sourceMatch.length() == sourceIndex) {
                if (match.charAt(matchIndex) != '*') {
                    return false;
                }
                ++matchIndex;
                continue;
            }
            char x = sourceMatch.charAt(sourceIndex);
            char y = match.charAt(matchIndex);
            if (!caseSensitive) {
                if (x >= 'A' && x <= 'Z') {
                    x = (char)(x + 32);
                }
                if (y >= 'A' && y <= 'Z') {
                    y = (char)(y + 32);
                }
            }
            if (y == '*') {
                return SharedDriveConnector.processCheck(caseSensitive, sourceMatch, sourceIndex + 1, match, matchIndex) || SharedDriveConnector.processCheck(caseSensitive, sourceMatch, sourceIndex, match, matchIndex + 1);
            }
            if (y != '?' && x != y) break;
            ++sourceIndex;
            ++matchIndex;
        }
        return false;
    }

    protected static String[] getForcedAcls(Specification spec) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        boolean securityOn = true;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if ((sn = spec.getChild(i++)).getType().equals("access")) {
                String token = sn.getAttributeValue(ATTRIBUTE_TOKEN);
                map.put(token, token);
                continue;
            }
            if (!sn.getType().equals(NODE_SECURITY)) continue;
            String value = sn.getAttributeValue(ATTRIBUTE_VALUE);
            if (value.equals("on")) {
                securityOn = true;
                continue;
            }
            if (!value.equals("off")) continue;
            securityOn = false;
        }
        if (!securityOn) {
            return null;
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.keySet().iterator();
        i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    protected static String[] getForcedShareAcls(Specification spec) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        boolean securityOn = true;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if ((sn = spec.getChild(i++)).getType().equals(NODE_SHAREACCESS)) {
                String token = sn.getAttributeValue(ATTRIBUTE_TOKEN);
                map.put(token, token);
                continue;
            }
            if (!sn.getType().equals(NODE_SHARESECURITY)) continue;
            String value = sn.getAttributeValue(ATTRIBUTE_VALUE);
            if (value.equals("on")) {
                securityOn = true;
                continue;
            }
            if (!value.equals("off")) continue;
            securityOn = false;
        }
        if (!securityOn) {
            return null;
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.keySet().iterator();
        i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    protected static String[] getForcedParentFolderAcls(Specification spec) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        boolean securityOn = false;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if ((sn = spec.getChild(i++)).getType().equals(NODE_PARENTFOLDERACCESS)) {
                String token = sn.getAttributeValue(ATTRIBUTE_TOKEN);
                map.put(token, token);
                continue;
            }
            if (!sn.getType().equals(NODE_PARENTFOLDERSECURITY)) continue;
            String value = sn.getAttributeValue(ATTRIBUTE_VALUE);
            if (value.equals("on")) {
                securityOn = true;
                continue;
            }
            if (!value.equals("off")) continue;
            securityOn = false;
        }
        if (!securityOn) {
            return null;
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.keySet().iterator();
        i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    protected String mapToIdentifier(String path) throws MalformedURLException, UnknownHostException {
        String smburi = this.smbconnectionPath;
        String uri = smburi + path + "/";
        return SharedDriveConnector.getFileCanonicalPath(new SmbFile(uri, SingletonContext.getInstance().withCredentials((Credentials)this.pa)));
    }

    protected static String getFileCanonicalPath(SmbFile file) {
        return file.getCanonicalPath();
    }

    protected static boolean fileExists(SmbFile file) throws SmbException {
        int totalTries = 0;
        int retriesRemaining = 3;
        SmbException currentException = null;
        while (retriesRemaining > 0 && totalTries < 5) {
            --retriesRemaining;
            ++totalTries;
            try {
                return file.exists();
            }
            catch (SmbException e) {
                TransportException te;
                Throwable cause = e.getRootCause();
                if (cause != null && cause instanceof TransportException && (te = (TransportException)cause).getRootCause() != null && te.getRootCause() instanceof InterruptedException) {
                    throw e;
                }
                Logging.connectors.warn((Object)("JCIFS: Possibly transient exception detected on attempt " + Integer.toString(totalTries) + " while checking if file exists: " + e.getMessage()), (Throwable)e);
                if (currentException != null && !SharedDriveConnector.equivalentSmbExceptions(currentException, e)) {
                    retriesRemaining = 3;
                }
                currentException = e;
            }
        }
        throw currentException;
    }

    protected static boolean fileIsDirectory(SmbFile file) throws SmbException {
        int totalTries = 0;
        int retriesRemaining = 3;
        SmbException currentException = null;
        while (retriesRemaining > 0 && totalTries < 5) {
            --retriesRemaining;
            ++totalTries;
            try {
                return file.isDirectory();
            }
            catch (SmbException e) {
                TransportException te;
                Throwable cause = e.getRootCause();
                if (cause != null && cause instanceof TransportException && (te = (TransportException)cause).getRootCause() != null && te.getRootCause() instanceof InterruptedException) {
                    throw e;
                }
                Logging.connectors.warn((Object)("JCIFS: Possibly transient exception detected on attempt " + Integer.toString(totalTries) + " while seeing if file is a directory: " + e.getMessage()), (Throwable)e);
                if (currentException != null && !SharedDriveConnector.equivalentSmbExceptions(currentException, e)) {
                    retriesRemaining = 3;
                }
                currentException = e;
            }
        }
        throw currentException;
    }

    protected static long fileLastModified(SmbFile file) throws SmbException {
        int totalTries = 0;
        int retriesRemaining = 3;
        SmbException currentException = null;
        while (retriesRemaining > 0 && totalTries < 5) {
            --retriesRemaining;
            ++totalTries;
            try {
                return file.lastModified();
            }
            catch (SmbException e) {
                TransportException te;
                Throwable cause = e.getRootCause();
                if (cause != null && cause instanceof TransportException && (te = (TransportException)cause).getRootCause() != null && te.getRootCause() instanceof InterruptedException) {
                    throw e;
                }
                Logging.connectors.warn((Object)("JCIFS: Possibly transient exception detected on attempt " + Integer.toString(totalTries) + " while getting file last-modified date: " + e.getMessage()), (Throwable)e);
                if (currentException != null && !SharedDriveConnector.equivalentSmbExceptions(currentException, e)) {
                    retriesRemaining = 3;
                }
                currentException = e;
            }
        }
        throw currentException;
    }

    protected static long fileLength(SmbFile file) throws SmbException {
        int totalTries = 0;
        int retriesRemaining = 3;
        SmbException currentException = null;
        while (retriesRemaining > 0 && totalTries < 5) {
            --retriesRemaining;
            ++totalTries;
            try {
                return file.length();
            }
            catch (SmbException e) {
                TransportException te;
                Throwable cause = e.getRootCause();
                if (cause != null && cause instanceof TransportException && (te = (TransportException)cause).getRootCause() != null && te.getRootCause() instanceof InterruptedException) {
                    throw e;
                }
                Logging.connectors.warn((Object)("JCIFS: Possibly transient exception detected on attempt " + Integer.toString(totalTries) + " while getting file length: " + e.getMessage()), (Throwable)e);
                if (currentException != null && !SharedDriveConnector.equivalentSmbExceptions(currentException, e)) {
                    retriesRemaining = 3;
                }
                currentException = e;
            }
        }
        throw currentException;
    }

    protected static SmbFile[] fileListFiles(SmbFile file, SmbFileFilter filter) throws SmbException {
        int totalTries = 0;
        int retriesRemaining = 3;
        SmbException currentException = null;
        while (retriesRemaining > 0 && totalTries < 5) {
            --retriesRemaining;
            ++totalTries;
            try {
                return file.listFiles(filter);
            }
            catch (SmbException e) {
                TransportException te;
                Throwable cause = e.getRootCause();
                if (cause != null && cause instanceof TransportException && (te = (TransportException)cause).getRootCause() != null && te.getRootCause() instanceof InterruptedException) {
                    throw e;
                }
                if (e.getMessage().equals("0x8000002D")) {
                    Logging.connectors.warn((Object)("JCIFS: Symlink detected: " + file));
                    return new SmbFile[0];
                }
                Logging.connectors.warn((Object)("JCIFS: Possibly transient exception detected on attempt " + Integer.toString(totalTries) + " while listing files: " + e.getMessage()), (Throwable)e);
                if (currentException != null && !SharedDriveConnector.equivalentSmbExceptions(currentException, e)) {
                    retriesRemaining = 3;
                }
                currentException = e;
            }
        }
        throw currentException;
    }

    protected static InputStream getFileInputStream(SmbFile file) throws IOException {
        int totalTries = 0;
        int retriesRemaining = 3;
        IOException currentException = null;
        while (retriesRemaining > 0 && totalTries < 5) {
            --retriesRemaining;
            ++totalTries;
            try {
                return file.getInputStream();
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (InterruptedIOException e) {
                throw e;
            }
            catch (IOException e) {
                Logging.connectors.warn((Object)("JCIFS: Possibly transient exception detected on attempt " + Integer.toString(totalTries) + " while getting file input stream: " + e.getMessage()), (Throwable)e);
                if (currentException != null && !SharedDriveConnector.equivalentIOExceptions(currentException, e)) {
                    retriesRemaining = 3;
                }
                currentException = e;
            }
        }
        throw currentException;
    }

    protected static ACE[] getFileSecurity(SmbFile file, boolean useSIDs) throws IOException {
        int totalTries = 0;
        int retriesRemaining = 3;
        IOException currentException = null;
        while (retriesRemaining > 0 && totalTries < 5) {
            --retriesRemaining;
            ++totalTries;
            try {
                return file.getSecurity(!useSIDs);
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (InterruptedIOException e) {
                throw e;
            }
            catch (IOException e) {
                Logging.connectors.warn((Object)("JCIFS: Possibly transient exception detected on attempt " + Integer.toString(totalTries) + " while getting file security: " + e.getMessage()), (Throwable)e);
                if (currentException != null && !SharedDriveConnector.equivalentIOExceptions(currentException, e)) {
                    retriesRemaining = 3;
                }
                currentException = e;
            }
        }
        throw currentException;
    }

    protected static ACE[] getFileShareSecurity(SmbFile file, boolean useSIDs) throws IOException {
        int totalTries = 0;
        int retriesRemaining = 3;
        IOException currentException = null;
        while (retriesRemaining > 0 && totalTries < 5) {
            --retriesRemaining;
            ++totalTries;
            try {
                return file.getShareSecurity(!useSIDs);
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (InterruptedIOException e) {
                throw e;
            }
            catch (IOException e) {
                Logging.connectors.warn((Object)("JCIFS: Possibly transient exception detected on attempt " + Integer.toString(totalTries) + " while getting share security: " + e.getMessage()), (Throwable)e);
                if (currentException != null && !SharedDriveConnector.equivalentIOExceptions(currentException, e)) {
                    retriesRemaining = 3;
                }
                currentException = e;
            }
        }
        throw currentException;
    }

    protected static int getFileType(SmbFile file) throws SmbException {
        int totalTries = 0;
        int retriesRemaining = 3;
        SmbException currentException = null;
        while (retriesRemaining > 0 && totalTries < 5) {
            --retriesRemaining;
            ++totalTries;
            try {
                return file.getType();
            }
            catch (SmbException e) {
                TransportException te;
                Throwable cause = e.getRootCause();
                if (cause != null && cause instanceof TransportException && (te = (TransportException)cause).getRootCause() != null && te.getRootCause() instanceof InterruptedException) {
                    throw e;
                }
                Logging.connectors.warn((Object)("JCIFS: Possibly transient exception detected on attempt " + Integer.toString(totalTries) + " while getting file type: " + e.getMessage()), (Throwable)e);
                if (currentException != null && !SharedDriveConnector.equivalentSmbExceptions(currentException, e)) {
                    retriesRemaining = 3;
                }
                currentException = e;
            }
        }
        throw currentException;
    }

    protected static boolean equivalentSmbExceptions(SmbException e1, SmbException e2) {
        String e1m = e1.getMessage();
        String e2m = e2.getMessage();
        if (e1m == null) {
            e1m = "";
        }
        if (e2m == null) {
            e2m = "";
        }
        return e1m.equals(e2m);
    }

    protected static boolean equivalentIOExceptions(IOException e1, IOException e2) {
        String e1m = e1.getMessage();
        String e2m = e2.getMessage();
        if (e1m == null) {
            e1m = "";
        }
        if (e2m == null) {
            e2m = "";
        }
        return e1m.equals(e2m);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "SharedDriveConnector.Server"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfigForSave()\n{\n  if (editconnection.server.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.NeedAServerName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.Server2") + "\");\n    editconnection.server.focus();\n    return false;\n  }\n\n  if (editconnection.server.value.indexOf(\"/\") != -1)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.ServerNameCannotIncludePathInformation") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.Server2") + "\");\n    editconnection.server.focus();\n    return false;\n  }\n\t\t\n  if (editconnection.username.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.NeedAUserName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.Server2") + "\");\n    editconnection.username.focus();\n    return false;\n  }\n\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String binName;
        String password;
        String username;
        String domain;
        String server = parameters.getParameter("Server");
        if (server == null) {
            server = "";
        }
        if ((domain = parameters.getParameter("Domain/Realm")) == null) {
            domain = "";
        }
        if ((username = parameters.getParameter("User Name")) == null) {
            username = "";
        }
        password = (password = parameters.getObfuscatedParameter("Password")) == null ? "" : out.mapPasswordToKey(password);
        String resolvesids = parameters.getParameter("Use SIDs");
        if (resolvesids == null) {
            resolvesids = "true";
        }
        if ((binName = parameters.getParameter("Bin Name")) == null) {
            binName = "";
        }
        if (tabName.equals(Messages.getString(locale, "SharedDriveConnector.Server"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.Server3") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"server\" value=\"" + Encoder.attributeEscape((String)server) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.AuthenticationDomain") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"domain\" value=\"" + Encoder.attributeEscape((String)domain) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.UserName") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"username\" value=\"" + Encoder.attributeEscape((String)username) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.Password") + "</nobr></td>\n    <td class=\"value\"><input type=\"password\" size=\"32\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/></td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.UseSIDSForSecurity") + "</nobr></td>\n    <td class=\"value\"><input type=\"hidden\" name=\"resolvesidspresent\" value=\"true\"/><input type=\"checkbox\" value=\"true\" name=\"resolvesids\" " + ("true".equals(resolvesids) ? "checked=\"true\"" : "") + "/></td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.BinName") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"binname\" value=\"" + Encoder.attributeEscape((String)binName) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"server\" value=\"" + Encoder.attributeEscape((String)server) + "\"/>\n<input type=\"hidden\" name=\"domain\" value=\"" + Encoder.attributeEscape((String)domain) + "\"/>\n<input type=\"hidden\" name=\"username\" value=\"" + Encoder.attributeEscape((String)username) + "\"/>\n<input type=\"hidden\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n<input type=\"hidden\" name=\"resolvesidspresent\" value=\"true\"/>\n<input type=\"hidden\" name=\"resolvesids\" value=\"" + Encoder.attributeEscape((String)resolvesids) + "\"/>\n<input type=\"hidden\" name=\"binname\" value=\"" + Encoder.attributeEscape((String)binName) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String binName;
        String resolvesidspresent;
        String password;
        String username;
        String domain;
        String server = variableContext.getParameter("server");
        if (server != null) {
            parameters.setParameter("Server", server);
        }
        if ((domain = variableContext.getParameter("domain")) != null) {
            parameters.setParameter("Domain/Realm", domain);
        }
        if ((username = variableContext.getParameter("username")) != null) {
            parameters.setParameter("User Name", username);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter("Password", variableContext.mapKeyToPassword(password));
        }
        if ((resolvesidspresent = variableContext.getParameter("resolvesidspresent")) != null) {
            parameters.setParameter("Use SIDs", "false");
            String resolvesids = variableContext.getParameter("resolvesids");
            if (resolvesids != null) {
                parameters.setParameter("Use SIDs", resolvesids);
            }
        }
        if ((binName = variableContext.getParameter("binname")) != null) {
            parameters.setParameter("Bin Name", binName);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.Parameters") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=&lt;" + Integer.toString(kmanager.getContents().length) + Messages.getBodyString(locale, "SharedDriveConnector.certificate") + "&gt;</nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "SharedDriveConnector.Paths"));
        tabsArray.add(Messages.getString(locale, "SharedDriveConnector.Security"));
        tabsArray.add(Messages.getString(locale, "SharedDriveConnector.Metadata"));
        tabsArray.add(Messages.getString(locale, "SharedDriveConnector.ContentLength"));
        tabsArray.add(Messages.getString(locale, "SharedDriveConnector.FileMapping"));
        tabsArray.add(Messages.getString(locale, "SharedDriveConnector.URLMapping"));
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        out.print("<script type=\"text/javascript\">\n//<!--\n\nfunction " + seqPrefix + "checkSpecification()\n{\n  if (editjob." + seqPrefix + "specmaxlength.value != \"\" && !isInteger(editjob." + seqPrefix + "specmaxlength.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.NeedAValidNumberForMaximumDocumentLength") + "\");\n    editjob." + seqPrefix + "specmaxlength.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction " + seqPrefix + "SpecOp(n, opValue, anchorvalue)\n{\n  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n  postFormSetAnchor(anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddToPath(anchorvalue)\n{\n  if (editjob." + seqPrefix + "pathaddon.value == \"\" && editjob." + seqPrefix + "pathtypein.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.SelectAFolderOrTypeInAPathFirst") + "\");\n    editjob." + seqPrefix + "pathaddon.focus();\n    return;\n  }\n  if (editjob." + seqPrefix + "pathaddon.value != \"\" && editjob." + seqPrefix + "pathtypein.value != \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.EitherSelectAFolderORTypeInAPath") + "\");\n    editjob." + seqPrefix + "pathaddon.focus();\n    return;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "pathop\",\"AddToPath\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddSpec(suffix,anchorvalue)\n{\n  if (eval(\"editjob." + seqPrefix + "specfile\"+suffix+\".value\") == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.EnterAFileSpecificationFirst") + "\");\n    eval(\"editjob." + seqPrefix + "specfile\"+suffix+\".focus()\");\n    return;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "pathop\"+suffix,\"Add\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecInsertSpec(postfix,anchorvalue)\n{\n  if (eval(\"editjob." + seqPrefix + "specfile_i\"+postfix+\".value\") == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.EnterAFileSpecificationFirst") + "\");\n    eval(\"editjob." + seqPrefix + "specfile_i\"+postfix+\".focus()\");\n    return;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "specop\"+postfix,\"Insert Here\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddToken(anchorvalue)\n{\n  if (editjob." + seqPrefix + "spectoken.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.NullAccessTokensNotAllowed") + "\");\n    editjob." + seqPrefix + "spectoken.focus();\n    return;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "accessop\",\"Add\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddMapping(anchorvalue)\n{\n  if (editjob." + seqPrefix + "specmatch.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.MatchStringCannotBeEmpty") + "\");\n    editjob." + seqPrefix + "specmatch.focus();\n    return;\n  }\n  if (!isRegularExpression(editjob." + seqPrefix + "specmatch.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.MatchStringMustBeValidRegularExpression") + "\");\n    editjob." + seqPrefix + "specmatch.focus();\n    return;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "specmappingop\",\"Add\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddFMap(anchorvalue)\n{\n  if (editjob." + seqPrefix + "specfmapmatch.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.MatchStringCannotBeEmpty") + "\");\n    editjob." + seqPrefix + "specfmapmatch.focus();\n    return;\n  }\n  if (!isRegularExpression(editjob." + seqPrefix + "specfmapmatch.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.MatchStringMustBeValidRegularExpression") + "\");\n    editjob." + seqPrefix + "specfmapmatch.focus();\n    return;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "specfmapop\",\"Add\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddUMap(anchorvalue)\n{\n  if (editjob." + seqPrefix + "specumapmatch.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.MatchStringCannotBeEmpty") + "\");\n    editjob." + seqPrefix + "specumapmatch.focus();\n    return;\n  }\n  if (!isRegularExpression(editjob." + seqPrefix + "specumapmatch.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SharedDriveConnector.MatchStringMustBeValidRegularExpression") + "\");\n    editjob." + seqPrefix + "specumapmatch.focus();\n    return;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "specumapop\",\"Add\",anchorvalue);\n}\n\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        String replaceString;
        String matchString;
        String replaceString2;
        String matchString2;
        String pathDescription;
        int k;
        SpecificationNode sn;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        int i = 0;
        String maxLength = null;
        while (i < ds.getChildCount()) {
            if (!(sn = ds.getChild(i++)).getType().equals(NODE_MAXLENGTH)) continue;
            maxLength = sn.getAttributeValue(ATTRIBUTE_VALUE);
        }
        if (maxLength == null) {
            maxLength = "";
        }
        if (tabName.equals(Messages.getString(locale, "SharedDriveConnector.ContentLength")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.MaximumDocumentLength") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" name=\"" + seqPrefix + "specmaxlength\" size=\"10\" value=\"" + maxLength + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmaxlength\" value=\"" + maxLength + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "SharedDriveConnector.Paths")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                int j;
                if (!(sn = ds.getChild(i++)).getType().equals(NODE_STARTPOINT)) continue;
                pathDescription = "_" + Integer.toString(k);
                String pathOpName = seqPrefix + "pathop" + pathDescription;
                String startPath = sn.getAttributeValue(ATTRIBUTE_PATH);
                out.print("  <tr>\n    <td class=\"value\">\n      <a name=\"" + seqPrefix + "path_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"Delete\" alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.DeletePath") + Integer.toString(k) + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + pathOpName + "\",\"Delete\",\"" + seqPrefix + "path_" + Integer.toString(k) + "\")'/>\n      </a>&nbsp;\n    </td>\n    <td class=\"value\">\n      <table class=\"displaytable\">\n        <tr>\n          <td class=\"value\">\n            <input type=\"hidden\" name=\"" + seqPrefix + "specpath" + pathDescription + "\" value=\"" + Encoder.attributeEscape((String)sn.getAttributeValue(ATTRIBUTE_PATH)) + "\"/>\n            <input type=\"hidden\" name=\"" + pathOpName + "\" value=\"\"/>\n            <nobr>" + (startPath.length() == 0 ? "(root)" : Encoder.bodyEscape((String)startPath)) + "</nobr>\n          </td>\n        </tr>\n        <tr>\n          <td class=\"boxcell\">\n            <table class=\"displaytable\">\n");
                for (j = 0; j < sn.getChildCount(); ++j) {
                    SpecificationNode excludeNode = sn.getChild(j);
                    String instanceDescription = "_" + Integer.toString(k) + "_" + Integer.toString(j);
                    String instanceOpName = seqPrefix + "specop" + instanceDescription;
                    String nodeFlavor = excludeNode.getType();
                    String nodeType = excludeNode.getAttributeValue(ATTRIBUTE_TYPE);
                    if (nodeType == null) {
                        nodeType = "";
                    }
                    String filespec = excludeNode.getAttributeValue(ATTRIBUTE_FILESPEC);
                    String indexable = excludeNode.getAttributeValue(ATTRIBUTE_INDEXABLE);
                    if (indexable == null) {
                        indexable = "";
                    }
                    out.print("              <tr>\n                <td class=\"value\">\n                    <input type=\"button\" value=\"Insert\" onClick='Javascript:" + seqPrefix + "SpecInsertSpec(\"" + instanceDescription + "\",\"" + seqPrefix + "filespec_" + Integer.toString(k) + "_" + Integer.toString(j + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.InsertNewMatchForPath") + Integer.toString(k) + " before position #" + Integer.toString(j) + "\"/>\n                </td>\n                <td class=\"value\">\n                  <nobr>\n                    <select name=\"" + seqPrefix + "specfl_i" + instanceDescription + "\">\n                      <option value=\"include\">" + Messages.getBodyString(locale, "SharedDriveConnector.Include") + "</option>\n                      <option value=\"exclude\">" + Messages.getBodyString(locale, "SharedDriveConnector.Exclude") + "</option>\n                    </select>&nbsp;\n                    <select name=\"" + seqPrefix + "spectin_i" + instanceDescription + "\">\n                      <option value=\"\" selected=\"selected\">" + Messages.getBodyString(locale, "SharedDriveConnector.AnyFileOrDirectory") + "</option>\n                      <option value=\"file\">" + Messages.getBodyString(locale, "SharedDriveConnector.files") + "</option>\n                      <option value=\"indexable-file\">" + Messages.getBodyString(locale, "SharedDriveConnector.indexableFiles") + "</option>\n                      <option value=\"unindexable-file\">" + Messages.getBodyString(locale, "SharedDriveConnector.unindexableFiles") + "</option>\n                      <option value=\"directory\">" + Messages.getBodyString(locale, "SharedDriveConnector.directorys") + "</option>\n                    </select>&nbsp;" + Messages.getBodyString(locale, "SharedDriveConnector.matching") + "&nbsp;\n                    <input type=\"text\" size=\"20\" name=\"" + seqPrefix + "specfile_i" + instanceDescription + "\" value=\"\"/>\n                  </nobr>\n                </td>\n\n              </tr>\n              <tr>\n                <td class=\"value\">\n                  <a name=\"" + seqPrefix + "filespec_" + Integer.toString(k) + "_" + Integer.toString(j) + "\">\n                    <input type=\"button\" value=\"Delete\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + instanceOpName + "\",\"Delete\",\"" + seqPrefix + "filespec_" + Integer.toString(k) + "_" + Integer.toString(j) + "\")' alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.DeletePath") + Integer.toString(k) + Messages.getAttributeString(locale, "SharedDriveConnector.matchSpec") + Integer.toString(j) + "\"/>\n                  </a>\n                </td>\n                <td class=\"value\">\n                  <nobr>\n                    <input type=\"hidden\" name=\"" + instanceOpName + "\" value=\"\"/>\n                    <input type=\"hidden\" name=\"" + seqPrefix + "specfl" + instanceDescription + "\" value=\"" + nodeFlavor + "\"/>\n                    <input type=\"hidden\" name=\"" + seqPrefix + "specty" + instanceDescription + "\" value=\"" + nodeType + "\"/>\n                    <input type=\"hidden\" name=\"" + seqPrefix + "specin" + instanceDescription + "\" value=\"" + indexable + "\"/>\n                    <input type=\"hidden\" name=\"" + seqPrefix + "specfile" + instanceDescription + "\" value=\"" + Encoder.attributeEscape((String)filespec) + "\"/>\n                    " + Integer.toString(j + 1) + ".&nbsp;" + (nodeFlavor.equals(NODE_INCLUDE) ? "Include" : "") + "" + (nodeFlavor.equals(NODE_EXCLUDE) ? "Exclude" : "") + "" + (indexable.equals("yes") ? "&nbsp;indexable" : "") + "" + (indexable.equals("no") ? "&nbsp;un-indexable" : "") + "" + (nodeType.equals(VALUE_FILE) ? "&nbsp;file(s)" : "") + "" + (nodeType.equals(VALUE_DIRECTORY) ? "&nbsp;directory(s)" : "") + "" + (nodeType.equals("") ? "&nbsp;file(s)&nbsp;or&nbsp;directory(s)" : "") + "&nbsp;matching&nbsp;" + Encoder.bodyEscape((String)filespec) + "\n                  </nobr>\n                </td>\n              </tr>\n");
                }
                if (j == 0) {
                    out.print("              <tr><td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "SharedDriveConnector.NoRulesDefined") + "</td></tr>\n");
                }
                out.print("              <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n              <tr>\n                <td class=\"value\">\n                  <input type=\"hidden\" name=\"" + seqPrefix + "specchildcount" + pathDescription + "\" value=\"" + Integer.toString(j) + "\"/>\n                  <a name=\"" + seqPrefix + "filespec_" + Integer.toString(k) + "_" + Integer.toString(j) + "\">\n                    <input type=\"button\" value=\"Add\" onClick='Javascript:" + seqPrefix + "SpecAddSpec(\"" + pathDescription + "\",\"" + seqPrefix + "filespec_" + Integer.toString(k) + "_" + Integer.toString(j + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.AddNewMatchForPath") + Integer.toString(k) + "\"/>\n                  </a>\n                </td>\n                <td class=\"value\">\n                  <nobr>\n                    <select name=\"" + seqPrefix + "specfl" + pathDescription + "\">\n                      <option value=\"include\">" + Messages.getBodyString(locale, "SharedDriveConnector.Include") + "</option>\n                      <option value=\"exclude\">" + Messages.getBodyString(locale, "SharedDriveConnector.Exclude") + "</option>\n                    </select>&nbsp;\n                    <select name=\"" + seqPrefix + "spectin" + pathDescription + "\">\n                      <option value=\"\">" + Messages.getBodyString(locale, "SharedDriveConnector.AnyFileOrDirectory") + "</option>\n                      <option value=\"file\">" + Messages.getBodyString(locale, "SharedDriveConnector.files") + "</option>\n                      <option value=\"indexable-file\">" + Messages.getBodyString(locale, "SharedDriveConnector.indexableFiles") + "</option>\n                      <option value=\"unindexable-file\">" + Messages.getBodyString(locale, "SharedDriveConnector.unindexableFiles") + "</option>\n                      <option value=\"directory\">" + Messages.getBodyString(locale, "SharedDriveConnector.directorys") + "</option>\n                    </select>&nbsp;" + Messages.getBodyString(locale, "SharedDriveConnector.matching") + "&nbsp;\n                    <input type=\"text\" size=\"20\" name=\"" + seqPrefix + "specfile" + pathDescription + "\" value=\"\"/>\n                  </nobr>\n                </td>\n              </tr>\n            </table>\n          </td>\n        </tr>\n      </table>\n    </td>\n  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "SharedDriveConnector.NoStartingPointsDefined") + "</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"value\" colspan=\"2\">\n      <nobr>\n        <input type=\"hidden\" name=\"" + seqPrefix + "pathcount\" value=\"" + Integer.toString(k) + "\"/>\n        <a name=\"" + seqPrefix + "path_" + Integer.toString(k) + "\">\n");
            String pathSoFar = (String)this.currentContext.get((Object)(seqPrefix + "specpath"));
            if (pathSoFar == null) {
                pathSoFar = "";
            }
            try {
                String[] childList = this.getChildFolderNames(pathSoFar);
                if (childList == null) {
                    pathSoFar = "";
                    childList = this.getChildFolderNames("");
                    if (childList == null) {
                        throw new ManifoldCFException("Can't find any children for root folder");
                    }
                }
                out.print("          <input type=\"hidden\" name=\"" + seqPrefix + "specpath\" value=\"" + Encoder.attributeEscape((String)pathSoFar) + "\"/>\n          <input type=\"hidden\" name=\"" + seqPrefix + "pathop\" value=\"\"/>\n          <input type=\"button\" value=\"Add\" alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.AddPath") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + seqPrefix + "pathop\",\"Add\",\"" + seqPrefix + "path_" + Integer.toString(k + 1) + "\")'/>\n          &nbsp;" + (pathSoFar.length() == 0 ? "(root)" : Encoder.bodyEscape((String)pathSoFar)) + "\n");
                if (pathSoFar.length() > 0) {
                    out.print("          <input type=\"button\" value=\"-\" alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.RemoveFromPath") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + seqPrefix + "pathop\",\"Up\",\"" + seqPrefix + "path_" + Integer.toString(k) + "\")'/>\n");
                }
                if (childList.length > 0) {
                    out.print("          <nobr>\n            <input type=\"button\" value=\"+\" alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.AddPath") + "\" onClick='Javascript:" + seqPrefix + "SpecAddToPath(\"" + seqPrefix + "path_" + Integer.toString(k) + "\")'/>&nbsp;\n            <select name=\"" + seqPrefix + "pathaddon\">\n              <option value=\"\" selected=\"selected\">" + Messages.getBodyString(locale, "SharedDriveConnector.PickAFolder") + "</option>\n");
                    for (int j = 0; j < childList.length; ++j) {
                        String folder = Encoder.attributeEscape((String)childList[j]);
                        out.print("              <option value=\"" + folder + "\">" + folder + "</option>\n");
                    }
                    out.print("            </select>" + Messages.getBodyString(locale, "SharedDriveConnector.orTypeAPath") + "            <input type=\"text\" name=\"" + seqPrefix + "pathtypein\" size=\"16\" value=\"\"/>\n          </nobr>\n");
                }
            }
            catch (ManifoldCFException e) {
                e.printStackTrace();
                out.println(Encoder.bodyEscape((String)e.getMessage()));
            }
            out.print("        </a>\n      </nobr>\n    </td>\n  </tr>\n</table>\n");
        } else {
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                int j;
                if (!(sn = ds.getChild(i++)).getType().equals(NODE_STARTPOINT)) continue;
                pathDescription = "_" + Integer.toString(k);
                String startPath = sn.getAttributeValue(ATTRIBUTE_PATH);
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specpath" + pathDescription + "\" value=\"" + Encoder.attributeEscape((String)startPath) + "\"/>\n");
                for (j = 0; j < sn.getChildCount(); ++j) {
                    SpecificationNode excludeNode = sn.getChild(j);
                    String instanceDescription = "_" + Integer.toString(k) + "_" + Integer.toString(j);
                    String nodeFlavor = excludeNode.getType();
                    String nodeType = excludeNode.getAttributeValue(ATTRIBUTE_TYPE);
                    if (nodeType == null) {
                        nodeType = "";
                    }
                    String filespec = excludeNode.getAttributeValue(ATTRIBUTE_FILESPEC);
                    String indexable = excludeNode.getAttributeValue(ATTRIBUTE_INDEXABLE);
                    if (indexable == null) {
                        indexable = "";
                    }
                    out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specfl" + instanceDescription + "\" value=\"" + nodeFlavor + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specty" + instanceDescription + "\" value=\"" + nodeType + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specin" + instanceDescription + "\" value=\"" + indexable + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specfile" + instanceDescription + "\" value=\"" + Encoder.attributeEscape((String)filespec) + "\"/>\n");
                }
                ++k;
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specchildcount" + pathDescription + "\" value=\"" + Integer.toString(j) + "\"/>\n");
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "pathcount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
        i = 0;
        boolean securityOn = true;
        boolean shareSecurityOn = true;
        boolean parentFolderSecurityOn = false;
        while (i < ds.getChildCount()) {
            String securityValue;
            SpecificationNode sn2;
            if ((sn2 = ds.getChild(i++)).getType().equals(NODE_SECURITY)) {
                securityValue = sn2.getAttributeValue(ATTRIBUTE_VALUE);
                if (securityValue.equals("off")) {
                    securityOn = false;
                } else if (securityValue.equals("on")) {
                    securityOn = true;
                }
            }
            if (sn2.getType().equals(NODE_SHARESECURITY)) {
                securityValue = sn2.getAttributeValue(ATTRIBUTE_VALUE);
                if (securityValue.equals("off")) {
                    shareSecurityOn = false;
                } else if (securityValue.equals("on")) {
                    shareSecurityOn = true;
                }
            }
            if (!sn2.getType().equals(NODE_PARENTFOLDERSECURITY)) continue;
            securityValue = sn2.getAttributeValue(ATTRIBUTE_VALUE);
            if (securityValue.equals("off")) {
                parentFolderSecurityOn = false;
                continue;
            }
            if (!securityValue.equals("on")) continue;
            parentFolderSecurityOn = true;
        }
        if (tabName.equals(Messages.getString(locale, "SharedDriveConnector.Security")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.FileSecurity") + "</nobr></td>\n    <td colspan=\"3\" class=\"value\">\n      <nobr>\n        <input type=\"radio\" name=\"" + seqPrefix + "specsecurity\" value=\"on\" " + (securityOn ? "checked=\"true\"" : "") + " />" + Messages.getBodyString(locale, "SharedDriveConnector.Enabled") + "&nbsp;\n        <input type=\"radio\" name=\"" + seqPrefix + "specsecurity\" value=\"off\" " + (!securityOn ? "checked=\"true\"" : "") + " />" + Messages.getBodyString(locale, "SharedDriveConnector.Disabled") + "\n      </nobr>\n    </td>\n  </tr>\n\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn3;
                if (!(sn3 = ds.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                String token = sn3.getAttributeValue(ATTRIBUTE_TOKEN);
                out.print("  <tr>\n    <td class=\"description\" colspan=\"1\">\n      <input type=\"hidden\" name=\"" + accessOpName + "\" value=\"\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"Delete\" alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.DeleteToken") + Integer.toString(k) + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + accessOpName + "\",\"Delete\",\"" + seqPrefix + "token_" + Integer.toString(k) + "\")'/>\n      </a>\n    </td>\n    <td class=\"value\" colspan=\"3\">\n      <nobr>" + Encoder.bodyEscape((String)token) + "</nobr>\n    </td>\n  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"4\">" + Messages.getBodyString(locale, "SharedDriveConnector.NoFileAccessTokensPresent") + "</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\" colspan=\"1\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "accessop\" value=\"\"/>\n      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"Add\" alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.AddToken") + "\" onClick='Javascript:" + seqPrefix + "SpecAddToken(\"" + seqPrefix + "token_" + Integer.toString(k + 1) + "\")'/>\n      </a>\n    </td>\n    <td class=\"value\" colspan=\"3\">\n      <nobr><input type=\"text\" size=\"30\" name=\"" + seqPrefix + "spectoken\" value=\"\"/></nobr>\n    </td>\n  </tr>\n\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.ShareSecurity") + "</nobr></td>\n    <td colspan=\"3\" class=\"value\">\n      <nobr>\n        <input type=\"radio\" name=\"" + seqPrefix + "specsharesecurity\" value=\"on\" " + (shareSecurityOn ? "checked=\"true\"" : "") + " />" + Messages.getBodyString(locale, "SharedDriveConnector.Enabled") + "&nbsp;\n        <input type=\"radio\" name=\"" + seqPrefix + "specsharesecurity\" value=\"off\" " + (!shareSecurityOn ? "checked=\"true\"" : "") + " />" + Messages.getBodyString(locale, "SharedDriveConnector.Disabled") + "\n      </nobr>\n    </td>\n  </tr>\n\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.ParentFolderSecurity") + "</nobr></td>\n    <td colspan=\"3\" class=\"value\">\n      <nobr>\n        <input type=\"radio\" name=\"" + seqPrefix + "specparentfoldersecurity\" value=\"on\" " + (parentFolderSecurityOn ? "checked=\"true\"" : "") + " />" + Messages.getBodyString(locale, "SharedDriveConnector.Enabled") + "&nbsp;\n        <input type=\"radio\" name=\"" + seqPrefix + "specparentfoldersecurity\" value=\"off\" " + (!parentFolderSecurityOn ? "checked=\"true\"" : "") + " />" + Messages.getBodyString(locale, "SharedDriveConnector.Disabled") + "\n      </nobr>\n    </td>\n  </tr>\n\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specsecurity\" value=\"" + (securityOn ? "on" : "off") + "\"/>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn4;
                if (!(sn4 = ds.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String token = sn4.getAttributeValue(ATTRIBUTE_TOKEN);
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specsharesecurity\" value=\"" + (shareSecurityOn ? "on" : "off") + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specparentfoldersecurity\" value=\"" + (parentFolderSecurityOn ? "on" : "off") + "\"/>\n");
        }
        i = 0;
        String pathNameAttribute = "";
        MatchMap matchMap = new MatchMap();
        while (i < ds.getChildCount()) {
            SpecificationNode sn5;
            if ((sn5 = ds.getChild(i++)).getType().equals(NODE_PATHNAMEATTRIBUTE)) {
                pathNameAttribute = sn5.getAttributeValue(ATTRIBUTE_VALUE);
                continue;
            }
            if (!sn5.getType().equals(NODE_PATHMAP)) continue;
            String pathMatch = sn5.getAttributeValue(ATTRIBUTE_MATCH);
            String pathReplace = sn5.getAttributeValue(ATTRIBUTE_REPLACE);
            matchMap.appendMatchPair(pathMatch, pathReplace);
        }
        if (tabName.equals(Messages.getString(locale, "SharedDriveConnector.Metadata")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmappingcount\" value=\"" + Integer.toString(matchMap.getMatchCount()) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specmappingop\" value=\"\"/>\n<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.PathAttributeName") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n      <input type=\"text\" name=\"" + seqPrefix + "specpathnameattribute\" size=\"20\" value=\"" + Encoder.attributeEscape((String)pathNameAttribute) + "\"/>\n    </td>\n  </tr>\n\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n\n");
            for (i = 0; i < matchMap.getMatchCount(); ++i) {
                matchString2 = matchMap.getMatchString(i);
                replaceString2 = matchMap.getReplaceString(i);
                out.print("  <tr>\n    <td class=\"value\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "specmappingop_" + Integer.toString(i) + "\" value=\"\"/>\n      <a name=\"" + seqPrefix + "mapping_" + Integer.toString(i) + "\">\n        <input type=\"button\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + seqPrefix + "specmappingop_" + Integer.toString(i) + "\",\"Delete\",\"" + seqPrefix + "mapping_" + Integer.toString(i) + "\")' alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.DeleteMapping") + Integer.toString(i) + "\" value=\"Delete\"/>\n      </a>\n    </td>\n    <td class=\"value\"><input type=\"hidden\" name=\"" + seqPrefix + "specmatch_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)matchString2) + "\"/>" + Encoder.bodyEscape((String)matchString2) + "</td>\n    <td class=\"value\">==></td>\n    <td class=\"value\"><input type=\"hidden\" name=\"" + seqPrefix + "specreplace_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)replaceString2) + "\"/>" + Encoder.bodyEscape((String)replaceString2) + "</td>\n  </tr>\n");
            }
            if (i == 0) {
                out.print("  <tr><td colspan=\"4\" class=\"message\">" + Messages.getBodyString(locale, "SharedDriveConnector.NoMappingsSpecified") + "</td></tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n\n  <tr>\n    <td class=\"value\">\n      <a name=\"" + seqPrefix + "mapping_" + Integer.toString(i) + "\">\n        <input type=\"button\" onClick='Javascript:" + seqPrefix + "SpecAddMapping(\"" + seqPrefix + "mapping_" + Integer.toString(i + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.AddToMappings") + "\" value=\"Add\"/>\n      </a>\n    </td>\n    <td class=\"value\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.MatchRegexp") + "<input type=\"text\" name=\"" + seqPrefix + "specmatch\" size=\"32\" value=\"\"/></nobr></td>\n    <td class=\"value\">==></td>\n    <td class=\"value\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.ReplaceString") + "<input type=\"text\" name=\"" + seqPrefix + "specreplace\" size=\"32\" value=\"\"/></nobr></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specpathnameattribute\" value=\"" + Encoder.attributeEscape((String)pathNameAttribute) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specmappingcount\" value=\"" + Integer.toString(matchMap.getMatchCount()) + "\"/>\n");
            for (i = 0; i < matchMap.getMatchCount(); ++i) {
                matchString2 = matchMap.getMatchString(i);
                replaceString2 = matchMap.getReplaceString(i);
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmatch_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)matchString2) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specreplace_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)replaceString2) + "\"/>\n");
            }
        }
        MatchMap fileMap = new MatchMap();
        MatchMap uriMap = new MatchMap();
        i = 0;
        while (i < ds.getChildCount()) {
            String pathReplace;
            String pathMatch;
            SpecificationNode sn6;
            if ((sn6 = ds.getChild(i++)).getType().equals(NODE_FILEMAP)) {
                pathMatch = sn6.getAttributeValue(ATTRIBUTE_MATCH);
                pathReplace = sn6.getAttributeValue(ATTRIBUTE_REPLACE);
                fileMap.appendMatchPair(pathMatch, pathReplace);
                continue;
            }
            if (!sn6.getType().equals(NODE_URIMAP)) continue;
            pathMatch = sn6.getAttributeValue(ATTRIBUTE_MATCH);
            pathReplace = sn6.getAttributeValue(ATTRIBUTE_REPLACE);
            uriMap.appendMatchPair(pathMatch, pathReplace);
        }
        if (tabName.equals(Messages.getString(locale, "SharedDriveConnector.FileMapping")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specfmapcount\" value=\"" + Integer.toString(fileMap.getMatchCount()) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specfmapop\" value=\"\"/>\n<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n");
            for (i = 0; i < fileMap.getMatchCount(); ++i) {
                matchString = fileMap.getMatchString(i);
                replaceString = fileMap.getReplaceString(i);
                out.print("  <tr>\n    <td class=\"value\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "specfmapop_" + Integer.toString(i) + "\" value=\"\"/>\n      <a name=\"" + seqPrefix + "fmap_" + Integer.toString(i) + "\">\n        <input type=\"button\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + seqPrefix + "specfmapop_" + Integer.toString(i) + "\",\"Delete\",\"" + seqPrefix + "fmap_" + Integer.toString(i) + "\")' alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.DeleteFileMapping") + Integer.toString(i) + "\" value=\"Delete\"/>\n      </a>\n    </td>\n    <td class=\"value\"><input type=\"hidden\" name=\"" + seqPrefix + "specfmapmatch_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)matchString) + "\"/>" + Encoder.bodyEscape((String)matchString) + "</td>\n    <td class=\"value\">==></td>\n    <td class=\"value\"><input type=\"hidden\" name=\"" + seqPrefix + "specfmapreplace_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)replaceString) + "\"/>" + Encoder.bodyEscape((String)replaceString) + "</td>\n  </tr>\n");
            }
            if (i == 0) {
                out.print("  <tr><td colspan=\"4\" class=\"message\">" + Messages.getBodyString(locale, "SharedDriveConnector.NoFileMappingsSpecified") + "</td></tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n\n  <tr>\n    <td class=\"value\">\n      <a name=\"" + seqPrefix + "fmap_" + Integer.toString(i) + "\">\n        <input type=\"button\" onClick='Javascript:" + seqPrefix + "SpecAddFMap(\"" + seqPrefix + "fmap_" + Integer.toString(i + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.AddToFileMappings") + "\" value=\"Add\"/>\n      </a>\n    </td>\n    <td class=\"value\">" + Messages.getBodyString(locale, "SharedDriveConnector.MatchRegexp") + "<input type=\"text\" name=\"" + seqPrefix + "specfmapmatch\" size=\"32\" value=\"\"/></td>\n    <td class=\"value\">==></td>\n    <td class=\"value\">" + Messages.getBodyString(locale, "SharedDriveConnector.ReplaceString") + "<input type=\"text\" name=\"" + seqPrefix + "specfmapreplace\" size=\"32\" value=\"\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specfmapcount\" value=\"" + Integer.toString(fileMap.getMatchCount()) + "\"/>\n");
            for (i = 0; i < fileMap.getMatchCount(); ++i) {
                matchString = fileMap.getMatchString(i);
                replaceString = fileMap.getReplaceString(i);
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specfmapmatch_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)matchString) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specfmapreplace_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)replaceString) + "\"/>\n");
            }
        }
        if (tabName.equals(Messages.getString(locale, "SharedDriveConnector.URLMapping")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specumapcount\" value=\"" + Integer.toString(uriMap.getMatchCount()) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specumapop\" value=\"\"/>\n<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n");
            for (i = 0; i < uriMap.getMatchCount(); ++i) {
                matchString = uriMap.getMatchString(i);
                replaceString = uriMap.getReplaceString(i);
                out.print("  <tr>\n    <td class=\"value\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "specumapop_" + Integer.toString(i) + "\" value=\"\"/>\n      <a name=\"" + seqPrefix + "umap_" + Integer.toString(i) + "\">\n        <input type=\"button\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + seqPrefix + "specumapop_" + Integer.toString(i) + "\",\"Delete\",\"" + seqPrefix + "umap_" + Integer.toString(i) + "\")' alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.DeleteUrlMapping") + Integer.toString(i) + "\" value=\"Delete\"/>\n      </a>\n    </td>\n    <td class=\"value\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "specumapmatch_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)matchString) + "\"/>\n      " + Encoder.bodyEscape((String)matchString) + "\n    </td>\n    <td class=\"value\">==></td>\n    <td class=\"value\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "specumapreplace_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)replaceString) + "\"/>\n      " + Encoder.bodyEscape((String)replaceString) + "\n    </td>\n  </tr>\n");
            }
            if (i == 0) {
                out.print("  <tr><td colspan=\"4\" class=\"message\">" + Messages.getBodyString(locale, "SharedDriveConnector.NoURLMappingsSpecifiedWillProduceAFileIRI") + "</td></tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n      \n  <tr>\n    <td class=\"value\">\n      <a name=\"" + seqPrefix + "umap_" + Integer.toString(i) + "\">\n        <input type=\"button\" onClick='Javascript:" + seqPrefix + "SpecAddUMap(\"" + seqPrefix + "umap_" + Integer.toString(i + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "SharedDriveConnector.AddToURLMappings") + "\" value=\"Add\"/>\n      </a>\n    </td>\n    <td class=\"value\">" + Messages.getBodyString(locale, "SharedDriveConnector.MatchRegexp") + "<input type=\"text\" name=\"" + seqPrefix + "specumapmatch\" size=\"32\" value=\"\"/></td>\n    <td class=\"value\">==></td>\n    <td class=\"value\">" + Messages.getBodyString(locale, "SharedDriveConnector.ReplaceString") + "<input type=\"text\" name=\"" + seqPrefix + "specumapreplace\" size=\"32\" value=\"\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specumapcount\" value=\"" + Integer.toString(uriMap.getMatchCount()) + "\"/>\n");
            for (i = 0; i < uriMap.getMatchCount(); ++i) {
                matchString = uriMap.getMatchString(i);
                replaceString = uriMap.getReplaceString(i);
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specumapmatch_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)matchString) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specumapreplace_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)replaceString) + "\"/>\n");
            }
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String match;
        String replace;
        String match2;
        String pathDescription;
        SpecificationNode sn;
        String xc;
        String op;
        SpecificationNode node;
        int i;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String x = variableContext.getParameter(seqPrefix + "pathcount");
        if (x != null) {
            String path;
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn2 = ds.getChild(i);
                if (sn2.getType().equals(NODE_STARTPOINT)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int pathCount = Integer.parseInt(x);
            i = 0;
            while (i < pathCount) {
                String pathDescription2 = "_" + Integer.toString(i);
                String pathOpName = seqPrefix + "pathop" + pathDescription2;
                x = variableContext.getParameter(pathOpName);
                if (x != null && x.equals("Delete")) {
                    ++i;
                    continue;
                }
                String path2 = variableContext.getParameter(seqPrefix + "specpath" + pathDescription2);
                node = new SpecificationNode(NODE_STARTPOINT);
                node.setAttribute(ATTRIBUTE_PATH, path2);
                String y = variableContext.getParameter(seqPrefix + "specchildcount" + pathDescription2);
                int childCount = Integer.parseInt(y);
                int j = 0;
                int w = 0;
                while (j < childCount) {
                    SpecificationNode sn3;
                    String match3;
                    String type;
                    String indexable;
                    String flavor;
                    String instanceDescription = "_" + Integer.toString(i) + "_" + Integer.toString(j);
                    String instanceOp = seqPrefix + "specop" + instanceDescription;
                    String z = variableContext.getParameter(instanceOp);
                    if (z != null && z.equals("Delete")) {
                        ++j;
                        continue;
                    }
                    if (z != null && z.equals("Insert Here")) {
                        flavor = variableContext.getParameter(seqPrefix + "specfl_i" + instanceDescription);
                        indexable = "";
                        type = "";
                        String xxx = variableContext.getParameter(seqPrefix + "spectin_i" + instanceDescription);
                        if (xxx.equals(VALUE_FILE) || xxx.equals(VALUE_DIRECTORY)) {
                            type = xxx;
                        } else if (xxx.equals("indexable-file")) {
                            indexable = "yes";
                            type = VALUE_FILE;
                        } else if (xxx.equals("unindexable-file")) {
                            indexable = "no";
                            type = VALUE_FILE;
                        }
                        match3 = variableContext.getParameter(seqPrefix + "specfile_i" + instanceDescription);
                        sn3 = new SpecificationNode(flavor);
                        if (type != null && type.length() > 0) {
                            sn3.setAttribute(ATTRIBUTE_TYPE, type);
                        }
                        if (indexable != null && indexable.length() > 0) {
                            sn3.setAttribute(ATTRIBUTE_INDEXABLE, indexable);
                        }
                        sn3.setAttribute(ATTRIBUTE_FILESPEC, match3);
                        node.addChild(w++, (ConfigurationNode)sn3);
                    }
                    flavor = variableContext.getParameter(seqPrefix + "specfl" + instanceDescription);
                    type = variableContext.getParameter(seqPrefix + "specty" + instanceDescription);
                    match3 = variableContext.getParameter(seqPrefix + "specfile" + instanceDescription);
                    indexable = variableContext.getParameter(seqPrefix + "specin" + instanceDescription);
                    sn3 = new SpecificationNode(flavor);
                    if (type != null && type.length() > 0) {
                        sn3.setAttribute(ATTRIBUTE_TYPE, type);
                    }
                    if (indexable != null && indexable.length() > 0) {
                        sn3.setAttribute(ATTRIBUTE_INDEXABLE, indexable);
                    }
                    sn3.setAttribute(ATTRIBUTE_FILESPEC, match3);
                    node.addChild(w++, (ConfigurationNode)sn3);
                    ++j;
                }
                if (x != null && x.equals("Add")) {
                    String match4 = variableContext.getParameter(seqPrefix + "specfile" + pathDescription2);
                    String indexable = "";
                    String type = "";
                    String xxx = variableContext.getParameter(seqPrefix + "spectin" + pathDescription2);
                    if (xxx.equals(VALUE_FILE) || xxx.equals(VALUE_DIRECTORY)) {
                        type = xxx;
                    } else if (xxx.equals("indexable-file")) {
                        indexable = "yes";
                        type = VALUE_FILE;
                    } else if (xxx.equals("unindexable-file")) {
                        indexable = "no";
                        type = VALUE_FILE;
                    }
                    String flavor = variableContext.getParameter(seqPrefix + "specfl" + pathDescription2);
                    SpecificationNode sn4 = new SpecificationNode(flavor);
                    if (type != null && type.length() > 0) {
                        sn4.setAttribute(ATTRIBUTE_TYPE, type);
                    }
                    if (indexable != null && indexable.length() > 0) {
                        sn4.setAttribute(ATTRIBUTE_INDEXABLE, indexable);
                    }
                    sn4.setAttribute(ATTRIBUTE_FILESPEC, match4);
                    node.addChild(w, (ConfigurationNode)sn4);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "pathop");
            if (op != null && op.equals("Add")) {
                path = variableContext.getParameter(seqPrefix + "specpath");
                SpecificationNode node2 = new SpecificationNode(NODE_STARTPOINT);
                node2.setAttribute(ATTRIBUTE_PATH, path);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node2);
                SpecificationNode sn5 = new SpecificationNode(NODE_INCLUDE);
                sn5.setAttribute(ATTRIBUTE_TYPE, VALUE_FILE);
                sn5.setAttribute(ATTRIBUTE_INDEXABLE, "yes");
                sn5.setAttribute(ATTRIBUTE_FILESPEC, "*");
                node2.addChild(node2.getChildCount(), (ConfigurationNode)sn5);
                sn5 = new SpecificationNode(NODE_INCLUDE);
                sn5.setAttribute(ATTRIBUTE_TYPE, VALUE_DIRECTORY);
                sn5.setAttribute(ATTRIBUTE_FILESPEC, "*");
                node2.addChild(node2.getChildCount(), (ConfigurationNode)sn5);
            } else if (op != null && op.equals("Up")) {
                path = variableContext.getParameter(seqPrefix + "specpath");
                int k = path.lastIndexOf("/");
                path = k == -1 ? "" : path.substring(0, k);
                this.currentContext.save((Object)(seqPrefix + "specpath"), (Object)path);
            } else if (op != null && op.equals("AddToPath")) {
                path = variableContext.getParameter(seqPrefix + "specpath");
                String addon = variableContext.getParameter(seqPrefix + "pathaddon");
                String typein = variableContext.getParameter(seqPrefix + "pathtypein");
                if (addon != null && addon.length() > 0) {
                    path = path.length() == 0 ? addon : path + "/" + addon;
                } else if (typein != null && typein.length() > 0) {
                    String trialPath = path;
                    trialPath = trialPath.length() == 0 ? typein : trialPath + "/" + typein;
                    try {
                        trialPath = this.validateFolderName(trialPath);
                        if (trialPath != null) {
                            path = trialPath;
                        }
                    }
                    catch (ManifoldCFException childCount) {
                        // empty catch block
                    }
                }
                this.currentContext.save((Object)(seqPrefix + "specpath"), (Object)path);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "specmaxlength")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn6 = ds.getChild(i);
                if (sn6.getType().equals(NODE_MAXLENGTH)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            if (x.length() > 0) {
                SpecificationNode node3 = new SpecificationNode(NODE_MAXLENGTH);
                node3.setAttribute(ATTRIBUTE_VALUE, x);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node3);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "specsecurity")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn7 = ds.getChild(i);
                if (sn7.getType().equals(NODE_SECURITY)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node4 = new SpecificationNode(NODE_SECURITY);
            node4.setAttribute(ATTRIBUTE_VALUE, x);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node4);
        }
        if ((x = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn8 = ds.getChild(i);
                if (sn8.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(x);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                x = variableContext.getParameter(accessOpName);
                if (x != null && x.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                node = new SpecificationNode("access");
                node.setAttribute(ATTRIBUTE_TOKEN, accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node5 = new SpecificationNode("access");
                node5.setAttribute(ATTRIBUTE_TOKEN, accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node5);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "specsharesecurity")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn9 = ds.getChild(i);
                if (sn9.getType().equals(NODE_SHARESECURITY)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node6 = new SpecificationNode(NODE_SHARESECURITY);
            node6.setAttribute(ATTRIBUTE_VALUE, x);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node6);
        }
        if ((x = variableContext.getParameter(seqPrefix + "specparentfoldersecurity")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn10 = ds.getChild(i);
                if (sn10.getType().equals(NODE_PARENTFOLDERSECURITY)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node7 = new SpecificationNode(NODE_PARENTFOLDERSECURITY);
            node7.setAttribute(ATTRIBUTE_VALUE, x);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node7);
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specpathnameattribute")) != null) {
            int i2 = 0;
            while (i2 < ds.getChildCount()) {
                sn = ds.getChild(i2);
                if (sn.getType().equals(NODE_PATHNAMEATTRIBUTE)) {
                    ds.removeChild(i2);
                    continue;
                }
                ++i2;
            }
            if (xc.length() > 0) {
                SpecificationNode node8 = new SpecificationNode(NODE_PATHNAMEATTRIBUTE);
                node8.setAttribute(ATTRIBUTE_VALUE, xc);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node8);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specmappingcount")) != null) {
            int i3 = 0;
            while (i3 < ds.getChildCount()) {
                sn = ds.getChild(i3);
                if (sn.getType().equals(NODE_PATHMAP)) {
                    ds.removeChild(i3);
                    continue;
                }
                ++i3;
            }
            int mappingCount = Integer.parseInt(xc);
            i3 = 0;
            while (i3 < mappingCount) {
                pathDescription = "_" + Integer.toString(i3);
                String pathOpName = seqPrefix + "specmappingop" + pathDescription;
                xc = variableContext.getParameter(pathOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i3;
                    continue;
                }
                match2 = variableContext.getParameter(seqPrefix + "specmatch" + pathDescription);
                replace = variableContext.getParameter(seqPrefix + "specreplace" + pathDescription);
                SpecificationNode node9 = new SpecificationNode(NODE_PATHMAP);
                node9.setAttribute(ATTRIBUTE_MATCH, match2);
                node9.setAttribute(ATTRIBUTE_REPLACE, replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node9);
                ++i3;
            }
            xc = variableContext.getParameter(seqPrefix + "specmappingop");
            if (xc != null && xc.equals("Add")) {
                match = variableContext.getParameter(seqPrefix + "specmatch");
                String replace2 = variableContext.getParameter(seqPrefix + "specreplace");
                node = new SpecificationNode(NODE_PATHMAP);
                node.setAttribute(ATTRIBUTE_MATCH, match);
                node.setAttribute(ATTRIBUTE_REPLACE, replace2);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specfmapcount")) != null) {
            int i4 = 0;
            while (i4 < ds.getChildCount()) {
                SpecificationNode sn11 = ds.getChild(i4);
                if (sn11.getType().equals(NODE_FILEMAP)) {
                    ds.removeChild(i4);
                    continue;
                }
                ++i4;
            }
            int mappingCount = Integer.parseInt(xc);
            i4 = 0;
            while (i4 < mappingCount) {
                pathDescription = "_" + Integer.toString(i4);
                String pathOpName = seqPrefix + "specfmapop" + pathDescription;
                xc = variableContext.getParameter(pathOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i4;
                    continue;
                }
                match2 = variableContext.getParameter(seqPrefix + "specfmapmatch" + pathDescription);
                replace = variableContext.getParameter(seqPrefix + "specfmapreplace" + pathDescription);
                SpecificationNode node10 = new SpecificationNode(NODE_FILEMAP);
                node10.setAttribute(ATTRIBUTE_MATCH, match2);
                node10.setAttribute(ATTRIBUTE_REPLACE, replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node10);
                ++i4;
            }
            xc = variableContext.getParameter(seqPrefix + "specfmapop");
            if (xc != null && xc.equals("Add")) {
                match = variableContext.getParameter(seqPrefix + "specfmapmatch");
                String replace3 = variableContext.getParameter(seqPrefix + "specfmapreplace");
                node = new SpecificationNode(NODE_FILEMAP);
                node.setAttribute(ATTRIBUTE_MATCH, match);
                node.setAttribute(ATTRIBUTE_REPLACE, replace3);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specumapcount")) != null) {
            int i5 = 0;
            while (i5 < ds.getChildCount()) {
                SpecificationNode sn12 = ds.getChild(i5);
                if (sn12.getType().equals(NODE_URIMAP)) {
                    ds.removeChild(i5);
                    continue;
                }
                ++i5;
            }
            int mappingCount = Integer.parseInt(xc);
            i5 = 0;
            while (i5 < mappingCount) {
                pathDescription = "_" + Integer.toString(i5);
                String pathOpName = seqPrefix + "specumapop" + pathDescription;
                xc = variableContext.getParameter(pathOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i5;
                    continue;
                }
                match2 = variableContext.getParameter(seqPrefix + "specumapmatch" + pathDescription);
                replace = variableContext.getParameter(seqPrefix + "specumapreplace" + pathDescription);
                SpecificationNode node11 = new SpecificationNode(NODE_URIMAP);
                node11.setAttribute(ATTRIBUTE_MATCH, match2);
                node11.setAttribute(ATTRIBUTE_REPLACE, replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node11);
                ++i5;
            }
            xc = variableContext.getParameter(seqPrefix + "specumapop");
            if (xc != null && xc.equals("Add")) {
                match = variableContext.getParameter(seqPrefix + "specumapmatch");
                String replace4 = variableContext.getParameter(seqPrefix + "specumapreplace");
                node = new SpecificationNode(NODE_URIMAP);
                node.setAttribute(ATTRIBUTE_MATCH, match);
                node.setAttribute(ATTRIBUTE_REPLACE, replace4);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        SpecificationNode sn;
        out.print("<table class=\"displaytable\">\n");
        int i = 0;
        boolean seenAny = false;
        while (i < ds.getChildCount()) {
            SpecificationNode spn;
            if (!(spn = ds.getChild(i++)).getType().equals(NODE_STARTPOINT)) continue;
            if (!seenAny) {
                seenAny = true;
            }
            out.print("  <tr>\n    <td class=\"description\">\n      <nobr>" + Encoder.bodyEscape((String)spn.getAttributeValue(ATTRIBUTE_PATH)) + ":</nobr>\n    </td>\n    <td class=\"value\">\n");
            int j = 0;
            while (j < spn.getChildCount()) {
                String ingestableFlag;
                SpecificationNode sn2 = spn.getChild(j++);
                String nodeFlavor = sn2.getType();
                String filespec = sn2.getAttributeValue(ATTRIBUTE_FILESPEC);
                String nodeType = sn2.getAttributeValue(ATTRIBUTE_TYPE);
                if (nodeType == null) {
                    nodeType = "";
                }
                if ((ingestableFlag = sn2.getAttributeValue(ATTRIBUTE_INDEXABLE)) == null) {
                    ingestableFlag = "";
                }
                out.print("      <nobr>\n        " + Integer.toString(j) + ".\n        " + (nodeFlavor.equals(NODE_INCLUDE) ? "Include" : "") + "\n        " + (nodeFlavor.equals(NODE_EXCLUDE) ? "Exclude" : "") + "\n        " + (ingestableFlag.equals("yes") ? "&nbsp;indexable" : "") + "\n        " + (ingestableFlag.equals("no") ? "&nbsp;un-indexable" : "") + "\n        " + (nodeType.equals(VALUE_FILE) ? "&nbsp;file(s)" : "") + "\n        " + (nodeType.equals(VALUE_DIRECTORY) ? "&nbsp;directory(s)" : "") + "\n        " + (nodeType.equals("") ? "&nbsp;file(s)&nbsp;or&nbsp;directory(s)" : "") + "&nbsp;matching&nbsp;\n        " + Encoder.bodyEscape((String)filespec) + "\n      </nobr>\n      <br/>\n");
            }
            out.print("    </td>\n  </tr>\n");
        }
        if (!seenAny) {
            out.print("  <tr><td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "SharedDriveConnector.NoDocumentsSpecified") + "</td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n\n");
        i = 0;
        boolean securityOn = true;
        boolean shareSecurityOn = true;
        boolean parentFolderSecurityOn = false;
        while (i < ds.getChildCount()) {
            String securityValue;
            if ((sn = ds.getChild(i++)).getType().equals(NODE_SECURITY)) {
                securityValue = sn.getAttributeValue(ATTRIBUTE_VALUE);
                if (securityValue.equals("off")) {
                    securityOn = false;
                } else if (securityValue.equals("on")) {
                    securityOn = true;
                }
            }
            if (sn.getType().equals(NODE_SHARESECURITY)) {
                securityValue = sn.getAttributeValue(ATTRIBUTE_VALUE);
                if (securityValue.equals("off")) {
                    shareSecurityOn = false;
                } else if (securityValue.equals("on")) {
                    shareSecurityOn = true;
                }
            }
            if (!sn.getType().equals(NODE_PARENTFOLDERSECURITY)) continue;
            securityValue = sn.getAttributeValue(ATTRIBUTE_VALUE);
            if (securityValue.equals("off")) {
                parentFolderSecurityOn = false;
                continue;
            }
            if (!securityValue.equals("on")) continue;
            parentFolderSecurityOn = true;
        }
        out.print("\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.FileSecurity") + "</nobr></td>\n    <td class=\"value\"><nobr>" + (securityOn ? Messages.getBodyString(locale, "SharedDriveConnector.Enabled") : Messages.getBodyString(locale, "SharedDriveConnector.Disabled")) + "</nobr></td>\n  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        seenAny = false;
        i = 0;
        while (i < ds.getChildCount()) {
            if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
            if (!seenAny) {
                out.print("  <tr><td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.FileAccessTokens") + "</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String token = sn.getAttributeValue(ATTRIBUTE_TOKEN);
            out.print("      <nobr>" + Encoder.bodyEscape((String)token) + "</nobr><br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "SharedDriveConnector.NoFileAccessTokensSpecified") + "</td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n    \n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.ShareSecurity") + "</nobr></td>\n    <td class=\"value\"><nobr>" + (shareSecurityOn ? Messages.getBodyString(locale, "SharedDriveConnector.Enabled") : Messages.getBodyString(locale, "SharedDriveConnector.Disabled")) + "</nobr></td>\n  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n    \n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.ParentFolderSecurity") + "</nobr></td>\n    <td class=\"value\"><nobr>" + (parentFolderSecurityOn ? Messages.getBodyString(locale, "SharedDriveConnector.Enabled") : Messages.getBodyString(locale, "SharedDriveConnector.Disabled")) + "</nobr></td>\n  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        i = 0;
        String pathNameAttribute = "";
        while (i < ds.getChildCount()) {
            SpecificationNode sn3;
            if (!(sn3 = ds.getChild(i++)).getType().equals(NODE_PATHNAMEATTRIBUTE)) continue;
            pathNameAttribute = sn3.getAttributeValue(ATTRIBUTE_VALUE);
        }
        out.print("  <tr>\n");
        if (pathNameAttribute.length() > 0) {
            out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.PathNameMetadataAttribute") + "</nobr></td>\n    <td class=\"value\"><nobr>" + Encoder.bodyEscape((String)pathNameAttribute) + "</nobr></td>\n");
        } else {
            out.print("    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "SharedDriveConnector.NoPathNameMetadataAttributeSpecified") + "</td>\n");
        }
        out.print("  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n\n  <tr>\n\n");
        i = 0;
        MatchMap matchMap = new MatchMap();
        while (i < ds.getChildCount()) {
            SpecificationNode sn4;
            if (!(sn4 = ds.getChild(i++)).getType().equals(NODE_PATHMAP)) continue;
            String pathMatch = sn4.getAttributeValue(ATTRIBUTE_MATCH);
            String pathReplace = sn4.getAttributeValue(ATTRIBUTE_REPLACE);
            matchMap.appendMatchPair(pathMatch, pathReplace);
        }
        if (matchMap.getMatchCount() > 0) {
            out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.PathValueMapping") + "</nobr></td>\n    <td class=\"value\">\n      <table class=\"displaytable\">\n");
            for (i = 0; i < matchMap.getMatchCount(); ++i) {
                String matchString = matchMap.getMatchString(i);
                String replaceString = matchMap.getReplaceString(i);
                out.print("        <tr>\n          <td class=\"value\"><nobr>" + Encoder.bodyEscape((String)matchString) + "</nobr></td>\n          <td class=\"value\">==></td>\n          <td class=\"value\"><nobr>" + Encoder.bodyEscape((String)replaceString) + "</nobr></td>\n        </tr>\n");
            }
            out.print("      </table>\n    </td>\n");
        } else {
            out.print("    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "SharedDriveConnector.NoMappingsSpecified") + "</td>\n");
        }
        out.print("  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n\n  <tr>\n");
        i = 0;
        MatchMap fileMap = new MatchMap();
        while (i < ds.getChildCount()) {
            SpecificationNode sn5;
            if (!(sn5 = ds.getChild(i++)).getType().equals(NODE_FILEMAP)) continue;
            String pathMatch = sn5.getAttributeValue(ATTRIBUTE_MATCH);
            String pathReplace = sn5.getAttributeValue(ATTRIBUTE_REPLACE);
            fileMap.appendMatchPair(pathMatch, pathReplace);
        }
        if (fileMap.getMatchCount() > 0) {
            out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.FileNameMapping") + "</nobr></td>\n    <td class=\"value\">\n      <table class=\"displaytable\">\n");
            for (i = 0; i < fileMap.getMatchCount(); ++i) {
                String matchString = fileMap.getMatchString(i);
                String replaceString = fileMap.getReplaceString(i);
                out.print("        <tr>\n          <td class=\"value\"><nobr>" + Encoder.bodyEscape((String)matchString) + "</nobr></td>\n          <td class=\"value\">==></td>\n          <td class=\"value\"><nobr>" + Encoder.bodyEscape((String)replaceString) + "</nobr></td>\n        </tr>\n");
            }
            out.print("      </table>\n    </td>\n");
        } else {
            out.print("    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "SharedDriveConnector.NoFileNameMappingsSpecified") + "</td>\n");
        }
        out.print("  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n\n  <tr>\n");
        i = 0;
        MatchMap uriMap = new MatchMap();
        while (i < ds.getChildCount()) {
            SpecificationNode sn6;
            if (!(sn6 = ds.getChild(i++)).getType().equals(NODE_URIMAP)) continue;
            String pathMatch = sn6.getAttributeValue(ATTRIBUTE_MATCH);
            String pathReplace = sn6.getAttributeValue(ATTRIBUTE_REPLACE);
            uriMap.appendMatchPair(pathMatch, pathReplace);
        }
        if (uriMap.getMatchCount() > 0) {
            out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.URLMappingColon") + "</nobr></td>\n    <td class=\"value\">\n      <table class=\"displaytable\">\n");
            for (i = 0; i < uriMap.getMatchCount(); ++i) {
                String matchString = uriMap.getMatchString(i);
                String replaceString = uriMap.getReplaceString(i);
                out.print("        <tr>\n          <td class=\"value\"><nobr>" + Encoder.bodyEscape((String)matchString) + "</nobr></td>\n          <td class=\"value\">==></td>\n          <td class=\"value\"><nobr>" + Encoder.bodyEscape((String)replaceString) + "</nobr></td>\n        </tr>\n");
            }
            out.print("      </table>\n    </td>\n");
        } else {
            out.print("    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "SharedDriveConnector.NoURLMappingsSpecifiedWillProduceAFileIRI") + "</td>\n");
        }
        out.print("  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SharedDriveConnector.MaximumDocumentLength") + "</nobr></td>\n    <td class=\"value\">\n      <nobr>\n");
        i = 0;
        String maxLength = null;
        while (i < ds.getChildCount()) {
            SpecificationNode sn7;
            if (!(sn7 = ds.getChild(i++)).getType().equals(NODE_MAXLENGTH)) continue;
            maxLength = sn7.getAttributeValue(ATTRIBUTE_VALUE);
        }
        if (maxLength == null || maxLength.length() == 0) {
            maxLength = "Unlimited";
        }
        out.print("        " + maxLength + "\n      </nobr>\n    </td>\n  </tr>\n</table>\n");
    }

    public SmbFile[] getShareNames(String serverURI) throws ManifoldCFException {
        this.getSession();
        SmbFile server = null;
        try {
            server = new SmbFile(serverURI, SingletonContext.getInstance().withCredentials((Credentials)this.pa));
        }
        catch (MalformedURLException e1) {
            throw new ManifoldCFException("MalformedURLException tossed", (Throwable)e1);
        }
        SmbFile[] shares = null;
        try {
            if (SharedDriveConnector.getFileType(server) == 4) {
                shares = SharedDriveConnector.fileListFiles(server, new ShareFilter());
            }
        }
        catch (SmbException e) {
            throw new ManifoldCFException("SmbException tossed: " + e.getMessage(), (Throwable)e);
        }
        return shares;
    }

    public String validateFolderName(String folder) throws ManifoldCFException {
        String smburi;
        this.getSession();
        String uri = smburi = this.smbconnectionPath;
        if (folder.length() > 0) {
            uri = smburi + folder + "/";
        }
        SmbFile currentDirectory = null;
        try {
            currentDirectory = new SmbFile(uri, SingletonContext.getInstance().withCredentials((Credentials)this.pa));
        }
        catch (MalformedURLException e1) {
            throw new ManifoldCFException("validateFolderName: Can't get parent file: " + uri, (Throwable)e1);
        }
        try {
            currentDirectory.connect();
            if (!SharedDriveConnector.fileIsDirectory(currentDirectory)) {
                return null;
            }
            String newCanonicalPath = currentDirectory.getCanonicalPath();
            String rval = newCanonicalPath.substring(smburi.length());
            if (rval.endsWith("/")) {
                rval = rval.substring(0, rval.length() - 1);
            }
            return rval;
        }
        catch (SmbException se) {
            try {
                SharedDriveConnector.processSMBException(se, folder, "checking folder", "getting canonical path");
                return null;
            }
            catch (ServiceInterruption si) {
                throw new ManifoldCFException("Service interruption: " + si.getMessage(), (Throwable)si);
            }
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("MalformedURLException tossed: " + e.getMessage(), (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("IOException tossed: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IOException tossed: " + e.getMessage(), (Throwable)e);
        }
    }

    public String[] getChildFolderNames(String folder) throws ManifoldCFException {
        String smburi;
        this.getSession();
        String uri = smburi = this.smbconnectionPath;
        if (folder.length() > 0) {
            uri = smburi + folder + "/";
        }
        SmbFile currentDirectory = null;
        try {
            currentDirectory = new SmbFile(uri, SingletonContext.getInstance().withCredentials((Credentials)this.pa));
        }
        catch (MalformedURLException e1) {
            throw new ManifoldCFException("getChildFolderNames: Can't get parent file: " + uri, (Throwable)e1);
        }
        SmbFile[] children = null;
        try {
            currentDirectory.connect();
            children = currentDirectory.listFiles((SmbFileFilter)new DirectoryFilter());
        }
        catch (SmbException se) {
            try {
                SharedDriveConnector.processSMBException(se, folder, "getting child folder names", "listing files");
                children = new SmbFile[]{};
            }
            catch (ServiceInterruption si) {
                throw new ManifoldCFException("Service interruption: " + si.getMessage(), (Throwable)si);
            }
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("MalformedURLException tossed: " + e.getMessage(), (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            throw new ManifoldCFException("IOException tossed: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IOException tossed: " + e.getMessage(), (Throwable)e);
        }
        Object[] directories = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            String directoryName = children[i].getName();
            directoryName = directoryName.replaceAll("/", "");
            directories[i] = directoryName;
        }
        Arrays.sort(directories);
        return directories;
    }

    static {
        if (System.getProperty("jcifs.resolveOrder") == null) {
            System.setProperty("jcifs.resolveOrder", "LMHOSTS,DNS,WINS");
        }
        if (System.getProperty("jcifs.smb.client.soTimeout") == null) {
            System.setProperty("jcifs.smb.client.soTimeout", "150000");
        }
        if (System.getProperty("jcifs.smb.client.responseTimeout") == null) {
            System.setProperty("jcifs.smb.client.responseTimeout", "120000");
        }
        if (System.getProperty("jcifs.smb.client.minVersion") == null) {
            System.setProperty("jcifs.smb.client.minVersion", "SMB1");
        }
        if (System.getProperty("jcifs.smb.client.maxVersion") == null) {
            System.setProperty("jcifs.smb.client.maxVersion", "SMB210");
        }
        if (System.getProperty("jcifs.traceResources") == null) {
            System.setProperty("jcifs.traceResources", "true");
        }
        if (System.getProperty("jcifs.smb.client.ipcSigningEnforced") == null) {
            System.setProperty("jcifs.smb.client.ipcSigningEnforced", "true");
        }
        System.setProperty("jcifs.smb.client.listCount", "20");
        System.setProperty("jcifs.smb.client.dfs.strictView", "true");
    }

    protected class ProcessDocumentsFilter
    implements SmbFileFilter {
        protected final IProcessActivity activities;
        protected final Specification spec;
        protected ManifoldCFException lcfException = null;
        protected ServiceInterruption serviceInterruption = null;

        public ProcessDocumentsFilter(IProcessActivity activities, Specification spec) {
            this.activities = activities;
            this.spec = spec;
        }

        public boolean accept(SmbFile f) throws SmbException {
            if (this.lcfException != null || this.serviceInterruption != null) {
                return false;
            }
            try {
                int type = f.getType();
                if (type != 4 && type != 1 && type != 8) {
                    return false;
                }
                String canonicalPath = SharedDriveConnector.getFileCanonicalPath(f);
                if (canonicalPath != null) {
                    String newPath = canonicalPath;
                    boolean fileIsDirectory = SharedDriveConnector.fileIsDirectory(f);
                    if (SharedDriveConnector.this.checkInclude(fileIsDirectory, newPath, this.spec)) {
                        if (fileIsDirectory) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("JCIFS: Recorded path is '" + newPath + "' and is included."));
                            }
                            this.activities.addDocumentReference(newPath);
                        } else {
                            long fileLength = SharedDriveConnector.fileLength(f);
                            if (SharedDriveConnector.checkIncludeFile(fileLength, newPath, this.spec, (IFingerprintActivity)this.activities)) {
                                if (Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)("JCIFS: Recorded path is '" + newPath + "' and is included."));
                                }
                                this.activities.addDocumentReference(newPath);
                            } else if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("JCIFS: Recorded path '" + newPath + "' is excluded!"));
                            }
                        }
                    } else if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("JCIFS: Recorded path '" + newPath + "' is excluded!"));
                    }
                } else {
                    Logging.connectors.debug((Object)"JCIFS: Excluding a child file because canonical path is null");
                }
                return false;
            }
            catch (ManifoldCFException e) {
                if (this.lcfException == null) {
                    this.lcfException = e;
                }
                return false;
            }
            catch (ServiceInterruption e) {
                if (this.serviceInterruption == null) {
                    this.serviceInterruption = e;
                }
                return false;
            }
        }

        public void checkAndThrow() throws ServiceInterruption, ManifoldCFException {
            if (this.lcfException != null) {
                throw this.lcfException;
            }
            if (this.serviceInterruption != null) {
                throw this.serviceInterruption;
            }
        }
    }

    class DirectoryFilter
    implements SmbFileFilter {
        DirectoryFilter() {
        }

        public boolean accept(SmbFile arg0) throws SmbException {
            int type = SharedDriveConnector.getFileType(arg0);
            return type == 8 || type == 1 && SharedDriveConnector.fileIsDirectory(arg0);
        }
    }

    class ShareFilter
    implements SmbFileFilter {
        ShareFilter() {
        }

        public boolean accept(SmbFile arg0) throws SmbException {
            return SharedDriveConnector.getFileType(arg0) == 8;
        }
    }
}

