/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.connectorcommon.throttler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.manifoldcf.connectorcommon.interfaces.BreakException;
import org.apache.manifoldcf.connectorcommon.interfaces.IBreakCheck;
import org.apache.manifoldcf.connectorcommon.interfaces.IConnectionThrottler;
import org.apache.manifoldcf.connectorcommon.interfaces.IFetchThrottler;
import org.apache.manifoldcf.connectorcommon.interfaces.IStreamThrottler;
import org.apache.manifoldcf.connectorcommon.interfaces.IThrottleSpec;
import org.apache.manifoldcf.connectorcommon.throttler.ConnectionBin;
import org.apache.manifoldcf.connectorcommon.throttler.FetchBin;
import org.apache.manifoldcf.connectorcommon.throttler.ThrottleBin;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class Throttler {
    public static final String _rcsid = "@(#)$Id: Throttler.java 1650911 2015-01-11 16:20:23Z kwright $";
    protected final Map<String, ThrottlingGroups> throttleGroupsHash = new HashMap<String, ThrottlingGroups>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getThrottleGroups(IThreadContext threadContext, String throttleGroupType) throws ManifoldCFException {
        Map<String, ThrottlingGroups> map = this.throttleGroupsHash;
        synchronized (map) {
            return this.throttleGroupsHash.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThrottleGroup(IThreadContext threadContext, String throttleGroupType, String throttleGroup) throws ManifoldCFException {
        Map<String, ThrottlingGroups> map = this.throttleGroupsHash;
        synchronized (map) {
            ThrottlingGroups tg = this.throttleGroupsHash.get(throttleGroupType);
            if (tg != null) {
                tg.removeThrottleGroup(threadContext, throttleGroup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpdateThrottleGroup(IThreadContext threadContext, String throttleGroupType, String throttleGroup, IThrottleSpec throttleSpec) throws ManifoldCFException {
        Map<String, ThrottlingGroups> map = this.throttleGroupsHash;
        synchronized (map) {
            ThrottlingGroups tg = this.throttleGroupsHash.get(throttleGroupType);
            if (tg == null) {
                tg = new ThrottlingGroups(throttleGroupType);
                this.throttleGroupsHash.put(throttleGroupType, tg);
            }
            tg.createOrUpdateThrottleGroup(threadContext, throttleGroup, throttleSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConnectionThrottler obtainConnectionThrottler(IThreadContext threadContext, String throttleGroupType, String throttleGroup, String[] binNames) throws ManifoldCFException {
        Map<String, ThrottlingGroups> map = this.throttleGroupsHash;
        synchronized (map) {
            ThrottlingGroups tg = this.throttleGroupsHash.get(throttleGroupType);
            if (tg != null) {
                return tg.obtainConnectionThrottler(threadContext, throttleGroup, binNames);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll(IThreadContext threadContext, String throttleGroupType) throws ManifoldCFException {
        Map<String, ThrottlingGroups> map = this.throttleGroupsHash;
        synchronized (map) {
            ThrottlingGroups tg = this.throttleGroupsHash.get(throttleGroupType);
            if (tg != null) {
                tg.poll(threadContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll(IThreadContext threadContext) throws ManifoldCFException {
        Map<String, ThrottlingGroups> map = this.throttleGroupsHash;
        synchronized (map) {
            for (ThrottlingGroups tg : this.throttleGroupsHash.values()) {
                tg.poll(threadContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUnusedResources(IThreadContext threadContext) throws ManifoldCFException {
        Map<String, ThrottlingGroups> map = this.throttleGroupsHash;
        synchronized (map) {
            for (ThrottlingGroups p : this.throttleGroupsHash.values()) {
                p.freeUnusedResources(threadContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(IThreadContext threadContext) throws ManifoldCFException {
        Map<String, ThrottlingGroups> map = this.throttleGroupsHash;
        synchronized (map) {
            Iterator<ThrottlingGroups> iter = this.throttleGroupsHash.values().iterator();
            while (iter.hasNext()) {
                ThrottlingGroups p = iter.next();
                p.destroy(threadContext);
                iter.remove();
            }
        }
    }

    protected static String buildThrottlingGroupName(String throttlingGroupType, String throttlingGroupName) {
        return throttlingGroupType + "_" + throttlingGroupName;
    }

    protected static class StreamThrottler
    implements IStreamThrottler {
        protected final ThrottlingGroup parent;
        protected final String[] binNames;

        public StreamThrottler(ThrottlingGroup parent, String[] binNames) {
            this.parent = parent;
            this.binNames = binNames;
        }

        @Override
        public boolean obtainReadPermission(int byteCount) throws InterruptedException {
            try {
                return this.obtainReadPermission(byteCount, null);
            }
            catch (BreakException e) {
                throw new RuntimeException("Unexpected break exception: " + e.getMessage(), e);
            }
        }

        @Override
        public boolean obtainReadPermission(int byteCount, IBreakCheck breakCheck) throws InterruptedException, BreakException {
            return this.parent.obtainReadPermission(this.binNames, byteCount, breakCheck);
        }

        @Override
        public void releaseReadPermission(int origByteCount, int actualByteCount) {
            this.parent.releaseReadPermission(this.binNames, origByteCount, actualByteCount);
        }

        @Override
        public void closeStream() {
            this.parent.closeStream(this.binNames);
        }
    }

    protected static class FetchThrottler
    implements IFetchThrottler {
        protected final ThrottlingGroup parent;
        protected final String[] binNames;

        public FetchThrottler(ThrottlingGroup parent, String[] binNames) {
            this.parent = parent;
            this.binNames = binNames;
        }

        @Override
        public boolean obtainFetchDocumentPermission() throws InterruptedException {
            try {
                return this.obtainFetchDocumentPermission(null);
            }
            catch (BreakException e) {
                throw new RuntimeException("Unexpected break exception: " + e.getMessage(), e);
            }
        }

        @Override
        public boolean obtainFetchDocumentPermission(IBreakCheck breakCheck) throws InterruptedException, BreakException {
            return this.parent.obtainFetchDocumentPermission(this.binNames, breakCheck);
        }

        @Override
        public IStreamThrottler createFetchStream() {
            return this.parent.createFetchStream(this.binNames);
        }
    }

    protected static class ConnectionThrottler
    implements IConnectionThrottler {
        protected final ThrottlingGroup parent;
        protected final String[] binNames;
        protected final AtomicInteger[] poolCounts;

        public ConnectionThrottler(ThrottlingGroup parent, String[] binNames) {
            this.parent = parent;
            this.binNames = binNames;
            this.poolCounts = new AtomicInteger[binNames.length];
            for (int i = 0; i < this.poolCounts.length; ++i) {
                this.poolCounts[i] = new AtomicInteger(0);
            }
        }

        @Override
        public int waitConnectionAvailable() throws InterruptedException {
            try {
                return this.waitConnectionAvailable(null);
            }
            catch (BreakException e) {
                throw new RuntimeException("Unexpected break exception: " + e.getMessage(), e);
            }
        }

        @Override
        public int waitConnectionAvailable(IBreakCheck breakCheck) throws InterruptedException, BreakException {
            return this.parent.waitConnectionAvailable(this.binNames, this.poolCounts, breakCheck);
        }

        @Override
        public IFetchThrottler getNewConnectionFetchThrottler() {
            return this.parent.getNewConnectionFetchThrottler(this.binNames);
        }

        @Override
        public boolean noteReturnedConnection() {
            return this.parent.noteReturnedConnection(this.binNames);
        }

        @Override
        public boolean checkDestroyPooledConnection() {
            return this.parent.checkDestroyPooledConnection(this.binNames, this.poolCounts);
        }

        @Override
        public boolean checkExpireConnection() {
            return this.parent.checkExpireConnection(this.binNames, this.poolCounts);
        }

        @Override
        public void noteConnectionReturnedToPool() {
            this.parent.noteConnectionReturnedToPool(this.binNames, this.poolCounts);
        }

        @Override
        public void noteConnectionDestroyed() {
            this.parent.noteConnectionDestroyed(this.binNames);
        }
    }

    protected class ThrottlingGroup {
        protected final String throttlingGroupName;
        protected IThrottleSpec throttleSpec;
        protected final Map<String, ConnectionBin> connectionBins = new HashMap<String, ConnectionBin>();
        protected final Map<String, FetchBin> fetchBins = new HashMap<String, FetchBin>();
        protected final Map<String, ThrottleBin> throttleBins = new HashMap<String, ThrottleBin>();

        public ThrottlingGroup(IThreadContext threadContext, String throttlingGroupType, String throttleGroup, IThrottleSpec throttleSpec) throws ManifoldCFException {
            this.throttlingGroupName = Throttler.buildThrottlingGroupName(throttlingGroupType, throttleGroup);
            this.throttleSpec = throttleSpec;
            this.poll(threadContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized IConnectionThrottler obtainConnectionThrottler(IThreadContext threadContext, String[] binNames) throws ManifoldCFException {
            Object bin;
            Map<String, Object> map = this.connectionBins;
            synchronized (map) {
                for (String binName : binNames) {
                    bin = this.connectionBins.get(binName);
                    if (bin != null) continue;
                    bin = new ConnectionBin(threadContext, this.throttlingGroupName, binName);
                    this.connectionBins.put(binName, (ConnectionBin)bin);
                }
            }
            map = this.fetchBins;
            synchronized (map) {
                for (String binName : binNames) {
                    bin = this.fetchBins.get(binName);
                    if (bin != null) continue;
                    bin = new FetchBin(threadContext, this.throttlingGroupName, binName);
                    this.fetchBins.put(binName, (FetchBin)bin);
                }
            }
            map = this.throttleBins;
            synchronized (map) {
                for (String binName : binNames) {
                    bin = this.throttleBins.get(binName);
                    if (bin != null) continue;
                    bin = new ThrottleBin(threadContext, this.throttlingGroupName, binName);
                    this.throttleBins.put(binName, (ThrottleBin)bin);
                }
            }
            return new ConnectionThrottler(this, binNames);
        }

        public synchronized void updateThrottleSpecification(IThrottleSpec throttleSpec) throws ManifoldCFException {
            this.throttleSpec = throttleSpec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int waitConnectionAvailable(String[] binNames, AtomicInteger[] poolCounts, IBreakCheck breakCheck) throws InterruptedException, BreakException {
            int currentRecommendation;
            boolean retry;
            block17: do {
                currentRecommendation = -1;
                retry = false;
                for (int i = 0; i < binNames.length; ++i) {
                    Map<String, ConnectionBin> e2;
                    int result;
                    ConnectionBin bin;
                    String binName = binNames[i];
                    Map<String, ConnectionBin> map = this.connectionBins;
                    synchronized (map) {
                        bin = this.connectionBins.get(binName);
                    }
                    if (bin == null) continue;
                    try {
                        result = bin.waitConnectionAvailable(poolCounts[i], breakCheck);
                    }
                    catch (Throwable e2) {
                        while (i > 0) {
                            binName = binNames[--i];
                            Map<String, ConnectionBin> map2 = this.connectionBins;
                            synchronized (map2) {
                                bin = this.connectionBins.get(binName);
                            }
                            if (bin == null) continue;
                            bin.undoReservation(currentRecommendation, poolCounts[i]);
                        }
                        if (e2 instanceof BreakException) {
                            throw (BreakException)e2;
                        }
                        if (e2 instanceof InterruptedException) {
                            throw (InterruptedException)e2;
                        }
                        if (e2 instanceof Error) {
                            throw (Error)e2;
                        }
                        if (e2 instanceof RuntimeException) {
                            throw (RuntimeException)e2;
                        }
                        throw new RuntimeException("Unexpected exception of type '" + e2.getClass().getName() + "': " + e2.getMessage(), e2);
                    }
                    if (result == -1) {
                        while (i > 0) {
                            binName = binNames[--i];
                            e2 = this.connectionBins;
                            synchronized (e2) {
                                bin = this.connectionBins.get(binName);
                            }
                            if (bin == null) continue;
                            bin.undoReservation(currentRecommendation, poolCounts[i]);
                        }
                        return result;
                    }
                    if (currentRecommendation != -1 && currentRecommendation != result) {
                        bin.undoReservation(result, poolCounts[i]);
                        while (i > 0) {
                            binName = binNames[--i];
                            e2 = this.connectionBins;
                            synchronized (e2) {
                                bin = this.connectionBins.get(binName);
                            }
                            if (bin == null) continue;
                            bin.undoReservation(currentRecommendation, poolCounts[i]);
                        }
                        retry = true;
                        continue block17;
                    }
                    if (currentRecommendation != -1) continue;
                    currentRecommendation = result;
                }
            } while (retry);
            if (currentRecommendation == 1) {
                for (String binName : binNames) {
                    ConnectionBin bin;
                    Map<String, ConnectionBin> map = this.connectionBins;
                    synchronized (map) {
                        bin = this.connectionBins.get(binName);
                    }
                    if (bin == null) continue;
                    bin.noteConnectionCreation();
                }
            }
            return currentRecommendation;
        }

        public IFetchThrottler getNewConnectionFetchThrottler(String[] binNames) {
            return new FetchThrottler(this, binNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean noteReturnedConnection(String[] binNames) {
            Map<String, ConnectionBin> map = this.connectionBins;
            synchronized (map) {
                boolean destroyConnection = false;
                for (String binName : binNames) {
                    ConnectionBin bin = this.connectionBins.get(binName);
                    if (bin == null) continue;
                    destroyConnection |= bin.shouldReturnedConnectionBeDestroyed();
                }
                return destroyConnection;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkDestroyPooledConnection(String[] binNames, AtomicInteger[] poolCounts) {
            Map<String, ConnectionBin> map = this.connectionBins;
            synchronized (map) {
                ConnectionBin bin;
                boolean destroyConnection = false;
                for (int i = 0; i < binNames.length; ++i) {
                    String binName = binNames[i];
                    bin = this.connectionBins.get(binName);
                    if (bin == null) continue;
                    int result = bin.shouldPooledConnectionBeDestroyed(poolCounts[i]);
                    if (result == 1) {
                        while (i > 0) {
                            binName = binNames[--i];
                            bin = this.connectionBins.get(binName);
                            bin.undoPooledConnectionDecision(poolCounts[i]);
                        }
                        return false;
                    }
                    if (result != 0) continue;
                    destroyConnection = true;
                }
                if (destroyConnection) {
                    return true;
                }
                for (int j = 0; j < binNames.length; ++j) {
                    bin = this.connectionBins.get(binNames[j]);
                    if (bin == null) continue;
                    bin.undoPooledConnectionDecision(poolCounts[j]);
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkExpireConnection(String[] binNames, AtomicInteger[] poolCounts) {
            Map<String, ConnectionBin> map = this.connectionBins;
            synchronized (map) {
                for (int i = 0; i < binNames.length; ++i) {
                    String binName = binNames[i];
                    ConnectionBin bin = this.connectionBins.get(binName);
                    if (bin == null || bin.hasPooledConnection(poolCounts[i])) continue;
                    while (i > 0) {
                        binName = binNames[--i];
                        bin = this.connectionBins.get(binName);
                        bin.undoPooledConnectionDecision(poolCounts[i]);
                    }
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noteConnectionReturnedToPool(String[] binNames, AtomicInteger[] poolCounts) {
            Map<String, ConnectionBin> map = this.connectionBins;
            synchronized (map) {
                for (int j = 0; j < binNames.length; ++j) {
                    ConnectionBin bin = this.connectionBins.get(binNames[j]);
                    if (bin == null) continue;
                    bin.noteConnectionReturnedToPool(poolCounts[j]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noteConnectionDestroyed(String[] binNames) {
            Map<String, ConnectionBin> map = this.connectionBins;
            synchronized (map) {
                for (String binName : binNames) {
                    ConnectionBin bin = this.connectionBins.get(binName);
                    if (bin == null) continue;
                    bin.noteConnectionDestroyed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean obtainFetchDocumentPermission(String[] binNames, IBreakCheck breakCheck) throws InterruptedException, BreakException {
            FetchBin bin;
            String binName;
            int i;
            for (i = 0; i < binNames.length; ++i) {
                binName = binNames[i];
                Map<String, FetchBin> map = this.fetchBins;
                synchronized (map) {
                    bin = this.fetchBins.get(binName);
                }
                try {
                    if (bin != null && bin.reserveFetchRequest(breakCheck)) continue;
                    while (i > 0) {
                        binName = binNames[--i];
                        map = this.fetchBins;
                        synchronized (map) {
                            bin = this.fetchBins.get(binName);
                        }
                        if (bin == null) continue;
                        bin.clearReservation();
                    }
                    return false;
                }
                catch (BreakException e) {
                    while (i > 0) {
                        binName = binNames[--i];
                        Map<String, FetchBin> map2 = this.fetchBins;
                        synchronized (map2) {
                            bin = this.fetchBins.get(binName);
                        }
                        if (bin == null) continue;
                        bin.clearReservation();
                    }
                    throw e;
                }
            }
            for (i = 0; i < binNames.length; ++i) {
                binName = binNames[i];
                Map<String, FetchBin> e = this.fetchBins;
                synchronized (e) {
                    bin = this.fetchBins.get(binName);
                }
                if (bin == null) continue;
                try {
                    if (bin.waitNextFetch(breakCheck)) continue;
                    while (i < binNames.length) {
                        binName = binNames[i];
                        e = this.fetchBins;
                        synchronized (e) {
                            bin = this.fetchBins.get(binName);
                        }
                        if (bin != null) {
                            bin.clearReservation();
                        }
                        ++i;
                    }
                    return false;
                }
                catch (BreakException e2) {
                    while (i < binNames.length) {
                        binName = binNames[i];
                        Map<String, FetchBin> map = this.fetchBins;
                        synchronized (map) {
                            bin = this.fetchBins.get(binName);
                        }
                        if (bin != null) {
                            bin.clearReservation();
                        }
                        ++i;
                    }
                    throw e2;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStreamThrottler createFetchStream(String[] binNames) {
            Map<String, ThrottleBin> map = this.throttleBins;
            synchronized (map) {
                for (String binName : binNames) {
                    ThrottleBin bin = this.throttleBins.get(binName);
                    if (bin == null) continue;
                    bin.beginFetch();
                }
            }
            return new StreamThrottler(this, binNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean obtainReadPermission(String[] binNames, int byteCount, IBreakCheck breakCheck) throws InterruptedException, BreakException {
            for (int i = 0; i < binNames.length; ++i) {
                ThrottleBin bin;
                String binName = binNames[i];
                Map<String, ThrottleBin> map = this.throttleBins;
                synchronized (map) {
                    bin = this.throttleBins.get(binName);
                }
                try {
                    if (bin != null && bin.beginRead(byteCount, breakCheck)) continue;
                    while (i > 0) {
                        binName = binNames[--i];
                        map = this.throttleBins;
                        synchronized (map) {
                            bin = this.throttleBins.get(binName);
                        }
                        if (bin == null) continue;
                        bin.endRead(byteCount, 0);
                    }
                    return false;
                }
                catch (BreakException e) {
                    while (i > 0) {
                        binName = binNames[--i];
                        Map<String, ThrottleBin> map2 = this.throttleBins;
                        synchronized (map2) {
                            bin = this.throttleBins.get(binName);
                        }
                        if (bin == null) continue;
                        bin.endRead(byteCount, 0);
                    }
                    throw e;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseReadPermission(String[] binNames, int origByteCount, int actualByteCount) {
            Map<String, ThrottleBin> map = this.throttleBins;
            synchronized (map) {
                for (String binName : binNames) {
                    ThrottleBin bin = this.throttleBins.get(binName);
                    if (bin == null) continue;
                    bin.endRead(origByteCount, actualByteCount);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeStream(String[] binNames) {
            Map<String, ThrottleBin> map = this.throttleBins;
            synchronized (map) {
                for (String binName : binNames) {
                    ThrottleBin bin = this.throttleBins.get(binName);
                    if (bin == null) continue;
                    bin.endFetch();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void poll(IThreadContext threadContext) throws ManifoldCFException {
            Map<String, Object> map = this.connectionBins;
            synchronized (map) {
                for (ConnectionBin connectionBin : this.connectionBins.values()) {
                    connectionBin.updateMaxActiveConnections(this.throttleSpec.getMaxOpenConnections(connectionBin.getBinName()));
                    connectionBin.poll(threadContext);
                }
            }
            map = this.fetchBins;
            synchronized (map) {
                for (FetchBin fetchBin : this.fetchBins.values()) {
                    fetchBin.updateMinTimeBetweenFetches(this.throttleSpec.getMinimumMillisecondsPerFetch(fetchBin.getBinName()));
                    fetchBin.poll(threadContext);
                }
            }
            map = this.throttleBins;
            synchronized (map) {
                for (ThrottleBin throttleBin : this.throttleBins.values()) {
                    throttleBin.updateMinimumMillisecondsPerByte(this.throttleSpec.getMinimumMillisecondsPerByte(throttleBin.getBinName()));
                    throttleBin.poll(threadContext);
                }
            }
        }

        public synchronized void freeUnusedResources(IThreadContext threadContext) throws ManifoldCFException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void destroy(IThreadContext threadContext) throws ManifoldCFException {
            Object bin;
            Iterator<Object> binIter;
            Map<String, Object> map = this.connectionBins;
            synchronized (map) {
                binIter = this.connectionBins.values().iterator();
                while (binIter.hasNext()) {
                    bin = binIter.next();
                    ((ConnectionBin)bin).shutDown(threadContext);
                    binIter.remove();
                }
            }
            map = this.fetchBins;
            synchronized (map) {
                binIter = this.fetchBins.values().iterator();
                while (binIter.hasNext()) {
                    bin = (FetchBin)binIter.next();
                    ((FetchBin)bin).shutDown(threadContext);
                    binIter.remove();
                }
            }
            map = this.throttleBins;
            synchronized (map) {
                binIter = this.throttleBins.values().iterator();
                while (binIter.hasNext()) {
                    bin = (ThrottleBin)binIter.next();
                    ((ThrottleBin)bin).shutDown(threadContext);
                    binIter.remove();
                }
            }
        }
    }

    protected class ThrottlingGroups {
        protected final String throttlingGroupTypeName;
        protected final Map<String, ThrottlingGroup> groups = new HashMap<String, ThrottlingGroup>();

        public ThrottlingGroups(String throttlingGroupTypeName) {
            this.throttlingGroupTypeName = throttlingGroupTypeName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createOrUpdateThrottleGroup(IThreadContext threadContext, String throttleGroup, IThrottleSpec throttleSpec) throws ManifoldCFException {
            Map<String, ThrottlingGroup> map = this.groups;
            synchronized (map) {
                ThrottlingGroup g = this.groups.get(throttleGroup);
                if (g == null) {
                    g = new ThrottlingGroup(threadContext, this.throttlingGroupTypeName, throttleGroup, throttleSpec);
                    this.groups.put(throttleGroup, g);
                } else {
                    g.updateThrottleSpecification(throttleSpec);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IConnectionThrottler obtainConnectionThrottler(IThreadContext threadContext, String throttleGroup, String[] binNames) throws ManifoldCFException {
            Map<String, ThrottlingGroup> map = this.groups;
            synchronized (map) {
                ThrottlingGroup g = this.groups.get(throttleGroup);
                if (g == null) {
                    return null;
                }
                return g.obtainConnectionThrottler(threadContext, binNames);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeThrottleGroup(IThreadContext threadContext, String throttleGroup) throws ManifoldCFException {
            Map<String, ThrottlingGroup> map = this.groups;
            synchronized (map) {
                ThrottlingGroup g = this.groups.remove(throttleGroup);
                if (g != null) {
                    g.destroy(threadContext);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void poll(IThreadContext threadContext) throws ManifoldCFException {
            Map<String, ThrottlingGroup> map = this.groups;
            synchronized (map) {
                for (String throttleGroup : this.groups.keySet()) {
                    ThrottlingGroup p = this.groups.get(throttleGroup);
                    p.poll(threadContext);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void freeUnusedResources(IThreadContext threadContext) throws ManifoldCFException {
            Map<String, ThrottlingGroup> map = this.groups;
            synchronized (map) {
                for (ThrottlingGroup g : this.groups.values()) {
                    g.freeUnusedResources(threadContext);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy(IThreadContext threadContext) throws ManifoldCFException {
            Map<String, ThrottlingGroup> map = this.groups;
            synchronized (map) {
                Iterator<ThrottlingGroup> iter = this.groups.values().iterator();
                while (iter.hasNext()) {
                    ThrottlingGroup p = iter.next();
                    p.destroy(threadContext);
                    iter.remove();
                }
            }
        }
    }
}

