/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.connectorcommon.keystore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.common.Base64;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.Logging;

public class KeystoreManager
implements IKeystoreManager {
    public static final String _rcsid = "@(#)$Id: KeystoreManager.java 988245 2010-08-23 18:39:35Z kwright $";
    protected final String passcode;
    protected final KeyStore keystore;

    public KeystoreManager(String passcode) throws ManifoldCFException {
        this.passcode = passcode;
        try {
            this.keystore = KeyStore.getInstance("JKS");
            this.keystore.load(null, passcode.toCharArray());
        }
        catch (KeyStoreException e) {
            throw new ManifoldCFException("Keystore exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted IO: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error creating keystore: " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ManifoldCFException("Unknown algorithm exception creating keystore: " + e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            throw new ManifoldCFException("Unknown certificate exception creating keystore: " + e.getMessage(), (Throwable)e);
        }
    }

    public KeystoreManager(String passcode, String base64String) throws ManifoldCFException {
        this.passcode = passcode;
        try {
            this.keystore = KeyStore.getInstance("JKS");
            byte[] decodedBytes = new Base64().decodeString(base64String);
            try (ByteArrayInputStream base64Input = new ByteArrayInputStream(decodedBytes);){
                this.keystore.load(base64Input, passcode.toCharArray());
            }
        }
        catch (KeyStoreException e) {
            throw new ManifoldCFException("Keystore exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted IO: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error creating keystore: " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ManifoldCFException("Unknown algorithm exception creating keystore: " + e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            throw new ManifoldCFException("Unknown certificate exception creating keystore: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getHashString() throws ManifoldCFException {
        String[] aliases;
        StringBuilder sb = new StringBuilder();
        for (String alias : aliases = this.getContents()) {
            String description = this.getDescription(alias);
            sb.append(":").append(alias).append(":").append(description);
        }
        return sb.toString();
    }

    @Override
    public String[] getContents() throws ManifoldCFException {
        try {
            String[] rval = new String[this.keystore.size()];
            Enumeration<String> enumeration = this.keystore.aliases();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                rval[i++] = alias;
            }
            return rval;
        }
        catch (KeyStoreException e) {
            throw new ManifoldCFException("Keystore not initialized: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getDescription(String alias) throws ManifoldCFException {
        try {
            Certificate c = this.keystore.getCertificate(alias);
            if (c == null) {
                return null;
            }
            return c.toString();
        }
        catch (KeyStoreException e) {
            throw new ManifoldCFException("Keystore not initialized: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void importCertificate(String alias, InputStream certData) throws ManifoldCFException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate c = cf.generateCertificate(certData);
            this.keystore.setCertificateEntry(alias, c);
            if (Logging.keystore.isDebugEnabled()) {
                if (this.keystore.isCertificateEntry(alias)) {
                    Logging.keystore.debug((Object)"The certificate just imported is a Trust Certificate");
                } else {
                    Logging.keystore.debug((Object)"The certificate just imported is NOT a Trust Certificate");
                }
            }
        }
        catch (KeyStoreException e) {
            throw new ManifoldCFException("Keystore exception: " + e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            throw new ManifoldCFException("Certificate error: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Certificate getCertificate(String alias) throws ManifoldCFException {
        try {
            return this.keystore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new ManifoldCFException("Keystore exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void addCertificate(String alias, Certificate certificate) throws ManifoldCFException {
        try {
            this.keystore.setCertificateEntry(alias, certificate);
            if (Logging.keystore.isDebugEnabled()) {
                if (this.keystore.isCertificateEntry(alias)) {
                    Logging.keystore.debug((Object)"The certificate just added is a Trust Certificate");
                } else {
                    Logging.keystore.debug((Object)"The certificate just added is NOT a Trust Certificate");
                }
            }
        }
        catch (KeyStoreException e) {
            throw new ManifoldCFException("Keystore exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void remove(String alias) throws ManifoldCFException {
        try {
            this.keystore.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new ManifoldCFException("Error deleting keystore entry", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getString() throws ManifoldCFException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            this.keystore.store(output, this.passcode.toCharArray());
            String string = new Base64().encodeByteArray(output.toByteArray());
            return string;
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted IO: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception storing keystore: " + e.getMessage(), (Throwable)e);
        }
    }

    public SSLSocketFactory getSecureSocketFactory() throws ManifoldCFException {
        try {
            int i;
            KeyManagerFactory keyManagerFactory = null;
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            Logging.keystore.debug((Object)"Contents of current trust keystore is:");
            if (Logging.keystore.isDebugEnabled()) {
                String[] contents = this.getContents();
                for (i = 0; i < contents.length; ++i) {
                    Logging.keystore.debug((Object)("Description " + Integer.toString(i) + ": " + this.getDescription(contents[i])));
                }
            }
            Logging.keystore.debug((Object)"Reading trust keystore...");
            trustManagerFactory.init(this.keystore);
            if (Logging.keystore.isDebugEnabled()) {
                Logging.keystore.debug((Object)"...done");
                TrustManager[] array = trustManagerFactory.getTrustManagers();
                Logging.keystore.debug((Object)("Found " + Integer.toString(array.length) + " trust managers"));
                for (i = 0; i < array.length; ++i) {
                    TrustManager tm = array[i];
                    if (!(tm instanceof X509TrustManager)) continue;
                    Logging.keystore.debug((Object)("Trust manager " + Integer.toString(i) + " is an x509 trust manager; it's class is " + tm.getClass().getName()));
                    X509TrustManager tm2 = (X509TrustManager)tm;
                    X509Certificate[] calist = tm2.getAcceptedIssuers();
                    Logging.keystore.debug((Object)("There are " + Integer.toString(calist.length) + " accepted issuers"));
                    for (int j = 0; j < calist.length; ++j) {
                        String value = calist[j].getSubjectDN().toString();
                        Logging.keystore.debug((Object)("Authority " + Integer.toString(j) + " is " + value));
                    }
                }
                Logging.keystore.debug((Object)"No more trust contents");
            }
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers(), trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers(), secureRandom);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ManifoldCFException("No such algorithm: " + e.getMessage(), (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new ManifoldCFException("Keystore exception: " + e.getMessage(), (Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new ManifoldCFException("Key management exception: " + e.getMessage(), (Throwable)e);
        }
    }
}

