/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.mappers.regexp;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class MatchMap {
    public static final String _rcsid = "@(#)$Id: MatchMap.java 1756230 2016-08-12 22:20:00Z kwright $";
    protected List<String> matchStrings;
    protected Pattern[] matchPatterns = null;
    protected List<String> replaceStrings;

    public MatchMap() {
        this.matchStrings = new ArrayList<String>();
        this.replaceStrings = new ArrayList<String>();
    }

    public MatchMap(String stringForm) {
        this.matchStrings = new ArrayList<String>();
        this.replaceStrings = new ArrayList<String>();
        StringBuilder matchString = new StringBuilder();
        StringBuilder replaceString = new StringBuilder();
        int i = 0;
        while (i < stringForm.length()) {
            char x;
            matchString.setLength(0);
            replaceString.setLength(0);
            while (i < stringForm.length() && (x = stringForm.charAt(i)) != '&' && x != '=') {
                if (x == '\\' && ++i < stringForm.length()) {
                    x = stringForm.charAt(i++);
                }
                matchString.append(x);
            }
            if (i < stringForm.length() && (x = stringForm.charAt(i)) == '=') {
                ++i;
                while (i < stringForm.length() && (x = stringForm.charAt(i)) != '&') {
                    if (x == '\\' && ++i < stringForm.length()) {
                        x = stringForm.charAt(i++);
                    }
                    replaceString.append(x);
                }
            }
            this.matchStrings.add(matchString.toString());
            this.replaceStrings.add(replaceString.toString());
            if (i >= stringForm.length() || (x = stringForm.charAt(i)) != '&') continue;
            ++i;
        }
    }

    public MatchMap(List<String> matchStrings, List<String> replaceStrings) {
        this.matchStrings = matchStrings;
        this.replaceStrings = replaceStrings;
    }

    public int getMatchCount() {
        return this.matchStrings.size();
    }

    public String getMatchString(int index) {
        return this.matchStrings.get(index);
    }

    public String getReplaceString(int index) {
        return this.replaceStrings.get(index);
    }

    public void deleteMatchPair(int index) {
        this.matchStrings.remove(index);
        this.replaceStrings.remove(index);
        this.matchPatterns = null;
    }

    public void insertMatchPair(int index, String match, String replace) {
        this.matchStrings.add(index, match);
        this.replaceStrings.add(index, replace);
        this.matchPatterns = null;
    }

    public void appendMatchPair(String match, String replace) {
        this.matchStrings.add(match);
        this.replaceStrings.add(replace);
        this.matchPatterns = null;
    }

    public void appendOldstyleMatchPair(String oldstyleMatch, String oldstyleReplace) {
        EvaluatorToken t;
        String newStyleMatch = "^" + oldstyleMatch + "$";
        EvaluatorTokenStream et = new EvaluatorTokenStream(oldstyleReplace);
        StringBuilder newStyleReplace = new StringBuilder();
        while ((t = et.peek()) != null) {
            block0 : switch (t.getType()) {
                case 2: {
                    et.advance();
                    break;
                }
                case 0: {
                    et.advance();
                    int groupNumber = t.getGroupNumber();
                    switch (t.getGroupStyle()) {
                        case 0: {
                            newStyleReplace.append("$(").append(Integer.toString(groupNumber)).append(")");
                            break block0;
                        }
                        case 1: {
                            newStyleReplace.append("$(").append(Integer.toString(groupNumber)).append("l)");
                            break block0;
                        }
                        case 2: {
                            newStyleReplace.append("$(").append(Integer.toString(groupNumber)).append("u)");
                            break block0;
                        }
                        case 3: {
                            newStyleReplace.append("$(").append(Integer.toString(groupNumber)).append("m)");
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    et.advance();
                    MatchMap.escape(newStyleReplace, t.getTextValue());
                    break;
                }
            }
        }
        this.appendMatchPair(newStyleMatch, newStyleReplace.toString());
    }

    protected static void escape(StringBuilder output, String input) {
        int i = 0;
        while (i < input.length()) {
            char x;
            if ((x = input.charAt(i++)) == '$') {
                output.append(x);
            }
            output.append(x);
        }
    }

    public String toString() {
        StringBuilder rval = new StringBuilder();
        for (int i = 0; i < this.matchStrings.size(); ++i) {
            String matchString = this.matchStrings.get(i);
            String replaceString = this.replaceStrings.get(i);
            if (i > 0) {
                rval.append('&');
            }
            MatchMap.stuff(rval, matchString);
            rval.append('=');
            MatchMap.stuff(rval, replaceString);
        }
        return rval.toString();
    }

    protected static void stuff(StringBuilder sb, String value) {
        int i = 0;
        while (i < value.length()) {
            char x;
            if ((x = value.charAt(i++)) == '\\' || x == '&' || x == '=') {
                sb.append('\\');
            }
            sb.append(x);
        }
    }

    public String translate(String input) throws ManifoldCFException {
        if (this.matchPatterns == null) {
            this.matchPatterns = new Pattern[this.matchStrings.size()];
            for (int i = 0; i < this.matchPatterns.length; ++i) {
                String regexp = this.matchStrings.get(i);
                try {
                    this.matchPatterns[i] = Pattern.compile(regexp);
                    continue;
                }
                catch (PatternSyntaxException e) {
                    this.matchPatterns = null;
                    throw new ManifoldCFException("For match expression '" + regexp + "', found pattern syntax error: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        int j = 0;
        while (j < this.matchPatterns.length) {
            Pattern p = this.matchPatterns[j];
            Matcher m = p.matcher(input);
            String outputDescription = this.replaceStrings.get(j);
            ++j;
            StringBuilder outputBuffer = new StringBuilder();
            int currentIndex = 0;
            while (true) {
                boolean foundOne;
                if (!(foundOne = m.find())) {
                    outputBuffer.append(input.substring(currentIndex));
                    break;
                }
                int matchStart = m.start(0);
                int matchEnd = m.end(0);
                if (matchStart == -1) {
                    outputBuffer.append(input.substring(currentIndex));
                    break;
                }
                outputBuffer.append(input.substring(currentIndex, matchStart));
                int i = 0;
                while (i < outputDescription.length()) {
                    char x;
                    if ((x = outputDescription.charAt(i++)) == '$' && i < outputDescription.length() && (x = outputDescription.charAt(i++)) == '(') {
                        char y;
                        StringBuilder numberBuf = new StringBuilder();
                        boolean upper = false;
                        boolean lower = false;
                        boolean mixed = false;
                        while (i < outputDescription.length() && (y = outputDescription.charAt(i++)) != ')') {
                            if (y >= '0' && y <= '9') {
                                numberBuf.append(y);
                                continue;
                            }
                            if (y == 'u' || y == 'U') {
                                upper = true;
                                continue;
                            }
                            if (y == 'l' || y == 'L') {
                                lower = true;
                                continue;
                            }
                            if (y != 'm' && y != 'M') continue;
                            mixed = true;
                        }
                        String number = numberBuf.toString();
                        try {
                            int groupnum = Integer.parseInt(number);
                            String groupValue = m.group(groupnum);
                            if (upper) {
                                outputBuffer.append(groupValue.toUpperCase(Locale.ROOT));
                                continue;
                            }
                            if (lower) {
                                outputBuffer.append(groupValue.toLowerCase(Locale.ROOT));
                                continue;
                            }
                            if (mixed && groupValue.length() > 0) {
                                outputBuffer.append(groupValue.substring(0, 1).toUpperCase(Locale.ROOT)).append(groupValue.substring(1).toLowerCase(Locale.ROOT));
                                continue;
                            }
                            outputBuffer.append(groupValue);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    outputBuffer.append(x);
                }
                currentIndex = matchEnd;
            }
            input = outputBuffer.toString();
        }
        return input;
    }

    protected static class EvaluatorTokenStream {
        protected String text;
        protected int pos;
        protected EvaluatorToken token = null;

        public EvaluatorTokenStream(String text) {
            this.text = text;
            this.pos = 0;
        }

        public EvaluatorToken peek() {
            if (this.token == null) {
                this.token = this.nextToken();
            }
            return this.token;
        }

        public void advance() {
            this.token = null;
        }

        protected EvaluatorToken nextToken() {
            char x;
            while (true) {
                if (this.pos == this.text.length()) {
                    return null;
                }
                x = this.text.charAt(this.pos);
                if (x > ' ') break;
                ++this.pos;
            }
            if (x == '\"') {
                ++this.pos;
                StringBuilder sb = new StringBuilder();
                while (this.pos != this.text.length()) {
                    x = this.text.charAt(this.pos);
                    ++this.pos;
                    if (x == '\"') break;
                    if (x == '\\') {
                        if (this.pos == this.text.length()) break;
                        x = this.text.charAt(this.pos++);
                    }
                    sb.append(x);
                }
                return new EvaluatorToken(sb.toString());
            }
            if (x == ',') {
                ++this.pos;
                return new EvaluatorToken();
            }
            StringBuilder sb = new StringBuilder();
            while (this.pos != this.text.length() && (x = this.text.charAt(this.pos)) >= '0' && x <= '9') {
                sb.append(x);
                ++this.pos;
            }
            String numberValue = sb.toString();
            int groupNumber = 0;
            if (numberValue.length() > 0) {
                groupNumber = new Integer(numberValue);
            }
            int modifierPos = this.pos;
            while (!(this.pos == this.text.length() || (x = this.text.charAt(this.pos)) == ',' || x >= '0' && x <= '9' || x <= ' ' && x >= '\u0000')) {
                ++this.pos;
            }
            int style = 0;
            if (modifierPos != this.pos) {
                String modifier = this.text.substring(modifierPos, this.pos);
                if (modifier.startsWith("u")) {
                    style = 2;
                } else if (modifier.startsWith("l")) {
                    style = 1;
                } else if (modifier.startsWith("m")) {
                    style = 3;
                }
            }
            return new EvaluatorToken(groupNumber, style);
        }
    }

    protected static class EvaluatorToken {
        public static final int TYPE_GROUP = 0;
        public static final int TYPE_TEXT = 1;
        public static final int TYPE_COMMA = 2;
        public static final int GROUPSTYLE_NONE = 0;
        public static final int GROUPSTYLE_LOWER = 1;
        public static final int GROUPSTYLE_UPPER = 2;
        public static final int GROUPSTYLE_MIXED = 3;
        protected int type;
        protected int groupNumber = -1;
        protected int groupStyle = 0;
        protected String textValue = null;

        public EvaluatorToken() {
            this.type = 2;
        }

        public EvaluatorToken(int groupNumber, int groupStyle) {
            this.type = 0;
            this.groupNumber = groupNumber;
            this.groupStyle = groupStyle;
        }

        public EvaluatorToken(String text) {
            this.type = 1;
            this.textValue = text;
        }

        public int getType() {
            return this.type;
        }

        public int getGroupNumber() {
            return this.groupNumber;
        }

        public int getGroupStyle() {
            return this.groupStyle;
        }

        public String getTextValue() {
            return this.textValue;
        }
    }
}

