/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.index;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestIndexAction
extends BaseRestHandler {
    @Inject
    public RestIndexAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/{id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/{id}/_create", new CreateHandler());
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_create", new CreateHandler());
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String consistencyLevel;
        String replicationType;
        IndexRequest indexRequest = new IndexRequest(request.param("index"), request.param("type"), request.param("id"));
        indexRequest.listenerThreaded(false);
        indexRequest.operationThreaded(true);
        indexRequest.routing(request.param("routing"));
        indexRequest.parent(request.param("parent"));
        indexRequest.timestamp(request.param("timestamp"));
        if (request.hasParam("ttl")) {
            indexRequest.ttl(request.paramAsTime("ttl", null).millis());
        }
        indexRequest.source(request.content(), request.contentUnsafe());
        indexRequest.timeout(request.paramAsTime("timeout", IndexRequest.DEFAULT_TIMEOUT));
        indexRequest.refresh(request.paramAsBoolean("refresh", indexRequest.refresh()));
        indexRequest.version(RestActions.parseVersion(request));
        indexRequest.versionType(VersionType.fromString(request.param("version_type"), indexRequest.versionType()));
        String sOpType = request.param("op_type");
        if (sOpType != null) {
            if ("index".equals(sOpType)) {
                indexRequest.opType(IndexRequest.OpType.INDEX);
            } else if ("create".equals(sOpType)) {
                indexRequest.opType(IndexRequest.OpType.CREATE);
            } else {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.BAD_REQUEST, builder.startObject().field("error", "opType [" + sOpType + "] not allowed, either [index] or [create] are allowed").endObject()));
                }
                catch (IOException e1) {
                    this.logger.warn("Failed to send response", e1, new Object[0]);
                    return;
                }
            }
        }
        if ((replicationType = request.param("replication")) != null) {
            indexRequest.replicationType(ReplicationType.fromString(replicationType));
        }
        if ((consistencyLevel = request.param("consistency")) != null) {
            indexRequest.consistencyLevel(WriteConsistencyLevel.fromString(consistencyLevel));
        }
        this.client.index(indexRequest, new ActionListener<IndexResponse>(){

            @Override
            public void onResponse(IndexResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject().field(Fields._INDEX, response.getIndex()).field(Fields._TYPE, response.getType()).field(Fields._ID, response.getId()).field(Fields._VERSION, response.getVersion()).field(Fields.CREATED, response.isCreated());
                    builder.endObject();
                    RestStatus status = RestStatus.OK;
                    if (response.isCreated()) {
                        status = RestStatus.CREATED;
                    }
                    channel.sendResponse(new XContentRestResponse(request, status, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestIndexAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    static final class Fields {
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString _VERSION = new XContentBuilderString("_version");
        static final XContentBuilderString CREATED = new XContentBuilderString("created");

        Fields() {
        }
    }

    final class CreateHandler
    implements RestHandler {
        CreateHandler() {
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel) {
            request.params().put("op_type", "create");
            RestIndexAction.this.handleRequest(request, channel);
        }
    }
}

