/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.monitor.process.ProcessInfo;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.monitor.process.ProcessStats;

public class ProcessService
extends AbstractComponent {
    private final ProcessProbe probe;
    private final ProcessInfo info;
    private final TimeValue refreshInterval;
    private ProcessStats cachedStats;

    @Inject
    public ProcessService(Settings settings, ProcessProbe probe) {
        super(settings);
        this.probe = probe;
        this.refreshInterval = this.componentSettings.getAsTime("refresh_interval", TimeValue.timeValueSeconds(1L));
        this.info = probe.processInfo();
        this.info.refreshInterval = this.refreshInterval.millis();
        this.cachedStats = probe.processStats();
        this.logger.debug("Using probe [{}] with refresh_interval [{}]", probe, this.refreshInterval);
    }

    public ProcessInfo info() {
        return this.info;
    }

    public synchronized ProcessStats stats() {
        if (System.currentTimeMillis() - this.cachedStats.timestamp() > this.refreshInterval.millis()) {
            this.cachedStats = this.probe.processStats();
        }
        return this.cachedStats;
    }
}

