/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.all;

import java.io.IOException;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.spans.TermSpans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class AllTermQuery
extends SpanTermQuery {
    public AllTermQuery(Term term) {
        super(term);
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return new AllTermWeight(this, searcher);
    }

    public int hashCode() {
        return super.hashCode() + 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return ((Object)((Object)this)).getClass() == obj.getClass();
    }

    protected class AllTermWeight
    extends SpanWeight {
        public AllTermWeight(AllTermQuery query, IndexSearcher searcher) throws IOException {
            super((SpanQuery)query, searcher);
        }

        public AllTermSpanScorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            if (this.stats == null) {
                return null;
            }
            Similarity.SimScorer sloppySimScorer = this.similarity.simScorer(this.stats, context);
            return new AllTermSpanScorer((TermSpans)this.query.getSpans(context, acceptDocs, this.termContexts), (Weight)this, sloppySimScorer);
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            int newDoc;
            AllTermSpanScorer scorer = this.scorer(context, true, false, context.reader().getLiveDocs());
            if (scorer != null && (newDoc = scorer.advance(doc)) == doc) {
                float freq = scorer.sloppyFreq();
                Similarity.SimScorer docScorer = this.similarity.simScorer(this.stats, context);
                ComplexExplanation inner = new ComplexExplanation();
                inner.setDescription("weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:");
                Explanation scoreExplanation = docScorer.explain(doc, new Explanation(freq, "phraseFreq=" + freq));
                inner.addDetail(scoreExplanation);
                inner.setValue(scoreExplanation.getValue());
                inner.setMatch(Boolean.valueOf(true));
                ComplexExplanation result = new ComplexExplanation();
                result.addDetail((Explanation)inner);
                Explanation payloadBoost = new Explanation();
                result.addDetail(payloadBoost);
                float payloadScore = scorer.getPayloadScore();
                payloadBoost.setValue(payloadScore);
                payloadBoost.setDescription("allPayload(...)");
                result.setValue(inner.getValue() * payloadScore);
                result.setDescription("btq, product of:");
                return result;
            }
            return new ComplexExplanation(false, 0.0f, "no matching term");
        }

        protected class AllTermSpanScorer
        extends SpanScorer {
            protected DocsAndPositionsEnum positions;
            protected float payloadScore;
            protected int payloadsSeen;

            public AllTermSpanScorer(TermSpans spans, Weight weight, Similarity.SimScorer docScorer) throws IOException {
                super((Spans)spans, weight, docScorer);
                this.positions = spans.getPostings();
            }

            protected boolean setFreqCurrentDoc() throws IOException {
                if (!this.more) {
                    return false;
                }
                this.doc = this.spans.doc();
                this.freq = 0.0f;
                this.numMatches = 0;
                this.payloadScore = 0.0f;
                this.payloadsSeen = 0;
                do {
                    int matchLength = this.spans.end() - this.spans.start();
                    this.freq += this.docScorer.computeSlopFactor(matchLength);
                    ++this.numMatches;
                    this.processPayload();
                    this.more = this.spans.next();
                } while (this.more && this.doc == this.spans.doc());
                return true;
            }

            protected void processPayload() throws IOException {
                BytesRef payload = this.positions.getPayload();
                if (payload != null) {
                    this.payloadScore += PayloadHelper.decodeFloat((byte[])payload.bytes, (int)payload.offset);
                    ++this.payloadsSeen;
                }
            }

            public float score() throws IOException {
                return this.getSpanScore() * this.getPayloadScore();
            }

            protected float getSpanScore() throws IOException {
                return super.score();
            }

            protected float getPayloadScore() {
                return this.payloadsSeen > 0 ? this.payloadScore / (float)this.payloadsSeen : 1.0f;
            }
        }
    }
}

