/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.pattern.RegexReplacement;

@Plugin(name="PatternLayout", category="Core", elementType="layout", printObject=true)
public final class PatternLayout
extends AbstractStringLayout {
    public static final String DEFAULT_CONVERSION_PATTERN = "%m%n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %x - %m%n";
    public static final String SIMPLE_CONVERSION_PATTERN = "%d [%t] %p %c - %m%n";
    public static final String KEY = "Converter";
    private static final long serialVersionUID = 1L;
    private final PatternFormatter[] formatters;
    private final String conversionPattern;
    private final PatternSelector patternSelector;
    private final Serializer serializer;
    private final Configuration config;
    private final RegexReplacement replace;
    private final boolean alwaysWriteExceptions;
    private final boolean noConsoleNoAnsi;

    private PatternLayout(Configuration config, RegexReplacement replace, String pattern, PatternSelector patternSelector, Charset charset, boolean alwaysWriteExceptions, boolean noConsoleNoAnsi, String header, String footer) {
        super(charset, PatternLayout.toBytes(header, charset), PatternLayout.toBytes(footer, charset));
        this.replace = replace;
        this.conversionPattern = pattern;
        this.patternSelector = patternSelector;
        this.config = config;
        this.alwaysWriteExceptions = alwaysWriteExceptions;
        this.noConsoleNoAnsi = noConsoleNoAnsi;
        if (patternSelector == null) {
            this.serializer = new PatternSerializer();
            PatternParser parser = PatternLayout.createPatternParser(config);
            try {
                List<PatternFormatter> list = parser.parse(pattern == null ? DEFAULT_CONVERSION_PATTERN : pattern, this.alwaysWriteExceptions, this.noConsoleNoAnsi);
                this.formatters = list.toArray(new PatternFormatter[0]);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException("Cannot parse pattern '" + pattern + "'", ex);
            }
        } else {
            this.formatters = null;
            this.serializer = new PatternSelectorSerializer();
        }
    }

    private byte[] strSubstitutorReplace(byte ... b) {
        if (b != null && this.config != null) {
            return this.getBytes(this.config.getStrSubstitutor().replace(new String(b, this.getCharset())));
        }
        return b;
    }

    @Override
    public byte[] getHeader() {
        return this.strSubstitutorReplace(super.getHeader());
    }

    @Override
    public byte[] getFooter() {
        return this.strSubstitutorReplace(super.getFooter());
    }

    public String getConversionPattern() {
        return this.conversionPattern;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("structured", "false");
        result.put("formatType", "conversion");
        result.put("format", this.conversionPattern);
        return result;
    }

    @Override
    public String toSerializable(LogEvent event) {
        return this.serializer.toSerializable(event);
    }

    public static PatternParser createPatternParser(Configuration config) {
        if (config == null) {
            return new PatternParser(config, KEY, LogEventPatternConverter.class);
        }
        PatternParser parser = (PatternParser)config.getComponent(KEY);
        if (parser == null) {
            parser = new PatternParser(config, KEY, LogEventPatternConverter.class);
            config.addComponent(KEY, parser);
            parser = (PatternParser)config.getComponent(KEY);
        }
        return parser;
    }

    public String toString() {
        return this.patternSelector == null ? this.conversionPattern : this.patternSelector.toString();
    }

    @PluginFactory
    public static PatternLayout createLayout(@PluginAttribute(value="pattern", defaultString="%m%n") String pattern, @PluginElement(value="PatternSelector") PatternSelector patternSelector, @PluginConfiguration Configuration config, @PluginElement(value="Replace") RegexReplacement replace, @PluginAttribute(value="charset") Charset charset, @PluginAttribute(value="alwaysWriteExceptions", defaultBoolean=true) boolean alwaysWriteExceptions, @PluginAttribute(value="noConsoleNoAnsi", defaultBoolean=false) boolean noConsoleNoAnsi, @PluginAttribute(value="header") String header, @PluginAttribute(value="footer") String footer) {
        return PatternLayout.newBuilder().withPattern(pattern).withPatternSelector(patternSelector).withConfiguration(config).withRegexReplacement(replace).withCharset(charset).withAlwaysWriteExceptions(alwaysWriteExceptions).withNoConsoleNoAnsi(noConsoleNoAnsi).withHeader(header).withFooter(footer).build();
    }

    public static PatternLayout createDefaultLayout() {
        return PatternLayout.newBuilder().build();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<PatternLayout> {
        @PluginBuilderAttribute
        private String pattern = "%m%n";
        @PluginElement(value="PatternSelector")
        private PatternSelector patternSelector = null;
        @PluginConfiguration
        private Configuration configuration = null;
        @PluginElement(value="Replace")
        private RegexReplacement regexReplacement = null;
        @PluginBuilderAttribute
        private Charset charset = Charset.defaultCharset();
        @PluginBuilderAttribute
        private boolean alwaysWriteExceptions = true;
        @PluginBuilderAttribute
        private boolean noConsoleNoAnsi = false;
        @PluginBuilderAttribute
        private String header = null;
        @PluginBuilderAttribute
        private String footer = null;

        private Builder() {
        }

        public Builder withPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder withPatternSelector(PatternSelector patternSelector) {
            this.patternSelector = patternSelector;
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder withRegexReplacement(RegexReplacement regexReplacement) {
            this.regexReplacement = regexReplacement;
            return this;
        }

        public Builder withCharset(Charset charset) {
            if (charset != null) {
                this.charset = charset;
            }
            return this;
        }

        public Builder withAlwaysWriteExceptions(boolean alwaysWriteExceptions) {
            this.alwaysWriteExceptions = alwaysWriteExceptions;
            return this;
        }

        public Builder withNoConsoleNoAnsi(boolean noConsoleNoAnsi) {
            this.noConsoleNoAnsi = noConsoleNoAnsi;
            return this;
        }

        public Builder withHeader(String header) {
            this.header = header;
            return this;
        }

        public Builder withFooter(String footer) {
            this.footer = footer;
            return this;
        }

        @Override
        public PatternLayout build() {
            if (this.configuration == null) {
                this.configuration = new DefaultConfiguration();
            }
            return new PatternLayout(this.configuration, this.regexReplacement, this.pattern, this.patternSelector, this.charset, this.alwaysWriteExceptions, this.noConsoleNoAnsi, this.header, this.footer);
        }
    }

    private class PatternSelectorSerializer
    implements Serializer {
        private PatternSelectorSerializer() {
        }

        @Override
        public String toSerializable(LogEvent event) {
            StringBuilder buf = PatternLayout.this.getStringBuilder();
            PatternFormatter[] formatters = PatternLayout.this.patternSelector.getFormatters(event);
            int len = formatters.length;
            for (int i = 0; i < len; ++i) {
                formatters[i].format(event, buf);
            }
            String str = buf.toString();
            if (PatternLayout.this.replace != null) {
                str = PatternLayout.this.replace.format(str);
            }
            return str;
        }
    }

    private class PatternSerializer
    implements Serializer {
        private PatternSerializer() {
        }

        @Override
        public String toSerializable(LogEvent event) {
            StringBuilder buf = PatternLayout.this.getStringBuilder();
            int len = PatternLayout.this.formatters.length;
            for (int i = 0; i < len; ++i) {
                PatternLayout.this.formatters[i].format(event, buf);
            }
            String str = buf.toString();
            if (PatternLayout.this.replace != null) {
                str = PatternLayout.this.replace.format(str);
            }
            return str;
        }
    }

    private static interface Serializer {
        public String toSerializable(LogEvent var1);
    }
}

