/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.child.CustomQueryWrappingFilter;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.index.search.child.TopChildrenQuery;
import org.elasticsearch.search.internal.SearchContext;

public class TopChildrenQueryParser
implements QueryParser {
    public static final String NAME = "top_children";

    @Inject
    public TopChildrenQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query innerQuery = null;
        boolean queryFound = false;
        float boost = 1.0f;
        String childType = null;
        ScoreType scoreType = ScoreType.MAX;
        int factor = 5;
        int incrementalFactor = 2;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    String[] stringArray;
                    queryFound = true;
                    if (childType == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = childType;
                    }
                    String[] origTypes = QueryParseContext.setTypesWithPrevious(stringArray);
                    try {
                        innerQuery = parseContext.parseInnerQuery();
                        continue;
                    }
                    finally {
                        QueryParseContext.setTypes(origTypes);
                        continue;
                    }
                }
                throw new QueryParsingException(parseContext.index(), "[top_children] query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("type".equals(currentFieldName)) {
                childType = parser.text();
                continue;
            }
            if ("_scope".equals(currentFieldName)) {
                throw new QueryParsingException(parseContext.index(), "the [_scope] support in [top_children] query has been removed, use a filter as a facet_filter in the relevant global facet");
            }
            if ("score".equals(currentFieldName)) {
                scoreType = ScoreType.fromString(parser.text());
                continue;
            }
            if ("score_mode".equals(currentFieldName) || "scoreMode".equals(currentFieldName)) {
                scoreType = ScoreType.fromString(parser.text());
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("factor".equals(currentFieldName)) {
                factor = parser.intValue();
                continue;
            }
            if ("incremental_factor".equals(currentFieldName) || "incrementalFactor".equals(currentFieldName)) {
                incrementalFactor = parser.intValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[top_children] query does not support [" + currentFieldName + "]");
        }
        if (!queryFound) {
            throw new QueryParsingException(parseContext.index(), "[top_children] requires 'query' field");
        }
        if (childType == null) {
            throw new QueryParsingException(parseContext.index(), "[top_children] requires 'type' field");
        }
        if (innerQuery == null) {
            return null;
        }
        if ("delete_by_query".equals(SearchContext.current().source())) {
            throw new QueryParsingException(parseContext.index(), "[top_children] unsupported in delete_by_query api");
        }
        DocumentMapper childDocMapper = parseContext.mapperService().documentMapper(childType);
        if (childDocMapper == null) {
            throw new QueryParsingException(parseContext.index(), "No mapping for for type [" + childType + "]");
        }
        if (!childDocMapper.parentFieldMapper().active()) {
            throw new QueryParsingException(parseContext.index(), "Type [" + childType + "] does not have parent mapping");
        }
        String parentType = childDocMapper.parentFieldMapper().type();
        innerQuery.setBoost(boost);
        innerQuery = new XFilteredQuery(innerQuery, parseContext.cacheFilter(childDocMapper.typeFilter(), null));
        TopChildrenQuery query = new TopChildrenQuery(innerQuery, childType, parentType, scoreType, factor, incrementalFactor, parseContext.cacheRecycler());
        if (queryName != null) {
            parseContext.addNamedFilter(queryName, new CustomQueryWrappingFilter(query));
        }
        return query;
    }
}

