/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public final class Locales
extends Static {
    private static final Map<Locale, Locale> POOL;
    private static final short LANGUAGE = 0;
    private static final short COUNTRY = Short.MIN_VALUE;
    private static final short[] ISO3;
    private static final short[] ISO2;
    public static final Locales ALL;
    public static final Locales SIS;

    private Locales() {
    }

    public Locale[] getAvailableLanguages() {
        if (this == ALL) {
            return Locales.getLanguages(Locale.getAvailableLocales());
        }
        return new Locale[]{Locale.ENGLISH, Locale.FRENCH};
    }

    public Locale[] getAvailableLocales() {
        int n;
        if (this == ALL) {
            return Locale.getAvailableLocales();
        }
        Locale[] localeArray = this.getAvailableLanguages();
        String[] stringArray = new String[localeArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = localeArray[n].getLanguage();
        }
        n = 0;
        block1: for (Locale locale : localeArray = Locale.getAvailableLocales()) {
            String string = locale.getLanguage();
            for (String string2 : stringArray) {
                if (!string.equals(string2)) continue;
                localeArray[n++] = Locales.unique(locale);
                continue block1;
            }
        }
        localeArray = ArraysExt.resize(localeArray, n);
        return localeArray;
    }

    private static Locale[] getLanguages(Locale ... localeArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Containers.hashMapCapacity(localeArray.length));
        for (Locale object : localeArray) {
            linkedHashSet.add(object.getLanguage());
        }
        int n = 0;
        Locale[] localeArray2 = new Locale[linkedHashSet.size()];
        for (String string : linkedHashSet) {
            localeArray2[n++] = Locales.unique(new Locale(string));
        }
        return localeArray2;
    }

    public static Locale parse(String string) {
        return Locales.parse(string, 0);
    }

    public static Locale parse(String string, int n) {
        ArgumentChecks.ensureNonNull("code", string);
        ArgumentChecks.ensurePositive("fromIndex", n);
        int n2 = string.indexOf(95, n);
        String string2 = "";
        String string3 = "";
        if (n2 < 0) {
            n2 = string.length();
        } else {
            int n3 = n2 + 1;
            int n4 = string.indexOf(95, n3);
            if (n4 < 0) {
                n4 = string.length();
            } else {
                string3 = (String)CharSequences.trimWhitespaces(string, n4 + 1, string.length());
            }
            string2 = (String)CharSequences.trimWhitespaces(string, n3, n4);
        }
        String string4 = (String)CharSequences.trimWhitespaces(string, n, n2);
        string4 = Locales.toISO2(string4, (short)0);
        string2 = Locales.toISO2(string2, (short)Short.MIN_VALUE);
        if (string4.length() > 8 || !Locales.isAlphaNumeric(string4) || string2.length() > 3 || !Locales.isAlphaNumeric(string2)) {
            throw new RuntimeException(Errors.format((short)36, string.substring(n)));
        }
        return Locales.unique(new Locale(string4, string2, string3));
    }

    private static boolean isAlphaNumeric(String string) {
        int n = string.length();
        while (--n >= 0) {
            char c = string.charAt(n);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static String toISO2(String string, short s) {
        int n;
        short s2 = Locales.toNumber(string, s);
        if (s2 != 0 && (n = Arrays.binarySearch(ISO3, s2)) >= 0) {
            int n2 = ((n = ISO2[n]) & Short.MIN_VALUE) != 0 ? 64 : 96;
            n &= Short.MAX_VALUE;
            int n3 = 0;
            char[] cArray = new char[3];
            do {
                cArray[n3++] = (char)((n & 0x1F) + n2);
            } while ((n >>>= 5) != 0);
            return String.valueOf(cArray, 0, n3);
        }
        return string;
    }

    private static short toNumber(String string, short s) {
        int n = string.length();
        if (n >= 1 && n <= 3) {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = string.charAt(i);
                if (n3 < 65 || (n3 -= n3 >= 97 ? 96 : 64) > 26) {
                    return 0;
                }
                s = (short)(s | n3 << n2);
                n2 += 5;
            }
            return s;
        }
        return 0;
    }

    public static Locale unique(Locale locale) {
        Locale locale2 = POOL.get(locale);
        return locale2 != null ? locale2 : locale;
    }

    static {
        Object object = Locale.getAvailableLocales();
        POOL = new HashMap<Locale, Locale>(Containers.hashMapCapacity(((Locale[])object).length));
        for (Locale object2 : object) {
            POOL.put(object2, object2);
        }
        try {
            for (Field entry : Locale.class.getFields()) {
                if (!Modifier.isStatic(entry.getModifiers()) || !Locale.class.isAssignableFrom(entry.getType())) continue;
                Locale locale = (Locale)entry.get(null);
                POOL.put(locale, locale);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.util.resources"), Locales.class, "<clinit>", illegalAccessException);
        }
        object = (short)0;
        TreeMap treeMap = new TreeMap();
        for (Locale locale : POOL.values()) {
            short s = 0;
            do {
                Short s2;
                short s3;
                short s4;
                if ((s4 = Locales.toNumber(s == 0 ? locale.getLanguage() : locale.getCountry(), s)) == 0) continue;
                try {
                    s3 = Locales.toNumber(s == 0 ? locale.getISO3Language() : locale.getISO3Country(), s);
                }
                catch (MissingResourceException missingResourceException) {
                    continue;
                }
                if (s3 == 0 || s3 == s4 || (s2 = treeMap.put(s3, s4)) == null || s2 == s4) continue;
                treeMap.put(s3, object);
            } while ((s = (short)(s ^ Short.MIN_VALUE)) != 0);
        }
        while (treeMap.values().remove(object)) {
        }
        ISO3 = new short[treeMap.size()];
        ISO2 = new short[treeMap.size()];
        int n = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            Locales.ISO3[n] = (Short)entry.getKey();
            Locales.ISO2[n++] = (Short)entry.getValue();
        }
        ALL = new Locales();
        SIS = new Locales();
    }
}

