/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.CompoundDirectPositions;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;

public class Plane
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2956201711131316723L;
    private static final int DIMENSION = 3;
    private static final double ZERO_THRESHOLD = 1.0E-14;
    private double sx;
    private double sy;
    private double z0;

    public Plane() {
        this.z0 = Double.NaN;
        this.sy = Double.NaN;
        this.sx = Double.NaN;
    }

    public Plane(double d, double d2, double d3) {
        this.sx = d;
        this.sy = d2;
        this.z0 = d3;
    }

    public final double slopeX() {
        return this.sx;
    }

    public final double slopeY() {
        return this.sy;
    }

    public final double z0() {
        return this.z0;
    }

    public final double x(double d, double d2) {
        return (d2 - (this.z0 + this.sy * d)) / this.sx;
    }

    public final double y(double d, double d2) {
        return (d2 - (this.z0 + this.sx * d)) / this.sy;
    }

    public final double z(double d, double d2) {
        return this.z0 + this.sx * d + this.sy * d2;
    }

    public void setEquation(double d, double d2, double d3) {
        this.sx = d;
        this.sy = d2;
        this.z0 = d3;
    }

    public double fit(double[] dArray, double[] dArray2, double[] dArray3) {
        return this.fit(new CompoundDirectPositions(dArray, dArray2, dArray3), true, true, true);
    }

    public double fit(Iterable<? extends DirectPosition> iterable) {
        return this.fit(iterable, true, true, true);
    }

    private double fit(Iterable<? extends DirectPosition> iterable, boolean bl, boolean bl2, boolean bl3) {
        double d;
        double d2;
        int n = 0;
        int n2 = 0;
        DoubleDouble doubleDouble = new DoubleDouble();
        DoubleDouble doubleDouble2 = new DoubleDouble();
        DoubleDouble doubleDouble3 = new DoubleDouble();
        DoubleDouble doubleDouble4 = new DoubleDouble();
        DoubleDouble doubleDouble5 = new DoubleDouble();
        DoubleDouble doubleDouble6 = new DoubleDouble();
        DoubleDouble doubleDouble7 = new DoubleDouble();
        DoubleDouble doubleDouble8 = new DoubleDouble();
        DoubleDouble doubleDouble9 = new DoubleDouble();
        DoubleDouble doubleDouble10 = new DoubleDouble();
        DoubleDouble doubleDouble11 = new DoubleDouble();
        DoubleDouble doubleDouble12 = new DoubleDouble();
        DoubleDouble doubleDouble13 = new DoubleDouble();
        for (DirectPosition object2 : iterable) {
            int doubleDouble15 = object2.getDimension();
            if (doubleDouble15 != 3) {
                throw new MismatchedDimensionException(Errors.format((short)59, "points[" + n + ']', 3, doubleDouble15));
            }
            ++n;
            double doubleDouble16 = object2.getOrdinate(0);
            if (Double.isNaN(doubleDouble16) || Double.isNaN(d2 = object2.getOrdinate(1)) || Double.isNaN(d = object2.getOrdinate(2))) continue;
            doubleDouble9.setToProduct(doubleDouble16, doubleDouble16);
            doubleDouble10.setToProduct(d2, d2);
            doubleDouble11.setToProduct(doubleDouble16, d2);
            doubleDouble12.setToProduct(d, doubleDouble16);
            doubleDouble13.setToProduct(d, d2);
            doubleDouble.add(doubleDouble16);
            doubleDouble2.add(d2);
            doubleDouble3.add(d);
            doubleDouble4.add(doubleDouble9);
            doubleDouble5.add(doubleDouble10);
            doubleDouble6.add(doubleDouble11);
            doubleDouble7.add(doubleDouble12);
            doubleDouble8.add(doubleDouble13);
            ++n2;
        }
        doubleDouble12.setFrom(doubleDouble);
        doubleDouble12.divide(-n2, 0.0);
        doubleDouble12.multiply(doubleDouble3);
        doubleDouble12.add(doubleDouble7);
        doubleDouble13.setFrom(doubleDouble2);
        doubleDouble13.divide(-n2, 0.0);
        doubleDouble13.multiply(doubleDouble3);
        doubleDouble13.add(doubleDouble8);
        doubleDouble9.setFrom(doubleDouble);
        doubleDouble9.divide(-n2, 0.0);
        doubleDouble9.multiply(doubleDouble);
        doubleDouble9.add(doubleDouble4);
        doubleDouble11.setFrom(doubleDouble2);
        doubleDouble11.divide(-n2, 0.0);
        doubleDouble11.multiply(doubleDouble);
        doubleDouble11.add(doubleDouble6);
        doubleDouble10.setFrom(doubleDouble2);
        doubleDouble10.divide(-n2, 0.0);
        doubleDouble10.multiply(doubleDouble2);
        doubleDouble10.add(doubleDouble5);
        DoubleDouble doubleDouble14 = new DoubleDouble(doubleDouble9);
        doubleDouble14.multiply(doubleDouble10);
        DoubleDouble doubleDouble15 = new DoubleDouble(doubleDouble11);
        doubleDouble15.multiply(doubleDouble11);
        doubleDouble15.subtract(doubleDouble14);
        DoubleDouble doubleDouble16 = new DoubleDouble(doubleDouble13);
        doubleDouble16.multiply(doubleDouble11);
        doubleDouble14.setFrom(doubleDouble12);
        doubleDouble14.multiply(doubleDouble10);
        doubleDouble16.subtract(doubleDouble14);
        doubleDouble16.divide(doubleDouble15);
        DoubleDouble doubleDouble17 = new DoubleDouble(doubleDouble12);
        doubleDouble17.multiply(doubleDouble11);
        doubleDouble14.setFrom(doubleDouble13);
        doubleDouble14.multiply(doubleDouble9);
        doubleDouble17.subtract(doubleDouble14);
        doubleDouble17.divide(doubleDouble15);
        DoubleDouble doubleDouble18 = new DoubleDouble(doubleDouble17);
        doubleDouble18.multiply(doubleDouble2);
        doubleDouble14.setFrom(doubleDouble16);
        doubleDouble14.multiply(doubleDouble);
        doubleDouble14.add(doubleDouble18);
        doubleDouble18.setFrom(doubleDouble3);
        doubleDouble18.subtract(doubleDouble14);
        doubleDouble18.divide(n2, 0.0);
        d2 = doubleDouble.value / (double)n2;
        d = doubleDouble2.value / (double)n2;
        double d3 = doubleDouble3.value / (double)n2;
        double d4 = Math.abs(doubleDouble16.value * d2 + doubleDouble17.value * d + doubleDouble18.value);
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (DirectPosition directPosition : iterable) {
            double d8 = (directPosition.getOrdinate(0) - d2) * doubleDouble16.value;
            double d9 = (directPosition.getOrdinate(1) - d) * doubleDouble17.value;
            double d10 = directPosition.getOrdinate(2) - d3;
            double d11 = d8 + d9;
            if (!Double.isNaN(d11) && !Double.isNaN(d10)) {
                d5 += d11 * d11;
                d6 += d10 * d10;
                d7 += d11 * d10;
            }
            if (bl && Math.abs(d8) >= Math.ulp(d9 * 1.0E-14)) {
                bl = false;
            }
            if (bl2 && Math.abs(d9) >= Math.ulp(d8 * 1.0E-14)) {
                bl2 = false;
            }
            if (!bl3 || !(d4 >= Math.ulp(d11 * 1.0E-14))) continue;
            bl3 = false;
        }
        this.setEquation(bl ? 0.0 : doubleDouble16.value, bl2 ? 0.0 : doubleDouble17.value, bl3 ? 0.0 : doubleDouble18.value);
        return Math.min(d7 / Math.sqrt(d5 * d6), 1.0);
    }

    public Plane clone() {
        try {
            return (Plane)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            Plane plane = (Plane)object;
            return Numerics.equals(this.z0, plane.z0) && Numerics.equals(this.sx, plane.sx) && Numerics.equals(this.sy, plane.sy);
        }
        return false;
    }

    public int hashCode() {
        return Numerics.hashCode(0x290689CB2C6251F3L ^ Double.doubleToLongBits(this.z0) + 31L * (Double.doubleToLongBits(this.sx) + 31L * Double.doubleToLongBits(this.sy)));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(60).append("z(x,y) = ");
        String string = "";
        if (this.sx != 0.0) {
            stringBuilder.append(this.sx).append("\u22c5x");
            string = " + ";
        }
        if (this.sy != 0.0) {
            stringBuilder.append(string).append(this.sy).append("\u22c5y");
            string = " + ";
        }
        return stringBuilder.append(string).append(this.z0).toString();
    }
}

