/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.internal.util.Utilities;

public final class DefaultFactories
extends SystemListener {
    private static final Map<Class<?>, Object> FACTORIES = new IdentityHashMap(4);

    private DefaultFactories() {
        super("org.apache.sis.util");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void classpathChanged() {
        Class<DefaultFactories> clazz = DefaultFactories.class;
        synchronized (DefaultFactories.class) {
            FACTORIES.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized <T> boolean isDefaultInstance(Class<T> clazz, T t) {
        return FACTORIES.get(clazz) == t;
    }

    public static synchronized <T> T forClass(Class<T> clazz) {
        T t = clazz.cast(FACTORIES.get(clazz));
        if (t == null && !FACTORIES.containsKey(clazz)) {
            Object var2_2 = null;
            for (T object : ServiceLoader.load(clazz)) {
                if (Utilities.isSIS(object.getClass())) {
                    if (t != null) {
                        throw new ServiceConfigurationError("Found two implementations of " + clazz);
                    }
                    t = object;
                    continue;
                }
                if (var2_2 != null) continue;
                var2_2 = object;
            }
            if (t == null) {
                t = var2_2;
            }
            if (t != null) {
                for (Object object : FACTORIES.values()) {
                    if (object == null || !t.getClass().equals(object.getClass())) continue;
                    t = clazz.cast(object);
                    break;
                }
            }
            FACTORIES.put(clazz, t);
        }
        return t;
    }

    public static <T> T forBuildin(Class<T> clazz) {
        T t = DefaultFactories.forClass(clazz);
        if (t == null) {
            throw new ServiceConfigurationError("Missing \u201cMETA-INF/services/" + clazz.getName() + "\u201d file. " + "The JAR file may be corrupted or the classpath incorrect.");
        }
        return t;
    }

    public static <T, I extends T> I forBuildin(Class<T> clazz, Class<I> clazz2) {
        T t = DefaultFactories.forBuildin(clazz);
        if (!clazz2.isInstance(t)) {
            throw new ServiceConfigurationError("The \u201cMETA-INF/services/" + clazz.getName() + "\u201d file should contains only \u201c" + clazz2.getName() + "\u201d in the Apache SIS namespace, but we found \u201c" + t.getClass().getName() + "\u201d.");
        }
        return clazz2.cast(t);
    }

    static {
        SystemListener.add(new DefaultFactories());
    }
}

