/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.util.MathArrays;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class SequenceEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;

    public SequenceEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (3 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting three values but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public List<Number> evaluate(Tuple tuple) throws IOException {
        StreamEvaluator sizeEval = (StreamEvaluator)this.subEvaluators.get(0);
        StreamEvaluator startEval = (StreamEvaluator)this.subEvaluators.get(1);
        StreamEvaluator strideEval = (StreamEvaluator)this.subEvaluators.get(2);
        Number sizeNum = (Number)sizeEval.evaluate(tuple);
        Number startNum = (Number)startEval.evaluate(tuple);
        Number strideNum = (Number)strideEval.evaluate(tuple);
        int[] sequence = MathArrays.sequence((int)sizeNum.intValue(), (int)startNum.intValue(), (int)strideNum.intValue());
        ArrayList<Number> numbers = new ArrayList<Number>(sequence.length);
        for (int i : sequence) {
            numbers.add(i);
        }
        return numbers;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

