/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class DescribeEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;

    public DescribeEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting one column but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Tuple evaluate(Tuple tuple) throws IOException {
        StreamEvaluator colEval = (StreamEvaluator)this.subEvaluators.get(0);
        List numbers = (List)colEval.evaluate(tuple);
        DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
        for (Number n : numbers) {
            descriptiveStatistics.addValue(n.doubleValue());
        }
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("max", descriptiveStatistics.getMax());
        map.put("mean", descriptiveStatistics.getMean());
        map.put("min", descriptiveStatistics.getMin());
        map.put("stdev", descriptiveStatistics.getStandardDeviation());
        map.put("sum", descriptiveStatistics.getSum());
        map.put("N", descriptiveStatistics.getN());
        map.put("var", descriptiveStatistics.getVariance());
        map.put("kurtosis", descriptiveStatistics.getKurtosis());
        map.put("skewness", descriptiveStatistics.getSkewness());
        map.put("popVar", descriptiveStatistics.getPopulationVariance());
        map.put("geometricMean", descriptiveStatistics.getGeometricMean());
        map.put("sumsq", descriptiveStatistics.getSumsq());
        return new Tuple(map);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

