/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CopyOfRangeEvaluator
extends ComplexEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;

    public CopyOfRangeEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public List<Number> evaluate(Tuple tuple) throws IOException {
        StreamEvaluator colEval1 = (StreamEvaluator)this.subEvaluators.get(0);
        List numbers1 = (List)colEval1.evaluate(tuple);
        double[] vals = new double[numbers1.size()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = ((Number)numbers1.get(i)).doubleValue();
        }
        StreamEvaluator startIndexEval = (StreamEvaluator)this.subEvaluators.get(1);
        Number startIndexNum = (Number)startIndexEval.evaluate(tuple);
        int startIndex = startIndexNum.intValue();
        StreamEvaluator endIndexEval = (StreamEvaluator)this.subEvaluators.get(2);
        Number endIndexNum = (Number)endIndexEval.evaluate(tuple);
        int endIndex = endIndexNum.intValue();
        vals = Arrays.copyOfRange(vals, startIndex, endIndex);
        ArrayList<Number> copyOf = new ArrayList<Number>(vals.length);
        for (int i = 0; i < vals.length; ++i) {
            copyOf.add(vals[i]);
        }
        return copyOf;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

