/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.eval.FieldEvaluator;
import org.apache.solr.client.solrj.io.eval.RawValueEvaluator;
import org.apache.solr.client.solrj.io.eval.SimpleEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class ComplexEvaluator
implements StreamEvaluator {
    protected static final long serialVersionUID = 1L;
    protected StreamContext streamContext;
    protected UUID nodeId = UUID.randomUUID();
    protected StreamFactory constructingFactory;
    protected List<StreamEvaluator> subEvaluators = new ArrayList<StreamEvaluator>();

    public ComplexEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        this(expression, factory, new ArrayList<String>());
    }

    public ComplexEvaluator(StreamExpression expression, StreamFactory factory, List<String> ignoredNamedParameters) throws IOException {
        this.constructingFactory = factory;
        List<StreamExpressionParameter> parameters = factory.getOperandsOfType(expression, StreamExpressionParameter.class);
        for (StreamExpressionParameter parameter : parameters) {
            if (parameter instanceof StreamExpression) {
                StreamExpression streamExpression = (StreamExpression)parameter;
                if (factory.doesRepresentTypes(streamExpression, ComplexEvaluator.class)) {
                    this.subEvaluators.add(factory.constructEvaluator(streamExpression));
                    continue;
                }
                if (factory.doesRepresentTypes(streamExpression, SimpleEvaluator.class)) {
                    this.subEvaluators.add(factory.constructEvaluator(streamExpression));
                    continue;
                }
                this.subEvaluators.add(new FieldEvaluator(streamExpression.toString()));
                continue;
            }
            if (!(parameter instanceof StreamExpressionValue) || 0 == ((StreamExpressionValue)parameter).getValue().length()) continue;
            Object value = factory.constructPrimitiveObject(((StreamExpressionValue)parameter).getValue());
            if (null == value || value instanceof Boolean || value instanceof Number) {
                this.subEvaluators.add(new RawValueEvaluator(value));
                continue;
            }
            if (!(value instanceof String)) continue;
            this.subEvaluators.add(new FieldEvaluator((String)value));
        }
        Set namedParameters = factory.getNamedOperands(expression).stream().map(param -> param.getName()).collect(Collectors.toSet());
        long ignorableCount = ignoredNamedParameters.stream().filter(name -> namedParameters.contains(name)).count();
        if (0L != (long)(expression.getParameters().size() - this.subEvaluators.size()) - ignorableCount) {
            if (namedParameters.isEmpty()) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found - expecting only StreamEvaluators or field names", expression));
            }
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found - expecting only StreamEvaluators, field names, or named parameters [%s]", expression, namedParameters.stream().collect(Collectors.joining(","))));
        }
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        for (StreamEvaluator evaluator : this.subEvaluators) {
            expression.addParameter(evaluator.toExpression(factory));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
        for (StreamEvaluator subEvaluator : this.subEvaluators) {
            subEvaluator.setStreamContext(context);
        }
    }

    @Override
    public StreamContext getStreamContext() {
        return this.streamContext;
    }
}

